/***************************************************************************
* COPYRIGHT NOTICE
* Copyright 2019 Horizon Robotics, Inc.
* All rights reserved.
***************************************************************************/
#ifndef UTILITY_SENSOR_INC_OVX8B_SETTING_H_
#define UTILITY_SENSOR_INC_OVX8B_SETTING_H_

#define MCLK_NUM                0
#define SENSOR_CLK_MIN          18
#define SENSOR_CLK_MAX          27
#define OVX8B_PARAM_HOLD        (0x3208)
	#define GROUP_0_START		(0x00)
	#define GROUP_0_END			(0x10)
	#define GROUP_0_QUICK_LUNCH (0xE0)
#define OVX8B_MANUAL_LUNCH      (0x3211)
	#define MANUAL_LUNCH_ON		(0x00)
#define OVX8B_HCG_AGAIN         (0x3508)
#define OVX8B_SPD_AGAIN         (0x3548)
#define OVX8B_LCG_AGAIN         (0x3588)
#define OVX8B_VS_AGAIN         	(0x35C8)
#define OVX8B_HCG_DGAIN         (0x350A)
#define OVX8B_SPD_DGAIN         (0x354A)
#define OVX8B_LCG_DGAIN         (0x358A)
#define OVX8B_VS_DGAIN         	(0x35CA)
#define OVX8B_DCG_LINE          (0x3501)
#define OVX8B_SPD_LINE          (0x3541)
#define OVX8B_VS_LINE           (0x35C1)
#define OVX8B_VTS               (0x380E)
#define OVX8B_HTS               (0x386E)
#define OVX8B_HTS_DCG           (0x380C)
#define OVX8B_HTS_S             (0x384C)
#define OVX8B_HTS_VS            (0x388C)
#define OVX8B_X_START           (0x3800)
#define OVX8B_X_END             (0x3804)
#define OVX8B_Y_START           (0x3802)
#define OVX8B_Y_END             (0x3806)
#define OVX8B_X_OUTPUT          (0x3808)
#define OVX8B_Y_OUTPUT          (0x380A)
#define OVX8b_AWB_HCG_B         (0x5280)
#define OVX8b_AWB_HCG_GB        (0x5282)
#define OVX8b_AWB_HCG_GR        (0x5284)
#define OVX8b_AWB_HCG_R         (0x5286)
#define OVX8b_AWB_LCG_B         (0x5480)
#define OVX8b_AWB_LCG_GB        (0x5482)
#define OVX8b_AWB_LCG_GR        (0x5484)
#define OVX8b_AWB_LCG_R         (0x5486)
#define OVX8b_AWB_SPD_B         (0x5680)
#define OVX8b_AWB_SPD_GB        (0x5682)
#define OVX8b_AWB_SPD_GR        (0x5684)
#define OVX8b_AWB_SPD_R         (0x5686)
#define OVX8b_AWB_VS_B          (0x5880)
#define OVX8b_AWB_VS_GB         (0x5882)
#define OVX8b_AWB_VS_GR         (0x5884)
#define OVX8b_AWB_VS_R          (0x5886)

#define OVX8b_PLL2_PREDIV0      (0x0326)
#define OVX8b_PLL2_PREDIV       (0x0323)
#define OVX8b_PLL2_MULT         (0x0324)
#define OVX8b_PLL2_DIVSYSPRE    (0x032A)
#define OVX8b_PLL2_DIVSYS       (0x032B)

#define OVX8B_OTP_VERSION_REG_1	(0x704B)
#define OVX8B_OTP_VERSION_REG_2	(0x700E)

#define OVX8B_HCG_SENSITIVITY_REG	(0x501a)
#define OVX8B_LCG_SENSITIVITY_REG	(0x501e)
#define OVX8B_SPD_SENSITIVITY_REG	(0x5022)
#define OVX8B_VS_SENSITIVITY_REG	(0x5026)

#define OVX8B_OTP_VERSION_THRESHOLD_1	0xa5
#define OVX8B_OTP_VERSION_THRESHOLD_2	0x06
#define OVX8B_RATIO_SHIFT		256

//#define OVX8B_CHANNEL_RATIO     16
#define OVX8B_HCG_LCG_CHANNEL_RATIO	36
#define OVX8B_LCG_SPD_CHANNEL_RATIO	3.6
#define OVX8B_LCG_VS_CHANNEL_RATIO	270
#define OVX8B_HCG_LCG_CG_RATIO_DEFT	4.0
// #define OVX8B_LPD_SPD_RATIO     36
#define OVX8B_SENSITIVITY_RATIO_DEFT	7.8

#define OVX8B_COMMON_ADDR       0x10
#define EXP_TIME_MIN            2
#define DCG_ADD_VS_LINE_MAX     1255    //  vts - 13
#define VS_LINE_MAX             35
#define VS_LINE_MIN             0       //  actual 0.5row
#define DCG_SPD_LINE_MIN        2
#define LCG_VS_AGAIN_MIN        1.3125
#define LCG_VS_DGAIN_MIN        1.015625
#define HCG_SPD_AGAIN_MIN       1
#define AGAIN_MAX               15.5
#define DGAIN_MAX               15.999
#define DGAIN_MIN               1

#define D65_TEMPER              6500
#define CWF_TEMPER              4150
#define ALIGHT_TEMPER           2856

#define SN_D65_TEMPER           6400
#define SN_CWF_TEMPER           4000
#define SN_ALIGHT_TEMPER        2800

#define ALIGHT_LPD_BGAIN        2.81
#define ALIGHT_LPD_RGAIN        1.21
#define ALIGHT_SPD_BGAIN        2.12
#define ALIGHT_SPD_RGAIN        1.12
#define CWF_LPD_BGAIN           2.43
#define CWF_LPD_RGAIN           1.79
#define CWF_SPD_BGAIN           2.00
#define CWF_SPD_RGAIN           1.42
#define D65_LPD_BGAIN           1.45
#define D65_LPD_RGAIN           2.15
#define D65_SPD_BGAIN           1.42
#define D65_SPD_RGAIN           1.68

#define ALIGHT_BGAIN_RATIO      1.27
#define ALIGHT_RGAIN_RATIO      1
#define CWF_BGAIN_RATIO         1.09
#define CWF_RGAIN_RATIO         1
#define D65_BGAIN_RATIO         1.004
#define D65_RGAIN_RATIO         1.185

#define SN120_ALIGHT_BGAIN_RATIO      1.344688
#define SN120_ALIGHT_RGAIN_RATIO      1.056244
#define SN120_CWF_BGAIN_RATIO         1.199707
#define SN120_CWF_RGAIN_RATIO         1.193359
#define SN120_D65_BGAIN_RATIO         1.04212
#define SN120_D65_RGAIN_RATIO         1.328776

#define SN30_ALIGHT_BGAIN_RATIO      1.272035
#define SN30_ALIGHT_RGAIN_RATIO      1.043288
#define SN30_CWF_BGAIN_RATIO         1.18004
#define SN30_CWF_RGAIN_RATIO         1.134698
#define SN30_D65_BGAIN_RATIO         1.009771
#define SN30_D65_RGAIN_RATIO         1.222323

#define DEFAULT_SENSOR_XCLK     24

#define BIT(i)		(1 << (i))
#define NC_XO_25MHZ 	BIT(0)
#define TEST_PATTERN	BIT(1)
#define FPS_DIV		BIT(2)
#define DPHY_PORTB		BIT(3)
#define DPHY_COPY		BIT(4)
#define AWB_DISABLE     BIT(6)
#define AE_DISABLE      BIT(7)

// config_index bit[8~11] reserved for camera trig mode
#define TRIG_STANDARD       BIT(8)
#define TRIG_SHUTTER_SYNC   BIT(9)
#define MIRROR			BIT(12)
#define FLIP			BIT(13)
#define PWL_24BIT		BIT(14)

#define AWB_CTRL_MODE_OFFS	(15)
#define AWB_CTRL_MODE_MASK	0x1f
#define AWB_CTRL_RATIO_DISABLE	BIT(4)

#define MAX9296_MFP_NUM		12u
#define MAX9296_MFP_OFFSET	3u

#define SENSOR_I2C_CRC_ID	0xC007
#define CRC16_POLY		0x8005
#define MODULE_SERIAL_ADDR	(0x0008)
#define DEFAULT_EEPROM_I2C_ADDR	(0x50)
#define RETRY_POC_TIMES 3
#define POC_RETRY_POLICY 1

enum OVX8B {
	NC_INCEPTIO = 0,
	NC_NURO,
	NC_WEISEN,
	SENSING_NARROW,
	SENSING,
	NC_WEISEN_DUAL,
	SENSING_DUAL,
	SENSING_WS0233,
	SUNNY_NC120,
	SUNNY_NC30,
};

typedef struct reg_setting_data {
	uint32_t *pdata;
	uint32_t size;
}reg_setting_data_t;

uint8_t max9296_add_max96718_init_setting[] = {
	0x04, 0x90, 0x01, 0x61, 0x09,
};

uint8_t sensing_max9296_max9295_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x10, 0xf1,
	0x00, 0xff,
	0x00, 0xff,

	// MAX9295 - Serializer config

	0x04, 0x80, 0x03, 0x11, 0x20,	 // start x/y/z/u from B,20
	0x04, 0x80, 0x03, 0x08, 0x62,	 // x/y/z/u selected B,62
	0x04, 0x80, 0x00, 0x02, 0x23,	 // Video transmit enable  //transmit Y,23

	0x04, 0x80, 0x03, 0x16, 0x6c,
	0x04, 0x80, 0x00, 0x44, 0x20,   // map sensor addr to 0x18.
	0x04, 0x80, 0x00, 0x45, 0x6C,

	0x04, 0x80, 0x03, 0xf0, 0x51,
	0x04, 0x80, 0x00, 0x03, 0x03,
	0x04, 0x80, 0x00, 0x06, 0xb1,
	// 0x04, 0x80, 0x02, 0xd6, 0x90,
	0x04, 0x80, 0x02, 0xbe, 0x18,
	0x04, 0x80, 0x02, 0xbf, 0x60,
	0x00, 0x20,
	0x04, 0x80, 0x00, 0x54, 0x80,

	// MAX9296 - Deserializer config
	0x04, 0x90, 0x03, 0x13, 0x00,
	0x04, 0x90, 0x03, 0x30, 0x04,
	0x04, 0x90, 0x03, 0x19, 0x0C,
	0x04, 0x90, 0x03, 0x39, 0x80,
	0x04, 0x90, 0x03, 0x3a, 0x42,
	0x04, 0x90, 0x00, 0x52, 0x81,
	0x04, 0x90, 0x03, 0x20, 0x2C, 	// MIPI CSI Port A 1.2G
	0x04, 0x90, 0x03, 0x23, 0x2C, 	// MIPI CSI Port B 1.2G
	0x04, 0x90, 0x03, 0x25, 0x80,
	0x04, 0x90, 0x03, 0x13, 0x02,  		// MIPI output enable
};


uint8_t sunny_max9296_max96717_init_setting[] = {
	// reset poc
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x10, 0xf1,
	0x00, 0xff,
	0x00, 0xff,

	// MAX96717 - Serializer config
	0x04, 0x80, 0x00, 0x02, 0x43,	 // Video transmit Y enable  //transmit Y,23
	0x04, 0x80, 0x03, 0x08, 0x64,	 // pipe Z selected B,62
	0x04, 0x80, 0x03, 0x11, 0x40,	 // tart Z from B,20
	0x04, 0x80, 0x00, 0x5b, 0x01,	 // Pipe Z strame ID 1
	0x04, 0x80, 0x03, 0x18, 0x6c,

	// 0x04, 0x80, 0x02, 0xd6, 0x90,

	// MAX9296 - Deserializer config
	0x04, 0x90, 0x03, 0x13, 0x00,
	0x04, 0x90, 0x03, 0x30, 0x04,
	0x04, 0x90, 0x03, 0x19, 0x0C,
	0x04, 0x90, 0x03, 0x39, 0x80,
	0x04, 0x90, 0x03, 0x3a, 0x42,
	0x04, 0x90, 0x00, 0x52, 0x81,
	0x04, 0x90, 0x03, 0x20, 0x2C, 	// MIPI CSI Port A 1.2G
	0x04, 0x90, 0x03, 0x23, 0x2C, 	// MIPI CSI Port B 1.2G
	0x04, 0x90, 0x03, 0x25, 0x80,
	0x04, 0x90, 0x03, 0x13, 0x02,  		// MIPI output enable
};

uint8_t max9296_phy_portb_init_setting[] = {
	0x04, 0x90, 0x00, 0x51, 0x81,
	0x04, 0x90, 0x00, 0x52, 0x82,
};

uint8_t max9296_phy_portall_init_setting[] = {
	0x04, 0x90, 0x00, 0x51, 0x81,
	0x04, 0x90, 0x00, 0x52, 0x81,
};

uint8_t sensing_max9296_max9295_dual_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x10, 0xf1,
	0x00, 0xff,
	0x00, 0xff,

	// LINKA: MAX9295 - i2c.
	0x04, 0x90, 0x00, 0x10, 0x01,
	0x04, 0x90, 0x00, 0x10, 0x21,
	0x00, 0x32,

	0x04, 0x80, 0x00, 0x00, 0x82,
	0x04, 0x82, 0x00, 0x42, 0xC4,
	0x04, 0x82, 0x00, 0x43, 0x82,
	0x04, 0x82, 0x00, 0x44, 0x22,
	0x04, 0x82, 0x00, 0x45, 0x6C,

	// split mode.
	0x04, 0x82, 0x00, 0x6B, 0x16,
	0x04, 0x82, 0x00, 0x73, 0x17,
	0x04, 0x82, 0x00, 0x7B, 0x36,
	0x04, 0x82, 0x00, 0x83, 0x36,
	0x04, 0x82, 0x00, 0x93, 0x36,
	0x04, 0x82, 0x00, 0x9B, 0x36,
	0x04, 0x82, 0x00, 0xA3, 0x36,
	0x04, 0x82, 0x00, 0xAB, 0x36,
	0x04, 0x82, 0x00, 0x8B, 0x36,
	0x00, 0x32,

	// LINKB: MAX9295 - i2c.
	0x04, 0x90, 0x00, 0x10, 0x02,
	0x04, 0x90, 0x00, 0x10, 0x22,
	0x00, 0x32,

	0x04, 0x80, 0x00, 0x00, 0x84,
	0x04, 0x84, 0x00, 0x42, 0xC4,
	0x04, 0x84, 0x00, 0x43, 0x84,
	0x04, 0x84, 0x00, 0x44, 0x24,
	0x04, 0x84, 0x00, 0x45, 0x6C,

	// LINKA + LINKB: MAX9295A config.
	0x04, 0x90, 0x00, 0x10, 0x23,
	0x00, 0x5F,

	0x04, 0x82, 0x03, 0x11, 0x40,	// start z from B,20
	0x04, 0x82, 0x03, 0x08, 0x64,	// z selected B,64
	0x04, 0x82, 0x00, 0x02, 0x43,	// Video transmit enable: z
	0x04, 0x82, 0x03, 0x18, 0x6c,	// z dt: 0x2c
	0x04, 0x82, 0x03, 0xf0, 0x51,
	0x04, 0x82, 0x00, 0x03, 0x03,
	0x04, 0x82, 0x00, 0x06, 0xb1,
	// 0x04, 0x82, 0x02, 0xd6, 0x90,
	0x04, 0x82, 0x02, 0xbe, 0x18,
	0x04, 0x82, 0x02, 0xbf, 0x60,

	0x04, 0x84, 0x03, 0x11, 0x20,	// start y from B,20
	0x04, 0x84, 0x03, 0x08, 0x62,	// y selected B,62
	0x04, 0x84, 0x00, 0x02, 0x23,	// Video transmit enable: y
	0x04, 0x84, 0x03, 0x16, 0x6c,	// y dt: 0x2c
	0x04, 0x84, 0x03, 0xf0, 0x51,
	0x04, 0x84, 0x00, 0x03, 0x03,
	0x04, 0x84, 0x00, 0x06, 0xb1,
	// 0x04, 0x84, 0x02, 0xd6, 0x90,
	0x04, 0x84, 0x02, 0xbe, 0x18,
	0x04, 0x84, 0x02, 0xbf, 0x60,

	// MAX9296 - Deserializer config
	0x04, 0x90, 0x03, 0x13, 0x00,
	0x04, 0x90, 0x03, 0x16, 0x80,	// y dt: 0x2c (x dt: 0x00)
	0x04, 0x90, 0x03, 0x17, 0xBC,	// z dt: 0x2c
	0x04, 0x90, 0x03, 0x18, 0x00,	// (u dt: 0x00)
	0x04, 0x90, 0x03, 0x19, 0x6C,	// y z dt: 12
	0x04, 0x90, 0x03, 0x1A, 0x00,
	0x04, 0x90, 0x03, 0x14, 0x10,	// y: vc1
	0x04, 0x90, 0x03, 0x15, 0x00,   // z: vc0

	0x04, 0x90, 0x03, 0x1D, 0xAC, 	// y: soft override.
	0x04, 0x90, 0x03, 0x20, 0x79, 	// z: soft overfide, Port A 2.5G
	0x04, 0x90, 0x03, 0x23, 0x39,   // PortB: 2.5G

	// y map to vc1 of PortA.
	0x04, 0x90, 0x04, 0x4B, 0x07,   // Enable 3 Mappings
	0x04, 0x90, 0x04, 0x6D, 0x15,   // Destionation Controller = Controller 1. Controller 1 sends data to MIPI Port A
	// For the following MSB 2 bits = VC, LSB 6 bits =DT
	0x04, 0x90, 0x04, 0x4D, 0x2C,   // SRC  0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x4E, 0x6C,   // DEST 0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x4F, 0x00,   // SRC  DT = Frame Start
	0x04, 0x90, 0x04, 0x50, 0x40,   // DEST DT = Frame Start
	0x04, 0x90, 0x04, 0x51, 0x01,   // SRC  DT = Frame End
	0x04, 0x90, 0x04, 0x52, 0x41,   // DEST DT = Frame End

	// z map to vc0 of PortA.
	0x04, 0x90, 0x04, 0x8B, 0x07,     // Enable 3 Mappings
	0x04, 0x90, 0x04, 0xAD, 0x15,     // Destionation Controller = Controller 1. Controller 2 sends data to MIPI Port A
	// For the following MSB 2 bits = VC, LSB 6 bits = DT
	0x04, 0x90, 0x04, 0x8D, 0x2C,     // SRC  0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x8E, 0x2C,     // DEST 0b01101100, DT = 0x2C VC=1
	0x04, 0x90, 0x04, 0x8F, 0x00,     // SRC  DT = Frame Start
	0x04, 0x90, 0x04, 0x90, 0x00,     // DEST DT = Frame Start
	0x04, 0x90, 0x04, 0x91, 0x01,     // SRC  DT = Frame End
	0x04, 0x90, 0x04, 0x92, 0x01,     // DEST DT = Frame End

	0x04, 0x90, 0x03, 0x25, 0x80,
	0x04, 0x90, 0x03, 0x13, 0x02,  		// MIPI output enable
};

uint8_t sensing_max9296_max9295_max96717_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x10, 0xf1,
	0x00, 0xff,
	0x00, 0xff,
	0x04, 0x80, 0x00, 0x01, 0x04,	// 9295: GMSL2 3Gbps.
	0x04, 0x90, 0x00, 0x01, 0x01,	// 9296: GMSL2 3Gbps.
	0x00, 0xff,

	// LINKA: MAX9295 - i2c.
	0x04, 0x90, 0x00, 0x10, 0x01,
	0x04, 0x90, 0x00, 0x10, 0x21,
	0x00, 0x32,

	0x04, 0x80, 0x00, 0x00, 0x82,
	0x04, 0x82, 0x00, 0x42, 0xC4,
	0x04, 0x82, 0x00, 0x43, 0x82,
	0x04, 0x82, 0x00, 0x44, 0x22,
	0x04, 0x82, 0x00, 0x45, 0x6C,

	// split mode.
	0x04, 0x82, 0x00, 0x6B, 0x16,
	0x04, 0x82, 0x00, 0x73, 0x17,
	0x04, 0x82, 0x00, 0x7B, 0x36,
	0x04, 0x82, 0x00, 0x83, 0x36,
	0x04, 0x82, 0x00, 0x93, 0x36,
	0x04, 0x82, 0x00, 0x9B, 0x36,
	0x04, 0x82, 0x00, 0xA3, 0x36,
	0x04, 0x82, 0x00, 0xAB, 0x36,
	0x04, 0x82, 0x00, 0x8B, 0x36,
	0x00, 0x32,

	// LINKB: MAX9295 - i2c.
	0x04, 0x90, 0x00, 0x10, 0x02,
	0x04, 0x90, 0x00, 0x10, 0x22,
	0x00, 0x32,

	0x04, 0x80, 0x00, 0x00, 0x84,
	0x04, 0x84, 0x00, 0x42, 0xC4,
	0x04, 0x84, 0x00, 0x43, 0x84,
	0x04, 0x84, 0x00, 0x44, 0x24,
	0x04, 0x84, 0x00, 0x45, 0x20,

	// LINKA + LINKB: MAX9295A+MAX96717 config.
	0x04, 0x90, 0x00, 0x10, 0x23,
	0x00, 0x5F,

	// MAX9295 - Serializer config
	0x04, 0x82, 0x03, 0x11, 0x40,	// start z from B,20
	0x04, 0x82, 0x03, 0x08, 0x64,	// z selected B,64
	0x04, 0x82, 0x00, 0x02, 0x43,	// Video transmit enable: z
	0x04, 0x82, 0x03, 0x18, 0x6c,	// z dt: 0x2c
	0x04, 0x82, 0x03, 0xf0, 0x51,
	0x04, 0x82, 0x00, 0x03, 0x03,
	0x04, 0x82, 0x00, 0x06, 0xb1,
	// 0x04, 0x82, 0x02, 0xd6, 0x90,
	0x04, 0x82, 0x02, 0xbe, 0x18,
	0x04, 0x82, 0x02, 0xbf, 0x60,

	// MAX96717 - Serializer config
	0x04, 0x84, 0x02, 0xd3, 0x00,
	0x04, 0x84, 0x00, 0x02, 0x43,
	0x04, 0x84, 0x03, 0x83, 0x00,
	0x04, 0x84, 0x03, 0x18, 0x6C,
	0x04, 0x84, 0x03, 0xf1, 0x09,
	0x04, 0x84, 0x03, 0xf0, 0x51,
	0x04, 0x84, 0x05, 0x70, 0x1C,
	0x04, 0x84, 0x05, 0x70, 0x0C,
	0x04, 0x84, 0x00, 0x06, 0xb1,
	0x04, 0x84, 0x02, 0xbf, 0x60,
	0x04, 0x84, 0x02, 0xbe, 0x90,
	0x04, 0x84, 0x02, 0xd3, 0x90,
	0x04, 0x84, 0x00, 0x5B, 0x01,       // Pipe Z ID = 1
	0x00, 0x32,

	// MAX9296 - Deserializer config
	0x04, 0x90, 0x03, 0x13, 0x00,
	0x04, 0x90, 0x03, 0x16, 0x80, 	// y dt: 0x2c (x dt: 0x00)
	0x04, 0x90, 0x03, 0x17, 0xBC, 	// z dt: 0x2c
	0x04, 0x90, 0x03, 0x18, 0x00, 	// (u dt: 0x00)
	0x04, 0x90, 0x03, 0x19, 0x6C, 	// y z dt: 12
	0x04, 0x90, 0x03, 0x1A, 0x00,
	0x04, 0x90, 0x03, 0x14, 0x10, 	// y: vc1
	0x04, 0x90, 0x03, 0x15, 0x00,   // z: vc0

	0x04, 0x90, 0x03, 0x1D, 0xAC, 	// y: soft override.
	0x04, 0x90, 0x03, 0x20, 0x79, 	// z: soft overfide, Port A 2.5G
	0x04, 0x90, 0x03, 0x23, 0x39,   // PortB: 2.5G

	// y map to vc1 of PortA.
	0x04, 0x90, 0x04, 0x4B, 0x07,   // Enable 3 Mappings
	0x04, 0x90, 0x04, 0x6D, 0x15,   // Destionation Controller = Controller 1. Controller 1 sends data to MIPI Port A
	// For the following MSB 2 bits = VC, LSB 6 bits =DT
	0x04, 0x90, 0x04, 0x4D, 0x2C,   // SRC  0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x4E, 0x6C,   // DEST 0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x4F, 0x00,   // SRC  DT = Frame Start
	0x04, 0x90, 0x04, 0x50, 0x40,   // DEST DT = Frame Start
	0x04, 0x90, 0x04, 0x51, 0x01,   // SRC  DT = Frame End
	0x04, 0x90, 0x04, 0x52, 0x41,   // DEST DT = Frame End

	// z map to vc0 of PortA.
	0x04, 0x90, 0x04, 0x8B, 0x07,     // Enable 3 Mappings
	0x04, 0x90, 0x04, 0xAD, 0x15,     // Destionation Controller = Controller 1. Controller 2 sends data to MIPI Port A
	// For the following MSB 2 bits = VC, LSB 6 bits = DT
	0x04, 0x90, 0x04, 0x8D, 0x2C,     // SRC  0b00101100, DT = 0x2C VC=0
	0x04, 0x90, 0x04, 0x8E, 0x2C,     // DEST 0b01101100, DT = 0x2C VC=1
	0x04, 0x90, 0x04, 0x8F, 0x00,     // SRC  DT = Frame Start
	0x04, 0x90, 0x04, 0x90, 0x00,     // DEST DT = Frame Start
	0x04, 0x90, 0x04, 0x91, 0x01,     // SRC  DT = Frame End
	0x04, 0x90, 0x04, 0x92, 0x01,     // DEST DT = Frame End

	0x04, 0x90, 0x03, 0x25, 0x80,
	0x04, 0x90, 0x03, 0x13, 0x02,  		// MIPI output enable
};

uint8_t max96712_max9295_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x13, 0x40, 	// reset all.
	0x00, 0xff,
	0x00, 0xff,
	0x04, 0x90, 0x00, 0x18, 0x0F, 	// One-shot link reset for all
	0x00, 0xff,
	0x00, 0xff,

	// MAX9295 - Serializer config
	0x04, 0x80, 0x03, 0x11, 0x40, 	// start z from B,20
	0x04, 0x80, 0x03, 0x08, 0x64, 	// z selected B,62
	0x04, 0x80, 0x00, 0x02, 0x43, 	// Video transmit z enable
	0x04, 0x80, 0x03, 0x18, 0x6c, 	// z dt1: 0x2c

	0x04, 0x80, 0x03, 0xf0, 0x51,
	0x04, 0x80, 0x00, 0x03, 0x03,
	0x04, 0x80, 0x00, 0x06, 0xb1,
	// 0x04, 0x80, 0x02, 0xd6, 0x90,
	0x04, 0x80, 0x02, 0xbe, 0x18,
	0x04, 0x80, 0x02, 0xbf, 0x60,
	0x04, 0x80, 0x00, 0x58, 0x80,	// z: tx crc.

	0x04, 0x80, 0x00, 0x44, 0x20,   // map sensor addr to 0x18.
	0x04, 0x80, 0x00, 0x45, 0x6C,

	// MAX96712 - Deserializer config
	0x04, 0x90, 0x00, 0x06, 0xF1, 	// Enable Link A in GMSL2 mode
	// Video Pipe Selection
	0x04, 0x90, 0x00, 0xF0, 0x62,  	// pipe0: A-Z, pipie1: B-Z.
	// 0x04, 0x90, 0x00, 0xF1, 0xEA,  	// pipe2: C-Z, pipie3: D-Z.
	// 0x04, 0x90, 0x00, 0xF2, 0x40, 	// pipe4: A-X, pipie5: B-X.
	// 0x04, 0x90, 0x00, 0xF3, 0xC8, 	// pipe6: D-X, pipie7: D-X.
	0x04, 0x90, 0x00, 0xF4, 0x01,  	// Turn on pipe 0.
	0x04, 0x90, 0x00, 0x60, 0x44,  	// a/b-z: rx crc.
	0x04, 0x90, 0x00, 0x61, 0x44,  	// c/d-z: rx crc.

	// Video Pipe to MIPI Controller Mapping
	// RAW12, video pipe 0
	0x04, 0x90, 0x09, 0x0B, 0x07,  	// pipe0: s/d 0~2 enable.
	0x04, 0x90, 0x09, 0x2D, 0x15,  	// pipe0: s/d 0~2 map to MIPI Controller 1
	0x04, 0x90, 0x09, 0x0D, 0x2C,
	0x04, 0x90, 0x09, 0x0E, 0x2C,  	// pipe0: s/d 0 map data to VC0:RAW12
	0x04, 0x90, 0x09, 0x0F, 0x00,
	0x04, 0x90, 0x09, 0x10, 0x00,  	// pipe0: s/d 1 map FS to VC0
	0x04, 0x90, 0x09, 0x11, 0x01,
	0x04, 0x90, 0x09, 0x12, 0x01,  	// pipe0: s/d 2 map FS to VC0

	// MIPI PHY Setting
	// Set Des in 2x4 mode
	0x04, 0x90, 0x08, 0xA0, 0x04,
	// Set Lane Mapping for 4-lane port A
	0x04, 0x90, 0x08, 0xA3, 0xE4,
	0x04, 0x90, 0x08, 0xA4, 0xE4,
	// Set 4 lane D-PHY
	0x04, 0x90, 0x09, 0x0A, 0xC0,
	0x04, 0x90, 0x09, 0x4A, 0xC0,
	0x04, 0x90, 0x09, 0x8A, 0xC0,
	0x04, 0x90, 0x09, 0xCA, 0xC0,
	// Turn on MIPI PHYs 0+1
	0x04, 0x90, 0x08, 0xA2, 0x34,

	// Hold DPLL in reset (config_soft_rst_n = 0) before changing the rate
	0x04, 0x90, 0x1C, 0x00, 0xF4,
	0x04, 0x90, 0x1D, 0x00, 0xF4,
	0x04, 0x90, 0x1E, 0x00, 0xF4,
	0x04, 0x90, 0x1F, 0x00, 0xF4,
	// Set Data rate to be 1200Mbps/lane
	// 0x04, 0x90, 0x04, 0x15, 0x2C,
	0x04, 0x90, 0x04, 0x18, 0x2C,
	// 0x04, 0x90, 0x04, 0x1B, 0x2C,
	// 0x04, 0x90, 0x04, 0x1E, 0x2C,
	// Release reset to DPLL (config_soft_rst_n = 1)
	0x04, 0x90, 0x1C, 0x00, 0xF5,
	0x04, 0x90, 0x1D, 0x00, 0xF5,
	0x04, 0x90, 0x1E, 0x00, 0xF5,
	0x04, 0x90, 0x1F, 0x00, 0xF5,
	0x04, 0x90, 0x04, 0x0B, 0x62,  	// stream on
};

uint8_t max96712_max9295_dual_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x13, 0x40, 	// reset all.
	0x00, 0xff,
	0x00, 0xff,
	0x04, 0x90, 0x00, 0x18, 0x0F, 	// One-shot link reset for all
	0x00, 0xff,
	0x00, 0xff,

	0x04, 0x90, 0x00, 0x06, 0xF1,     // Link A
	0x00, 0x32,
	0x04, 0x80, 0x00, 0x00, 0x82,
	0x04, 0x82, 0x00, 0x42, 0xC4,
	0x04, 0x82, 0x00, 0x43, 0x82,
	0x04, 0x82, 0x00, 0x44, 0x22,
	0x04, 0x82, 0x00, 0x45, 0x6C,

	0x04, 0x90, 0x00, 0x06, 0xF2,     // Link B
	0x00, 0x32,
	0x04, 0x80, 0x00, 0x00, 0x84,
	0x04, 0x84, 0x00, 0x42, 0xC4,
	0x04, 0x84, 0x00, 0x43, 0x84,
	0x04, 0x84, 0x00, 0x44, 0x24,
	0x04, 0x84, 0x00, 0x45, 0x6C,

	0x04, 0x90, 0x00, 0x06, 0xF3,   // Enable 2 Links in GMSL2 mode
	0x00, 0xFF,

	// LinkA: MAX9295 - Serializer config
	0x04, 0x82, 0x03, 0x11, 0x40, 	// start z from B,20
	0x04, 0x82, 0x03, 0x08, 0x64, 	// z selected B,62
	0x04, 0x82, 0x00, 0x02, 0x43, 	// Video transmit z enable
	0x04, 0x82, 0x03, 0x18, 0x6c, 	// z dt1: 0x2c

	0x04, 0x82, 0x03, 0xf0, 0x51,
	0x04, 0x82, 0x00, 0x03, 0x03,
	0x04, 0x82, 0x00, 0x06, 0xb1,
	// 0x04, 0x82, 0x02, 0xd6, 0x90,
	0x04, 0x82, 0x02, 0xbe, 0x18,
	0x04, 0x82, 0x02, 0xbf, 0x60,
	0x04, 0x82, 0x00, 0x58, 0x80,	// z: tx crc.

	// LinkB: MAX9295 - Serializer config
	0x04, 0x84, 0x03, 0x11, 0x40, 	// start z from B,20
	0x04, 0x84, 0x03, 0x08, 0x64, 	// z selected B,62
	0x04, 0x84, 0x00, 0x02, 0x43, 	// Video transmit z enable
	0x04, 0x84, 0x03, 0x18, 0x6c, 	// z dt1: 0x2c

	0x04, 0x84, 0x03, 0xf0, 0x51,
	0x04, 0x84, 0x00, 0x03, 0x03,
	0x04, 0x84, 0x00, 0x06, 0xb1,
	// 0x04, 0x84, 0x02, 0xd6, 0x90,
	0x04, 0x84, 0x02, 0xbe, 0x18,
	0x04, 0x84, 0x02, 0xbf, 0x60,
	0x04, 0x84, 0x00, 0x58, 0x80,	// z: tx crc.

	// MAX96712 - Deserializer config
	// Video Pipe Selection
	0x04, 0x90, 0x00, 0xF0, 0x62,  	// pipe0: A-Z, pipie1: B-Z.
	// 0x04, 0x90, 0x00, 0xF1, 0xEA,  	// pipe2: C-Z, pipie3: D-Z.
	// 0x04, 0x90, 0x00, 0xF2, 0x40, 	// pipe4: A-X, pipie5: B-X.
	// 0x04, 0x90, 0x00, 0xF3, 0xC8, 	// pipe6: D-X, pipie7: D-X.
	0x04, 0x90, 0x00, 0xF4, 0x03,  	// Turn on pipe 0+1.
	0x04, 0x90, 0x00, 0x60, 0x44,  	// a/b-z: rx crc.

	// Video Pipe to MIPI Controller Mapping
	// RAW12, video pipe 0
	0x04, 0x90, 0x09, 0x0B, 0x07,  	// pipe0: s/d 0~2 enable.
	0x04, 0x90, 0x09, 0x2D, 0x15,  	// pipe0: s/d 0~2 map to MIPI Controller 1
	0x04, 0x90, 0x09, 0x0D, 0x2C,
	0x04, 0x90, 0x09, 0x0E, 0x2C,  	// pipe0: s/d 0 map data to VC0:RAW12
	0x04, 0x90, 0x09, 0x0F, 0x00,
	0x04, 0x90, 0x09, 0x10, 0x00,  	// pipe0: s/d 1 map FS to VC0
	0x04, 0x90, 0x09, 0x11, 0x01,
	0x04, 0x90, 0x09, 0x12, 0x01,  	// pipe0: s/d 2 map FS to VC0

	0x04, 0x90, 0x09, 0x4B, 0x07,    // Map source 0~2 for Link B
	0x04, 0x90, 0x09, 0x6D, 0x15,
	0x04, 0x90, 0x09, 0x4D, 0x2C,
	0x04, 0x90, 0x09, 0x4E, 0x6C,    // vc = 1
	0x04, 0x90, 0x09, 0x4F, 0x00,
	0x04, 0x90, 0x09, 0x50, 0x40,
	0x04, 0x90, 0x09, 0x51, 0x01,
	0x04, 0x90, 0x09, 0x52, 0x41,

	// MIPI PHY Setting
	// Set Des in 2x4 mode
	0x04, 0x90, 0x08, 0xA0, 0x04,
	// Set Lane Mapping for 4-lane port A
	0x04, 0x90, 0x08, 0xA3, 0xE4,
	0x04, 0x90, 0x08, 0xA4, 0xE4,
	// Set 4 lane D-PHY
	0x04, 0x90, 0x09, 0x0A, 0xC0,
	0x04, 0x90, 0x09, 0x4A, 0xC0,
	0x04, 0x90, 0x09, 0x8A, 0xC0,
	0x04, 0x90, 0x09, 0xCA, 0xC0,
	// Turn on MIPI PHYs 0+1
	0x04, 0x90, 0x08, 0xA2, 0x34,

	// Hold DPLL in reset (config_soft_rst_n = 0) before changing the rate
	0x04, 0x90, 0x1C, 0x00, 0xF4,
	0x04, 0x90, 0x1D, 0x00, 0xF4,
	0x04, 0x90, 0x1E, 0x00, 0xF4,
	0x04, 0x90, 0x1F, 0x00, 0xF4,
	// Set Data rate to be 2500Mbps/lane
	// 0x04, 0x90, 0x04, 0x15, 0x39,
	0x04, 0x90, 0x04, 0x18, 0x39,
	// 0x04, 0x90, 0x04, 0x1B, 0x39,
	// 0x04, 0x90, 0x04, 0x1E, 0x39,
	// Release reset to DPLL (config_soft_rst_n = 1)
	0x04, 0x90, 0x1C, 0x00, 0xF5,
	0x04, 0x90, 0x1D, 0x00, 0xF5,
	0x04, 0x90, 0x1E, 0x00, 0xF5,
	0x04, 0x90, 0x1F, 0x00, 0xF5,
	0x04, 0x90, 0x04, 0x0B, 0x62,  	// stream on
};

uint8_t max96712_max9295_max96717_init_setting[] = {
	// reset 0820
#ifndef POC_RETRY_POLICY
	0x03, 0x50, 0x01, 0x00,
	0x00, 0xff,
	0x03, 0x50, 0x01, 0x1f,
	0x00, 0xff,
#endif
	0x04, 0x90, 0x00, 0x13, 0x40, 	// reset all.
	0x00, 0xff,
	0x00, 0xff,
	0x04, 0x52, 0x00, 0x10, 0x12,   // Link A:6Gbps B:3Gbps
	0x04, 0x90, 0x00, 0x18, 0x0F, 	// One-shot link reset for all
	0x00, 0xff,
	0x00, 0xff,

	0x04, 0x90, 0x00, 0x06, 0xF1,     // Link A
	0x00, 0x32,
	0x04, 0x80, 0x00, 0x00, 0x82,
	0x04, 0x82, 0x00, 0x42, 0xC4,
	0x04, 0x82, 0x00, 0x43, 0x82,
	0x04, 0x82, 0x00, 0x44, 0x22,
	0x04, 0x82, 0x00, 0x45, 0x6C,

	0x04, 0x90, 0x00, 0x06, 0xF2,     // Link B
	0x00, 0x64,
	0x04, 0x80, 0x00, 0x00, 0x84,
	0x04, 0x84, 0x00, 0x42, 0xC4,
	0x04, 0x84, 0x00, 0x43, 0x84,
	0x04, 0x84, 0x00, 0x44, 0x24,
	0x04, 0x84, 0x00, 0x45, 0x20,

	0x04, 0x90, 0x00, 0x06, 0xF3,   // Enable 2 Links in GMSL2 mode
	0x00, 0xFF,

	// LinkA: MAX9295 - Serializer config
	0x04, 0x82, 0x03, 0x11, 0x40, 	// start z from B,20
	0x04, 0x82, 0x03, 0x08, 0x64, 	// z selected B,62
	0x04, 0x82, 0x00, 0x02, 0x43, 	// Video transmit z enable
	0x04, 0x82, 0x03, 0x18, 0x6c, 	// z dt1: 0x2c

	0x04, 0x82, 0x03, 0xf0, 0x51,
	0x04, 0x82, 0x00, 0x03, 0x03,
	0x04, 0x82, 0x00, 0x06, 0xb1,
	// 0x04, 0x82, 0x02, 0xd6, 0x90,
	0x04, 0x82, 0x02, 0xbe, 0x18,
	0x04, 0x82, 0x02, 0xbf, 0x60,
	0x04, 0x82, 0x00, 0x58, 0x80,	// z: tx crc.

	// LinkB: MAX96717 - Serializer config
	0x04, 0x84, 0x02, 0xd3, 0x00,
	0x04, 0x84, 0x02, 0xbe, 0x90,
	0x04, 0x84, 0x02, 0xbf, 0x60,

	0x04, 0x84, 0x03, 0x30, 0x00,   // Sensor 1 set pipe Z
	0x04, 0x84, 0x03, 0x31, 0x33,   // 4 Lanes
	0x04, 0x84, 0x03, 0x32, 0xE0,   // Lane mapping for PHY 1
	0x04, 0x84, 0x03, 0x33, 0x04,   // Lane mapping for PHY 2
	0x04, 0x84, 0x03, 0x08, 0x64,   // Enable PORT B && pipe Z
	0x04, 0x84, 0x03, 0x11, 0x40,   // stat pipe Z for PORT B
	0x04, 0x84, 0x00, 0x02, 0x43,   // transmit enable for pipe Z
	0x04, 0x84, 0x03, 0x18, 0x6C,   // Datatype for pipe Z
	0x04, 0x84, 0x03, 0x83, 0x00,
	0x04, 0x84, 0x03, 0xf0, 0x51,
	0x04, 0x84, 0x03, 0xf1, 0x09,
	0x04, 0x84, 0x05, 0x70, 0x1c,
	0x04, 0x84, 0x05, 0x70, 0x0c,
	0x04, 0x84, 0x00, 0x06, 0xb1,
	0x04, 0x84, 0x02, 0xd3, 0x90,
	0x04, 0x84, 0x00, 0x58, 0x80, 	// z: tx crc.

	// MAX96712 - Deserializer config
	// Video Pipe Selection
	0x04, 0x90, 0x00, 0xF0, 0x62,  	// pipe0: A-Z, pipie1: B-Z.
	// 0x04, 0x90, 0x00, 0xF1, 0xEA,  	// pipe2: C-Z, pipie3: D-Z.
	// 0x04, 0x90, 0x00, 0xF2, 0x40, 	// pipe4: A-X, pipie5: B-X.
	// 0x04, 0x90, 0x00, 0xF3, 0xC8, 	// pipe6: D-X, pipie7: D-X.
	0x04, 0x90, 0x00, 0xF4, 0x03,  	// Turn on pipe 0+1.
	0x04, 0x90, 0x00, 0x60, 0x44,  	// a/b-z: rx crc.

	// Video Pipe to MIPI Controller Mapping
	// RAW12, video pipe 0
	0x04, 0x90, 0x09, 0x0B, 0x07,  	// pipe0: s/d 0~2 enable.
	0x04, 0x90, 0x09, 0x2D, 0x15,  	// pipe0: s/d 0~2 map to MIPI Controller 1
	0x04, 0x90, 0x09, 0x0D, 0x2C,
	0x04, 0x90, 0x09, 0x0E, 0x2C,  	// pipe0: s/d 0 map data to VC0:RAW12
	0x04, 0x90, 0x09, 0x0F, 0x00,
	0x04, 0x90, 0x09, 0x10, 0x00,  	// pipe0: s/d 1 map FS to VC0
	0x04, 0x90, 0x09, 0x11, 0x01,
	0x04, 0x90, 0x09, 0x12, 0x01,  	// pipe0: s/d 2 map FS to VC0

	0x04, 0x90, 0x09, 0x4B, 0x07,    // Map source 0~2 for Link B
	0x04, 0x90, 0x09, 0x6D, 0x15,
	0x04, 0x90, 0x09, 0x4D, 0x2C,
	0x04, 0x90, 0x09, 0x4E, 0x6C,    // vc = 1
	0x04, 0x90, 0x09, 0x4F, 0x00,
	0x04, 0x90, 0x09, 0x50, 0x40,
	0x04, 0x90, 0x09, 0x51, 0x01,
	0x04, 0x90, 0x09, 0x52, 0x41,

	// MIPI PHY Setting
	// Set Des in 2x4 mode
	0x04, 0x90, 0x08, 0xA0, 0x04,
	// Set Lane Mapping for 4-lane port A
	0x04, 0x90, 0x08, 0xA3, 0xE4,
	0x04, 0x90, 0x08, 0xA4, 0xE4,
	// Set 4 lane D-PHY
	0x04, 0x90, 0x09, 0x0A, 0xC0,
	0x04, 0x90, 0x09, 0x4A, 0xC0,
	0x04, 0x90, 0x09, 0x8A, 0xC0,
	0x04, 0x90, 0x09, 0xCA, 0xC0,
	// Turn on MIPI PHYs 0+1
	0x04, 0x90, 0x08, 0xA2, 0x34,

	// Hold DPLL in reset (config_soft_rst_n = 0) before changing the rate
	0x04, 0x90, 0x1C, 0x00, 0xF4,
	0x04, 0x90, 0x1D, 0x00, 0xF4,
	0x04, 0x90, 0x1E, 0x00, 0xF4,
	0x04, 0x90, 0x1F, 0x00, 0xF4,
	// Set Data rate to be 2500Mbps/lane
	// 0x04, 0x90, 0x04, 0x15, 0x39,
	0x04, 0x90, 0x04, 0x18, 0x39,
	// 0x04, 0x90, 0x04, 0x1B, 0x39,
	// 0x04, 0x90, 0x04, 0x1E, 0x39,
	// Release reset to DPLL (config_soft_rst_n = 1)
	0x04, 0x90, 0x1C, 0x00, 0xF5,
	0x04, 0x90, 0x1D, 0x00, 0xF5,
	0x04, 0x90, 0x1E, 0x00, 0xF5,
	0x04, 0x90, 0x1F, 0x00, 0xF5,
	0x04, 0x90, 0x04, 0x0B, 0x62,  	// stream on
};

uint8_t ovx8b_linear_30fps_init_setting[] = {
};

uint8_t ovx8b_hdr_2exp_30fps_init_setting[] = {
};

uint8_t ovx8b_hdr_3exp_30fps_init_setting[] = {
	//  X8B_3840X2160_30fps_HDR3_PWL12_LFR_mipi972_27M_R1D
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x04,
	0x05, 0x6c, 0x46, 0x20, 0x00, 0x04,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x14,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x05,
	0x05, 0x6c, 0x46, 0x20, 0x00, 0x04,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x15,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x02,
	0x05, 0x6c, 0x35, 0x07, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x12,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0xa2,
	0x05, 0x6c, 0x03, 0x05, 0x00, 0x3c,
	0x05, 0x6c, 0x03, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x20, 0x00, 0x02,
	0x05, 0x6c, 0x03, 0x21, 0x00, 0x33,
	0x05, 0x6c, 0x03, 0x25, 0x00, 0x95,
	0x05, 0x6c, 0x04, 0x08, 0x00, 0xe7,
	0x05, 0x6c, 0x04, 0x09, 0x00, 0xff,
	0x05, 0x6c, 0x04, 0x0a, 0x00, 0x2b,
	0x05, 0x6c, 0x04, 0x0b, 0x00, 0x32,
	0x05, 0x6c, 0x04, 0x0c, 0x00, 0x28,
	0x05, 0x6c, 0x04, 0x0d, 0x00, 0x5a,
	0x05, 0x6c, 0x04, 0x0e, 0x00, 0x0c,
	0x05, 0x6c, 0x30, 0x02, 0x00, 0xf8,
	0x05, 0x6c, 0x30, 0x12, 0x00, 0x41,
	0x05, 0x6c, 0x28, 0x03, 0x00, 0xfe,
	0x05, 0x6c, 0x28, 0x0b, 0x00, 0x00,
	0x05, 0x6c, 0x28, 0x0c, 0x00, 0x79,
	0x05, 0x6c, 0x37, 0x00, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x06, 0x00, 0x35,
	0x05, 0x6c, 0x37, 0x09, 0x00, 0x5e,
	0x05, 0x6c, 0x37, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x0b, 0x00, 0x7d,
	0x05, 0x6c, 0x37, 0x0e, 0x00, 0x51,
	0x05, 0x6c, 0x37, 0x12, 0x00, 0x13,
	0x05, 0x6c, 0x37, 0x17, 0x00, 0x07,
	0x05, 0x6c, 0x37, 0x18, 0x00, 0x72,
	0x05, 0x6c, 0x37, 0x19, 0x00, 0x24,
	0x05, 0x6c, 0x37, 0x2b, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x2c, 0x00, 0xb0,
	0x05, 0x6c, 0x37, 0x30, 0x00, 0x12,
	0x05, 0x6c, 0x37, 0x31, 0x00, 0x43,
	0x05, 0x6c, 0x37, 0x33, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x38, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x39, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x3a, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0x3b, 0x00, 0x1a,
	0x05, 0x6c, 0x37, 0x3f, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x40, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x41, 0x00, 0x1b,
	0x05, 0x6c, 0x37, 0x42, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x45, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x47, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x48, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x50, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0x55, 0x00, 0x14,
	0x05, 0x6c, 0x37, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x37, 0x57, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x59, 0x00, 0x31,
	0x05, 0x6c, 0x37, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x5b, 0x00, 0x6e,
	0x05, 0x6c, 0x37, 0x6c, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x78, 0x00, 0x20,
	0x05, 0x6c, 0x37, 0x7c, 0x00, 0xc8,
	0x05, 0x6c, 0x37, 0x97, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x99, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9c, 0x00, 0x58,
	0x05, 0x6c, 0x37, 0x9e, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9f, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xa0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xbc, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0xc0, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0xc4, 0x00, 0x2f,
	0x05, 0x6c, 0x37, 0xc5, 0x00, 0x2f,
	0x05, 0x6c, 0x37, 0xc6, 0x00, 0x2a,
	0x05, 0x6c, 0x37, 0xc7, 0x00, 0x1e,
	0x05, 0x6c, 0x37, 0xc8, 0x00, 0x02,
	0x05, 0x6c, 0x37, 0xc9, 0x00, 0x09,
	0x05, 0x6c, 0x37, 0xd0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd1, 0x00, 0x30,
	0x05, 0x6c, 0x37, 0xd2, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd3, 0x00, 0x6d,
	0x05, 0x6c, 0x37, 0xd5, 0x00, 0x30,
	0x05, 0x6c, 0x37, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd7, 0x00, 0x64,
	0x05, 0x6c, 0x37, 0xdc, 0x00, 0x5a,
	0x05, 0x6c, 0x37, 0xdd, 0x00, 0x57,
	0x05, 0x6c, 0x3c, 0x03, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x04, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x06, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0b, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x12, 0x00, 0xc0,
	0x05, 0x6c, 0x3c, 0x13, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x14, 0x00, 0x03,
	0x05, 0x6c, 0x3c, 0x21, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x22, 0x00, 0xb3,
	0x05, 0x6c, 0x3c, 0x2a, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x39, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x3d, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3e, 0x00, 0x06,
	0x05, 0x6c, 0x3c, 0x55, 0x00, 0x20,
	0x05, 0x6c, 0x3c, 0x57, 0x00, 0x0c,
	0x05, 0x6c, 0x3c, 0x58, 0x00, 0x0c,
	0x05, 0x6c, 0x3c, 0x5a, 0x00, 0x43,
	0x05, 0x6c, 0x3c, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x3c, 0x61, 0x00, 0x80,
	0x05, 0x6c, 0x3c, 0x78, 0x00, 0x76,
	0x05, 0x6c, 0x3c, 0xc0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc1, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc2, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc9, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xca, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xcb, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe1, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe2, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe3, 0x00, 0xd5,
	0x05, 0x6c, 0x3c, 0xe8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe9, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xea, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xeb, 0x00, 0x58,
	0x05, 0x6c, 0x32, 0x0e, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x0f, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x11, 0x00, 0x61,
	0x05, 0x6c, 0x32, 0x15, 0x00, 0xcd,
	0x05, 0x6c, 0x34, 0x00, 0x00, 0x08,
	0x05, 0x6c, 0x34, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0x89, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0x8b, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x35, 0x42, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x48, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0xc2, 0x00, 0x06,
	0x05, 0x6c, 0x35, 0xc9, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0xcb, 0x00, 0x04,
	0x05, 0x6c, 0x36, 0x00, 0x00, 0x8f,
	0x05, 0x6c, 0x36, 0x03, 0x00, 0x40,
	0x05, 0x6c, 0x36, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x36, 0x07, 0x00, 0x02,
	0x05, 0x6c, 0x36, 0x09, 0x00, 0xe0,
	0x05, 0x6c, 0x36, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x36, 0x11, 0x00, 0x3f,
	0x05, 0x6c, 0x36, 0x16, 0x00, 0x8a,
	0x05, 0x6c, 0x36, 0x1e, 0x00, 0xf4,
	0x05, 0x6c, 0x36, 0x1f, 0x00, 0xcb,
	0x05, 0x6c, 0x36, 0x57, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x59, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x5a, 0x00, 0x0f,
	0x05, 0x6c, 0x36, 0x74, 0x00, 0x08,
	0x05, 0x6c, 0x36, 0x77, 0x00, 0x3f,
	0x05, 0x6c, 0x36, 0x78, 0x00, 0x3f,
	0x05, 0x6c, 0x38, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x06, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x07, 0x00, 0x7b,
	0x05, 0x6c, 0x38, 0x08, 0x00, 0x0f,
	0x05, 0x6c, 0x38, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x0a, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x0b, 0x00, 0x70,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x03,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0xdc,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0x66,
	0x05, 0x6c, 0x38, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x11, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x12, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x13, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x17, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1c, 0x00, 0x18,
	0x05, 0x6c, 0x38, 0x1e, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1f, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x20, 0x00, 0x20,
	0x05, 0x6c, 0x38, 0x21, 0x00, 0x19,
	0x05, 0x6c, 0x38, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0xee,
	0x05, 0x6c, 0x38, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x51, 0x00, 0x42,
	0x05, 0x6c, 0x38, 0x52, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x53, 0x00, 0x40,
	0x05, 0x6c, 0x38, 0x58, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0xee,
	0x05, 0x6c, 0x3b, 0x40, 0x00, 0x04,
	0x05, 0x6c, 0x3b, 0x41, 0x00, 0x80,
	0x05, 0x6c, 0x3b, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x43, 0x00, 0x90,
	0x05, 0x6c, 0x3b, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x45, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x47, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x48, 0x00, 0x16,
	0x05, 0x6c, 0x3b, 0x49, 0x00, 0x0e,
	0x05, 0x6c, 0x3b, 0x4a, 0x00, 0x12,
	0x05, 0x6c, 0x3b, 0x4b, 0x00, 0x2a,
	0x05, 0x6c, 0x3b, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x3d, 0x8a, 0x00, 0x03,
	0x05, 0x6c, 0x3d, 0x8b, 0x00, 0xff,
	0x05, 0x6c, 0x42, 0x0e, 0x00, 0x44,
	0x05, 0x6c, 0x42, 0x0f, 0x00, 0x58,
	0x05, 0x6c, 0x42, 0x10, 0x00, 0xa7,
	0x05, 0x6c, 0x42, 0x11, 0x00, 0x60,
	0x05, 0x6c, 0x42, 0x1e, 0x00, 0x02,
	0x05, 0x6c, 0x42, 0x1f, 0x00, 0x45,
	0x05, 0x6c, 0x42, 0x20, 0x00, 0xc1,
	0x05, 0x6c, 0x42, 0x21, 0x00, 0x01,
	0x05, 0x6c, 0x43, 0x01, 0x00, 0x0f,
	0x05, 0x6c, 0x43, 0x07, 0x00, 0x03,
	0x05, 0x6c, 0x43, 0x08, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x0a, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x0d, 0x00, 0x93,

	0x05, 0x6c, 0x43, 0x0f, 0x00, 0x17,
	0x05, 0x6c, 0x43, 0x10, 0x00, 0x95,
	0x05, 0x6c, 0x43, 0x11, 0x00, 0x16,
	0x05, 0x6c, 0x43, 0x16, 0x00, 0x00,
	// 0x4317, 0x38,
	0x05, 0x6c, 0x43, 0x17, 0x00, 0x08,
	0x05, 0x6c, 0x43, 0x19, 0x00, 0x01,
	0x05, 0x6c, 0x43, 0x1b, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x1c, 0x00, 0x2f,
	0x05, 0x6c, 0x43, 0x1d, 0x00, 0x6f,
	0x05, 0x6c, 0x43, 0x1e, 0x00, 0x11,
	0x05, 0x6c, 0x43, 0x1f, 0x00, 0x20,
	0x05, 0x6c, 0x43, 0x20, 0x00, 0x3b,
	0x05, 0x6c, 0x43, 0x23, 0x00, 0x80,
	0x05, 0x6c, 0x43, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x03, 0x00, 0x4e,
	0x05, 0x6c, 0x45, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x08, 0x00, 0x10,
	0x05, 0x6c, 0x45, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x83, 0x00, 0x06,
	0x05, 0x6c, 0x45, 0x84, 0x00, 0xee,
	0x05, 0x6c, 0x45, 0x85, 0x00, 0x08,
	0x05, 0x6c, 0x45, 0x86, 0x00, 0x88,
	0x05, 0x6c, 0x45, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x45, 0x88, 0x00, 0x0d,
	0x05, 0x6c, 0x45, 0x89, 0x00, 0x09,
	0x05, 0x6c, 0x45, 0x8a, 0x00, 0xae,
	0x05, 0x6c, 0x45, 0x8b, 0x00, 0x02,
	0x05, 0x6c, 0x45, 0x8c, 0x00, 0x44,
	0x05, 0x6c, 0x45, 0x8d, 0x00, 0x03,
	0x05, 0x6c, 0x45, 0x8e, 0x00, 0x55,
	0x05, 0x6c, 0x46, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x03, 0x00, 0x13,
	0x05, 0x6c, 0x46, 0x04, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x06, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x07, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x0a, 0x00, 0x30,
	0x05, 0x6c, 0x46, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x11, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x12, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x13, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x14, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x15, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x47, 0x00, 0x00, 0xe0,
	0x05, 0x6c, 0x48, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x48, 0x0a, 0x00, 0x22,
	0x05, 0x6c, 0x48, 0x13, 0x00, 0xe4,
	0x05, 0x6c, 0x48, 0x14, 0x00, 0x2a,
	0x05, 0x6c, 0x48, 0x37, 0x00, 0x0b,
	0x05, 0x6c, 0x48, 0x4b, 0x00, 0x47,
	0x05, 0x6c, 0x48, 0x4f, 0x00, 0x00,
	0x05, 0x6c, 0x48, 0x50, 0x00, 0x47,
	0x05, 0x6c, 0x4f, 0x00, 0x00, 0x3f,
	0x05, 0x6c, 0x4f, 0x01, 0x00, 0xff,
	0x05, 0x6c, 0x4f, 0x02, 0x00, 0xff,
	0x05, 0x6c, 0x4f, 0x03, 0x00, 0x2d,
	0x05, 0x6c, 0x4f, 0x04, 0x00, 0x60,
	0x05, 0x6c, 0x6a, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x01, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x03, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x6a, 0x05, 0x00, 0x80,
	0x05, 0x6c, 0x6a, 0x06, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x07, 0x00, 0xe0,
	0x05, 0x6c, 0x6a, 0x08, 0x00, 0xcf,
	0x05, 0x6c, 0x6a, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x0a, 0x00, 0x40,
	0x05, 0x6c, 0x6a, 0x20, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x21, 0x00, 0x04,
	0x05, 0x6c, 0x6a, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x25, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x5a, 0xef, 0x00, 0xd9,
	0x05, 0x6c, 0x5a, 0xf1, 0x00, 0xf0,
	0x05, 0x6c, 0x5a, 0xf3, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x79, 0x00, 0xd9,
	0x05, 0x6c, 0x5b, 0x7b, 0x00, 0xf0,
	0x05, 0x6c, 0x5b, 0x7d, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x7e, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x80, 0x00, 0xc0,
	0x05, 0x6c, 0x5b, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5b, 0x8e, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x92, 0x00, 0x60,
	0x05, 0x6c, 0x5b, 0x93, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x97, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9a, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9b, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9c, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x9d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9f, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa0, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa1, 0x00, 0x10,
	0x05, 0x6c, 0x5b, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa3, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa4, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa5, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa8, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xab, 0x00, 0x76,
	0x05, 0x6c, 0x5b, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5b, 0xae, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xaf, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb0, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb2, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0xb3, 0x00, 0x08,
	0x05, 0x6c, 0x5b, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5b, 0xb5, 0x00, 0xc6,
	0x05, 0x6c, 0x5b, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5b, 0xc0, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc1, 0x00, 0x06,
	0x05, 0x6c, 0x5b, 0xc4, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc5, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xd2, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd4, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0xd5, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd8, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xda, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdb, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdc, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdd, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xde, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdf, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x00, 0x00, 0xc0,
	0x05, 0x6c, 0x5c, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x05, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x12, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x13, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x14, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x15, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x16, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x17, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x19, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1a, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x1b, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x1c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1d, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x28, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x29, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2a, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x2b, 0x00, 0x76,
	0x05, 0x6c, 0x5c, 0x2c, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0x2e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2f, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x30, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x31, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x34, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0x35, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0x38, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x39, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3e, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0x40, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x44, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x48, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x51, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x52, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x54, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x56, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x59, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x5a, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5d, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x5e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x67, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x80, 0x00, 0xc0,
	0x05, 0x6c, 0x5c, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x8e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x92, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x93, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x97, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x98, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9a, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9b, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9c, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x9d, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa0, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa1, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xa3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xab, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xae, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xaf, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb0, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb2, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xb3, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0xb5, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0xc6, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd2, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd6, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd9, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xda, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdb, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0xdd, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xde, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdf, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe2, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x60, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x07, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x08, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x09, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x0b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x0c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x0d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x27, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x28, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x29, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x2b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x2c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x48, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x49, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x4b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x4c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x4d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x67, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x69, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x6a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x6c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x6d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x86, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x88, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x89, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x8a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x8b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x8c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x8d, 0x00, 0x08,
	0x05, 0x6c, 0x52, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x52, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x54, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x56, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x58, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x01, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x02, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x03, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x04, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x05, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x06, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x07, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x0a, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0c, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0d, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0e, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0f, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x10, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x11, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x12, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x13, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x14, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x15, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x16, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x17, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x18, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x19, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x1a, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x1b, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x1c, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x1d, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x1e, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1f, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x20, 0x00, 0x16,
	0x05, 0x6c, 0x5e, 0x21, 0x00, 0x17,
	0x05, 0x6c, 0x5e, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x23, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x27, 0x00, 0x3f,
	0x05, 0x6c, 0x5e, 0x29, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2a, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2d, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x2f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x30, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x33, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x35, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x36, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x38, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x39, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3c, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3f, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x42, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x45, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x48, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4b, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4e, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x51, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x54, 0x00, 0x60,
	0x05, 0x6c, 0x5e, 0x56, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x57, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x59, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5a, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5d, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x60, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x62, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x63, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x65, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x66, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x68, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x69, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x6b, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x6c, 0x00, 0x20,
	0x05, 0x6c, 0x5e, 0x6e, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x6f, 0x00, 0xd0,
	0x05, 0x6c, 0x5e, 0x71, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x72, 0x00, 0x30,
	0x05, 0x6c, 0x5e, 0x74, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x75, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x77, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x78, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x80, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x81, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x84, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x00, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x01, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x02, 0x00, 0x09,
	0x05, 0x6c, 0x5f, 0x03, 0x00, 0x0a,
	0x05, 0x6c, 0x5f, 0x04, 0x00, 0x0b,
	0x05, 0x6c, 0x5f, 0x05, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x06, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x07, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x0a, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0c, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0d, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0e, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0f, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x10, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x11, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x12, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x13, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x14, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x15, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x16, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x17, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x19, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x1a, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1b, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1c, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1d, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1e, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x1f, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x20, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x21, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x23, 0x00, 0x01,
	0x05, 0x6c, 0x5f, 0x26, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x29, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2c, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2f, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x30, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x35, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x36, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x38, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x39, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3b, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3e, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x41, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x44, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4a, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4d, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x50, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x51, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x53, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x54, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x59, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5c, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x62, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x65, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x69, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x6c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6e, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x6f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x71, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x72, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x74, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x75, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x77, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x78, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7a, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7d, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x80, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x81, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x84, 0x00, 0xff,
	0x05, 0x6c, 0x52, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x52, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x54, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x56, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x58, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x00, 0x00, 0x87,
	0x05, 0x6c, 0x50, 0x01, 0x00, 0x65,
	0x05, 0x6c, 0x50, 0x02, 0x00, 0x7f,
	0x05, 0x6c, 0x50, 0x03, 0x00, 0x6a,
	0x05, 0x6c, 0x50, 0x04, 0x00, 0x3e,
	0x05, 0x6c, 0x50, 0x05, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x06, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x07, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x08, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x0a, 0x00, 0x3f,
	0x05, 0x6c, 0x50, 0x0c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x2a, 0x00, 0x10,
	0x05, 0x6c, 0x50, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x70, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x74, 0x00, 0x04,
	0x05, 0x6c, 0x40, 0x00, 0x00, 0x78,
	0x05, 0x6c, 0x40, 0x01, 0x00, 0x2b,
	0x05, 0x6c, 0x40, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x0b, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0e, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x12, 0x00, 0x30,
	0x05, 0x6c, 0x40, 0x13, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x40, 0x1e, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x1f, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x21, 0x00, 0x05,
	0x05, 0x6c, 0x40, 0x22, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x23, 0x00, 0x20,
	0x05, 0x6c, 0x40, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x27, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x29, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2b, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2d, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x7e, 0x00, 0xcc,
	0x05, 0x6c, 0x40, 0x7f, 0x00, 0x18,
	0x05, 0x6c, 0x40, 0x82, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x83, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x85, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x86, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x87, 0x00, 0x80,
	0x05, 0x6c, 0x46, 0x40, 0x00, 0x40,
	0x05, 0x6c, 0x46, 0x41, 0x00, 0x11,
	0x05, 0x6c, 0x46, 0x42, 0x00, 0x0e,
	0x05, 0x6c, 0x46, 0x43, 0x00, 0xee,
	0x05, 0x6c, 0x46, 0x46, 0x00, 0x0f,
	0x05, 0x6c, 0x46, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x49, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x09, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x0b, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x19, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x40, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x42, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x43, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x44, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x45, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x46, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x47, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x48, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x49, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x4a, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4b, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x50, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x51, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x52, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x53, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x54, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x57, 0x00, 0x10,
	0x05, 0x6c, 0x5d, 0x59, 0x00, 0x20,
	0x05, 0x6c, 0x5d, 0x5c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x5e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x60, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x61, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x62, 0x00, 0x07,
	0x05, 0x6c, 0x5d, 0x63, 0x00, 0x28,
	0x05, 0x6c, 0x5d, 0x65, 0x00, 0xff,
	0x05, 0x6c, 0x61, 0x02, 0x00, 0x1f,
	0x05, 0x6c, 0x61, 0x0a, 0x00, 0x0f,
	0x05, 0x6c, 0x61, 0x0b, 0x00, 0x20,
	0x05, 0x6c, 0x61, 0x0c, 0x00, 0x08,
	0x05, 0x6c, 0x61, 0x0d, 0x00, 0x80,
	0x05, 0x6c, 0x61, 0x44, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x45, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x46, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x47, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x48, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x49, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x50, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x51, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x52, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x53, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x54, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x55, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x56, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x57, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x58, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x59, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x60, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x61, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x62, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x63, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x64, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x65, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x66, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x67, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x68, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x69, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x70, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x71, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x72, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x73, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x74, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x75, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x76, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x77, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x78, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x79, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x80, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x81, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x82, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x83, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x84, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x85, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x86, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x87, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x88, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x89, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x90, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x91, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x92, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x93, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x94, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x95, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x96, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x97, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x98, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x99, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa0, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa1, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa2, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa3, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa4, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa5, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa6, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa7, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa8, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa9, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaa, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xab, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xac, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xad, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xae, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaf, 0x00, 0x75,
	0x05, 0x6c, 0x50, 0x22, 0x00, 0x02,
	0x05, 0x6c, 0x50, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0x66,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0xae,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x02,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0x58,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x02,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0x58,
	0x05, 0x6c, 0x03, 0x05, 0x00, 0x48,
	0x05, 0x6c, 0x03, 0x07, 0x00, 0x01,
	0x05, 0x6c, 0x03, 0x25, 0x00, 0x68,
	0x05, 0x6c, 0x50, 0x1a, 0x00, 0xff,
	0x05, 0x6c, 0x50, 0x1b, 0x00, 0xff,
	0x05, 0x6c, 0x50, 0x1e, 0x00, 0x40,
	0x05, 0x6c, 0x50, 0x1f, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x22, 0x00, 0x08,
	0x05, 0x6c, 0x50, 0x23, 0x00, 0x7a,
	0x05, 0x6c, 0x50, 0x26, 0x00, 0x40,
	0x05, 0x6c, 0x50, 0x27, 0x00, 0x00,
};

uint8_t ovx8b_hdr_4exp_30fps_init_setting[] = {
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x04,
	0x05, 0x6c, 0x46, 0x20, 0x00, 0x04,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x14,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x05,
	0x05, 0x6c, 0x46, 0x20, 0x00, 0x04,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x15,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x02,
	0x05, 0x6c, 0x35, 0x07, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0x12,
	0x05, 0x6c, 0x32, 0x08, 0x00, 0xa2,
	0x05, 0x6c, 0x03, 0x05, 0x00, 0x5c,
	0x05, 0x6c, 0x03, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x20, 0x00, 0x02,
	0x05, 0x6c, 0x03, 0x21, 0x00, 0x33,
	0x05, 0x6c, 0x03, 0x25, 0x00, 0x95,
	0x05, 0x6c, 0x04, 0x08, 0x00, 0xe7,
	0x05, 0x6c, 0x04, 0x09, 0x00, 0xff,
	0x05, 0x6c, 0x04, 0x0a, 0x00, 0x2b,
	0x05, 0x6c, 0x04, 0x0b, 0x00, 0x32,
	0x05, 0x6c, 0x04, 0x0c, 0x00, 0x28,
	0x05, 0x6c, 0x04, 0x0d, 0x00, 0x5a,
	0x05, 0x6c, 0x04, 0x0e, 0x00, 0x0c,
	0x05, 0x6c, 0x30, 0x02, 0x00, 0xf8,
	0x05, 0x6c, 0x30, 0x12, 0x00, 0x41,
	0x05, 0x6c, 0x28, 0x03, 0x00, 0xfe,
	0x05, 0x6c, 0x28, 0x0b, 0x00, 0x00,
	0x05, 0x6c, 0x28, 0x0c, 0x00, 0x79,
	0x05, 0x6c, 0x37, 0x00, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x03, 0x00, 0x43,
	0x05, 0x6c, 0x37, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x06, 0x00, 0x37,
	0x05, 0x6c, 0x37, 0x08, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0x09, 0x00, 0x5e,
	0x05, 0x6c, 0x37, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x0b, 0x00, 0x83,
	0x05, 0x6c, 0x37, 0x0e, 0x00, 0x51,
	0x05, 0x6c, 0x37, 0x12, 0x00, 0x13,
	0x05, 0x6c, 0x37, 0x17, 0x00, 0x07,
	0x05, 0x6c, 0x37, 0x18, 0x00, 0x72,
	0x05, 0x6c, 0x37, 0x19, 0x00, 0x31,
	0x05, 0x6c, 0x37, 0x2b, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x2c, 0x00, 0xb0,
	0x05, 0x6c, 0x37, 0x2d, 0x00, 0x1e,
	0x05, 0x6c, 0x37, 0x30, 0x00, 0x05,
	0x05, 0x6c, 0x37, 0x31, 0x00, 0x43,
	0x05, 0x6c, 0x37, 0x33, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x38, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x39, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x3a, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0x3b, 0x00, 0x1a,
	0x05, 0x6c, 0x37, 0x3f, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x40, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x41, 0x00, 0x1b,
	0x05, 0x6c, 0x37, 0x42, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x45, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x47, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x48, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x50, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0x55, 0x00, 0x14,
	0x05, 0x6c, 0x37, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x37, 0x57, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x59, 0x00, 0x33,
	0x05, 0x6c, 0x37, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x5b, 0x00, 0x6d,
	0x05, 0x6c, 0x37, 0x6c, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x78, 0x00, 0x20,
	0x05, 0x6c, 0x37, 0x7c, 0x00, 0x88,
	0x05, 0x6c, 0x37, 0x97, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x99, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9c, 0x00, 0x58,
	0x05, 0x6c, 0x37, 0x9e, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9f, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xa0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xa1, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xbc, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0xc0, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0xc4, 0x00, 0x34,
	0x05, 0x6c, 0x37, 0xc5, 0x00, 0x2f,
	0x05, 0x6c, 0x37, 0xc6, 0x00, 0x2a,
	0x05, 0x6c, 0x37, 0xc7, 0x00, 0x1e,
	0x05, 0x6c, 0x37, 0xc8, 0x00, 0x02,
	0x05, 0x6c, 0x37, 0xc9, 0x00, 0x09,
	0x05, 0x6c, 0x37, 0xd0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd1, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0xd2, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd3, 0x00, 0x6c,
	0x05, 0x6c, 0x37, 0xd5, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd7, 0x00, 0x66,
	0x05, 0x6c, 0x37, 0xdc, 0x00, 0x5a,
	0x05, 0x6c, 0x37, 0xdd, 0x00, 0x57,
	0x05, 0x6c, 0x3c, 0x03, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x04, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x06, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0b, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x12, 0x00, 0x40,
	0x05, 0x6c, 0x3c, 0x13, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x14, 0x00, 0x03,
	0x05, 0x6c, 0x3c, 0x21, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x22, 0x00, 0xb3,
	0x05, 0x6c, 0x3c, 0x2a, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x39, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x3d, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3e, 0x00, 0x06,
	0x05, 0x6c, 0x3c, 0x4e, 0x00, 0x0f,
	0x05, 0x6c, 0x3c, 0x55, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x57, 0x00, 0x23,
	0x05, 0x6c, 0x3c, 0x58, 0x00, 0x27,
	0x05, 0x6c, 0x3c, 0x5a, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x3c, 0x61, 0x00, 0x80,
	0x05, 0x6c, 0x3c, 0x70, 0x00, 0x62,
	0x05, 0x6c, 0x3c, 0x74, 0x00, 0x43,
	0x05, 0x6c, 0x3c, 0x78, 0x00, 0x77,
	0x05, 0x6c, 0x3c, 0xc0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc1, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc2, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc9, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xca, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xcb, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe1, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe2, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe3, 0x00, 0xd5,
	0x05, 0x6c, 0x3c, 0xe8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe9, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xea, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xeb, 0x00, 0x58,
	0x05, 0x6c, 0x32, 0x0e, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x0f, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x11, 0x00, 0x61,
	0x05, 0x6c, 0x32, 0x15, 0x00, 0xcd,
	0x05, 0x6c, 0x32, 0x19, 0x00, 0x08,
	0x05, 0x6c, 0x34, 0x00, 0x00, 0x08,
	0x05, 0x6c, 0x34, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0x06, 0x00, 0x30,
	0x05, 0x6c, 0x35, 0x86, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0x88, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0x89, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0x8b, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x35, 0x42, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x46, 0x00, 0x10,
	0x05, 0x6c, 0x35, 0x48, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x35, 0xc2, 0x00, 0x02,
	0x05, 0x6c, 0x35, 0xc6, 0x00, 0x90,
	0x05, 0x6c, 0x35, 0xc8, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0xc9, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0xcb, 0x00, 0x04,
	0x05, 0x6c, 0x36, 0x00, 0x00, 0x8f,
	0x05, 0x6c, 0x36, 0x03, 0x00, 0x40,
	0x05, 0x6c, 0x36, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x36, 0x07, 0x00, 0x02,
	0x05, 0x6c, 0x36, 0x09, 0x00, 0xe0,
	0x05, 0x6c, 0x36, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x36, 0x0e, 0x00, 0x1d,
	0x05, 0x6c, 0x36, 0x11, 0x00, 0x47,
	0x05, 0x6c, 0x36, 0x16, 0x00, 0x8a,
	0x05, 0x6c, 0x36, 0x1b, 0x00, 0x5c,
	0x05, 0x6c, 0x36, 0x1e, 0x00, 0xdc,
	0x05, 0x6c, 0x36, 0x1f, 0x00, 0xca,
	0x05, 0x6c, 0x36, 0x57, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x59, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x5a, 0x00, 0x0f,
	0x05, 0x6c, 0x36, 0x74, 0x00, 0x08,
	0x05, 0x6c, 0x36, 0x77, 0x00, 0x47,
	0x05, 0x6c, 0x36, 0x78, 0x00, 0x47,
	0x05, 0x6c, 0x38, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x06, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x07, 0x00, 0x7b,
	0x05, 0x6c, 0x38, 0x08, 0x00, 0x0f,
	0x05, 0x6c, 0x38, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x0a, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x0b, 0x00, 0x70,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x03,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0xf5,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0x66,
	0x05, 0x6c, 0x38, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x11, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x12, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x13, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x17, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1c, 0x00, 0x18,
	0x05, 0x6c, 0x38, 0x1e, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1f, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x20, 0x00, 0x20,
	0x05, 0x6c, 0x38, 0x21, 0x00, 0x19,
	0x05, 0x6c, 0x38, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0xec,
	0x05, 0x6c, 0x38, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x51, 0x00, 0x42,
	0x05, 0x6c, 0x38, 0x52, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x53, 0x00, 0x40,
	0x05, 0x6c, 0x38, 0x58, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0xe7,
	0x05, 0x6c, 0x3b, 0x40, 0x00, 0x05,
	0x05, 0x6c, 0x3b, 0x41, 0x00, 0x40,
	0x05, 0x6c, 0x3b, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x43, 0x00, 0x90,
	0x05, 0x6c, 0x3b, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x45, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x47, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x48, 0x00, 0x1a,
	0x05, 0x6c, 0x3b, 0x49, 0x00, 0x13,
	0x05, 0x6c, 0x3b, 0x4a, 0x00, 0x17,
	0x05, 0x6c, 0x3b, 0x4b, 0x00, 0x2f,
	0x05, 0x6c, 0x3b, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x4d, 0x00, 0x10,
	0x05, 0x6c, 0x3b, 0x8a, 0x00, 0x08,
	0x05, 0x6c, 0x3b, 0x8b, 0x00, 0x70,
	0x05, 0x6c, 0x3b, 0x8c, 0x00, 0x0f,
	0x05, 0x6c, 0x3b, 0x8d, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x92, 0x00, 0x08,
	0x05, 0x6c, 0x3b, 0x93, 0x00, 0x70,
	0x05, 0x6c, 0x3b, 0x94, 0x00, 0x0f,
	0x05, 0x6c, 0x3b, 0x95, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x9e, 0x00, 0x09,
	0x05, 0x6c, 0x3d, 0x8a, 0x00, 0x03,
	0x05, 0x6c, 0x3d, 0x8b, 0x00, 0xff,
	0x05, 0x6c, 0x3d, 0xa4, 0x00, 0x00,
	0x05, 0x6c, 0x42, 0x0e, 0x00, 0x44,
	0x05, 0x6c, 0x42, 0x0f, 0x00, 0x41,
	0x05, 0x6c, 0x42, 0x10, 0x00, 0x57,
	0x05, 0x6c, 0x42, 0x11, 0x00, 0x78,
	0x05, 0x6c, 0x42, 0x1e, 0x00, 0x02,
	0x05, 0x6c, 0x42, 0x1f, 0x00, 0x55,
	0x05, 0x6c, 0x42, 0x20, 0x00, 0xe1,
	0x05, 0x6c, 0x42, 0x21, 0x00, 0x07,
	0x05, 0x6c, 0x43, 0x01, 0x00, 0xff,
	0x05, 0x6c, 0x43, 0x07, 0x00, 0x03,
	0x05, 0x6c, 0x43, 0x08, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x0a, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x0d, 0x00, 0x93,
	0x05, 0x6c, 0x43, 0x0f, 0x00, 0x17,        // emb off
	0x05, 0x6c, 0x43, 0x10, 0x00, 0x95,
	0x05, 0x6c, 0x43, 0x11, 0x00, 0x16,
	0x05, 0x6c, 0x43, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x17, 0x00, 0x08,        // emb off
	0x05, 0x6c, 0x43, 0x19, 0x00, 0x03,
	0x05, 0x6c, 0x43, 0x1a, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x1b, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x1c, 0x00, 0x27,
	0x05, 0x6c, 0x43, 0x1d, 0x00, 0x67,
	0x05, 0x6c, 0x43, 0x1e, 0x00, 0x11,
	0x05, 0x6c, 0x43, 0x1f, 0x00, 0x20,
	0x05, 0x6c, 0x43, 0x20, 0x00, 0x3b,
	0x05, 0x6c, 0x43, 0x23, 0x00, 0x80,
	0x05, 0x6c, 0x43, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x03, 0x00, 0x4e,
	0x05, 0x6c, 0x45, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x08, 0x00, 0x10,
	0x05, 0x6c, 0x45, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x83, 0x00, 0x07,
	0x05, 0x6c, 0x45, 0x84, 0x00, 0x6a,
	0x05, 0x6c, 0x45, 0x85, 0x00, 0x08,
	0x05, 0x6c, 0x45, 0x86, 0x00, 0x05,
	0x05, 0x6c, 0x45, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x45, 0x88, 0x00, 0x73,
	0x05, 0x6c, 0x45, 0x89, 0x00, 0x05,
	0x05, 0x6c, 0x45, 0x8a, 0x00, 0x1f,
	0x05, 0x6c, 0x45, 0x8b, 0x00, 0x02,
	0x05, 0x6c, 0x45, 0x8c, 0x00, 0xdc,
	0x05, 0x6c, 0x45, 0x8d, 0x00, 0x03,
	0x05, 0x6c, 0x45, 0x8e, 0x00, 0x02,
	0x05, 0x6c, 0x45, 0x97, 0x00, 0x07,
	0x05, 0x6c, 0x45, 0x98, 0x00, 0x40,
	0x05, 0x6c, 0x45, 0x99, 0x00, 0x0c,
	0x05, 0x6c, 0x45, 0x9a, 0x00, 0x0c,
	0x05, 0x6c, 0x45, 0x9b, 0x00, 0xfa,
	0x05, 0x6c, 0x45, 0x9c, 0x00, 0xf8,
	0x05, 0x6c, 0x46, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x03, 0x00, 0x13,
	0x05, 0x6c, 0x46, 0x04, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x06, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x07, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x0a, 0x00, 0x30,
	0x05, 0x6c, 0x46, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x11, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x12, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x13, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x14, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x15, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x47, 0x00, 0x00, 0xe0,
	0x05, 0x6c, 0x47, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x48, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x48, 0x08, 0x00, 0x07,
	0x05, 0x6c, 0x48, 0x0a, 0x00, 0x22,
	0x05, 0x6c, 0x48, 0x13, 0x00, 0xe4,
	0x05, 0x6c, 0x48, 0x14, 0x00, 0x2a,
	0x05, 0x6c, 0x48, 0x37, 0x00, 0x07,
	0x05, 0x6c, 0x48, 0x4b, 0x00, 0x47,
	0x05, 0x6c, 0x48, 0x4f, 0x00, 0x00,
	0x05, 0x6c, 0x48, 0x50, 0x00, 0x47,
	0x05, 0x6c, 0x48, 0x53, 0x00, 0x04,
	0x05, 0x6c, 0x48, 0x55, 0x00, 0x09,
	0x05, 0x6c, 0x4d, 0x30, 0x00, 0x0a,
	0x05, 0x6c, 0x4d, 0x31, 0x00, 0x00,
	0x05, 0x6c, 0x4d, 0x5a, 0x00, 0x1a,
	0x05, 0x6c, 0x4f, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x4f, 0x01, 0x00, 0x00,
	0x05, 0x6c, 0x4f, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x4f, 0x03, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x01, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x03, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x6a, 0x05, 0x00, 0x80,
	0x05, 0x6c, 0x6a, 0x06, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x07, 0x00, 0xe0,
	0x05, 0x6c, 0x6a, 0x08, 0x00, 0xcf,
	0x05, 0x6c, 0x6a, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x0a, 0x00, 0x40,
	0x05, 0x6c, 0x6a, 0x20, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x21, 0x00, 0x04,
	0x05, 0x6c, 0x6a, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x25, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x5a, 0xef, 0x00, 0xd9,
	0x05, 0x6c, 0x5a, 0xf1, 0x00, 0xf0,
	0x05, 0x6c, 0x5a, 0xf3, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x79, 0x00, 0xd9,
	0x05, 0x6c, 0x5b, 0x7b, 0x00, 0xf0,
	0x05, 0x6c, 0x5b, 0x7d, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x7e, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x52, 0x01, 0x00, 0x04,
	0x05, 0x6c, 0x52, 0x02, 0x00, 0x04,
	0x05, 0x6c, 0x52, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x54, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x54, 0x01, 0x00, 0x04,
	0x05, 0x6c, 0x54, 0x02, 0x00, 0x04,
	0x05, 0x6c, 0x54, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x56, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x56, 0x01, 0x00, 0x04,
	0x05, 0x6c, 0x56, 0x02, 0x00, 0x04,
	0x05, 0x6c, 0x56, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x58, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x58, 0x01, 0x00, 0x04,
	0x05, 0x6c, 0x58, 0x02, 0x00, 0x04,
	0x05, 0x6c, 0x58, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0x80, 0x00, 0xc8,
	0x05, 0x6c, 0x5b, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5b, 0x8e, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x92, 0x00, 0x60,
	0x05, 0x6c, 0x5b, 0x93, 0x00, 0x10,
	0x05, 0x6c, 0x5b, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x97, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9a, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x9b, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x9c, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x9d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9f, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa0, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa1, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa3, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa4, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa5, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa8, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xab, 0x00, 0x76,
	0x05, 0x6c, 0x5b, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5b, 0xae, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xaf, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xb0, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb2, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xb3, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5b, 0xb5, 0x00, 0xc6,
	0x05, 0x6c, 0x5b, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5b, 0xc0, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc1, 0x00, 0x06,
	0x05, 0x6c, 0x5b, 0xc4, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc5, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xd2, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd4, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0xd5, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd8, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xda, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdb, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdc, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdd, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xde, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdf, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x00, 0x00, 0xc8,
	0x05, 0x6c, 0x5c, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x05, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x0e, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x12, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x13, 0x00, 0x10,
	0x05, 0x6c, 0x5c, 0x14, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x15, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x16, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x17, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x19, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1a, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x1b, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x1c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1d, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x28, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x29, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2a, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x2b, 0x00, 0x76,
	0x05, 0x6c, 0x5c, 0x2c, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0x2e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2f, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x30, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x31, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x34, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0x35, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0x38, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x39, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3e, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0x40, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x44, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x48, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x51, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x52, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x54, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x56, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x59, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x5a, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5d, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x5e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x67, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x80, 0x00, 0xc0,
	0x05, 0x6c, 0x5c, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x8e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x92, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x93, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x97, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x98, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9a, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9b, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9c, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x9d, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa0, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa1, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xa3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xab, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xae, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xaf, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb0, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb2, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xb3, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0xb5, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0xc6, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd2, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd6, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd9, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xda, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdb, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0xdd, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xde, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdf, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe2, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x60, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x07, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x08, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x09, 0x00, 0x72,
	0x05, 0x6c, 0x60, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x0b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x0c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x0d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x27, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x28, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x29, 0x00, 0x72,
	0x05, 0x6c, 0x60, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x2b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x2c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x48, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x49, 0x00, 0x72,
	0x05, 0x6c, 0x60, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x4b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x4c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x4d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x67, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x69, 0x00, 0x72,
	0x05, 0x6c, 0x60, 0x6a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x6c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x6d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x86, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x88, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x89, 0x00, 0x72,
	0x05, 0x6c, 0x60, 0x8a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x8b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x8c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x8d, 0x00, 0x08,
	0x05, 0x6c, 0x52, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x52, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x54, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x56, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x58, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x01, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x02, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x03, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x04, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x05, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x06, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x07, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x0a, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0c, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x0d, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x0e, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x0f, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x10, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x11, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x12, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x13, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x14, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x15, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x16, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x17, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x18, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x19, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x1a, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x1b, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1c, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1d, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1e, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x1f, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x20, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x21, 0x00, 0x16,
	0x05, 0x6c, 0x5e, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x23, 0x00, 0x02,
	0x05, 0x6c, 0x5e, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x27, 0x00, 0xff,
	0x05, 0x6c, 0x5e, 0x29, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2c, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x2d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2f, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x30, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x33, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x35, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x36, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x38, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x39, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3c, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3f, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x42, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x45, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x48, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4b, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4e, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x51, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x54, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x56, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x57, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x59, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5a, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5d, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x60, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x62, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x63, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x65, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x66, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x68, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x69, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x6b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6c, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x6e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6f, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x71, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x72, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x74, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x75, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x77, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x78, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x7a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7b, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x7d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7e, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x80, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x81, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x84, 0x00, 0x40,
	0x05, 0x6c, 0x5f, 0x00, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x01, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x02, 0x00, 0x09,
	0x05, 0x6c, 0x5f, 0x03, 0x00, 0x0a,
	0x05, 0x6c, 0x5f, 0x04, 0x00, 0x0b,
	0x05, 0x6c, 0x5f, 0x05, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x06, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x07, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x0a, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0c, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0d, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0e, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0f, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x10, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x11, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x12, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x13, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x14, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x15, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x16, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x17, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x19, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x1a, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1b, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1c, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1d, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1e, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x1f, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x20, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x21, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x23, 0x00, 0x01,
	0x05, 0x6c, 0x5f, 0x26, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x29, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2c, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2f, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x30, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x35, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x36, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x38, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x39, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3b, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3e, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x41, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x44, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4a, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4d, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x50, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x51, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x53, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x54, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x59, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5c, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x62, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x65, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x69, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x6c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6e, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x6f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x71, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x72, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x74, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x75, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x77, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x78, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7a, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7d, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x80, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x81, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x84, 0x00, 0xff,
	0x05, 0x6c, 0x52, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x52, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x54, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x56, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x58, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5d, 0xc0, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xc1, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xc2, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xc3, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xe0, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xe1, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xe2, 0x00, 0x04,
	0x05, 0x6c, 0x5d, 0xe3, 0x00, 0x04,
	0x05, 0x6c, 0x50, 0x00, 0x00, 0x87,
	0x05, 0x6c, 0x50, 0x01, 0x00, 0x75,
	0x05, 0x6c, 0x50, 0x02, 0x00, 0x7f,
	0x05, 0x6c, 0x50, 0x03, 0x00, 0x3a,
	0x05, 0x6c, 0x50, 0x04, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x05, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x06, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x07, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x08, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x0a, 0x00, 0x3f,
	0x05, 0x6c, 0x50, 0x0c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x2a, 0x00, 0x10,
	0x05, 0x6c, 0x50, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x70, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x74, 0x00, 0x04,
	0x05, 0x6c, 0x40, 0x00, 0x00, 0x78,
	0x05, 0x6c, 0x40, 0x01, 0x00, 0x2b,
	0x05, 0x6c, 0x40, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x0b, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0e, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x12, 0x00, 0x30,
	0x05, 0x6c, 0x40, 0x13, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x40, 0x1e, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x1f, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x21, 0x00, 0x05,
	0x05, 0x6c, 0x40, 0x22, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x23, 0x00, 0x20,
	0x05, 0x6c, 0x40, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x27, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x29, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2b, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2d, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x7e, 0x00, 0xcc,
	0x05, 0x6c, 0x40, 0x7f, 0x00, 0x18,
	0x05, 0x6c, 0x40, 0x82, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x83, 0x00, 0x18,
	0x05, 0x6c, 0x40, 0x84, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x85, 0x00, 0x18,
	0x05, 0x6c, 0x40, 0x86, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x87, 0x00, 0xa0,
	0x05, 0x6c, 0x46, 0x40, 0x00, 0x40,
	0x05, 0x6c, 0x46, 0x41, 0x00, 0x11,
	0x05, 0x6c, 0x46, 0x42, 0x00, 0x0e,
	0x05, 0x6c, 0x46, 0x43, 0x00, 0xee,
	0x05, 0x6c, 0x46, 0x46, 0x00, 0x0f,
	0x05, 0x6c, 0x46, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x49, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x09, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x0b, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x19, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x40, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x42, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x43, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x44, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x45, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x46, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x47, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x48, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x49, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x4a, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4b, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x50, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x51, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x52, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x53, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x54, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x57, 0x00, 0x10,
	0x05, 0x6c, 0x5d, 0x59, 0x00, 0x20,
	0x05, 0x6c, 0x5d, 0x5c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x5e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x60, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x61, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x62, 0x00, 0x07,
	0x05, 0x6c, 0x5d, 0x63, 0x00, 0x28,
	0x05, 0x6c, 0x5d, 0x65, 0x00, 0xff,
	0x05, 0x6c, 0x61, 0x02, 0x00, 0x1f,
	0x05, 0x6c, 0x61, 0x0a, 0x00, 0x0f,
	0x05, 0x6c, 0x61, 0x0b, 0x00, 0x20,
	0x05, 0x6c, 0x61, 0x0c, 0x00, 0x08,
	0x05, 0x6c, 0x61, 0x0d, 0x00, 0x80,
	0x05, 0x6c, 0x61, 0x44, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x45, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x46, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x47, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x48, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x49, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x50, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x51, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x52, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x53, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x54, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x55, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x56, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x57, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x58, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x59, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x60, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x61, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x62, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x63, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x64, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x65, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x66, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x67, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x68, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x69, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x70, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x71, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x72, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x73, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x74, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x75, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x76, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x77, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x78, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x79, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x80, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x81, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x82, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x83, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x84, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x85, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x86, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x87, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x88, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x89, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x90, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x91, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x92, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x93, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x94, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x95, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x96, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x97, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x98, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x99, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa0, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa1, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa2, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa3, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa4, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa5, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa6, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa7, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa8, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa9, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaa, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xab, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xac, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xad, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xae, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaf, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x20, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x21, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x22, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x23, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x24, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x25, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x26, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x27, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x28, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x29, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x30, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x31, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x32, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x33, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x34, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x35, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x36, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x37, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x38, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x39, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x40, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x41, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x42, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x43, 0x00, 0x75,
	0x05, 0x6c, 0x4f, 0x04, 0x00, 0x78,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x05,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0x4c,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x03,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0xf5,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0xec,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0xe7,
	0x05, 0x6c, 0x42, 0x0e, 0x00, 0x63,
	0x05, 0x6c, 0x42, 0x0f, 0x00, 0x77,
	0x05, 0x6c, 0x42, 0x10, 0x00, 0xce,
	0x05, 0x6c, 0x42, 0x11, 0x00, 0xed,
	0x05, 0x6c, 0x50, 0x7a, 0x00, 0x28,
	0x05, 0x6c, 0x50, 0x7b, 0x00, 0x40,
	0x05, 0x6c, 0x04, 0x08, 0x00, 0xe7,
	0x05, 0x6c, 0x04, 0x09, 0x00, 0xff,
	0x05, 0x6c, 0x04, 0x0a, 0x00, 0x2b,
	0x05, 0x6c, 0x04, 0x0b, 0x00, 0x32,
	0x05, 0x6c, 0x04, 0x0c, 0x00, 0x50,
	0x05, 0x6c, 0x04, 0x0d, 0x00, 0xb3,
	0x05, 0x6c, 0x04, 0x0e, 0x00, 0x0c,
	0x05, 0x6c, 0x50, 0x04, 0x00, 0x1e,
	0x05, 0x6c, 0x03, 0x07, 0x00, 0x01,
	0x05, 0x6c, 0x48, 0x37, 0x00, 0x0e,
	0x05, 0x6c, 0x42, 0x21, 0x00, 0x07,
	0x05, 0x6c, 0x35, 0x06, 0x00, 0x40,
	0x05, 0x6c, 0x35, 0x46, 0x00, 0x10,
	0x05, 0x6c, 0x35, 0xc6, 0x00, 0x90,
	0x05, 0x6c, 0x4f, 0x03, 0x00, 0x2c,
};

uint8_t ovx8b_hdr_4exp_30fps_init_setting_old[] = {
	// X8B_3840X2160_30fps_HDR4_PWL12_LFR_mipi960_R1D-24M_0621
	0x05, 0x6c, 0x01, 0x03, 0x00, 0x01,
	0x05, 0x6c, 0x01, 0x07, 0x00, 0x01,
	0x00, 0x0a,
	0x05, 0x6c, 0x03, 0x05, 0x00, 0x3c,
	0x05, 0x6c, 0x03, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x03, 0x20, 0x00, 0x02,
	0x05, 0x6c, 0x03, 0x21, 0x00, 0x33,
	0x05, 0x6c, 0x03, 0x25, 0x00, 0x95,
	0x05, 0x6c, 0x04, 0x08, 0x00, 0xe7,
	0x05, 0x6c, 0x04, 0x09, 0x00, 0xff,
	0x05, 0x6c, 0x04, 0x0a, 0x00, 0x2b,
	0x05, 0x6c, 0x04, 0x0b, 0x00, 0x32,
	0x05, 0x6c, 0x04, 0x0c, 0x00, 0x28,
	0x05, 0x6c, 0x04, 0x0d, 0x00, 0x5a,
	0x05, 0x6c, 0x04, 0x0e, 0x00, 0x0c,
	0x05, 0x6c, 0x30, 0x02, 0x00, 0xf8,
	0x05, 0x6c, 0x30, 0x12, 0x00, 0x41,
	0x05, 0x6c, 0x28, 0x03, 0x00, 0xfe,
	0x05, 0x6c, 0x28, 0x0b, 0x00, 0x00,
	0x05, 0x6c, 0x28, 0x0c, 0x00, 0x79,
	0x05, 0x6c, 0x37, 0x00, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x06, 0x00, 0x35,
	0x05, 0x6c, 0x37, 0x09, 0x00, 0x5e,
	0x05, 0x6c, 0x37, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x0b, 0x00, 0x7d,
	0x05, 0x6c, 0x37, 0x0e, 0x00, 0x51,
	0x05, 0x6c, 0x37, 0x12, 0x00, 0x13,
	0x05, 0x6c, 0x37, 0x17, 0x00, 0x07,
	0x05, 0x6c, 0x37, 0x18, 0x00, 0x72,
	0x05, 0x6c, 0x37, 0x19, 0x00, 0x24,
	0x05, 0x6c, 0x37, 0x2b, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x2c, 0x00, 0xb0,
	0x05, 0x6c, 0x37, 0x30, 0x00, 0x12,
	0x05, 0x6c, 0x37, 0x31, 0x00, 0x43,
	0x05, 0x6c, 0x37, 0x33, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x38, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x39, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x3a, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0x3b, 0x00, 0x1a,
	0x05, 0x6c, 0x37, 0x3f, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x40, 0x00, 0x21,
	0x05, 0x6c, 0x37, 0x41, 0x00, 0x1b,
	0x05, 0x6c, 0x37, 0x42, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x45, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0x47, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x48, 0x00, 0x19,
	0x05, 0x6c, 0x37, 0x50, 0x00, 0x32,
	0x05, 0x6c, 0x37, 0x55, 0x00, 0x14,
	0x05, 0x6c, 0x37, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x37, 0x57, 0x00, 0x16,
	0x05, 0x6c, 0x37, 0x59, 0x00, 0x31,
	0x05, 0x6c, 0x37, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x5b, 0x00, 0x6e,
	0x05, 0x6c, 0x37, 0x6c, 0x00, 0x27,
	0x05, 0x6c, 0x37, 0x78, 0x00, 0x20,
	0x05, 0x6c, 0x37, 0x7c, 0x00, 0xc8,
	0x05, 0x6c, 0x37, 0x97, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x99, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9c, 0x00, 0x58,
	0x05, 0x6c, 0x37, 0x9e, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0x9f, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xa0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xbc, 0x00, 0x22,
	0x05, 0x6c, 0x37, 0xc0, 0x00, 0x01,
	0x05, 0x6c, 0x37, 0xc4, 0x00, 0x2f,
	0x05, 0x6c, 0x37, 0xc5, 0x00, 0x2f,
	0x05, 0x6c, 0x37, 0xc6, 0x00, 0x2a,
	0x05, 0x6c, 0x37, 0xc7, 0x00, 0x1e,
	0x05, 0x6c, 0x37, 0xc8, 0x00, 0x02,
	0x05, 0x6c, 0x37, 0xc9, 0x00, 0x09,
	0x05, 0x6c, 0x37, 0xd0, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd1, 0x00, 0x30,
	0x05, 0x6c, 0x37, 0xd2, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd3, 0x00, 0x6d,
	0x05, 0x6c, 0x37, 0xd5, 0x00, 0x30,
	0x05, 0x6c, 0x37, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x37, 0xd7, 0x00, 0x64,
	0x05, 0x6c, 0x37, 0xdc, 0x00, 0x5a,
	0x05, 0x6c, 0x37, 0xdd, 0x00, 0x57,
	0x05, 0x6c, 0x3c, 0x03, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x04, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x06, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x0b, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x12, 0x00, 0x40,
	0x05, 0x6c, 0x3c, 0x13, 0x00, 0x21,
	0x05, 0x6c, 0x3c, 0x14, 0x00, 0x03,
	0x05, 0x6c, 0x3c, 0x21, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x22, 0x00, 0xb3,
	0x05, 0x6c, 0x3c, 0x2a, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x39, 0x00, 0x11,
	0x05, 0x6c, 0x3c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0x3d, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0x3e, 0x00, 0x06,
	0x05, 0x6c, 0x3c, 0x55, 0x00, 0x20,
	0x05, 0x6c, 0x3c, 0x57, 0x00, 0x0c,
	0x05, 0x6c, 0x3c, 0x58, 0x00, 0x0c,
	0x05, 0x6c, 0x3c, 0x5a, 0x00, 0x43,
	0x05, 0x6c, 0x3c, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x3c, 0x61, 0x00, 0x80,
	0x05, 0x6c, 0x3c, 0x78, 0x00, 0x76,
	0x05, 0x6c, 0x3c, 0xc0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc1, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc2, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xc9, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xca, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xcb, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe1, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe2, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xe3, 0x00, 0xd5,
	0x05, 0x6c, 0x3c, 0xe8, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xe9, 0x00, 0x01,
	0x05, 0x6c, 0x3c, 0xea, 0x00, 0x00,
	0x05, 0x6c, 0x3c, 0xeb, 0x00, 0x58,
	0x05, 0x6c, 0x32, 0x0e, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x0f, 0x00, 0x00,
	0x05, 0x6c, 0x32, 0x11, 0x00, 0x61,
	0x05, 0x6c, 0x32, 0x15, 0x00, 0xcd,
	0x05, 0x6c, 0x32, 0x19, 0x00, 0x08,
	0x05, 0x6c, 0x34, 0x00, 0x00, 0x08,
	0x05, 0x6c, 0x34, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0x89, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0x8b, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x35, 0x42, 0x00, 0x04,
	0x05, 0x6c, 0x35, 0x48, 0x00, 0x01,
	0x05, 0x6c, 0x35, 0xc2, 0x00, 0x02,
	0x05, 0x6c, 0x35, 0xc9, 0x00, 0x50,
	0x05, 0x6c, 0x35, 0xcb, 0x00, 0x04,
	0x05, 0x6c, 0x36, 0x00, 0x00, 0x8f,
	0x05, 0x6c, 0x36, 0x03, 0x00, 0x40,
	0x05, 0x6c, 0x36, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x36, 0x07, 0x00, 0x02,
	0x05, 0x6c, 0x36, 0x09, 0x00, 0xe0,
	0x05, 0x6c, 0x36, 0x0a, 0x00, 0x01,
	0x05, 0x6c, 0x36, 0x11, 0x00, 0x3f,
	0x05, 0x6c, 0x36, 0x16, 0x00, 0x8a,
	0x05, 0x6c, 0x36, 0x1e, 0x00, 0xf4,
	0x05, 0x6c, 0x36, 0x1f, 0x00, 0xcb,
	0x05, 0x6c, 0x36, 0x57, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x59, 0x00, 0x0a,
	0x05, 0x6c, 0x36, 0x5a, 0x00, 0x0f,
	0x05, 0x6c, 0x36, 0x74, 0x00, 0x08,
	0x05, 0x6c, 0x36, 0x77, 0x00, 0x3f,
	0x05, 0x6c, 0x36, 0x78, 0x00, 0x3f,
	0x05, 0x6c, 0x38, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x03, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x06, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x07, 0x00, 0x7b,
	0x05, 0x6c, 0x38, 0x08, 0x00, 0x0f,
	0x05, 0x6c, 0x38, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x0a, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x0b, 0x00, 0x70,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x03,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0xdc,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0x66,
	0x05, 0x6c, 0x38, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x11, 0x00, 0x08,
	0x05, 0x6c, 0x38, 0x12, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x13, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x17, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1c, 0x00, 0x18,
	0x05, 0x6c, 0x38, 0x1e, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x1f, 0x00, 0x01,

	0x05, 0x6c, 0x38, 0x20, 0x00, 0x20,
	0x05, 0x6c, 0x38, 0x21, 0x00, 0x19,
	0x05, 0x6c, 0x38, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0xee,
	0x05, 0x6c, 0x38, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x51, 0x00, 0x42,
	0x05, 0x6c, 0x38, 0x52, 0x00, 0x00,
	0x05, 0x6c, 0x38, 0x53, 0x00, 0x40,
	0x05, 0x6c, 0x38, 0x58, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x01,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0xee,
	0x05, 0x6c, 0x3b, 0x40, 0x00, 0x04,
	0x05, 0x6c, 0x3b, 0x41, 0x00, 0x80,
	0x05, 0x6c, 0x3b, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x43, 0x00, 0x90,
	0x05, 0x6c, 0x3b, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x45, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x47, 0x00, 0x20,
	0x05, 0x6c, 0x3b, 0x48, 0x00, 0x16,
	0x05, 0x6c, 0x3b, 0x49, 0x00, 0x0e,
	0x05, 0x6c, 0x3b, 0x4a, 0x00, 0x12,
	0x05, 0x6c, 0x3b, 0x4b, 0x00, 0x2a,
	0x05, 0x6c, 0x3b, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x4d, 0x00, 0x10,
	0x05, 0x6c, 0x3b, 0x8a, 0x00, 0x08,
	0x05, 0x6c, 0x3b, 0x8b, 0x00, 0x70,
	0x05, 0x6c, 0x3b, 0x8c, 0x00, 0x0f,
	0x05, 0x6c, 0x3b, 0x8d, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x92, 0x00, 0x08,
	0x05, 0x6c, 0x3b, 0x93, 0x00, 0x70,
	0x05, 0x6c, 0x3b, 0x94, 0x00, 0x0f,
	0x05, 0x6c, 0x3b, 0x95, 0x00, 0x00,
	0x05, 0x6c, 0x3b, 0x9e, 0x00, 0x09,
	0x05, 0x6c, 0x3d, 0x8a, 0x00, 0x03,
	0x05, 0x6c, 0x3d, 0x8b, 0x00, 0xff,
	0x05, 0x6c, 0x42, 0x0e, 0x00, 0x4d,
	0x05, 0x6c, 0x42, 0x0f, 0x00, 0x15,
	0x05, 0x6c, 0x42, 0x10, 0x00, 0xfc,
	0x05, 0x6c, 0x42, 0x11, 0x00, 0x30,
	0x05, 0x6c, 0x42, 0x1e, 0x00, 0x02,
	0x05, 0x6c, 0x42, 0x1f, 0x00, 0x45,
	0x05, 0x6c, 0x42, 0x20, 0x00, 0xc1,
	0x05, 0x6c, 0x42, 0x21, 0x00, 0x05,
	0x05, 0x6c, 0x43, 0x01, 0x00, 0xff,
	0x05, 0x6c, 0x43, 0x07, 0x00, 0x03,
	0x05, 0x6c, 0x43, 0x08, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x0a, 0x00, 0x13,
	0x05, 0x6c, 0x43, 0x0d, 0x00, 0x93,
	0x05, 0x6c, 0x43, 0x0f, 0x00, 0x17,  // statistics off
	0x05, 0x6c, 0x43, 0x10, 0x00, 0x95,
	0x05, 0x6c, 0x43, 0x11, 0x00, 0x16,  // column id off
	0x05, 0x6c, 0x43, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x17, 0x00, 0x08,  // embedded off
	0x05, 0x6c, 0x43, 0x19, 0x00, 0x03,
	0x05, 0x6c, 0x43, 0x1b, 0x00, 0x00,
	0x05, 0x6c, 0x43, 0x1c, 0x00, 0x27,
	0x05, 0x6c, 0x43, 0x1d, 0x00, 0x67,
	0x05, 0x6c, 0x43, 0x1e, 0x00, 0x11,
	0x05, 0x6c, 0x43, 0x1f, 0x00, 0x20,
	0x05, 0x6c, 0x43, 0x20, 0x00, 0x3b,
	0x05, 0x6c, 0x43, 0x23, 0x00, 0x80,
	0x05, 0x6c, 0x43, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x03, 0x00, 0x4e,
	0x05, 0x6c, 0x45, 0x05, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x08, 0x00, 0x10,
	0x05, 0x6c, 0x45, 0x09, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x45, 0x83, 0x00, 0x06,
	0x05, 0x6c, 0x45, 0x84, 0x00, 0xee,
	0x05, 0x6c, 0x45, 0x85, 0x00, 0x08,
	0x05, 0x6c, 0x45, 0x86, 0x00, 0x88,
	0x05, 0x6c, 0x45, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x45, 0x88, 0x00, 0x0d,
	0x05, 0x6c, 0x45, 0x89, 0x00, 0x09,
	0x05, 0x6c, 0x45, 0x8a, 0x00, 0xae,
	0x05, 0x6c, 0x45, 0x8b, 0x00, 0x02,
	0x05, 0x6c, 0x45, 0x8c, 0x00, 0x44,
	0x05, 0x6c, 0x45, 0x8d, 0x00, 0x03,
	0x05, 0x6c, 0x45, 0x8e, 0x00, 0x55,
	0x05, 0x6c, 0x46, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x03, 0x00, 0x13,
	0x05, 0x6c, 0x46, 0x04, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x06, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x07, 0x00, 0x06,
	0x05, 0x6c, 0x46, 0x0a, 0x00, 0x30,
	0x05, 0x6c, 0x46, 0x10, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x11, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x12, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x13, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x14, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x15, 0x00, 0xe0,
	0x05, 0x6c, 0x46, 0x16, 0x00, 0x01,
	0x05, 0x6c, 0x46, 0x17, 0x00, 0x00,
	0x05, 0x6c, 0x47, 0x00, 0x00, 0xe0,
	0x05, 0x6c, 0x48, 0x00, 0x00, 0x04,
	0x05, 0x6c, 0x48, 0x0a, 0x00, 0x22,
	0x05, 0x6c, 0x48, 0x13, 0x00, 0xe4,
	0x05, 0x6c, 0x48, 0x14, 0x00, 0x2a,
	0x05, 0x6c, 0x48, 0x37, 0x00, 0x0b,
	0x05, 0x6c, 0x48, 0x4b, 0x00, 0x47,
	0x05, 0x6c, 0x48, 0x4f, 0x00, 0x00,
	0x05, 0x6c, 0x48, 0x50, 0x00, 0x47,
	0x05, 0x6c, 0x4d, 0x5a, 0x00, 0x18,
	0x05, 0x6c, 0x4f, 0x00, 0x00, 0x3f,
	0x05, 0x6c, 0x4f, 0x01, 0x00, 0xff,
	0x05, 0x6c, 0x4f, 0x02, 0x00, 0xff,
	0x05, 0x6c, 0x4f, 0x03, 0x00, 0x2d,
	0x05, 0x6c, 0x6a, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x01, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x02, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x03, 0x00, 0x20,
	0x05, 0x6c, 0x6a, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x6a, 0x05, 0x00, 0x80,
	0x05, 0x6c, 0x6a, 0x06, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x07, 0x00, 0xe0,
	0x05, 0x6c, 0x6a, 0x08, 0x00, 0xcf,
	0x05, 0x6c, 0x6a, 0x09, 0x00, 0x01,
	0x05, 0x6c, 0x6a, 0x0a, 0x00, 0x40,
	0x05, 0x6c, 0x6a, 0x20, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x21, 0x00, 0x04,
	0x05, 0x6c, 0x6a, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x25, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x6a, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x5a, 0xef, 0x00, 0xd9,
	0x05, 0x6c, 0x5a, 0xf1, 0x00, 0xf0,
	0x05, 0x6c, 0x5a, 0xf3, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x79, 0x00, 0xd9,
	0x05, 0x6c, 0x5b, 0x7b, 0x00, 0xf0,
	0x05, 0x6c, 0x5b, 0x7d, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x7e, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x80, 0x00, 0xc0,
	0x05, 0x6c, 0x5b, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5b, 0x8e, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x92, 0x00, 0x60,
	0x05, 0x6c, 0x5b, 0x93, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x97, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0x98, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9a, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9b, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9c, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0x9d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0x9f, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa0, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa1, 0x00, 0x10,
	0x05, 0x6c, 0x5b, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xa3, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa4, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa5, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xa8, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xab, 0x00, 0x76,
	0x05, 0x6c, 0x5b, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5b, 0xae, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xaf, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb0, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xb2, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0xb3, 0x00, 0x08,
	0x05, 0x6c, 0x5b, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5b, 0xb5, 0x00, 0xc6,
	0x05, 0x6c, 0x5b, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5b, 0xc0, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc1, 0x00, 0x06,
	0x05, 0x6c, 0x5b, 0xc4, 0x00, 0x04,
	0x05, 0x6c, 0x5b, 0xc5, 0x00, 0x02,
	0x05, 0x6c, 0x5b, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5b, 0xd2, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd4, 0x00, 0x40,
	0x05, 0x6c, 0x5b, 0xd5, 0x00, 0x20,
	0x05, 0x6c, 0x5b, 0xd6, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd7, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd8, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xd9, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xda, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdb, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdc, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdd, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xde, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xdf, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe0, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x00, 0x00, 0xc0,
	0x05, 0x6c, 0x5c, 0x04, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x05, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x12, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x13, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x14, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x15, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x16, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x17, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x18, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x19, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1a, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x1b, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x1c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1d, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x1e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x1f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x23, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x28, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x29, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2a, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x2b, 0x00, 0x76,
	0x05, 0x6c, 0x5c, 0x2c, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0x2e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x2f, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x30, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x31, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x34, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0x35, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0x38, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x39, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3a, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0x3e, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0x40, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x44, 0x00, 0x04,
	0x05, 0x6c, 0x5c, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x48, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x51, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x52, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x54, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x56, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x59, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x5a, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5d, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x5e, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0x67, 0x00, 0x86,
	0x05, 0x6c, 0x5c, 0x80, 0x00, 0xc0,
	0x05, 0x6c, 0x5c, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0x85, 0x00, 0xcc,
	0x05, 0x6c, 0x5c, 0x8e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x8f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x92, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x93, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x94, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x95, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x96, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x97, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0x98, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x99, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9a, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9b, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9c, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0x9d, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0x9e, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0x9f, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa0, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa1, 0x00, 0x20,
	0x05, 0x6c, 0x5c, 0xa2, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xa3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xa8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xa9, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xaa, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xab, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xac, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xad, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xae, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xaf, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb0, 0x00, 0x02,
	0x05, 0x6c, 0x5c, 0xb1, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xb2, 0x00, 0x03,
	0x05, 0x6c, 0x5c, 0xb3, 0x00, 0x08,
	0x05, 0x6c, 0x5c, 0xb4, 0x00, 0x05,
	0x05, 0x6c, 0x5c, 0xb5, 0x00, 0x33,
	0x05, 0x6c, 0x5c, 0xb8, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xb9, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xba, 0x00, 0x01,
	0x05, 0x6c, 0x5c, 0xbe, 0x00, 0x0a,
	0x05, 0x6c, 0x5c, 0xc6, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc7, 0x00, 0x00,
	0x05, 0x6c, 0x5c, 0xc8, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd2, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd5, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xd6, 0x00, 0x60,
	0x05, 0x6c, 0x5c, 0xd9, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xda, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdb, 0x00, 0x40,
	0x05, 0x6c, 0x5c, 0xdd, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xde, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xdf, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe2, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe3, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe4, 0x00, 0x80,
	0x05, 0x6c, 0x5c, 0xe7, 0x00, 0x86,
	0x05, 0x6c, 0x60, 0x06, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x07, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x08, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x09, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x0a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x0b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x0c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x0d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x16, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x27, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x28, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x29, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x2b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x2c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x2d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x48, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x49, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x4b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x4c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x4d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x67, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x69, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x6a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x6c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x6d, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x86, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x87, 0x00, 0x04,
	0x05, 0x6c, 0x60, 0x88, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x89, 0x00, 0x74,
	0x05, 0x6c, 0x60, 0x8a, 0x00, 0x00,
	0x05, 0x6c, 0x60, 0x8b, 0x00, 0x08,
	0x05, 0x6c, 0x60, 0x8c, 0x00, 0x0f,
	0x05, 0x6c, 0x60, 0x8d, 0x00, 0x08,
	0x05, 0x6c, 0x52, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x52, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x52, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x54, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x54, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x56, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x56, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc3, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc4, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0xc6, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xc7, 0x00, 0x23,
	0x05, 0x6c, 0x58, 0xc9, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xca, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcb, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcd, 0x00, 0x02,
	0x05, 0x6c, 0x58, 0xce, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0xcf, 0x00, 0x01,
	0x05, 0x6c, 0x52, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x52, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x52, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x54, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x54, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x56, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x56, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x40, 0x00, 0x0f,
	0x05, 0x6c, 0x58, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x58, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x00, 0x00, 0x87,
	0x05, 0x6c, 0x50, 0x01, 0x00, 0x75,
	0x05, 0x6c, 0x50, 0x02, 0x00, 0x7f,
	0x05, 0x6c, 0x50, 0x03, 0x00, 0x7a,  // pre_ccm enable
	0x05, 0x6c, 0x50, 0x04, 0x00, 0x3e,
	0x05, 0x6c, 0x50, 0x05, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x06, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x07, 0x00, 0x1e,
	0x05, 0x6c, 0x50, 0x08, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x0a, 0x00, 0x3f,
	0x05, 0x6c, 0x50, 0x0c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x2a, 0x00, 0x10,
	0x05, 0x6c, 0x50, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x70, 0x00, 0x00,
	0x05, 0x6c, 0x50, 0x74, 0x00, 0x04,
	0x05, 0x6c, 0x40, 0x00, 0x00, 0x78,
	0x05, 0x6c, 0x40, 0x01, 0x00, 0x2b,
	0x05, 0x6c, 0x40, 0x08, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x0b, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0e, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x0f, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x12, 0x00, 0x30,
	0x05, 0x6c, 0x40, 0x13, 0x00, 0x01,
	0x05, 0x6c, 0x40, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x40, 0x1e, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x1f, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x21, 0x00, 0x05,
	0x05, 0x6c, 0x40, 0x22, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x23, 0x00, 0x20,
	0x05, 0x6c, 0x40, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x27, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x29, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2b, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x40, 0x2d, 0x00, 0x40,
	0x05, 0x6c, 0x40, 0x7e, 0x00, 0xcc,
	0x05, 0x6c, 0x40, 0x7f, 0x00, 0x18,
	0x05, 0x6c, 0x40, 0x82, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x83, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x84, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x85, 0x00, 0x80,
	0x05, 0x6c, 0x40, 0x86, 0x00, 0x02,
	0x05, 0x6c, 0x40, 0x87, 0x00, 0x80,
	0x05, 0x6c, 0x46, 0x40, 0x00, 0x40,
	0x05, 0x6c, 0x46, 0x41, 0x00, 0x11,
	0x05, 0x6c, 0x46, 0x42, 0x00, 0x0e,
	0x05, 0x6c, 0x46, 0x43, 0x00, 0xee,
	0x05, 0x6c, 0x46, 0x46, 0x00, 0x0f,
	0x05, 0x6c, 0x46, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x46, 0x49, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x09, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x0b, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x19, 0x00, 0x6b,
	0x05, 0x6c, 0x5d, 0x40, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x42, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x43, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x44, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x45, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x46, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x47, 0x00, 0x85,
	0x05, 0x6c, 0x5d, 0x48, 0x00, 0x1b,
	0x05, 0x6c, 0x5d, 0x49, 0x00, 0xdd,
	0x05, 0x6c, 0x5d, 0x4a, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4b, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x4e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x4f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x50, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x51, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x52, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x53, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x54, 0x00, 0x18,
	0x05, 0x6c, 0x5d, 0x55, 0x00, 0x80,
	0x05, 0x6c, 0x5d, 0x57, 0x00, 0x10,
	0x05, 0x6c, 0x5d, 0x59, 0x00, 0x20,
	0x05, 0x6c, 0x5d, 0x5c, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5d, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x5e, 0x00, 0x02,
	0x05, 0x6c, 0x5d, 0x5f, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x60, 0x00, 0x03,
	0x05, 0x6c, 0x5d, 0x61, 0x00, 0x40,
	0x05, 0x6c, 0x5d, 0x62, 0x00, 0x07,
	0x05, 0x6c, 0x5d, 0x63, 0x00, 0x28,
	0x05, 0x6c, 0x5d, 0x65, 0x00, 0xff,
	0x05, 0x6c, 0x61, 0x02, 0x00, 0x1f,
	0x05, 0x6c, 0x61, 0x0a, 0x00, 0x0f,
	0x05, 0x6c, 0x61, 0x0b, 0x00, 0x20,
	0x05, 0x6c, 0x61, 0x0c, 0x00, 0x08,
	0x05, 0x6c, 0x61, 0x0d, 0x00, 0x80,
	0x05, 0x6c, 0x61, 0x44, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x45, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x46, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x47, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x48, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x49, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x4f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x50, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x51, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x52, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x53, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x54, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x55, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x56, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x57, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x58, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x59, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x5f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x60, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x61, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x62, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x63, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x64, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x65, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x66, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x67, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x68, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x69, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x6f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x70, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x71, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x72, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x73, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x74, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x75, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x76, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x77, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x78, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x79, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x7f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x80, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x81, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x82, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x83, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x84, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x85, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x86, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x87, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x88, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x89, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x8f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x90, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x91, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x92, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x93, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x94, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x95, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x96, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x97, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x98, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x99, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x9f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa0, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa1, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa2, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa3, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa4, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa5, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa6, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa7, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa8, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xa9, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaa, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xab, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xac, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xad, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xae, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0xaf, 0x00, 0x75,
	0x05, 0x6c, 0x50, 0x22, 0x00, 0x08,
	0x05, 0x6c, 0x50, 0x23, 0x00, 0x7a,
	0x05, 0x6c, 0x61, 0x20, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x21, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x22, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x23, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x24, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x25, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x26, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x27, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x28, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x29, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x2f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x30, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x31, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x32, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x33, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x34, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x35, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x36, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x37, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x38, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x39, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3a, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3b, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3c, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3d, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3e, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x3f, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x40, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x41, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x42, 0x00, 0x75,
	0x05, 0x6c, 0x61, 0x43, 0x00, 0x75,
	0x05, 0x6c, 0x4f, 0x04, 0x00, 0x78,
	0x05, 0x6c, 0x38, 0x0e, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0f, 0x00, 0xf4,
	0x05, 0x6c, 0x38, 0x0c, 0x00, 0x04,
	0x05, 0x6c, 0x38, 0x0d, 0x00, 0x2a,
	0x05, 0x6c, 0x38, 0x4c, 0x00, 0x02,
	0x05, 0x6c, 0x38, 0x4d, 0x00, 0x14,
	0x05, 0x6c, 0x38, 0x8c, 0x00, 0x02,
	0x05, 0x6c, 0x38, 0x8d, 0x00, 0x14,
	0x05, 0x6c, 0x03, 0x05, 0x00, 0x50,
	0x05, 0x6c, 0x03, 0x07, 0x00, 0x01,

	0x05, 0x6c, 0x5b, 0x7e, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x78, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x79, 0x00, 0xd9,
	0x05, 0x6c, 0x5b, 0x7a, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x7b, 0x00, 0xf0,
	0x05, 0x6c, 0x5b, 0x7c, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x7d, 0x00, 0x03,
	0x05, 0x6c, 0x5b, 0x64, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x65, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x67, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x68, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x69, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x6a, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x6b, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x6c, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x6d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x6e, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x6f, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x70, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x71, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x72, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x73, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x74, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x75, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x52, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x54, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x55, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x56, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x58, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x59, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x5a, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x5d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x5e, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x61, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x62, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x40, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x48, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4e, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x4f, 0x00, 0x00,
	0x05, 0x6c, 0x5b, 0x50, 0x00, 0x01,
	0x05, 0x6c, 0x5b, 0x51, 0x00, 0x00,

	// //  matrix_A
	// 0x5b64, 0x00,
	// 0x5b65, 0xce,
	// 0x5b66, 0x00,
	// 0x5b67, 0x49,
	// 0x5b68, 0x0f,
	// 0x5b69, 0xe8,
	// 0x5b6a, 0x0f,
	// 0x5b6b, 0x97,
	// 0x5b6c, 0x01,
	// 0x5b6d, 0x1f,
	// 0x5b6e, 0x00,
	// 0x5b6f, 0x49,
	// 0x5b70, 0x0f,
	// 0x5b71, 0x67,
	// 0x5b72, 0x0f,
	// 0x5b73, 0x47,
	// 0x5b74, 0x02,
	// 0x5b75, 0x51,

	// //  matrix_CWF
	// 0x5b52, 0x01,
	// 0x5b53, 0x70,
	// 0x5b54, 0x0f,
	// 0x5b55, 0xc3,
	// 0x5b56, 0x0f,
	// 0x5b57, 0xcc,
	// 0x5b58, 0x00,
	// 0x5b59, 0x15,
	// 0x5b5a, 0x01,
	// 0x5b5b, 0x02,
	// 0x5b5c, 0x0f,
	// 0x5b5d, 0xe7,
	// 0x5b5e, 0x00,
	// 0x5b5f, 0x31,
	// 0x5b60, 0x0f,
	// 0x5b61, 0x2c,
	// 0x5b62, 0x01,
	// 0x5b63, 0xa2,

	// //  matrix_D65
	// 0x5b40, 0x01,
	// 0x5b41, 0x57,
	// 0x5b42, 0x0f,
	// 0x5b43, 0xbd,
	// 0x5b44, 0x0f,
	// 0x5b45, 0xea,
	// 0x5b46, 0x00,
	// 0x5b47, 0x0e,
	// 0x5b48, 0x00,
	// 0x5b49, 0xfe,
	// 0x5b4a, 0x0f,
	// 0x5b4b, 0xf3,
	// 0x5b4c, 0x00,
	// 0x5b4d, 0x46,
	// 0x5b4e, 0x0f,
	// 0x5b4f, 0x76,
	// 0x5b50, 0x01,
	// 0x5b51, 0x42,
};

uint8_t sunny_ovx8b_pwl_setting_20bit[] = {
	0x05, 0x6c, 0x5e, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x01, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x02, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x03, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x04, 0x00, 0x08,
	0x05, 0x6c, 0x5e, 0x05, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x06, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x07, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x08, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x09, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x0a, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x0b, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x0c, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x0d, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x0e, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x0f, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x10, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x11, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x12, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x13, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x14, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x15, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x16, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x17, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x18, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x19, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x1a, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x1b, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x1c, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x1d, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x1e, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x1f, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x20, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x21, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x23, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x27, 0x00, 0x3f,
	0x05, 0x6c, 0x5e, 0x29, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2a, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x2c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2d, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x2f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x30, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x33, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x35, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x36, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x38, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x39, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3c, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3f, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x42, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x45, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x48, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4b, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4e, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x51, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x54, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x56, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x57, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x59, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5a, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5d, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x5f, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x62, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x65, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x68, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x69, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6b, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x6c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6e, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x6f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x71, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x72, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x74, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x75, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x77, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x78, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x7a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7b, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x7d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7e, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x80, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x81, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x84, 0x00, 0x40,
	0x05, 0x6c, 0x5f, 0x00, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x01, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x02, 0x00, 0x09,
	0x05, 0x6c, 0x5f, 0x03, 0x00, 0x0a,
	0x05, 0x6c, 0x5f, 0x04, 0x00, 0x0b,
	0x05, 0x6c, 0x5f, 0x05, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x06, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x07, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5f, 0x0a, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0c, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0d, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0e, 0x00, 0x0d,
	0x05, 0x6c, 0x5f, 0x0f, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x10, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x11, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x12, 0x00, 0x0e,
	0x05, 0x6c, 0x5f, 0x13, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x14, 0x00, 0x0f,
	0x05, 0x6c, 0x5f, 0x15, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x16, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x17, 0x00, 0x11,
	0x05, 0x6c, 0x5f, 0x18, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x19, 0x00, 0x12,
	0x05, 0x6c, 0x5f, 0x1a, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1b, 0x00, 0x13,
	0x05, 0x6c, 0x5f, 0x1c, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1d, 0x00, 0x14,
	0x05, 0x6c, 0x5f, 0x1e, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x1f, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x20, 0x00, 0x16,
	0x05, 0x6c, 0x5f, 0x21, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x23, 0x00, 0x01,
	0x05, 0x6c, 0x5f, 0x26, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x27, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x29, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2c, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x2d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x2f, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x30, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x32, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x33, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x35, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x36, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x38, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x39, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3b, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x3e, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x3f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x41, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x42, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x44, 0x00, 0x02,
	0x05, 0x6c, 0x5f, 0x45, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x47, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x48, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4a, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x4d, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x4e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x50, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x51, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x53, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x54, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x56, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x57, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x59, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5a, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5c, 0x00, 0x04,
	0x05, 0x6c, 0x5f, 0x5d, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x5f, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x60, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x62, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x63, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x65, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x66, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x68, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x69, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6b, 0x00, 0x08,
	0x05, 0x6c, 0x5f, 0x6c, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x6e, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x6f, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x71, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x72, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x74, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x75, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x77, 0x00, 0x10,
	0x05, 0x6c, 0x5f, 0x78, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7a, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7b, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x7d, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x7e, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x80, 0x00, 0x20,
	0x05, 0x6c, 0x5f, 0x81, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5f, 0x84, 0x00, 0xff,
};

uint8_t sunny_ovx8b_pwl_setting_24bit[] = {
	0x05, 0x6c, 0x5e, 0x00, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x01, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x02, 0x00, 0x09,
	0x05, 0x6c, 0x5e, 0x03, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x04, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x05, 0x00, 0x0a,
	0x05, 0x6c, 0x5e, 0x06, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x07, 0x00, 0x0b,
	0x05, 0x6c, 0x5e, 0x08, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x09, 0x00, 0x0c,
	0x05, 0x6c, 0x5e, 0x0a, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0b, 0x00, 0x0d,
	0x05, 0x6c, 0x5e, 0x0c, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x0d, 0x00, 0x0e,
	0x05, 0x6c, 0x5e, 0x0e, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x0f, 0x00, 0x0f,
	0x05, 0x6c, 0x5e, 0x10, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x11, 0x00, 0x10,
	0x05, 0x6c, 0x5e, 0x12, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x13, 0x00, 0x11,
	0x05, 0x6c, 0x5e, 0x14, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x15, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x16, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x17, 0x00, 0x12,
	0x05, 0x6c, 0x5e, 0x18, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x19, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x1a, 0x00, 0x13,
	0x05, 0x6c, 0x5e, 0x1b, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1c, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1d, 0x00, 0x14,
	0x05, 0x6c, 0x5e, 0x1e, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x1f, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x20, 0x00, 0x15,
	0x05, 0x6c, 0x5e, 0x21, 0x00, 0x16,
	0x05, 0x6c, 0x5e, 0x22, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x23, 0x00, 0x02,
	0x05, 0x6c, 0x5e, 0x24, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x25, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x26, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x27, 0x00, 0xff,
	0x05, 0x6c, 0x5e, 0x28, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x29, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x2a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2c, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x2d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x2f, 0x00, 0x01,
	0x05, 0x6c, 0x5e, 0x30, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x31, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x32, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x33, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x34, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x35, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x36, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x37, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x38, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x39, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x3a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3c, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x3d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x3f, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x40, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x41, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x42, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x43, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x44, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x45, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x46, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x47, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x48, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x49, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4b, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x4c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x4e, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x4f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x50, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x51, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x52, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x53, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x54, 0x00, 0x80,
	0x05, 0x6c, 0x5e, 0x55, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x56, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x57, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x58, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x59, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5a, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x5b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5d, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x5e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x5f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x60, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x61, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x62, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x63, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x64, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x65, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x66, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x67, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x68, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x69, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x6a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6b, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6c, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x6d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6e, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x6f, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x70, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x71, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x72, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x73, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x74, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x75, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x76, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x77, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x78, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x79, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7a, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7b, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x7c, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7d, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x7e, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x7f, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x80, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x81, 0x00, 0x40,
	0x05, 0x6c, 0x5e, 0x82, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x83, 0x00, 0x00,
	0x05, 0x6c, 0x5e, 0x84, 0x00, 0x40,
};

uint8_t ovx8b_test_pattern[] = {
	0x05, 0x6c, 0x52, 0x40, 0x00, 0x01,
	0x05, 0x6c, 0x54, 0x40, 0x00, 0x01,
	0x05, 0x6c, 0x56, 0x40, 0x00, 0x01,
	0x05, 0x6c, 0x58, 0x40, 0x00, 0x01,
	0x05, 0x6c, 0x50, 0x04, 0x00, 0x01,
	0x05, 0x6c, 0x50, 0x05, 0x00, 0x01,
	0x05, 0x6c, 0x50, 0x06, 0x00, 0x01,
	0x05, 0x6c, 0x50, 0x07, 0x00, 0x01,
};

uint8_t ovx8b_stream_on_setting[] = {
	0x05, 0x6c, 0x01, 0x00, 0x00, 0x01,
};

uint8_t ovx8b_stream_off_setting[] = {
	0x05, 0x6c, 0x01, 0x00, 0x00, 0x00,
};

// for nano
uint8_t nano_x8b_init_setting[] = {

	0x04, 0x6c, 0x01,0x03, 0x01,
	0x04, 0x6c, 0x32,0x08, 0x05,
	0x04, 0x6c, 0x46,0x20, 0x04,
	0x04, 0x6c, 0x32,0x08, 0x15,
	0x04, 0x6c, 0x03,0x01, 0x88,
	0x04, 0x6c, 0x03,0x02, 0x31,
	0x04, 0x6c, 0x03,0x04, 0x00,
	0x04, 0x6c, 0x03,0x05, 0x5c,
	0x04, 0x6c, 0x03,0x07, 0x00,
	0x04, 0x6c, 0x03,0x09, 0x03,
	0x04, 0x6c, 0x03,0x16, 0x00,
	0x04, 0x6c, 0x03,0x17, 0x00,
	0x04, 0x6c, 0x03,0x18, 0x00,
	0x04, 0x6c, 0x03,0x20, 0x12,
	0x04, 0x6c, 0x03,0x21, 0x31,
	0x04, 0x6c, 0x03,0x22, 0x02,
	0x04, 0x6c, 0x03,0x23, 0x02,
	0x04, 0x6c, 0x03,0x24, 0x01,
	0x04, 0x6c, 0x03,0x25, 0x95,
	0x04, 0x6c, 0x03,0x26, 0xce,
	0x04, 0x6c, 0x03,0x27, 0x04,
	0x04, 0x6c, 0x03,0x29, 0x02,
	0x04, 0x6c, 0x03,0x2a, 0x04,
	0x04, 0x6c, 0x03,0x2b, 0x04,
	0x04, 0x6c, 0x03,0x2c, 0x02,
	0x04, 0x6c, 0x03,0x31, 0x04,
	0x04, 0x6c, 0x04,0x05, 0x22,
	0x04, 0x6c, 0x04,0x06, 0x5f,
	0x04, 0x6c, 0x04,0x08, 0xe7,
	0x04, 0x6c, 0x04,0x09, 0xff,
	0x04, 0x6c, 0x04,0x0a, 0x2b,
	0x04, 0x6c, 0x04,0x0b, 0x32,
	0x04, 0x6c, 0x04,0x0c, 0x28,
	0x04, 0x6c, 0x04,0x0d, 0x5a,
	0x04, 0x6c, 0x04,0x0e, 0x0c,
	0x04, 0x6c, 0x04,0x41, 0x00,
	0x04, 0x6c, 0x28,0x0b, 0x00,
	0x04, 0x6c, 0x30,0x02, 0xf8,
	0x04, 0x6c, 0x30,0x12, 0x41,
	0x04, 0x6c, 0x30,0x15, 0x08,
	0x04, 0x6c, 0x30,0x16, 0xd0,
	0x04, 0x6c, 0x30,0x18, 0xf0,
	0x04, 0x6c, 0x30,0x1a, 0xb0,
	0x04, 0x6c, 0x30,0x1e, 0x30,
	0x04, 0x6c, 0x30,0x1f, 0x61,
	0x04, 0x6c, 0x30,0x20, 0x01,
	0x04, 0x6c, 0x30,0x22, 0x88,
	0x04, 0x6c, 0x30,0x23, 0x80,
	0x04, 0x6c, 0x30,0x24, 0x80,
	0x04, 0x6c, 0x30,0x28, 0x30,
	0x04, 0x6c, 0x37,0x01, 0x22,
	0x04, 0x6c, 0x37,0x03, 0x3c,
	0x04, 0x6c, 0x37,0x05, 0x00,
	0x04, 0x6c, 0x37,0x06, 0x2f,
	0x04, 0x6c, 0x37,0x09, 0x62,
	0x04, 0x6c, 0x37,0x0a, 0x00,
	0x04, 0x6c, 0x37,0x0b, 0x75,
	0x04, 0x6c, 0x37,0x0d, 0x00,
	0x04, 0x6c, 0x37,0x12, 0x13,
	0x04, 0x6c, 0x37,0x14, 0x02,
	0x04, 0x6c, 0x37,0x17, 0x02,
	0x04, 0x6c, 0x37,0x18, 0x72,
	0x04, 0x6c, 0x37,0x1d, 0x00,
	0x04, 0x6c, 0x37,0x20, 0x03,
	0x04, 0x6c, 0x37,0x2c, 0x10,
	0x04, 0x6c, 0x37,0x38, 0x2c,
	0x04, 0x6c, 0x37,0x39, 0x2c,
	0x04, 0x6c, 0x37,0x3a, 0x27,
	0x04, 0x6c, 0x37,0x3b, 0x27,
	0x04, 0x6c, 0x37,0x3f, 0x26,
	0x04, 0x6c, 0x37,0x40, 0x26,
	0x04, 0x6c, 0x37,0x41, 0x21,
	0x04, 0x6c, 0x37,0x42, 0x21,
	0x04, 0x6c, 0x37,0x4b, 0x03,
	0x04, 0x6c, 0x37,0x52, 0x03,
	0x04, 0x6c, 0x37,0x58, 0x00,
	0x04, 0x6c, 0x37,0x59, 0x2f,
	0x04, 0x6c, 0x37,0x6c, 0x07,
	0x04, 0x6c, 0x37,0x6d, 0x08,
	0x04, 0x6c, 0x37,0x6e, 0x08,
	0x04, 0x6c, 0x37,0x6f, 0x08,
	0x04, 0x6c, 0x37,0x77, 0x00,
	0x04, 0x6c, 0x37,0x79, 0x02,
	0x04, 0x6c, 0x37,0x7a, 0x00,
	0x04, 0x6c, 0x37,0x7b, 0x00,
	0x04, 0x6c, 0x37,0x81, 0x02,
	0x04, 0x6c, 0x37,0x82, 0x05,
	0x04, 0x6c, 0x37,0x83, 0x02,
	0x04, 0x6c, 0x37,0x85, 0x10,
	0x04, 0x6c, 0x37,0x97, 0x00,
	0x04, 0x6c, 0x37,0x98, 0x00,
	0x04, 0x6c, 0x37,0x99, 0x00,
	0x04, 0x6c, 0x37,0x9c, 0x58,
	0x04, 0x6c, 0x37,0x9e, 0x00,
	0x04, 0x6c, 0x37,0x9f, 0x00,
	0x04, 0x6c, 0x37,0xa0, 0x00,
	0x04, 0x6c, 0x37,0xbc, 0x22,
	0x04, 0x6c, 0x37,0xbd, 0x01,
	0x04, 0x6c, 0x37,0xbe, 0x01,
	0x04, 0x6c, 0x37,0xc0, 0x01,
	0x04, 0x6c, 0x37,0xc4, 0x34,
	0x04, 0x6c, 0x37,0xc5, 0x34,
	0x04, 0x6c, 0x37,0xc6, 0x2f,
	0x04, 0x6c, 0x37,0xc7, 0x2f,
	0x04, 0x6c, 0x37,0xd0, 0x00,
	0x04, 0x6c, 0x37,0xd1, 0x2f,
	0x04, 0x6c, 0x37,0xd2, 0x00,
	0x04, 0x6c, 0x37,0xd3, 0x61,
	0x04, 0x6c, 0x37,0xd4, 0x00,
	0x04, 0x6c, 0x37,0xd5, 0x2f,
	0x04, 0x6c, 0x37,0xd8, 0x01,
	0x04, 0x6c, 0x37,0xdb, 0x00,
	0x04, 0x6c, 0x3c,0x0b, 0x26,
	0x04, 0x6c, 0x3c,0x12, 0x88,
	0x04, 0x6c, 0x3c,0x21, 0x00,
	0x04, 0x6c, 0x3c,0x3c, 0x00,
	0x04, 0x6c, 0x3c,0x55, 0x20,
	0x04, 0x6c, 0x3c,0x5b, 0x20,
	0x04, 0x6c, 0x3c,0x61, 0x80,
	0x04, 0x6c, 0x3c,0x6f, 0x3a,
	0x04, 0x6c, 0x3c,0x70, 0x62,
	0x04, 0x6c, 0x31,0x06, 0x10,
	0x04, 0x6c, 0x32,0x0e, 0x00,
	0x04, 0x6c, 0x32,0x0f, 0x00,
	0x04, 0x6c, 0x32,0x11, 0x61,
	0x04, 0x6c, 0x32,0x15, 0xcd,
	0x04, 0x6c, 0x33,0x04, 0x04,
	0x04, 0x6c, 0x33,0x06, 0x03,
	0x04, 0x6c, 0x33,0x07, 0x00,
	0x04, 0x6c, 0x33,0x08, 0x00,
	0x04, 0x6c, 0x33,0x09, 0x00,
	0x04, 0x6c, 0x33,0x0a, 0x00,
	0x04, 0x6c, 0x33,0x0b, 0x00,
	0x04, 0x6c, 0x33,0x0c, 0x00,
	0x04, 0x6c, 0x33,0x0d, 0x00,
	0x04, 0x6c, 0x33,0x0e, 0x00,
	0x04, 0x6c, 0x33,0x0f, 0x00,
	0x04, 0x6c, 0x33,0x10, 0x06,
	0x04, 0x6c, 0x33,0x11, 0x05,
	0x04, 0x6c, 0x33,0x12, 0x55,
	0x04, 0x6c, 0x33,0x13, 0x02,
	0x04, 0x6c, 0x33,0x14, 0xaa,
	0x04, 0x6c, 0x33,0x15, 0x07,
	0x04, 0x6c, 0x33,0x16, 0xf0,
	0x04, 0x6c, 0x33,0x17, 0x00,
	0x04, 0x6c, 0x33,0x18, 0x00,
	0x04, 0x6c, 0x34,0x00, 0x08,
	0x04, 0x6c, 0x34,0x08, 0x01,
	0x04, 0x6c, 0x35,0x01, 0x00,
	0x04, 0x6c, 0x35,0x02, 0x08,
	0x04, 0x6c, 0x35,0x08, 0x01,
	0x04, 0x6c, 0x35,0x09, 0x00,
	0x04, 0x6c, 0x35,0x0a, 0x01,
	0x04, 0x6c, 0x35,0x0b, 0x00,
	0x04, 0x6c, 0x35,0x0c, 0x00,
	0x04, 0x6c, 0x35,0x88, 0x01,
	0x04, 0x6c, 0x35,0x89, 0x00,
	0x04, 0x6c, 0x35,0x8a, 0x01,
	0x04, 0x6c, 0x35,0x8b, 0x00,
	0x04, 0x6c, 0x35,0x8c, 0x00,
	0x04, 0x6c, 0x35,0x41, 0x00,
	0x04, 0x6c, 0x35,0x42, 0x04,
	0x04, 0x6c, 0x35,0x48, 0x01,
	0x04, 0x6c, 0x35,0x49, 0x00,
	0x04, 0x6c, 0x35,0x4a, 0x01,
	0x04, 0x6c, 0x35,0x4b, 0x00,
	0x04, 0x6c, 0x35,0x4c, 0x00,
	0x04, 0x6c, 0x35,0xc1, 0x00,
	0x04, 0x6c, 0x35,0xc2, 0x02,
	0x04, 0x6c, 0x35,0xc7, 0x00,
	0x04, 0x6c, 0x35,0xc8, 0x01,
	0x04, 0x6c, 0x35,0xc9, 0x00,
	0x04, 0x6c, 0x35,0xca, 0x01,
	0x04, 0x6c, 0x35,0xcb, 0x00,
	0x04, 0x6c, 0x35,0xcc, 0x00,
	0x04, 0x6c, 0x36,0x00, 0xff,
	0x04, 0x6c, 0x36,0x04, 0x91,
	0x04, 0x6c, 0x36,0x05, 0x2c,
	0x04, 0x6c, 0x36,0x07, 0x0a,
	0x04, 0x6c, 0x36,0x09, 0x00,
	0x04, 0x6c, 0x36,0x0a, 0x00,
	0x04, 0x6c, 0x36,0x0e, 0x1b,
	0x04, 0x6c, 0x36,0x11, 0x3f,
	0x04, 0x6c, 0x36,0x13, 0x00,
	0x04, 0x6c, 0x36,0x16, 0x8a,
	0x04, 0x6c, 0x36,0x1a, 0x01,
	0x04, 0x6c, 0x36,0x1c, 0x70,
	0x04, 0x6c, 0x36,0x1d, 0x00,
	0x04, 0x6c, 0x36,0x1e, 0xdc,
	0x04, 0x6c, 0x36,0x1f, 0x42,
	0x04, 0x6c, 0x36,0x2c, 0x82,
	0x04, 0x6c, 0x36,0x39, 0x7b,
	0x04, 0x6c, 0x36,0x3f, 0x20,
	0x04, 0x6c, 0x36,0x43, 0x2a,
	0x04, 0x6c, 0x36,0x46, 0x0c,
	0x04, 0x6c, 0x36,0x47, 0xa0,
	0x04, 0x6c, 0x36,0x48, 0x00,
	0x04, 0x6c, 0x36,0x49, 0x00,
	0x04, 0x6c, 0x36,0x4a, 0x00,
	0x04, 0x6c, 0x36,0x4b, 0x00,
	0x04, 0x6c, 0x36,0x4e, 0x12,
	0x04, 0x6c, 0x36,0x4f, 0x12,
	0x04, 0x6c, 0x36,0x53, 0x07,
	0x04, 0x6c, 0x36,0x54, 0x07,
	0x04, 0x6c, 0x36,0x55, 0x07,
	0x04, 0x6c, 0x36,0x56, 0x07,
	0x04, 0x6c, 0x36,0x57, 0x04,
	0x04, 0x6c, 0x36,0x58, 0x04,
	0x04, 0x6c, 0x36,0x59, 0x04,
	0x04, 0x6c, 0x36,0x5a, 0x04,
	0x04, 0x6c, 0x36,0x5c, 0x12,
	0x04, 0x6c, 0x36,0x5f, 0x01,
	0x04, 0x6c, 0x36,0x61, 0x1c,
	0x04, 0x6c, 0x36,0x63, 0x00,
	0x04, 0x6c, 0x36,0x64, 0x00,
	0x04, 0x6c, 0x36,0x68, 0x08,
	0x04, 0x6c, 0x36,0x69, 0x08,
	0x04, 0x6c, 0x36,0x6b, 0x00,
	0x04, 0x6c, 0x38,0x00, 0x00,
	0x04, 0x6c, 0x38,0x01, 0x00,
	0x04, 0x6c, 0x38,0x02, 0x00,
	0x04, 0x6c, 0x38,0x03, 0x04,
	0x04, 0x6c, 0x38,0x04, 0x0f,
	0x04, 0x6c, 0x38,0x05, 0x1f,
	0x04, 0x6c, 0x38,0x06, 0x08,
	0x04, 0x6c, 0x38,0x07, 0x7b,
	0x04, 0x6c, 0x38,0x08, 0x0f,
	0x04, 0x6c, 0x38,0x09, 0x00,
	0x04, 0x6c, 0x38,0x0a, 0x08,
	0x04, 0x6c, 0x38,0x0b, 0x70,
	0x04, 0x6c, 0x38,0x0c, 0x03,
	0x04, 0x6c, 0x38,0x0d, 0xdc,
	0x04, 0x6c, 0x38,0x0e, 0x04,
	0x04, 0x6c, 0x38,0x0f, 0x66,
	0x04, 0x6c, 0x38,0x10, 0x00,
	0x04, 0x6c, 0x38,0x11, 0x08,
	0x04, 0x6c, 0x38,0x12, 0x00,
	0x04, 0x6c, 0x38,0x13, 0x04,
	0x04, 0x6c, 0x38,0x16, 0x01,
	0x04, 0x6c, 0x38,0x17, 0x01,
	0x04, 0x6c, 0x38,0x1c, 0x18,
	0x04, 0x6c, 0x38,0x1e, 0x01,
	0x04, 0x6c, 0x38,0x1f, 0x01,
	0x04, 0x6c, 0x38,0x20, 0x00,
	0x04, 0x6c, 0x38,0x21, 0x19,
	0x04, 0x6c, 0x38,0x22, 0x03,
	0x04, 0x6c, 0x38,0x28, 0x36,
	0x04, 0x6c, 0x38,0x32, 0x00,
	0x04, 0x6c, 0x38,0x34, 0x00,
	0x04, 0x6c, 0x38,0x3d, 0x00,
	0x04, 0x6c, 0x38,0x47, 0x04,
	0x04, 0x6c, 0x38,0x48, 0x60,
	0x04, 0x6c, 0x38,0x4c, 0x01,
	0x04, 0x6c, 0x38,0x4d, 0xee,
	0x04, 0x6c, 0x38,0x50, 0x00,
	0x04, 0x6c, 0x38,0x51, 0x42,
	0x04, 0x6c, 0x38,0x52, 0x00,
	0x04, 0x6c, 0x38,0x53, 0x40,
	0x04, 0x6c, 0x38,0x58, 0x04,
	0x04, 0x6c, 0x38,0x5b, 0x04,
	0x04, 0x6c, 0x38,0x5c, 0x60,
	0x04, 0x6c, 0x38,0x8c, 0x01,
	0x04, 0x6c, 0x38,0x8d, 0xee,
	0x04, 0x6c, 0x3b,0x40, 0x0f,
	0x04, 0x6c, 0x3b,0x41, 0x80,
	0x04, 0x6c, 0x3b,0x42, 0x00,
	0x04, 0x6c, 0x3b,0x43, 0x80,
	0x04, 0x6c, 0x3b,0x4b, 0x27,
	0x04, 0x6c, 0x3b,0x4c, 0x00,
	0x04, 0x6c, 0x3b,0x4d, 0x00,
	0x04, 0x6c, 0x3b,0x82, 0xe8,
	0x04, 0x6c, 0x3b,0x85, 0xe8,
	0x04, 0x6c, 0x3d,0x8a, 0x03,
	0x04, 0x6c, 0x3d,0x8b, 0xff,
	0x04, 0x6c, 0x43,0x07, 0x03,
	0x04, 0x6c, 0x43,0x08, 0x13,
	0x04, 0x6c, 0x43,0x0a, 0x13,
	0x04, 0x6c, 0x43,0x0d, 0x93,
	0x04, 0x6c, 0x43,0x0e, 0x14,
	0x04, 0x6c, 0x43,0x0f, 0x57,
	0x04, 0x6c, 0x43,0x10, 0x95,
	0x04, 0x6c, 0x43,0x11, 0x16,
	0x04, 0x6c, 0x43,0x16, 0x00,
	0x04, 0x6c, 0x43,0x17, 0x38,
	0x04, 0x6c, 0x43,0x18, 0x12,
	0x04, 0x6c, 0x43,0x19, 0x03,
	0x04, 0x6c, 0x43,0x1b, 0x00,
	0x04, 0x6c, 0x43,0x1d, 0x2a,
	0x04, 0x6c, 0x43,0x1e, 0x11,
	0x04, 0x6c, 0x43,0x1f, 0x20,
	0x04, 0x6c, 0x43,0x20, 0x01,
	0x04, 0x6c, 0x43,0x23, 0x80,
	0x04, 0x6c, 0x45,0x02, 0xf2,
	0x04, 0x6c, 0x45,0x03, 0x4e,
	0x04, 0x6c, 0x45,0x05, 0x00,
	0x04, 0x6c, 0x45,0x06, 0x64,
	0x04, 0x6c, 0x45,0x08, 0x10,
	0x04, 0x6c, 0x45,0x09, 0x00,
	0x04, 0x6c, 0x45,0x0a, 0x00,
	0x04, 0x6c, 0x45,0x81, 0xc7,
	0x04, 0x6c, 0x45,0x83, 0x07,
	0x04, 0x6c, 0x45,0x84, 0xec,
	0x04, 0x6c, 0x45,0x85, 0x09,
	0x04, 0x6c, 0x45,0x86, 0xae,
	0x04, 0x6c, 0x45,0x8f, 0x00,
	0x04, 0x6c, 0x45,0x90, 0x20,
	0x04, 0x6c, 0x45,0x97, 0x00,
	0x04, 0x6c, 0x45,0x99, 0x0f,
	0x04, 0x6c, 0x45,0x9a, 0x0f,
	0x04, 0x6c, 0x46,0x02, 0x00,
	0x04, 0x6c, 0x46,0x03, 0x13,
	0x04, 0x6c, 0x46,0x04, 0x00,
	0x04, 0x6c, 0x46,0x0a, 0x30,
	0x04, 0x6c, 0x46,0x10, 0x00,
	0x04, 0x6c, 0x46,0x11, 0xe0,
	0x04, 0x6c, 0x46,0x12, 0x01,
	0x04, 0x6c, 0x46,0x13, 0x00,
	0x04, 0x6c, 0x46,0x14, 0x00,
	0x04, 0x6c, 0x46,0x15, 0xe0,
	0x04, 0x6c, 0x46,0x16, 0x01,
	0x04, 0x6c, 0x46,0x17, 0x00,
	0x04, 0x6c, 0x47,0x00, 0xe0,
	0x04, 0x6c, 0x48,0x00, 0x04,
	0x04, 0x6c, 0x48,0x0a, 0x22,
	0x04, 0x6c, 0x48,0x0e, 0x04,
	0x04, 0x6c, 0x48,0x13, 0xe4,
	0x04, 0x6c, 0x48,0x14, 0x2a,
	0x04, 0x6c, 0x48,0x1f, 0x30,
	0x04, 0x6c, 0x48,0x33, 0x15,
	0x04, 0x6c, 0x48,0x37, 0x07,
	0x04, 0x6c, 0x48,0x4b, 0x47,
	0x04, 0x6c, 0x48,0x4f, 0x00,
	0x04, 0x6c, 0x48,0x50, 0x47,
	0x04, 0x6c, 0x48,0x61, 0xcc,
	0x04, 0x6c, 0x48,0x84, 0x08,
	0x04, 0x6c, 0x48,0x89, 0x00,
	0x04, 0x6c, 0x4d,0x00, 0x4a,
	0x04, 0x6c, 0x4d,0x01, 0x18,
	0x04, 0x6c, 0x4d,0x05, 0xff,
	0x04, 0x6c, 0x4d,0x06, 0x88,
	0x04, 0x6c, 0x4d,0x08, 0x23,
	0x04, 0x6c, 0x4d,0x09, 0xdf,
	0x04, 0x6c, 0x4d,0x15, 0x7d,
	0x04, 0x6c, 0x4d,0x1a, 0x20,
	0x04, 0x6c, 0x4d,0x34, 0x7d,
	0x04, 0x6c, 0x4d,0x3c, 0x7d,
	0x04, 0x6c, 0x4d,0x3e, 0x4a,
	0x04, 0x6c, 0x4d,0x3f, 0x18,
	0x04, 0x6c, 0x4d,0x40, 0xbb,
	0x04, 0x6c, 0x4d,0x41, 0xde,
	0x04, 0x6c, 0x4d,0x42, 0x93,
	0x04, 0x6c, 0x4d,0x43, 0xff,
	0x04, 0x6c, 0x4d,0x5a, 0x10,
	0x04, 0x6c, 0x4f,0x00, 0x3f,
	0x04, 0x6c, 0x4f,0x01, 0xff,
	0x04, 0x6c, 0x4f,0x02, 0xff,
	0x04, 0x6c, 0x4f,0x03, 0x2d,
	0x04, 0x6c, 0x4f,0x04, 0x00,
	0x04, 0x6c, 0x6a,0x00, 0x00,
	0x04, 0x6c, 0x6a,0x01, 0x20,
	0x04, 0x6c, 0x6a,0x02, 0x00,
	0x04, 0x6c, 0x6a,0x03, 0x20,
	0x04, 0x6c, 0x6a,0x04, 0x02,
	0x04, 0x6c, 0x6a,0x05, 0x80,
	0x04, 0x6c, 0x6a,0x06, 0x01,
	0x04, 0x6c, 0x6a,0x07, 0xe0,
	0x04, 0x6c, 0x6a,0x08, 0xcf,
	0x04, 0x6c, 0x6a,0x09, 0x01,
	0x04, 0x6c, 0x6a,0x0a, 0x40,
	0x04, 0x6c, 0x6a,0x20, 0x00,
	0x04, 0x6c, 0x6a,0x21, 0x02,
	0x04, 0x6c, 0x6a,0x22, 0x00,
	0x04, 0x6c, 0x6a,0x23, 0x00,
	0x04, 0x6c, 0x6a,0x24, 0x00,
	0x04, 0x6c, 0x6a,0x25, 0x00,
	0x04, 0x6c, 0x6a,0x26, 0x00,
	0x04, 0x6c, 0x6a,0x27, 0x00,
	0x04, 0x6c, 0x6a,0x28, 0x00,
	0x04, 0x6c, 0x6a,0x29, 0x01,
	0x04, 0x6c, 0x51,0x80, 0x80,
	0x04, 0x6c, 0x51,0x81, 0x0b,
	0x04, 0x6c, 0x51,0x82, 0xf0,
	0x04, 0x6c, 0x51,0x83, 0x20,
	0x04, 0x6c, 0x51,0x84, 0x86,
	0x04, 0x6c, 0x51,0x88, 0x85,
	0x04, 0x6c, 0x51,0x8c, 0x81,
	0x04, 0x6c, 0x51,0x90, 0x86,
	0x04, 0x6c, 0x51,0x94, 0x85,
	0x04, 0x6c, 0x51,0x98, 0x81,
	0x04, 0x6c, 0x51,0x9c, 0x86,
	0x04, 0x6c, 0x51,0xa0, 0x85,
	0x04, 0x6c, 0x51,0xa4, 0x86,
	0x04, 0x6c, 0x51,0xa8, 0x82,
	0x04, 0x6c, 0x51,0xac, 0x84,
	0x04, 0x6c, 0x5d,0x0d, 0x0a,
	0x04, 0x6c, 0x5d,0x0e, 0x0a,
	0x04, 0x6c, 0x5d,0x0f, 0x0a,
	0x04, 0x6c, 0x5d,0x11, 0x10,
	0x04, 0x6c, 0x5d,0x12, 0x10,
	0x04, 0x6c, 0x5d,0x13, 0x10,
	0x04, 0x6c, 0x5d,0x15, 0x05,
	0x04, 0x6c, 0x5d,0x16, 0x05,
	0x04, 0x6c, 0x5d,0x17, 0x05,
	0x04, 0x6c, 0x5d,0x1f, 0x81,
	0x04, 0x6c, 0x53,0x00, 0xc2,
	0x04, 0x6c, 0x53,0x14, 0x70,
	0x04, 0x6c, 0x53,0x15, 0x70,
	0x04, 0x6c, 0x53,0x16, 0x73,
	0x04, 0x6c, 0x53,0x17, 0xff,
	0x04, 0x6c, 0x5b,0x80, 0x00,
	0x04, 0x6c, 0x5b,0x84, 0x03,
	0x04, 0x6c, 0x5b,0x85, 0x9a,
	0x04, 0x6c, 0x5b,0x8e, 0x20,
	0x04, 0x6c, 0x5b,0x92, 0x60,
	0x04, 0x6c, 0x5b,0x93, 0x10,
	0x04, 0x6c, 0x5b,0x96, 0x60,
	0x04, 0x6c, 0x5b,0x97, 0x40,
	0x04, 0x6c, 0x5b,0x98, 0x00,
	0x04, 0x6c, 0x5b,0x99, 0x80,
	0x04, 0x6c, 0x5b,0x9a, 0x80,
	0x04, 0x6c, 0x5b,0x9b, 0x40,
	0x04, 0x6c, 0x5b,0x9c, 0x00,
	0x04, 0x6c, 0x5b,0x9d, 0x00,
	0x04, 0x6c, 0x5b,0x9e, 0x80,
	0x04, 0x6c, 0x5b,0x9f, 0x80,
	0x04, 0x6c, 0x5b,0xa0, 0x00,
	0x04, 0x6c, 0x5b,0xa1, 0x00,
	0x04, 0x6c, 0x5b,0xa2, 0x00,
	0x04, 0x6c, 0x5b,0xa3, 0x80,
	0x04, 0x6c, 0x5b,0xa4, 0x80,
	0x04, 0x6c, 0x5b,0xa5, 0x00,
	0x04, 0x6c, 0x5b,0xa6, 0x00,
	0x04, 0x6c, 0x5b,0xa7, 0x00,
	0x04, 0x6c, 0x5b,0xae, 0x02,
	0x04, 0x6c, 0x5b,0xaf, 0x00,
	0x04, 0x6c, 0x5b,0xb0, 0x02,
	0x04, 0x6c, 0x5b,0xb1, 0x76,
	0x04, 0x6c, 0x5b,0xb2, 0x03,
	0x04, 0x6c, 0x5b,0xb3, 0x08,
	0x04, 0x6c, 0x5b,0xb4, 0x04,
	0x04, 0x6c, 0x5b,0xb5, 0x67,
	0x04, 0x6c, 0x5b,0xba, 0x10,
	0x04, 0x6c, 0x5b,0xbe, 0x0a,
	0x04, 0x6c, 0x5c,0x00, 0x00,
	0x04, 0x6c, 0x5c,0x04, 0x03,
	0x04, 0x6c, 0x5c,0x05, 0x9a,
	0x04, 0x6c, 0x5c,0x0e, 0x20,
	0x04, 0x6c, 0x5c,0x12, 0x60,
	0x04, 0x6c, 0x5c,0x13, 0x10,
	0x04, 0x6c, 0x5c,0x16, 0x60,
	0x04, 0x6c, 0x5c,0x17, 0x40,
	0x04, 0x6c, 0x5c,0x18, 0x00,
	0x04, 0x6c, 0x5c,0x19, 0x80,
	0x04, 0x6c, 0x5c,0x1a, 0x80,
	0x04, 0x6c, 0x5c,0x1b, 0x40,
	0x04, 0x6c, 0x5c,0x1c, 0x00,
	0x04, 0x6c, 0x5c,0x1d, 0x00,
	0x04, 0x6c, 0x5c,0x1e, 0x80,
	0x04, 0x6c, 0x5c,0x1f, 0x80,
	0x04, 0x6c, 0x5c,0x20, 0x00,
	0x04, 0x6c, 0x5c,0x21, 0x00,
	0x04, 0x6c, 0x5c,0x22, 0x00,
	0x04, 0x6c, 0x5c,0x23, 0x80,
	0x04, 0x6c, 0x5c,0x24, 0x80,
	0x04, 0x6c, 0x5c,0x25, 0x00,
	0x04, 0x6c, 0x5c,0x26, 0x00,
	0x04, 0x6c, 0x5c,0x27, 0x00,
	0x04, 0x6c, 0x5c,0x2e, 0x02,
	0x04, 0x6c, 0x5c,0x2f, 0x00,
	0x04, 0x6c, 0x5c,0x30, 0x02,
	0x04, 0x6c, 0x5c,0x31, 0x76,
	0x04, 0x6c, 0x5c,0x32, 0x03,
	0x04, 0x6c, 0x5c,0x33, 0x08,
	0x04, 0x6c, 0x5c,0x34, 0x04,
	0x04, 0x6c, 0x5c,0x35, 0x67,
	0x04, 0x6c, 0x5c,0x3a, 0x10,
	0x04, 0x6c, 0x5c,0x3e, 0x0a,
	0x04, 0x6c, 0x5c,0x80, 0x00,
	0x04, 0x6c, 0x5c,0x84, 0x03,
	0x04, 0x6c, 0x5c,0x85, 0x9a,
	0x04, 0x6c, 0x5c,0x8e, 0x20,
	0x04, 0x6c, 0x5c,0x92, 0x60,
	0x04, 0x6c, 0x5c,0x93, 0x10,
	0x04, 0x6c, 0x5c,0x96, 0x60,
	0x04, 0x6c, 0x5c,0x97, 0x40,
	0x04, 0x6c, 0x5c,0x98, 0x00,
	0x04, 0x6c, 0x5c,0x99, 0x80,
	0x04, 0x6c, 0x5c,0x9a, 0x80,
	0x04, 0x6c, 0x5c,0x9b, 0x40,
	0x04, 0x6c, 0x5c,0x9c, 0x00,
	0x04, 0x6c, 0x5c,0x9d, 0x00,
	0x04, 0x6c, 0x5c,0x9e, 0x80,
	0x04, 0x6c, 0x5c,0x9f, 0x80,
	0x04, 0x6c, 0x5c,0xa0, 0x00,
	0x04, 0x6c, 0x5c,0xa1, 0x00,
	0x04, 0x6c, 0x5c,0xa2, 0x00,
	0x04, 0x6c, 0x5c,0xa3, 0x80,
	0x04, 0x6c, 0x5c,0xa4, 0x80,
	0x04, 0x6c, 0x5c,0xa5, 0x00,
	0x04, 0x6c, 0x5c,0xa6, 0x00,
	0x04, 0x6c, 0x5c,0xa7, 0x00,
	0x04, 0x6c, 0x5c,0xae, 0x02,
	0x04, 0x6c, 0x5c,0xaf, 0x00,
	0x04, 0x6c, 0x5c,0xb0, 0x02,
	0x04, 0x6c, 0x5c,0xb1, 0x76,
	0x04, 0x6c, 0x5c,0xb2, 0x03,
	0x04, 0x6c, 0x5c,0xb3, 0x08,
	0x04, 0x6c, 0x5c,0xb4, 0x04,
	0x04, 0x6c, 0x5c,0xb5, 0x67,
	0x04, 0x6c, 0x5c,0xba, 0x10,
	0x04, 0x6c, 0x5c,0xbe, 0x0a,
	0x04, 0x6c, 0x60,0x06, 0x00,
	0x04, 0x6c, 0x60,0x07, 0x3c,
	0x04, 0x6c, 0x60,0x08, 0x03,
	0x04, 0x6c, 0x60,0x09, 0x20,
	0x04, 0x6c, 0x60,0x0a, 0x00,
	0x04, 0x6c, 0x60,0x0b, 0x3c,
	0x04, 0x6c, 0x60,0x0c, 0x03,
	0x04, 0x6c, 0x60,0x0d, 0x20,
	0x04, 0x6c, 0x60,0x16, 0x00,
	0x04, 0x6c, 0x60,0x26, 0x00,
	0x04, 0x6c, 0x60,0x27, 0x3c,
	0x04, 0x6c, 0x60,0x28, 0x03,
	0x04, 0x6c, 0x60,0x29, 0x20,
	0x04, 0x6c, 0x60,0x2a, 0x00,
	0x04, 0x6c, 0x60,0x2b, 0x3c,
	0x04, 0x6c, 0x60,0x2c, 0x03,
	0x04, 0x6c, 0x60,0x2d, 0x20,
	0x04, 0x6c, 0x60,0x36, 0x01,
	0x04, 0x6c, 0x60,0x46, 0x00,
	0x04, 0x6c, 0x60,0x47, 0x3c,
	0x04, 0x6c, 0x60,0x48, 0x03,
	0x04, 0x6c, 0x60,0x49, 0x20,
	0x04, 0x6c, 0x60,0x4a, 0x00,
	0x04, 0x6c, 0x60,0x4b, 0x3c,
	0x04, 0x6c, 0x60,0x4c, 0x03,
	0x04, 0x6c, 0x60,0x4d, 0x20,
	0x04, 0x6c, 0x60,0x56, 0x02,
	0x04, 0x6c, 0x60,0x67, 0x3c,
	0x04, 0x6c, 0x60,0x68, 0x03,
	0x04, 0x6c, 0x60,0x69, 0x20,
	0x04, 0x6c, 0x60,0x6a, 0x00,
	0x04, 0x6c, 0x60,0x6b, 0x3c,
	0x04, 0x6c, 0x60,0x6c, 0x03,
	0x04, 0x6c, 0x60,0x6d, 0x20,
	0x04, 0x6c, 0x60,0x76, 0x03,
	0x04, 0x6c, 0x60,0x86, 0x00,
	0x04, 0x6c, 0x60,0x87, 0x3c,
	0x04, 0x6c, 0x60,0x88, 0x03,
	0x04, 0x6c, 0x60,0x89, 0x20,
	0x04, 0x6c, 0x60,0x8a, 0x00,
	0x04, 0x6c, 0x60,0x8b, 0x3c,
	0x04, 0x6c, 0x60,0x8c, 0x03,
	0x04, 0x6c, 0x60,0x8d, 0x20,
	0x04, 0x6c, 0x60,0x96, 0x04,
	0x04, 0x6c, 0x5e,0x00, 0x00,
	0x04, 0x6c, 0x5e,0x01, 0x08,
	0x04, 0x6c, 0x5e,0x02, 0x09,
	0x04, 0x6c, 0x5e,0x03, 0x0a,
	0x04, 0x6c, 0x5e,0x04, 0x0b,
	0x04, 0x6c, 0x5e,0x05, 0x0c,
	0x04, 0x6c, 0x5e,0x06, 0x0c,
	0x04, 0x6c, 0x5e,0x07, 0x0c,
	0x04, 0x6c, 0x5e,0x08, 0x0c,
	0x04, 0x6c, 0x5e,0x09, 0x0c,
	0x04, 0x6c, 0x5e,0x0a, 0x0d,
	0x04, 0x6c, 0x5e,0x0b, 0x0d,
	0x04, 0x6c, 0x5e,0x0c, 0x0d,
	0x04, 0x6c, 0x5e,0x0d, 0x0d,
	0x04, 0x6c, 0x5e,0x0e, 0x0d,
	0x04, 0x6c, 0x5e,0x0f, 0x0e,
	0x04, 0x6c, 0x5e,0x10, 0x0e,
	0x04, 0x6c, 0x5e,0x11, 0x0e,
	0x04, 0x6c, 0x5e,0x12, 0x0e,
	0x04, 0x6c, 0x5e,0x13, 0x0f,
	0x04, 0x6c, 0x5e,0x14, 0x0f,
	0x04, 0x6c, 0x5e,0x15, 0x10,
	0x04, 0x6c, 0x5e,0x16, 0x11,
	0x04, 0x6c, 0x5e,0x17, 0x11,
	0x04, 0x6c, 0x5e,0x18, 0x12,
	0x04, 0x6c, 0x5e,0x19, 0x12,
	0x04, 0x6c, 0x5e,0x1a, 0x13,
	0x04, 0x6c, 0x5e,0x1b, 0x13,
	0x04, 0x6c, 0x5e,0x1c, 0x14,
	0x04, 0x6c, 0x5e,0x1d, 0x14,
	0x04, 0x6c, 0x5e,0x1e, 0x16,
	0x04, 0x6c, 0x5e,0x1f, 0x16,
	0x04, 0x6c, 0x5e,0x20, 0x16,
	0x04, 0x6c, 0x5e,0x21, 0x08,
	0x04, 0x6c, 0x5e,0x22, 0x00,
	0x04, 0x6c, 0x5e,0x23, 0x01,
	0x04, 0x6c, 0x5e,0x24, 0x00,
	0x04, 0x6c, 0x5e,0x25, 0x00,
	0x04, 0x6c, 0x5e,0x26, 0x00,
	0x04, 0x6c, 0x5e,0x27, 0x40,
	0x04, 0x6c, 0x5e,0x28, 0x00,
	0x04, 0x6c, 0x5e,0x29, 0x00,
	0x04, 0x6c, 0x5e,0x2a, 0x40,
	0x04, 0x6c, 0x5e,0x2b, 0x00,
	0x04, 0x6c, 0x5e,0x2c, 0x00,
	0x04, 0x6c, 0x5e,0x2d, 0x40,
	0x04, 0x6c, 0x5e,0x2e, 0x00,
	0x04, 0x6c, 0x5e,0x2f, 0x00,
	0x04, 0x6c, 0x5e,0x30, 0x40,
	0x04, 0x6c, 0x5e,0x31, 0x00,
	0x04, 0x6c, 0x5e,0x32, 0x00,
	0x04, 0x6c, 0x5e,0x33, 0x40,
	0x04, 0x6c, 0x5e,0x34, 0x00,
	0x04, 0x6c, 0x5e,0x35, 0x00,
	0x04, 0x6c, 0x5e,0x36, 0x40,
	0x04, 0x6c, 0x5e,0x37, 0x00,
	0x04, 0x6c, 0x5e,0x38, 0x00,
	0x04, 0x6c, 0x5e,0x39, 0x40,
	0x04, 0x6c, 0x5e,0x3a, 0x00,
	0x04, 0x6c, 0x5e,0x3b, 0x00,
	0x04, 0x6c, 0x5e,0x3c, 0x40,
	0x04, 0x6c, 0x5e,0x3d, 0x00,
	0x04, 0x6c, 0x5e,0x3e, 0x00,
	0x04, 0x6c, 0x5e,0x3f, 0x40,
	0x04, 0x6c, 0x5e,0x40, 0x00,
	0x04, 0x6c, 0x5e,0x41, 0x00,
	0x04, 0x6c, 0x5e,0x42, 0x40,
	0x04, 0x6c, 0x5e,0x43, 0x00,
	0x04, 0x6c, 0x5e,0x44, 0x00,
	0x04, 0x6c, 0x5e,0x45, 0x40,
	0x04, 0x6c, 0x5e,0x46, 0x00,
	0x04, 0x6c, 0x5e,0x47, 0x00,
	0x04, 0x6c, 0x5e,0x48, 0x40,
	0x04, 0x6c, 0x5e,0x49, 0x00,
	0x04, 0x6c, 0x5e,0x4a, 0x00,
	0x04, 0x6c, 0x5e,0x4b, 0x40,
	0x04, 0x6c, 0x5e,0x4c, 0x00,
	0x04, 0x6c, 0x5e,0x4d, 0x00,
	0x04, 0x6c, 0x5e,0x4e, 0x40,
	0x04, 0x6c, 0x5e,0x4f, 0x00,
	0x04, 0x6c, 0x5e,0x50, 0x00,
	0x04, 0x6c, 0x5e,0x51, 0x40,
	0x04, 0x6c, 0x5e,0x52, 0x00,
	0x04, 0x6c, 0x5e,0x53, 0x00,
	0x04, 0x6c, 0x5e,0x54, 0x40,
	0x04, 0x6c, 0x5e,0x55, 0x00,
	0x04, 0x6c, 0x5e,0x56, 0x00,
	0x04, 0x6c, 0x5e,0x57, 0x40,
	0x04, 0x6c, 0x5e,0x58, 0x00,
	0x04, 0x6c, 0x5e,0x59, 0x00,
	0x04, 0x6c, 0x5e,0x5a, 0x80,
	0x04, 0x6c, 0x5e,0x5b, 0x00,
	0x04, 0x6c, 0x5e,0x5c, 0x00,
	0x04, 0x6c, 0x5e,0x5d, 0x80,
	0x04, 0x6c, 0x5e,0x5e, 0x00,
	0x04, 0x6c, 0x5e,0x5f, 0x01,
	0x04, 0x6c, 0x5e,0x60, 0x00,
	0x04, 0x6c, 0x5e,0x61, 0x00,
	0x04, 0x6c, 0x5e,0x62, 0x01,
	0x04, 0x6c, 0x5e,0x63, 0x00,
	0x04, 0x6c, 0x5e,0x64, 0x00,
	0x04, 0x6c, 0x5e,0x65, 0x01,
	0x04, 0x6c, 0x5e,0x66, 0x00,
	0x04, 0x6c, 0x5e,0x67, 0x00,
	0x04, 0x6c, 0x5e,0x68, 0x01,
	0x04, 0x6c, 0x5e,0x69, 0x00,
	0x04, 0x6c, 0x5e,0x6a, 0x00,
	0x04, 0x6c, 0x5e,0x6b, 0x01,
	0x04, 0x6c, 0x5e,0x6c, 0x00,
	0x04, 0x6c, 0x5e,0x6d, 0x00,
	0x04, 0x6c, 0x5e,0x6e, 0x01,
	0x04, 0x6c, 0x5e,0x6f, 0x00,
	0x04, 0x6c, 0x5e,0x70, 0x00,
	0x04, 0x6c, 0x5e,0x71, 0x01,
	0x04, 0x6c, 0x5e,0x72, 0x00,
	0x04, 0x6c, 0x5e,0x73, 0x00,
	0x04, 0x6c, 0x5e,0x74, 0x00,
	0x04, 0x6c, 0x5e,0x75, 0x80,
	0x04, 0x6c, 0x5e,0x76, 0x00,
	0x04, 0x6c, 0x5e,0x77, 0x00,
	0x04, 0x6c, 0x5e,0x78, 0x80,
	0x04, 0x6c, 0x5e,0x79, 0x00,
	0x04, 0x6c, 0x5e,0x7a, 0x00,
	0x04, 0x6c, 0x5e,0x7b, 0x80,
	0x04, 0x6c, 0x5e,0x7c, 0x00,
	0x04, 0x6c, 0x5e,0x7d, 0x00,
	0x04, 0x6c, 0x5e,0x7e, 0x80,
	0x04, 0x6c, 0x5e,0x7f, 0x00,
	0x04, 0x6c, 0x5e,0x80, 0x00,
	0x04, 0x6c, 0x5e,0x81, 0x80,
	0x04, 0x6c, 0x5e,0x82, 0x00,
	0x04, 0x6c, 0x5e,0x83, 0x00,
	0x04, 0x6c, 0x5e,0x84, 0x3f,
	0x04, 0x6c, 0x5f,0x00, 0x02,
	0x04, 0x6c, 0x5f,0x01, 0x08,
	0x04, 0x6c, 0x5f,0x02, 0x09,
	0x04, 0x6c, 0x5f,0x03, 0x0a,
	0x04, 0x6c, 0x5f,0x04, 0x0b,
	0x04, 0x6c, 0x5f,0x05, 0x0c,
	0x04, 0x6c, 0x5f,0x06, 0x0c,
	0x04, 0x6c, 0x5f,0x07, 0x0c,
	0x04, 0x6c, 0x5f,0x08, 0x0c,
	0x04, 0x6c, 0x5f,0x09, 0x0c,
	0x04, 0x6c, 0x5f,0x0a, 0x0d,
	0x04, 0x6c, 0x5f,0x0b, 0x0d,
	0x04, 0x6c, 0x5f,0x0c, 0x0d,
	0x04, 0x6c, 0x5f,0x0d, 0x0d,
	0x04, 0x6c, 0x5f,0x0e, 0x0d,
	0x04, 0x6c, 0x5f,0x0f, 0x0e,
	0x04, 0x6c, 0x5f,0x10, 0x0e,
	0x04, 0x6c, 0x5f,0x11, 0x0e,
	0x04, 0x6c, 0x5f,0x12, 0x0e,
	0x04, 0x6c, 0x5f,0x13, 0x0f,
	0x04, 0x6c, 0x5f,0x14, 0x0f,
	0x04, 0x6c, 0x5f,0x15, 0x10,
	0x04, 0x6c, 0x5f,0x16, 0x11,
	0x04, 0x6c, 0x5f,0x17, 0x11,
	0x04, 0x6c, 0x5f,0x18, 0x12,
	0x04, 0x6c, 0x5f,0x19, 0x12,
	0x04, 0x6c, 0x5f,0x1a, 0x13,
	0x04, 0x6c, 0x5f,0x1b, 0x13,
	0x04, 0x6c, 0x5f,0x1c, 0x14,
	0x04, 0x6c, 0x5f,0x1d, 0x14,
	0x04, 0x6c, 0x5f,0x1e, 0x16,
	0x04, 0x6c, 0x5f,0x1f, 0x16,
	0x04, 0x6c, 0x5f,0x20, 0x16,
	0x04, 0x6c, 0x5f,0x21, 0x08,
	0x04, 0x6c, 0x5f,0x22, 0x00,
	0x04, 0x6c, 0x5f,0x23, 0x01,
	0x04, 0x6c, 0x5f,0x24, 0x00,
	0x04, 0x6c, 0x5f,0x25, 0x00,
	0x04, 0x6c, 0x5f,0x26, 0x02,
	0x04, 0x6c, 0x5f,0x27, 0x00,
	0x04, 0x6c, 0x5f,0x28, 0x00,
	0x04, 0x6c, 0x5f,0x29, 0x02,
	0x04, 0x6c, 0x5f,0x2a, 0x00,
	0x04, 0x6c, 0x5f,0x2b, 0x00,
	0x04, 0x6c, 0x5f,0x2c, 0x02,
	0x04, 0x6c, 0x5f,0x2d, 0x00,
	0x04, 0x6c, 0x5f,0x2e, 0x00,
	0x04, 0x6c, 0x5f,0x2f, 0x02,
	0x04, 0x6c, 0x5f,0x30, 0x00,
	0x04, 0x6c, 0x5f,0x31, 0x00,
	0x04, 0x6c, 0x5f,0x32, 0x02,
	0x04, 0x6c, 0x5f,0x33, 0x00,
	0x04, 0x6c, 0x5f,0x34, 0x00,
	0x04, 0x6c, 0x5f,0x35, 0x02,
	0x04, 0x6c, 0x5f,0x36, 0x00,
	0x04, 0x6c, 0x5f,0x37, 0x00,
	0x04, 0x6c, 0x5f,0x38, 0x02,
	0x04, 0x6c, 0x5f,0x39, 0x00,
	0x04, 0x6c, 0x5f,0x3a, 0x00,
	0x04, 0x6c, 0x5f,0x3b, 0x02,
	0x04, 0x6c, 0x5f,0x3c, 0x00,
	0x04, 0x6c, 0x5f,0x3d, 0x00,
	0x04, 0x6c, 0x5f,0x3e, 0x02,
	0x04, 0x6c, 0x5f,0x3f, 0x00,
	0x04, 0x6c, 0x5f,0x40, 0x00,
	0x04, 0x6c, 0x5f,0x41, 0x02,
	0x04, 0x6c, 0x5f,0x42, 0x00,
	0x04, 0x6c, 0x5f,0x43, 0x00,
	0x04, 0x6c, 0x5f,0x44, 0x02,
	0x04, 0x6c, 0x5f,0x45, 0x00,
	0x04, 0x6c, 0x5f,0x46, 0x00,
	0x04, 0x6c, 0x5f,0x47, 0x04,
	0x04, 0x6c, 0x5f,0x48, 0x00,
	0x04, 0x6c, 0x5f,0x49, 0x00,
	0x04, 0x6c, 0x5f,0x4a, 0x04,
	0x04, 0x6c, 0x5f,0x4b, 0x00,
	0x04, 0x6c, 0x5f,0x4c, 0x00,
	0x04, 0x6c, 0x5f,0x4d, 0x04,
	0x04, 0x6c, 0x5f,0x4e, 0x00,
	0x04, 0x6c, 0x5f,0x4f, 0x00,
	0x04, 0x6c, 0x5f,0x50, 0x04,
	0x04, 0x6c, 0x5f,0x51, 0x00,
	0x04, 0x6c, 0x5f,0x52, 0x00,
	0x04, 0x6c, 0x5f,0x53, 0x04,
	0x04, 0x6c, 0x5f,0x54, 0x00,
	0x04, 0x6c, 0x5f,0x55, 0x00,
	0x04, 0x6c, 0x5f,0x56, 0x04,
	0x04, 0x6c, 0x5f,0x57, 0x00,
	0x04, 0x6c, 0x5f,0x58, 0x00,
	0x04, 0x6c, 0x5f,0x59, 0x04,
	0x04, 0x6c, 0x5f,0x5a, 0x00,
	0x04, 0x6c, 0x5f,0x5b, 0x00,
	0x04, 0x6c, 0x5f,0x5c, 0x04,
	0x04, 0x6c, 0x5f,0x5d, 0x00,
	0x04, 0x6c, 0x5f,0x5e, 0x00,
	0x04, 0x6c, 0x5f,0x5f, 0x08,
	0x04, 0x6c, 0x5f,0x60, 0x00,
	0x04, 0x6c, 0x5f,0x61, 0x00,
	0x04, 0x6c, 0x5f,0x62, 0x08,
	0x04, 0x6c, 0x5f,0x63, 0x00,
	0x04, 0x6c, 0x5f,0x64, 0x00,
	0x04, 0x6c, 0x5f,0x65, 0x08,
	0x04, 0x6c, 0x5f,0x66, 0x00,
	0x04, 0x6c, 0x5f,0x67, 0x00,
	0x04, 0x6c, 0x5f,0x68, 0x08,
	0x04, 0x6c, 0x5f,0x69, 0x00,
	0x04, 0x6c, 0x5f,0x6a, 0x00,
	0x04, 0x6c, 0x5f,0x6b, 0x08,
	0x04, 0x6c, 0x5f,0x6c, 0x00,
	0x04, 0x6c, 0x5f,0x6d, 0x00,
	0x04, 0x6c, 0x5f,0x6e, 0x10,
	0x04, 0x6c, 0x5f,0x6f, 0x00,
	0x04, 0x6c, 0x5f,0x70, 0x00,
	0x04, 0x6c, 0x5f,0x71, 0x10,
	0x04, 0x6c, 0x5f,0x72, 0x00,
	0x04, 0x6c, 0x5f,0x73, 0x00,
	0x04, 0x6c, 0x5f,0x74, 0x10,
	0x04, 0x6c, 0x5f,0x75, 0x00,
	0x04, 0x6c, 0x5f,0x76, 0x00,
	0x04, 0x6c, 0x5f,0x77, 0x10,
	0x04, 0x6c, 0x5f,0x78, 0x00,
	0x04, 0x6c, 0x5f,0x79, 0x00,
	0x04, 0x6c, 0x5f,0x7a, 0x20,
	0x04, 0x6c, 0x5f,0x7b, 0x00,
	0x04, 0x6c, 0x5f,0x7c, 0x00,
	0x04, 0x6c, 0x5f,0x7d, 0x20,
	0x04, 0x6c, 0x5f,0x7e, 0x00,
	0x04, 0x6c, 0x5f,0x7f, 0x00,
	0x04, 0x6c, 0x5f,0x80, 0x20,
	0x04, 0x6c, 0x5f,0x81, 0x00,
	0x04, 0x6c, 0x5f,0x82, 0x00,
	0x04, 0x6c, 0x5f,0x83, 0x00,
	0x04, 0x6c, 0x5f,0x84, 0xff,
	0x04, 0x6c, 0x52,0x40, 0x0f,
	0x04, 0x6c, 0x52,0x41, 0x00,
	0x04, 0x6c, 0x52,0x42, 0x00,
	0x04, 0x6c, 0x52,0x43, 0x00,
	0x04, 0x6c, 0x52,0x44, 0x00,
	0x04, 0x6c, 0x52,0x45, 0x00,
	0x04, 0x6c, 0x52,0x46, 0x00,
	0x04, 0x6c, 0x52,0x47, 0x00,
	0x04, 0x6c, 0x52,0x48, 0x00,
	0x04, 0x6c, 0x52,0x49, 0x00,
	0x04, 0x6c, 0x54,0x40, 0x0f,
	0x04, 0x6c, 0x54,0x41, 0x00,
	0x04, 0x6c, 0x54,0x42, 0x00,
	0x04, 0x6c, 0x54,0x43, 0x00,
	0x04, 0x6c, 0x54,0x44, 0x00,
	0x04, 0x6c, 0x54,0x45, 0x00,
	0x04, 0x6c, 0x54,0x46, 0x00,
	0x04, 0x6c, 0x54,0x47, 0x00,
	0x04, 0x6c, 0x54,0x48, 0x00,
	0x04, 0x6c, 0x54,0x49, 0x00,
	0x04, 0x6c, 0x56,0x40, 0x0f,
	0x04, 0x6c, 0x56,0x41, 0x00,
	0x04, 0x6c, 0x56,0x42, 0x00,
	0x04, 0x6c, 0x56,0x43, 0x00,
	0x04, 0x6c, 0x56,0x44, 0x00,
	0x04, 0x6c, 0x56,0x45, 0x00,
	0x04, 0x6c, 0x56,0x46, 0x00,
	0x04, 0x6c, 0x56,0x47, 0x00,
	0x04, 0x6c, 0x56,0x48, 0x00,
	0x04, 0x6c, 0x56,0x49, 0x00,
	0x04, 0x6c, 0x58,0x40, 0x0f,
	0x04, 0x6c, 0x58,0x41, 0x00,
	0x04, 0x6c, 0x58,0x42, 0x00,
	0x04, 0x6c, 0x58,0x43, 0x00,
	0x04, 0x6c, 0x58,0x44, 0x00,
	0x04, 0x6c, 0x58,0x45, 0x00,
	0x04, 0x6c, 0x58,0x46, 0x00,
	0x04, 0x6c, 0x58,0x47, 0x00,
	0x04, 0x6c, 0x58,0x48, 0x00,
	0x04, 0x6c, 0x58,0x49, 0x00,
	0x04, 0x6c, 0x50,0x00, 0x8f,
	0x04, 0x6c, 0x50,0x01, 0x75,
	0x04, 0x6c, 0x50,0x02, 0x7f,
	0x04, 0x6c, 0x50,0x03, 0x3e,
	0x04, 0x6c, 0x50,0x04, 0x1e,
	0x04, 0x6c, 0x50,0x05, 0x1e,
	0x04, 0x6c, 0x50,0x06, 0x1e,
	0x04, 0x6c, 0x50,0x07, 0x1e,
	0x04, 0x6c, 0x50,0x08, 0x00,
	0x04, 0x6c, 0x50,0x0c, 0x00,
	0x04, 0x6c, 0x50,0x19, 0x00,
	0x04, 0x6c, 0x50,0x1a, 0xff,
	0x04, 0x6c, 0x50,0x1b, 0xff,
	0x04, 0x6c, 0x50,0x1d, 0x00,
	0x04, 0x6c, 0x50,0x1e, 0x40,
	0x04, 0x6c, 0x50,0x1f, 0x00,
	0x04, 0x6c, 0x50,0x21, 0x00,
	0x04, 0x6c, 0x50,0x22, 0x01,
	0x04, 0x6c, 0x50,0x23, 0x74,
	0x04, 0x6c, 0x50,0x25, 0x00,
	0x04, 0x6c, 0x50,0x26, 0x40,
	0x04, 0x6c, 0x50,0x27, 0x00,
	0x04, 0x6c, 0x50,0x70, 0x00,
	0x04, 0x6c, 0x50,0x74, 0x04,
	0x04, 0x6c, 0x40,0x01, 0x2b,
	0x04, 0x6c, 0x40,0x09, 0x07,
	0x04, 0x6c, 0x40,0x0a, 0x08,
	0x04, 0x6c, 0x40,0x0b, 0x04,
	0x04, 0x6c, 0x40,0x0c, 0x1b,
	0x04, 0x6c, 0x40,0x0d, 0x18,
	0x04, 0x6c, 0x40,0x12, 0x00,
	0x04, 0x6c, 0x40,0x14, 0x0f,
	0x04, 0x6c, 0x40,0x15, 0xff,
	0x04, 0x6c, 0x40,0x18, 0x12,
	0x04, 0x6c, 0x40,0x21, 0x05,
	0x04, 0x6c, 0x40,0x26, 0x00,
	0x04, 0x6c, 0x40,0x27, 0x40,
	0x04, 0x6c, 0x40,0x28, 0x00,
	0x04, 0x6c, 0x40,0x29, 0x40,
	0x04, 0x6c, 0x40,0x2a, 0x00,
	0x04, 0x6c, 0x40,0x2b, 0x40,
	0x04, 0x6c, 0x40,0x2c, 0x00,
	0x04, 0x6c, 0x40,0x2d, 0x40,
	0x04, 0x6c, 0x40,0x2e, 0x00,
	0x04, 0x6c, 0x40,0x2f, 0x00,
	0x04, 0x6c, 0x40,0x30, 0x00,
	0x04, 0x6c, 0x40,0x31, 0x00,
	0x04, 0x6c, 0x40,0x7e, 0xcc,
	0x04, 0x6c, 0x40,0x7f, 0x18,
	0x04, 0x6c, 0x46,0x40, 0x40,
	0x04, 0x6c, 0x46,0x41, 0x11,
	0x04, 0x6c, 0x46,0x42, 0x0e,
	0x04, 0x6c, 0x46,0x43, 0xee,
	0x04, 0x6c, 0x46,0x46, 0x0f,
	0x04, 0x6c, 0x46,0x48, 0x00,
	0x04, 0x6c, 0x46,0x49, 0x03,
	0x04, 0x6c, 0x38,0x0e, 0x04,
	0x04, 0x6c, 0x38,0x0f, 0x66,
	0x04, 0x6c, 0x38,0x0c, 0x09,
	0x04, 0x6c, 0x38,0x0d, 0xc8,
	0x04, 0x6c, 0x38,0x4c, 0x05,
	0x04, 0x6c, 0x38,0x4d, 0xf0,
	0x04, 0x6c, 0x38,0x8c, 0x03,
	0x04, 0x6c, 0x38,0x8d, 0xf0,
	0x04, 0x6c, 0x03,0x05, 0x42,
	0x04, 0x6c, 0x03,0x07, 0x03,
	0x04, 0x6c, 0x03,0x25, 0x54,
	0x04, 0x6c, 0x03,0x26, 0xde,
	0x04, 0x6c, 0x03,0x27, 0x09,
	0x04, 0x6c, 0x03,0x2a, 0x09,
	0x04, 0x6c, 0x48,0x37, 0x28,
	0x04, 0x6c, 0x46,0x03, 0x11,
	0x04, 0x6c, 0x35,0x01, 0x04,
	0x04, 0x6c, 0x35,0x02, 0x00,
	0x04, 0x6c, 0x35,0x41, 0x00,
	0x04, 0x6c, 0x35,0x42, 0x0f,
	0x04, 0x6c, 0x35,0xc1, 0x00,
	0x04, 0x6c, 0x35,0xc2, 0x02,
	0x04, 0x6c, 0x35,0x0A, 0x0F,
	0x04, 0x6c, 0x35,0x0B, 0x00,
	0x04, 0x6c, 0x43,0x17, 0x08,
	0x04, 0x6c, 0x43,0x0f, 0x27,
	//0x04, 0x6c, 0x01,0x00, 0x01,
	0x00, 0xff,
};



uint32_t max9295_trigger_mfp7_setting[] = {
    0x02D3, 0xf4,  // 1M,High prio,Jitter,ouput 1,GMSL2 rx,ouput en
    0x02D4, 0x67,  // pullup,push-pull,id = 7
    0x02D5, 0x07,  // id = 7
};

uint32_t max9295_trigger_mfp8_setting[] = {
	0x02D7, 0x67,  // pullup,push-pull,id = 7
	0x02D8, 0x07,  // id = 7
	0x02D6, 0xf4,  // 1M,High prio,Jitter,ouput 1,GMSL2 rx,ouput en
};

static uint16_t max9296_trigger_mfp[] = {
	0x02B1, 0xa7,  // pulldown,push-pull,id = 7
	0x02B2, 0x07,  // id = 7
	0x02B0, 0xeb,  // 1M,High prio,Jitter,output 0,GMSL2 tx
};

static uint16_t max9296_trigger_mfp8[] = {
	0x02C9, 0xa7,  // pulldown,push-pull,id = 7
	0x02Ca, 0x07,  // id = 7
	0x02C8, 0xeb,  // 1M,High prio,Jitter,output 0,GMSL2 tx
};

static uint16_t max9296_trigger_mfp7[] = {
	0x02C6, 0xa7,  // pulldown,push-pull,id = 7
	0x02C7, 0x07,  // id = 7
	0x02C5, 0xeb,  // 1M,High prio,Jitter,output 0,GMSL2 tx
};

static uint16_t max9296_trigger_mfp5[] = {
	0x0003, 0x40,  // pulldown,push-pull,id = 7
	0x02C0, 0xa7,  // pulldown,push-pull,id = 7
	0x02C1, 0x07,  // id = 7
	0x02bf, 0xeb,  // 1M,High prio,Jitter,output 0,GMSL2 tx
};

static uint16_t ovx8b_trigger_arbitrary_mode_setting[] = {
	0x3002, 0x04,  // output enable for VSYNC pad
	0x3834, 0xf0,  // output VSYNC at certain launch group
	0x3832, 0x10,  // VSYNC width in units of row time
	0x3015, 0x02,  // GPIO setting to receive GSIN pulse
	0x3009, 0x02,  // GPIO setting to receive GSIN pulse
	0x3822, 0x24,  // enable mode fix timing counter, numb of rows before frame end
	0x3823, 0x50,  // ext_vsync_en, enable set row counter manually
	0x383e, 0x81,  // vsync_ext_rst_dis
	0x3881, 0x34,  // hdr_num, ext_vsync_adj_en
	0x3882, 0x00,  // number of rows before frame end
	0x3883, 0x08,
	0x3826, 0x04,  // row conter initial value
	0x3827, 0xec,
};

#endif  // UTILITY_SENSOR_INC_OVX8B_SETTING_H_
