# Copyright (c) 2023 Horizon Robotics.All Rights Reserved.
#
# The material in this file is confidential and contains trade secrets
# of Horizon Robotics Inc. This is proprietary information owned by
# Horizon Robotics Inc. No part of this work may be disclosed,
# reproduced, copied, transmitted, or used in any way for any purpose,
# without the express written permission of Horizon Robotics Inc.

import socket
from http.server import SimpleHTTPRequestHandler, HTTPServer


def get_public_ip() -> str:
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    sock.connect(("8.8.8.8", 80))
    local_ip = sock.getsockname()[0]
    sock.close()
    return local_ip


def get_port(host: str, port: int = 8080) -> int:
    if port > 8090:
        raise EnvironmentError('Port is not available(8080-8090), '
                               'please check the network settings')
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(2)
    result = sock.connect_ex((host, port))
    if result == 0:
        sock.close()
        port = get_port(host, port+1)
        return port
    else:
        sock.close()
        return port


def run() -> None:
    host = get_public_ip()
    port = get_port(host, 8080)
    server_address = (host, port)
    httpd = HTTPServer(
        server_address=server_address,
        RequestHandlerClass=SimpleHTTPRequestHandler
    )
    print(f'Server running on http://{host}:{port}')
    print('Please copy and paste this URL into your browser')
    print('If you want to stop the server, press Ctrl + C in this terminal')
    httpd.serve_forever()


if __name__ == '__main__':
    run()
