"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["94996"],{47963:function(e,n,s){s.r(n);var i=s(85893),r=s(50065);function t(e){let n=Object.assign({h1:"h1",a:"a",p:"p",h2:"h2",ul:"ul",li:"li",pre:"pre",code:"code",span:"span",div:"div",h3:"h3",strong:"strong",ol:"ol",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"model-quantized-compilation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-quantized-compilation",children:"#"}),"Model Quantized Compilation"]}),"\n",(0,i.jsx)(n.p,{children:"During the model quantized compilation, the tool will generate the intermediate stage onnx model as well as the runtime model for simulating the on-board situations according to the configuration file."}),"\n",(0,i.jsxs)(n.h2,{id:"usage",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#usage",children:"#"}),"Usage"]}),"\n",(0,i.jsx)(n.p,{children:"The hb_compile provides two modes when doing the model quantized compilation, fast performance evaluation mode (with fast-perf turned on) and traditional model conversion compilation mode (without fast-perf turned on)."}),"\n",(0,i.jsx)(n.p,{children:"The fast performance evaluation mode, when turned on, will generate the hbm model that can have the highest performance when running on the board side during the conversion process, and the tool internally performs the following operations:"}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"Run BPU executable operators on the BPU whenever possible (i.e. you can specify the operators to run on the BPU via the node_info parameter in the yaml file)."}),"\n",(0,i.jsx)(n.li,{children:"Remove CPU operators that are removable at the beginning and end of the model, including: Quantize/Dequantize, Transpose, Cast, Reshape, etc."}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"If you want to use the fast performance evaluation mode (i.e., turn on fast-perf), the reference command is as follows:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"hb_compile"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--fast-perf"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${caffe_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"onnx_model} \\"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"           "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--proto"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${caffe_proto} \\"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"           "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--march"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${march} \\ "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"           "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"--input-shape"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${input_node_name} ${input_shape} "})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["Please note that if you need to enable fast performance evaluation mode, do not configure the ",(0,i.jsx)(n.code,{children:"-config"})," parameter as the tool uses the built-in high-performance configuration in this mode."]}),"\n",(0,i.jsxs)(n.li,{children:["When using hb_compile for model quantized compilation, the ",(0,i.jsx)(n.code,{children:"--input-shape"})," parameter configuration only works in fast performance evaluation mode (i.e. fast-perf is turned on)."]}),"\n"]})})]}),"\n",(0,i.jsx)(n.p,{children:"If you want to use the traditional model conversion compilation mode (without fast-perf enabled), the reference command is as follows:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"hb_compile"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${config_file} "})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h2,{id:"parameters-introduction",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#parameters-introduction",children:"#"}),"Parameters Introduction"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"20%"}}),(0,i.jsx)("col",{style:{width:"80%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"PARAMETER"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"DESCRIPTION"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"-h, --help"})}),(0,i.jsx)("td",{children:"Show help information and exit."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"-c, --config"})}),(0,i.jsx)("td",{children:"Configuration file for the model compilation, in YAML format."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"--fast-perf"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:["Turn on fast-perf, which will generate the hbm model that can have the highest performance when running on the board side during the conversion process, so that you can easily use it for the model performance evaluation later.",(0,i.jsx)("br",{}),"If you turned on fast-perf, you also need to configure the following:",(0,i.jsx)("br",{}),(0,i.jsx)("code",{children:"-m, --model"}),", Floating-point model file of Caffe/ONNX.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("code",{children:"--proto"}),", Specify the Prototxt file of the Caffe model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("code",{children:"--march"}),", BPU's micro architectures, for J6E processor, you should specify it to",(0,i.jsx)("code",{children:"nash-e"}),", for J6M processor, you should specify it to ",(0,i.jsx)("code",{children:"nash-m"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("code",{children:"-i, --input-shape"}),", Optional parameter that specifies the shape of the input node of the model. When using hb_compile for model quantized compilation, this configuration only takes effect when fast-perf is turned on currently. It is used in the following way:",(0,i.jsx)("br",{}),"\n",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsxs)("li",{children:["Specify the shape information of a single input node, example of how to use: ",(0,i.jsx)("code",{children:"--input-shape input_1 1x3x224x224"}),"."]}),(0,i.jsxs)("li",{children:["Specify the shapes of multiple input nodes, example of how to use: ",(0,i.jsx)("code",{children:"--input-shape input_1 1x3x224x224 --input-shape input_2 1x3x224x224"}),"."]})]}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": When the model is a single input node, ",(0,i.jsx)("code",{children:"--input-shape"}),"can be left unconfigured and the tool will automatically read the size information from the model file. However, for dynamic input nodes, if ",(0,i.jsx)("code",{children:"--input-shape"}),", is not specified, the tool will only support models where the first dimension of the dynamic input node is [-1, 0, ?], by default, the first dimension of the dynamic input node will be set to 1."]})})]})]})]}),"\n",(0,i.jsxs)(n.p,{children:["The log file generated by the compilation will be stored in the directory where the command is executed under the default name ",(0,i.jsx)(n.code,{children:"hb_compile.log"}),"."]}),"\n",(0,i.jsxs)(n.h2,{id:"full_yaml",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#full_yaml",children:"#"}),"Configuration File Template"]}),"\n",(0,i.jsx)(n.p,{children:"A complete configuration file template is shown as below:"}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive info",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.p,{children:["Below configuration file is only for display, in an actual configuration file of a model, the ",(0,i.jsx)(n.code,{children:"caffe_model"})," and ",(0,i.jsx)(n.code,{children:"onnx_model"})," parameters are not coexisting.\nThe model should be either a Caffe or an ONNX model. That is, ",(0,i.jsx)(n.code,{children:"caffe_model"})," + ",(0,i.jsx)(n.code,{children:"prototxt"})," or ",(0,i.jsx)(n.code,{children:"onnx_model"})," , you need to choose one of the two when configuring."]})})]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-yaml",meta:"",children:[(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# model parameters  "})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"model_parameters"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The descriptive file of the original Caffe floating-point model "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"prototxt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'***.prototxt'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The original Caffe model file  "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"caffe_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'****.caffemodel'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The original ONNX model file"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"onnx_model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'****.onnx'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The target processor architecture of conversion"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"march"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'nash-e'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The prefix of the converted model file which will run on the dev board  "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"output_model_file_prefix"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'mobilenetv1'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The directory where the conversion results will be saved  "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"working_dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./model_output_dir'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# To specify whether the converted Hybrid heterogeneous model retains the ability to output the intermediate layer results for each layer after conversion "})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"layer_out_dump"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify the output node of the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"output_nodes"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"OP_name"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Batch delete nodes of a certain type"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"remove_node_type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Dequantize"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Delete the node with the specified name"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"remove_node_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"OP_name"'})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# input information parameters"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_parameters"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The input node name of the floating-point model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"data"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The input data format of the original floating-point model (quantity/sequence consistent with the input_name)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'bgr'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The input data layout of the original floating-point model (quantity/sequence consistent with the input_name)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_layout_train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'NCHW'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The input data size of the original floating-point model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_shape"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'1x3x224x224'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The data batch_size input to the neural network when the network is actually executed"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_batch"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The data pre-processing method to be added into the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"norm_type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'data_mean_and_scale'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The mean value of the image subtracted by the preprocessing method, if it is the channel mean, the values must be separated by a space"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"mean_value"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'103.94 116.78 123.68'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The image scaling of the preprocessing method, if it is a channel scaling, the values must be separated by a space"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"scale_value"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'0.017'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The input data format which the converted heterogeneous model needs to match"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# (quantity/sequence consistent with the input_name)"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_rt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'yuv444'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Special input data format"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_space_and_range"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'regular'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Calibration parameters"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"calibration_parameters"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# The directory where the calibration samples will be saved"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"cal_data_dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./calibration_data'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Type of algorithms used for calibration"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"calibration_type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'kl'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# max calibration parameter"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"max_percentile"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify whether to calibrate for each channel"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"per_channel"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"False"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# compilation parameters "})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"compiler_parameters"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Select compilation strategy"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"compile_mode"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'latency'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Number of cores to run the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"core_num"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Select the priority of model compilation"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"optimize_level"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'O2'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify the input data source with the name data"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_source"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" {"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"data"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"pyramid"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify the maximum continuous execution time for each function call of the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"max_time_per_fc"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# Specify the number of processes when compiling the model"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"jobs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"8"})]}),"\n"]})})}),"\n","\n",(0,i.jsx)(n.p,{children:"The configuration file mainly contains model parameters, input information parameters, calibration parameters, compilation parameters. All parameter groups must exist in your configuration file. Parameters can be divided into the optional and the mandatory, while the optional parameters can be left unconfigured."}),"\n",(0,i.jsx)(n.p,{children:"The following is the specific parameter information, the parameters will be more, we follow the above parameter group order to introduce. Required/Optional indicates whether this parameter must be specified in the Yaml file."}),"\n",(0,i.jsxs)(n.h2,{id:"config_parameter",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#config_parameter",children:"#"}),"Specific Parameter Information"]}),"\n",(0,i.jsxs)(n.h3,{id:"model_parameter_group",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model_parameter_group",children:"#"}),"Model Parameters"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"74%"}}),(0,i.jsx)("col",{style:{width:"11%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"PARAMETER"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"DESCRIPTION"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"Required/Optional"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"prototxt"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the prototxt filename of the floating-point Caffe model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Model path.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter must be specified when the model is a ",(0,i.jsx)("code",{children:"Caffe"})," model."]})}),(0,i.jsx)("td",{children:"Caffe module required"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"caffe_model"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the caffemodel filename of the floating-point Caffe model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Model path.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter must be specified when the model is a ",(0,i.jsx)("code",{children:"Caffe"})," model."]})}),(0,i.jsx)("td",{children:"Caffe module required"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"onnx_model"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the onnx filename of the floating-point ONNX model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Model path.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter must be specified when the model is a ",(0,i.jsx)("code",{children:"ONNX"})," model."]})}),(0,i.jsx)("td",{children:"ONNX module required"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"march"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the platform architecture to run the converted heterogeneous model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'nash-e'"})," or ",(0,i.jsx)("code",{children:"'nash-m'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The two optional configuration values correspond to J6E and J6M processors in that order.",(0,i.jsx)("br",{}),"Depending on the platform you are using, you can choose between the two options."]})}),(0,i.jsx)("td",{children:"required"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"output_model_file_prefix"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the prefix of the converted heterogeneous model filename.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),":",(0,i.jsx)("code",{children:"'model'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter specifies the prefix of the converted heterogeneous model filename."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"working_dir"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the directory to save the conversion results.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),":",(0,i.jsx)("code",{children:"'model_output'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The tool will create a new directory automatically if it doesn't exist."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"layer_out_dump"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies whether the heterogeneous model retains the ability to output intermediate layer values.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Bool.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"True"}),",",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Dumping the intermediate layer results is a debugging method, please do not enable it unless it is necessary.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": It is not supported to configure input_source to be resizer when layer_out_dump is True."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"output_nodes"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies model output node(s).",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Specific node name of the model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter is used to support you to specify the node as the model output, the value should be the specific node name of the model.",(0,i.jsx)("br",{}),"When there are multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:"param_value Configuration"}),"."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"remove_node_type"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter sets the type of the deleted node.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:'"Quantize"'}),", ",(0,i.jsx)("code",{children:'"Transpose"'}),", ",(0,i.jsx)("code",{children:'"Dequantize"'}),", ",(0,i.jsx)("code",{children:'"Cast"'}),", ",(0,i.jsx)("code",{children:'"Reshape"'}),", ",(0,i.jsx)("code",{children:'"Softmax"'}),". Different types should be split by",(0,i.jsx)("code",{children:";"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": No settings or set to null doesn't affect the model conversion process.",(0,i.jsx)("br",{}),"This parameter is used to support you in setting the type information of the node to be deleted.\n",(0,i.jsx)("br",{}),"The deleted node must be at the beginning or end of the model, connected to the input or output of the model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": After setting this parameter, we will match the deletable nodes of the model according to your configuration. If the node type you configured to be deleted meets the deletion conditions, it will be deleted and this process will be repeated until the deletable nodes can not be matched with the configured node type."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"remove_node_name"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter sets the name of the deleted node.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": The name of the node in the model to be deleted. Different names should be split by",(0,i.jsx)("code",{children:";"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": No settings or set to null doesn't affect the model conversion process.",(0,i.jsx)("br",{}),"This parameter is used to support you in setting the name of the node to be deleted.",(0,i.jsx)("br",{}),"The deleted node must be at the beginning or the end of the model, connected to the input or output of the model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": After setting this parameter, we will match the deletable nodes of the model according to your configuration. If the node name you configured to be deleted meets the deletion conditions, it will be deleted and this process will be repeated until the deletable nodes can not be matched with the configured node name."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"debug_mode"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": Save calibration data for accuracy debug analysis.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:'"dump_calibration_data"'}),(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter serves to save the calibration data for the accuracy debug analysis and the data format is .npy. This data can be fed directly into the model for inference via np.load(). If you don't set this parameter, you can also save the data yourself and use the accuracy debug tool for accuracy analysis."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"node_info"})}),(0,i.jsxs)("td",{children:[(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": Support setting the input and output data type of the specified op to be int16 and forcing the specified operator to run on the CPU or BPU.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": The range of operators supporting the configuration of int16 you can refer to ",(0,i.jsx)("a",{href:"../../../appendix/supported_op_list/onnx_operator_support_list.html",children:"Toolchain Operator Support Constraint List-ONNX Operator Support List"}),". The operators that can be specified to run on the CPU or BPU need to be the ones included in the model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),":",(0,i.jsx)("br",{}),(0,i.jsx)(n.code,{children:"node_info"})," parameter usage: ",(0,i.jsx)("ul",{className:"list-disc pl-5 my-4 leading-7",children:(0,i.jsx)("li",{children:"Specify only that the OP runs on BPU/CPU (BPU is used as an example below, CPU method is the same):"})})]}),(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"node_info:"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:'"node_name"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"'ON'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'BPU'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),(0,i.jsx)("ul",{className:"list-disc pl-5 my-4 leading-7",children:(0,i.jsx)("li",{children:"Configure only the node data type:"})}),(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"node_info:"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'node_name1:int16;node_name2:int16'"})]}),"\n"]})})}),(0,i.jsxs)(n.p,{children:["For the configuration of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:"param_value Configuration"}),"\u3002\n",(0,i.jsx)("ul",{className:"list-disc pl-5 my-4 leading-7",children:(0,i.jsx)("li",{children:"Specifies that the OP runs on the BPU and also configures the input and output data types of the OP:"})})]}),(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"node_info:"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:'"node_name"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"'ON'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'BPU'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"'InputType'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'int16'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"'OutputType'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'int16'"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.code,{children:"'InputType': 'int16'"})," means that all input data types for the specified operator are int16.",(0,i.jsx)("br",{})," To specify the ",(0,i.jsx)(n.code,{children:"InputType"})," of an operator-specific input, configure it by specifying a number after ",(0,i.jsx)(n.code,{children:"InputType"}),". E.g.:\n",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsxs)("li",{children:[(0,i.jsx)(n.code,{children:"'InputType0': 'int16'"})," means that the first input data type of the specified operator is int16."]}),"\n",(0,i.jsxs)("li",{children:[(0,i.jsx)(n.code,{children:"'InputType1': 'int16'"})," means that the second input data type of the specified operator is int16, and so on."]})]}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": ",(0,i.jsx)(n.code,{children:"'OutputType'"})," does not support specifying an operator-specific output ",(0,i.jsx)(n.code,{children:"OutputType"}),", which takes effect on all outputs of the operator when configured; configuring ",(0,i.jsx)(n.code,{children:"'OutputType0'"}),", ",(0,i.jsx)(n.code,{children:"'OutputType1'"}),", etc. is not supported."]})]}),(0,i.jsx)("td",{children:"optional"})]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"input-information-parameters",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#input-information-parameters",children:"#"}),"Input Information Parameters"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"15%"}}),(0,i.jsx)("col",{style:{width:"74%"}}),(0,i.jsx)("col",{style:{width:"11%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"PARAMETER"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"DESCRIPTION"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"Required/Optional"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_name"})}),(0,i.jsxs)("td",{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input node names of the original floating-point model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Single input: ",(0,i.jsx)("code",{children:'""'})," or the input node name, Multiple inputs: ",(0,i.jsx)("code",{children:'"input_name1; input_name2; input_name3..."'}),(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": No configuration is required if there is only one input node.",(0,i.jsx)("br",{}),"If there are more than one nodes, it must be configured so as to guarantee the accuracy of subsequent types and input sequence of the calibration data.",(0,i.jsx)("br",{})," For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration "}),"."]}),(0,i.jsxs)("td",{children:["Single input: optional ",(0,i.jsx)("br",{})," Multiple inputs: required "]})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_type_train"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input data type of the original floating-point model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'rgb'"}),", ",(0,i.jsx)("code",{children:"'bgr'"}),",",(0,i.jsx)("code",{children:"'yuv444'"}),", ",(0,i.jsx)("code",{children:"'yuv444_128'"}),", ",(0,i.jsx)("code",{children:"'gray'"})," and ",(0,i.jsx)("code",{children:"'featuremap'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'featuremap'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Each input node needs to be configured with a defined input data type. If there are multiple input nodes, the order of the nodes must be strictly consistent with the order in the ",(0,i.jsx)("code",{children:"input_name"}),".",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),(0,i.jsx)("br",{}),"For the selection of data types, please refer to: ",(0,i.jsx)("a",{href:"../../ptq_usage/quantize_compile.html#conversion_interpretation",children:"Model Conversion Interpretation"}),"section."]})}),(0,i.jsx)("td",{children:"required "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_type_rt"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input data format that the converted heterogeneous model must match.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'rgb'"}),", ",(0,i.jsx)("code",{children:"'bgr'"}),",",(0,i.jsx)("code",{children:"'yuv444_128'"}),(0,i.jsx)("code",{children:"'nv12'"}),",",(0,i.jsx)("code",{children:"'gray'"})," and ",(0,i.jsx)("code",{children:"'featuremap'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'featuremap'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Here is an indication of the data format you need to use.",(0,i.jsx)("br",{}),"It doesn't have to be the same as the data format of the original model, ",(0,i.jsx)("b",{children:"but note that this is the format that will actually feed into your model when running on the computing platform"}),".",(0,i.jsx)("br",{}),"Each input node needs to be configured with a defined input data layout. If there are multiple input nodes, the sequence of the configured nodes must be strictly consistent with the ",(0,i.jsx)("code",{children:"input_name"})," sequence.",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),".",(0,i.jsx)("br",{}),"For the selection of data types, please refer to ",(0,i.jsx)("a",{href:"../../ptq_usage/quantize_compile.html#conversion_interpretation",children:"Model Conversion Interpretation"}),"section."]})}),(0,i.jsx)("td",{children:"required "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_layout_train"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input data layout of the original floating-point model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'NHWC'"}),", ",(0,i.jsx)("code",{children:"'NCHW'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Each input node needs to be configured with a defined input data layout that shall be the same as the layout of the original floating-point model.",(0,i.jsx)("br",{}),"If there are multiple input nodes, the order of the nodes must be strictly consistent with the ",(0,i.jsx)("code",{children:"input_name"})," sequence.",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),".",(0,i.jsx)("br",{}),"For more about data layout, please refer to ",(0,i.jsx)("a",{href:"../../ptq_usage/quantize_compile.html#conversion_interpretation",children:"Model Conversion Interpretation"}),"section."]})}),(0,i.jsx)("td",{children:"required "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_space_and_range"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies special data formats.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'regular'"})," and ",(0,i.jsx)("code",{children:"'bt601_video'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'regular'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The purpose of this parameter is to deal with the YUV420 format dumped by different ISP and it will only become valid when the ",(0,i.jsx)("code",{children:"input_type_rt"})," is specified as ",(0,i.jsx)("code",{children:"nv12"}),", if the format is not ",(0,i.jsx)("code",{children:"nv12"}),", an error will be reported, and the process will exit.",(0,i.jsx)("br",{}),"\n",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"regular"})," is a common YUV420 format ranged between ",(0,i.jsx)("code",{children:"[0,255]"}),"."]}),(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"bt_601_video"})," is another YUV420 video format ranged between ",(0,i.jsx)("code",{children:"[16,235]"}),". For more information about bt601, please feel free to Google it."]})]}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": You don't need to configure this parameter without explicit requirements."]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_shape"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input data size of the original floating-point model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Dimensions of shape should be separated by ",(0,i.jsx)("code",{children:"x"}),", e.g. ",(0,i.jsx)("code",{children:"'1x3x224x224'"}),".",(0,i.jsx)("br",{}),"You don't need to configure this parameter unless there are more input nodes in the model, because the tool can read the size information from model files automatically.",(0,i.jsx)("br",{}),"When there are multiple input nodes, the sequence of configured nodes must be strictly consistent with the ",(0,i.jsx)("code",{children:"input_name"})," sequence.",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),"."]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_batch"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input data batch size that the converted heterogeneous model must match.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"1-4096"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"1"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter specifies the input data batch size that the converted heterogeneous model must match, but does not affect the input data batch size of the converted bc model.",(0,i.jsx)("br",{}),"If you don't configure this parameter, the default value is 1.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": ",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsxs)("li",{children:["This parameter can only be used when the first dimension of ",(0,i.jsx)("code",{children:"input_shape"}),"is 1 for a single-input model."]}),(0,i.jsx)("li",{children:"This parameter only effective when the original onnx model itself supports multi-batch inference. However, due to the complexity of the operators, if during the model conversion process, However, due to the complexity of the operators, if during the model conversion process, you meet the conversion failure log which indicates that the model does not support the configuration of the input_batch parameter, please try to directly export a multi-batch onnx model and correctly configure the size of the calibration data to re-convert it (at this time, you no longer need to configure this arameter). "})]})]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"separate_batch"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies whether to enable the separated batch mode.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Bool.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"True"}),", ",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": If you don't configure this parameter, the default value is False, that is, the separated batch mode is not enabled.",(0,i.jsx)("br",{}),"When the separated batch mode is not enabled, the input need to be allocated in a contiguous memory area. For example, if the model input is 1x3x224x224 and input_batch is set to N, you will need to prepare an on-board model input of Nx3x224x224.",(0,i.jsx)("br",{}),"When the separate batch mode is enabled, the input nodes with this mode enabled will be separated, the number of which to be separated is the value you specified with input_batch. You can prepare the input for each batch individually, which no longer requires the input to be allocated in a contiguous area of memory in this mode. For example, if the model input is 1x3x224x224 and input_batch is set to N, then you need to prepare N 1x3x224x224 on-board model inputs."]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"norm_type"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the pre-processing method to deal with the model input data.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'data_mean_and_scale'"}),", ",(0,i.jsx)("code",{children:"'data_mean'"}),", ",(0,i.jsx)("code",{children:"'data_scale'"})," and ",(0,i.jsx)("code",{children:"'no_preprocess'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'no_preprocess'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": ",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"no_preprcess"})," means that no pre-processing method will be used."]}),"\n",(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"data_mean"})," means subtracting mean value."]}),"\n",(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"data_scale"})," means providing multiply scale factor preprocessing."]}),"\n",(0,i.jsxs)("li",{children:[(0,i.jsx)("code",{children:"data_mean_and_scale"})," means first subtracting mean value and then multiplying scale factor."]})]}),"When there are multiple input nodes, the sequence of configured nodes must be strictly consistent with the ",(0,i.jsx)("code",{children:"input_name"})," sequence.",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),".",(0,i.jsx)("br",{}),"For the influence of this parameter, please refer to ",(0,i.jsx)("a",{href:"../../ptq_usage/quantize_compile.html#conversion_interpretation",children:"Model Conversion Interpretation"}),"section.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": When ",(0,i.jsx)("code",{children:"input_type_rt"})," is configured as a featuremap non-four-dimensional input, norm_type can only be configured as no_preprocess."]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"mean_value"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the mean value to be subtracted by the pre-processing method.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Float.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter will be valid when the ",(0,i.jsx)("code",{children:"norm_type"})," is specified as ",(0,i.jsx)("code",{children:"data_mean_and_scale"})," or ",(0,i.jsx)("code",{children:"data_mean"}),".",(0,i.jsx)("br",{}),"Each input node has 2 configuration methods.",(0,i.jsx)("br",{}),"If only one value is specified, then all channels will subtract the same mean value.",(0,i.jsx)("br",{}),"Otherwise, you need to specify the mean values for each channel and the number of values (separated by space) must be consistent with the numbers of channel.",(0,i.jsx)("br",{}),"The number of configured input nodes must be consistent with the node number specified by ",(0,i.jsx)("code",{children:"norm_type"}),".",(0,i.jsx)("br",{}),"If there is a node that doesn't require ",(0,i.jsx)("code",{children:"mean"})," processing, it should be specified as ",(0,i.jsx)("code",{children:"'None'"}),".",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),"."]})}),(0,i.jsx)("td",{children:"optional "})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"scale_value"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the scale factor of the pre-processing method .",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Float.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter will be valid when the ",(0,i.jsx)("code",{children:"norm_type"})," is specified as ",(0,i.jsx)("code",{children:"data_mean_and_scale"})," or ",(0,i.jsx)("code",{children:"data_scale"}),".",(0,i.jsx)("br",{}),"Each input node has 2 configuration methods.",(0,i.jsx)("br",{}),"You can either specify only 1 value for all channels or specify the values (separated by space) for each channel.",(0,i.jsx)("br",{}),"The number of values must be consistent with number of channels.",(0,i.jsx)("br",{}),"The number of configured input nodes must be consistent with the node number specified by ",(0,i.jsx)("code",{children:"norm_type"}),".",(0,i.jsx)("br",{}),"If there is a node that doesn't require ",(0,i.jsx)("code",{children:"scale"})," processing, it should be specified as ",(0,i.jsx)("code",{children:"'None'"}),".",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),"."]})}),(0,i.jsx)("td",{children:"optional "})]})]})]}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"input_type_rt/input_type_train additional description"})}),"\n",(0,i.jsx)(n.p,{children:"To boost the ASIC performance, 2 assumptions have been made in the design of ASIC micro architecture:"}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsx)(n.li,{children:"All inputs are quantized int8 data."}),"\n",(0,i.jsx)(n.li,{children:"All camera captured data are NV12."}),"\n"]}),"\n",(0,i.jsx)(n.p,{children:"Therefore, if you use the RGB (NCHW) format in the model training and expect the model to process NV12 data efficiently, then you will need to configure as follow:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-yaml",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_parameters"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_rt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'nv12'"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_type_train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'rgb'"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"input_layout_train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'NCHW'"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive tip",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Tip"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.p,{children:["When Gray format is used in the model training, while in practice, the model input is NV12,\nyou can set both ",(0,i.jsx)(n.code,{children:"input_type_rt"})," and ",(0,i.jsx)(n.code,{children:"input_type_train"})," to ",(0,i.jsx)(n.code,{children:"gray"})," during model conversion, and use only the y channel address of the NV12 data in embedded application development."]})})]}),"\n",(0,i.jsxs)(n.p,{children:["In addition to converting the input data to NV12, you can also use different RGB-orders in the training and runtime infer.\nThe tool will automatically add data conversion nodes according to the data formats specified by the ",(0,i.jsx)(n.code,{children:"input_type_rt"})," and ",(0,i.jsx)(n.code,{children:"input_type_train"}),".\nNot any type combination is needed, in order to avoid your misuse, we only open some fixed type combinations in the following table\n(Y for supported image types, while N for unsupported image types. The first row of the table is the data types supported in ",(0,i.jsx)(n.code,{children:"input_type_rt"})," and the first column is the data types supported in ",(0,i.jsx)(n.code,{children:"input_type_train"}),".):"]}),"\n",(0,i.jsxs)(n.table,{children:[(0,i.jsx)(n.thead,{children:(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"input_type_train \\ input_type_rt"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"nv12"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"yuv444"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"rgb"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"bgr"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"gray"})}),(0,i.jsx)(n.th,{align:"center",children:(0,i.jsx)(n.strong,{children:"featuremap"})})]})}),(0,i.jsxs)(n.tbody,{children:[(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"yuv444"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"rgb"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"bgr"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"gray"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"Y"}),(0,i.jsx)(n.td,{align:"center",children:"N"})]}),(0,i.jsxs)(n.tr,{children:[(0,i.jsx)(n.td,{align:"center",children:"featuremap"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"N"}),(0,i.jsx)(n.td,{align:"center",children:"Y"})]})]})]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive info",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.p,{children:["To meet the requirements of Horizon ASICs on input data type (int8) and reduce the inference costs,\nwhen ",(0,i.jsx)(n.code,{children:"input_type_rt"})," is of the RGB(NHWC/NCHW)/BGR(NHWC/NCHW) type, the input data type of the models converted by using the conversion tool will all be ",(0,i.jsx)(n.code,{children:"int8"}),".\nThat is, for regular image formats, pixel values should be subtracted by 128, which has already been done by the API and you do not need to do it again."]})})]}),"\n",(0,i.jsxs)(n.p,{children:["In the final hbm model obtained from the conversion, the conversion from ",(0,i.jsx)(n.code,{children:"input_type_rt"})," to ",(0,i.jsx)(n.code,{children:"input_type_train"})," is an internal process.\nYou only need to focus on the data format of ",(0,i.jsx)(n.code,{children:"input_type_rt"}),".\n",(0,i.jsxs)(n.strong,{children:["It is of vital importance to understand the requirement of the ",(0,i.jsx)(n.code,{children:"input_type_rt"})," when preparing the inference data for embedded applications"]}),", ",(0,i.jsxs)(n.strong,{children:["please refer to the following explanations to each format of the ",(0,i.jsx)(n.code,{children:"input_type_rt"})]}),"."]}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsx)(n.li,{children:"rgb, bgr, and gray are commonly used image format. Note that each value is represented using UINT8."}),"\n",(0,i.jsx)(n.li,{children:"yuv444 is a popular image format. Note that each value is represented using UINT8."}),"\n",(0,i.jsx)(n.li,{children:"NV12 is a popular YUV420 image format. note that each value is represented using UINT8."}),"\n",(0,i.jsxs)(n.li,{children:["One special case of NV12 is to specify the ",(0,i.jsx)(n.code,{children:"bt601_video"})," of the ",(0,i.jsx)(n.code,{children:"input_space_and_range"}),".\nCompared with typical NV12 format, its value range has changed from [0,255] to [16,235].\nEach value is still represented as UINT8. Note that ",(0,i.jsx)(n.code,{children:"bt601_video"})," is supported configuring via ",(0,i.jsx)(n.code,{children:"input_space_and_range"})," only when ",(0,i.jsx)(n.code,{children:"input_type_train"})," is ",(0,i.jsx)(n.code,{children:"bgr"})," or ",(0,i.jsx)(n.code,{children:"rgb"}),"."]}),"\n",(0,i.jsx)(n.li,{children:"Featuremap is suitable for cases where the above listed formats failed to meet your needs, and this type uses float32 for each value.\nFor example, this format is commonly used for model processing such as radar and speech."}),"\n"]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive tip",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Tip"}),(0,i.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,i.jsxs)(n.p,{children:["The above ",(0,i.jsx)(n.code,{children:"input_type_rt"})," and ",(0,i.jsx)(n.code,{children:"input_type_train"})," are integrated into the toolchain processing procedure.\nIf you are very sure that no format conversion is required, then set the two ",(0,i.jsx)(n.code,{children:"input_type"})," to be the same,\nso that the same ",(0,i.jsx)(n.code,{children:"input_type"})," will perform the processing in a straight-through way and will not affect the actual execution performance of the model."]}),(0,i.jsxs)(n.p,{children:["Similarly, data pre-processing also is also integrated into the process.\nIf you don't need to do any pre-processing, you can disable this function through the ",(0,i.jsx)(n.code,{children:"norm_type"})," configuration, which will not affect the actual execution performance of the model."]})]})]}),"\n",(0,i.jsxs)(n.h3,{id:"calibration-parameters",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#calibration-parameters",children:"#"}),"Calibration Parameters"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"12%"}}),(0,i.jsx)("col",{style:{width:"77%"}}),(0,i.jsx)("col",{style:{width:"11%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"PARAMETER"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"DESCRIPTION"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"Required/Optional"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"cal_data_dir"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the directory to save the calibration samples.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The calibration data in the directory must comply with the requirements of input configurations, please refer to the ",(0,i.jsx)("a",{href:"../../ptq_usage/prepare_calibration_data.html",children:"Prepare Calibration Data"})," section.",(0,i.jsx)("br",{}),"When there are multiple input nodes, the sequence of configured nodes must be strictly consistent with the ",(0,i.jsx)("code",{children:"input_name"})," sequence.",(0,i.jsx)("br",{}),"For configuration methods of multiple values, please refer to ",(0,i.jsx)("a",{href:"#param_value",children:" param_value Configuration"}),".",(0,i.jsx)("br",{}),"When calibration_type is ",(0,i.jsx)("code",{children:"skip"}),", cal_data_dir doesn't need to be set."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"calibration_type"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the types of algorithms used in the calibration.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'default'"}),", ",(0,i.jsx)("code",{children:"'mix'"}),", ",(0,i.jsx)("code",{children:"'kl'"}),", ",(0,i.jsx)("code",{children:"'max'"})," and ",(0,i.jsx)("code",{children:"'skip'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'default'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Both the ",(0,i.jsx)("code",{children:"kl"})," and ",(0,i.jsx)("code",{children:"max"})," are public quantization calibration algorithms. Users can learn more from the Internet.",(0,i.jsx)("br",{}),(0,i.jsx)("code",{children:"default"})," is an automatic search strategy to try to get a better calibration combination from a series of quantization calibration parameters.",(0,i.jsx)("br",{}),(0,i.jsx)("code",{children:"mix"})," is a search strategy that integrates multiple calibration methods. It automatically identifies quantization-sensitive nodes and selects the best method from different calibration methods at the node granularity. Ultimately, a combined calibration approach that incorporates the advantages of multiple calibration methods is constructed.",(0,i.jsx)("br",{}),"It is recommended to firstly try the ",(0,i.jsx)("code",{children:"default"}),", and if the results fails to meet the expectation, configure different calibration parameters according to ",(0,i.jsx)("a",{href:"../../../tune_content/accuracy_tune.html",children:"PTQ Model Accuracy Optimization"})," section.",(0,i.jsx)("br",{}),"If you only want to try to verify the model performance, but do not require the accuracy, you can try the ",(0,i.jsx)("code",{children:"skip"})," method of calibration. This method uses max + internally generated random calibration data for calibration and does not require you to prepare calibration data, so it is suitable for first-time attempts to validate the model structure.",(0,i.jsx)("br",{}),(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": When using the skip, the model obtained cannot be used for accuracy verification because it uses max + internally generated random calibration data for calibration."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"max_percentile"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This is the parameter of the ",(0,i.jsx)("code",{children:"max"})," calibration method and it is used to adjust the intercept point of the ",(0,i.jsx)("code",{children:"max"})," calibration.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Float.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"0.5"})," - ",(0,i.jsx)("code",{children:"1.0"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"1.0"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter is valid only when the ",(0,i.jsx)("code",{children:"calibration_type"})," is specified as ",(0,i.jsx)("code",{children:"max"}),".",(0,i.jsx)("br",{}),"Typical options: 0.99999/0.99995/0.99990/0.99950/0.99900.",(0,i.jsx)("br",{}),"It is recommended to firstly specify the ",(0,i.jsx)("code",{children:"calibration_type"})," as ",(0,i.jsx)("code",{children:"default"}),", and if the results fails to meet the expectation, configure different calibration parameters according to the ",(0,i.jsx)("a",{href:"../../../tune_content/accuracy_tune.html",children:"PTQ Model Accuracy Optimization"})," section."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"per_channel"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter determines whether to calibrate each channel of featuremap.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Bool.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"True"})," or ",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"False"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter is valid only when the ",(0,i.jsx)("code",{children:"calibration_type"})," is specified as non-default or non-mix values.",(0,i.jsx)("br",{}),"You are recommended to firstly try the ",(0,i.jsx)("code",{children:"default"}),", and if the results still fails to meet the expectation, configure different calibration parameters according to the ",(0,i.jsx)("a",{href:"../../../tune_content/accuracy_tune.html",children:"PTQ Model Accuracy Optimization"})," section."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"optimization"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter provides you with several configurable options for tuning, through which you can configure different modes to tune the accuracy/performance.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"set_model_output_int8"}),", ",(0,i.jsx)("code",{children:"set_model_output_int16"}),", ",(0,i.jsx)("code",{children:"set_{NodeKind}_input_int16"}),", ",(0,i.jsx)("code",{children:"set_{NodeKind}_output_int16"}),",",(0,i.jsx)("code",{children:"set_Softmax_input_int8"}),", ",(0,i.jsx)("code",{children:"set_Softmax_output_int8"}),", ",(0,i.jsx)("code",{children:"asymmetric"}),", ",(0,i.jsx)("code",{children:"bias_correction"})," and ",(0,i.jsx)("code",{children:"lstm_batch_last"}),".",(0,i.jsx)("br",{}),"Note: Nodekind here needs to be written in standard ONNX operator type, such as Conv, Mul, Sigmoid, etc. (case sensitive). For details, please refer to the official ONNX op documentation or the ",(0,i.jsx)("a",{href:"../../../appendix/supported_op_list/onnx_operator_support_list.html",children:"Toolchain Operator Support Constraint List-ONNX Operator Support List"}),(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Note: the int16 support for operator, you can refer to ",(0,i.jsx)("a",{href:"../../../appendix/supported_op_list/onnx_operator_support_list.html",children:"Toolchain Operator Support Constraint List-ONNX Operator Support List"}),".",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:[(0,i.jsx)("li",{children:"When the value is specified as set_model_output_int8, set the model to output in int8 format with low accuracy."}),(0,i.jsx)("li",{children:"When the value is specified as set_model_output_int16, set the model to output in int16 format with low accuracy."}),(0,i.jsxs)("li",{children:["When the value is specified as "," set_{NodeKind}_input_int16 ",", specify that a certain type of operator input to the model is quantized to int16, and if a situation arises where int16 is not supported due to the node context, the int8 computation will be rolled back and the log will be printed."]}),(0,i.jsxs)("li",{children:["When the value is specified as "," set_{NodeKind}_output_int16 ",", specify that a certain type of operator output to the model is quantized to int16, and if a situation arises where int16 is not supported due to the node context, the int8 computation will be rolled back and the log will be printed."]}),(0,i.jsx)("li",{children:"When the value is specified as set_Softmax_input_int8/set_Softmax_output_int8, since the current softmax defaults to float to compute non-quantized nodes. These two specified values will quantize the softmax operator to int8 and compute it on the BPU. There is no difference in usage between the two."}),(0,i.jsxs)("li",{children:["When the value is specified as asymmetric, the asymmetric quantization will be tried to be turned on, which can improve the quantization accuracy of some models.",(0,i.jsx)("br",{}),(0,i.jsx)("b",{children:"When calibration_type is configured as default, this parameter will be automatically selected by the algorithm and cannot be explicitly configured at this time."})]}),(0,i.jsx)("li",{children:"When the value is specified as bias_correction, the BiasCorrection quantization method will be used, which can improve the quantization accuracy of some models."}),(0,i.jsxs)("li",{children:["When the value is specified as lstm_batch_last, for J6 BPU, for LSTM when the batch-input size is large, the batch dimension can be converted to W dimension for computation (to guarantee the equivalence), which is more in line with the hardware computation logic, and some scenarios can realize the effect of accelerating the inference performance of J6 BPU.",(0,i.jsx)("br",{}),(0,i.jsx)("b",{children:"Since the model deployment inference performance is related to multiple hierarchical levels of optimization, there is no guarantee that this method will achieve performance acceleration."})]})]})]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"quant_config"})}),(0,i.jsxs)("td",{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": The J6 platform supports the configuration of multiple computation types for a single operator. This parameter supports you configuring the computation type of the operator and configuring the computational accuracy of the operator in the model at different levels to generate the desired mixed-accuracy model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Path of json file.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter supports the configuration of computation accuracy from multiple levels(",(0,i.jsx)("code",{children:"model_config"}),", ",(0,i.jsx)("code",{children:"op_config"}),", ",(0,i.jsx)("code",{children:"node_config"}),"), and supports the configuration of multiple computation accuracy data types(",(0,i.jsx)("code",{children:"int8/int16/float16"}),"), please refer to the quant_config additional description below for detailed description."]}),(0,i.jsx)("td",{children:"optional"})]})]})]}),"\n",(0,i.jsx)(n.p,{children:(0,i.jsx)(n.strong,{children:"quant_config additional description"})}),"\n",(0,i.jsxs)(n.ol,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"The quant_config supports multiple levels of configuration of computation accuracy:"}),"\n",(0,i.jsxs)(n.p,{children:["It supports configuring the computation accuracy from ",(0,i.jsx)(n.code,{children:"model_config"}),", ",(0,i.jsx)(n.code,{children:"op_config"}),", and ",(0,i.jsx)(n.code,{children:"node_config"})," levels.\nThere is a priority relationship between the three levels, the smaller the configuration granularity, the higher the priority, i.e., priority model_config<op_config<node_config.\nWhen a node is configured by more than one level at the same time, the level with the highest priority takes effect in the end.\nFor example, if you configure all the ",(0,i.jsx)(n.code,{children:"Add"})," type nodes in op_config for int16 computation, and configure the ",(0,i.jsx)(n.code,{children:"Add_2"})," in node_config for int8 computation,\nthen ultimately, the ",(0,i.jsx)(n.code,{children:"Add_2"})," node is int8 computation, and the rest of the ",(0,i.jsx)(n.code,{children:"Add"})," operators are int16 computation."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"The quant_config supports multiple configurations of computation accuracy data types:"}),"\n",(0,i.jsxs)(n.p,{children:["It supports the configuration of ",(0,i.jsx)(n.code,{children:"int8/int16/float16"})," three kinds of computation accuracy data types, about these three kinds of data types are described as follows:"]}),"\n",(0,i.jsxs)(n.ul,{children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"int8: The default quantization type for most operators, which generally does not need to be actively configured by you."}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsxs)(n.p,{children:["int16: You can refer to the section ",(0,i.jsx)(n.a,{href:"#int16_config",children:"int16 Configuration"}),"."]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"float16: When configured as the float16 type, the tool will internally only configure this operator as the float16 computation accuracy type (there will be no computation broadcast updates to the float16 computation operator context operators)."}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Description of the parameters for each level of the quant_config json file:"}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"19%"}}),(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"17%"}}),(0,i.jsx)("col",{style:{width:"30%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Primary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Secondary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Tertiary Parameter"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Required or Not"})}),(0,i.jsx)("td",{children:(0,i.jsx)(n.strong,{children:"Description"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{rowSpan:"2",children:"model_config"}),(0,i.jsx)("td",{children:"all_node_type"}),(0,i.jsx)("td",{children:"None"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Set the inputs of all nodes in the model to the specified type at once, with optional configuration of int16/float16."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"model_output_type"}),(0,i.jsx)("td",{children:"None"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Set the output tensor of the model to the specified type, with optional configuration of int8/int16."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"op_config"}),(0,i.jsx)("td",{children:"NodeKind"}),(0,i.jsx)("td",{children:"type"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the input data type of a node of a certain type, with optional configuration of int8/int16/float16."})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:"node_config"}),(0,i.jsx)("td",{children:"NodeName"}),(0,i.jsx)("td",{children:"type"}),(0,i.jsx)("td",{children:"Optional"}),(0,i.jsx)("td",{children:"Configure the input data type of a node with a specified name, with optional configuration of int8/int16/float16."})]})]})]}),"\n",(0,i.jsxs)(n.ol,{start:"4",children:["\n",(0,i.jsxs)(n.li,{children:["\n",(0,i.jsx)(n.p,{children:"Configuration example of the json template of the quant_config:"}),"\n",(0,i.jsx)(n.p,{children:"The following is an example of a json template configuration of the quant_config with all the configurable options, you can refer to this template for configuration."}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-json",meta:"",children:[(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure model-level parameters"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure input data types for all nodes at once"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"all_node_type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int16/float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the data type of the model output"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_output_type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8/int16"'})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameters of a node type, change the op_name to the node type name, e.g. \u201CConv\u201D, \u201CAdd\u201D, \u201CSoftmax\u201D..."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the type of input data for a certain type of node"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_name1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8/int16/float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"op_name2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8/int16/float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the parameters of a node,, change the node_name to the name of the node, e.g. \u201CConv_0\u201D, \u201CAdd_1\u201D..."})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_config"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"// Configure the input data type of a node"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_name1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8/int16/float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"node_name2"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:'"type"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int8/int16/float16"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    }"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(n.h3,{id:"compile_parameter_group",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#compile_parameter_group",children:"#"}),"Compilation Parameters"]}),"\n",(0,i.jsxs)("table",{children:[(0,i.jsxs)("colgroup",{children:[(0,i.jsx)("col",{style:{width:"12%"}}),(0,i.jsx)("col",{style:{width:"77%"}}),(0,i.jsx)("col",{style:{width:"11%"}})]}),(0,i.jsx)("thead",{children:(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"PARAMETER"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"DESCRIPTION"})}),(0,i.jsx)("td",{children:(0,i.jsx)("b",{children:"Required/Optional"})})]})}),(0,i.jsxs)("tbody",{children:[(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"compile_mode"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies compilation strategies.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'latency'"}),", ",(0,i.jsx)("code",{children:"'bandwidth'"})," and ",(0,i.jsx)("code",{children:"'balance'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'latency'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The ",(0,i.jsx)("code",{children:"latency"})," aims to optimize the latency time of inference.",(0,i.jsx)("br",{}),"The ",(0,i.jsx)("code",{children:"bandwidth"})," aims to optimize the access bandwidth of DDR.",(0,i.jsx)("br",{}),"The ",(0,i.jsx)("code",{children:"balance"})," aims to balance the optimization of ",(0,i.jsx)("code",{children:"latency"})," and ",(0,i.jsx)("code",{children:"bandwidth"}),", to set this option, you need to specify the balance_factor.",(0,i.jsx)("br",{}),"It is recommended to use the ",(0,i.jsx)("code",{children:"latency"})," strategy as long as your models don't severely exceed the expected bandwidth."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"balance_factor"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the balance ratio when the compile_mode is specified as balance.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"0-100"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This parameter is only used when the compile_mode is specified as balance, otherwise the configuration will not take effect. ",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:["\n",(0,i.jsx)("li",{children:"Configuration of 0 means that the bandwidth is optimal, which corresponds to the compile strategy with bandwidth as the compile_mode."}),"\n",(0,i.jsx)("li",{children:"Configuration of 100 means that the performance is optimal, which corresponds to the compile strategy with latency as the compile_mode."})]})]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"core_num"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the number of cores to run model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"1"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"1"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Used to configure the number of cores for the model to run on the Horizon platform."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"optimize_level"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the model optimization levels.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"'O0'"})," , ",(0,i.jsx)("code",{children:"'O1'"}),",",(0,i.jsx)("code",{children:"'O2'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"'O0'"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": Optimization level ranges between ",(0,i.jsx)("code",{children:"O0"})," - ",(0,i.jsx)("code",{children:"O2"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("code",{children:"O0"}),": No optimization, fastest compilation speed and lowest optimization level.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("code",{children:"O1"})," to ",(0,i.jsx)("code",{children:"O2"}),": As the optimization level increases, the compiled model is expected to execute faster, but the compilation time is also expected to be longer."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"input_source"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the input source of dev board hbm models.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": String.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"ddr"})," , ",(0,i.jsx)("code",{children:"pyramid"})," and ",(0,i.jsx)("code",{children:"resizer"})," .",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": None, it will be automatically selected from an optional range based on the value of input_type_rt by default: ",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:["\n",(0,i.jsx)("li",{children:"When input_type_rt is specified as nv12 or gray, input_source is automatically selected as pyramid by default."}),"\n",(0,i.jsx)("li",{children:"When input_type_rt is specified as any other value, input_source is automatically selected as ddr by default."}),"\n",(0,i.jsx)("li",{children:"When this parameter is specified as resizer, input_type_rt only supports specifying as nv12 or gray."})]}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": This is an option for adapting the engineering environment and you are recommended to configure it after all model validations are complete.",(0,i.jsx)("br",{})," The ",(0,i.jsx)("code",{children:"ddr"})," indicates that the data comes from memory. ",(0,i.jsx)("code",{children:"pyramid"})," and ",(0,i.jsx)("code",{children:"resizer"})," indicates the fixed hardware from the processor.",(0,i.jsx)("br",{}),"To configure the ",(0,i.jsx)("code",{children:"resizer"})," source data in engineering environment requires a call to a proprietary interface, for related constraints and descriptions, please refer to the ",(0,i.jsx)("a",{href:"../../../ucp/runtime/bpu_sdk_api/api_interface/model_inference.html#hbdnnroiinferv2",children:"hbDNNRoiInferV2 interface introduction"}),(0,i.jsx)("br",{}),"This parameter is a bit special, e.g., if the model input name is data and the data source is memory (ddr), then this parameter should be configured as ",(0,i.jsx)("code",{children:'{"data": "ddr"}'}),"."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"max_time_per_fc"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter specifies the maximum continuous execution time (by \u03BCs) of model's each function call.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": ",(0,i.jsx)("code",{children:"0 or 1000-4294967295"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": ",(0,i.jsx)("code",{children:"0"}),".",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": The inference of the compiled directive model in the BPU are denoted by 1 or multiple function-calls(the function-call is the atomic unit in BPU execution). The value of 0 means no restriction.",(0,i.jsx)("br",{}),"This parameter is used for specifying the max execution time of each function-call. The model only has a chance to be preempted when the execution of a single function-call is finished.",(0,i.jsx)("br",{}),"Please refer to the ",(0,i.jsx)("a",{href:"../../../ucp/runtime/runtime_dev.html#preemption",children:"Model Preemption Control"})," section.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("span",{style:{color:"red"},children:"Attention"}),": ",(0,i.jsxs)("ul",{className:"list-disc pl-5 my-4 leading-7",children:["\n",(0,i.jsx)("li",{children:"Note that this parameter is only used to implement the model preemption function and can be ignored otherwise."}),"\n",(0,i.jsx)("li",{children:"The model preemption funtion is only supported on the board, not in the simulator."})]})]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"jobs"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter sets the number of processes when compiling the hbm model.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Within the maximum number of cores supported by the machine.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": 16.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": When you compile the hbm model, it is used to set the number of processes.",(0,i.jsx)("br",{}),"It can improve the compilation speed to some extent."]})}),(0,i.jsx)("td",{children:"optional"})]}),(0,i.jsxs)("tr",{children:[(0,i.jsx)("td",{children:(0,i.jsx)("code",{children:"advice"})}),(0,i.jsx)("td",{children:(0,i.jsxs)(n.p,{children:[(0,i.jsx)("b",{children:"PURPOSE"}),": This parameter is used to indicate the predicted increase in elapsed time in microseconds after the model is compiled.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"PARAMETER TYPE"}),": Int.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"RANGE"}),": Natural number.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DEFAULT VALUE"}),": 0.",(0,i.jsx)("br",{}),"\n",(0,i.jsx)("b",{children:"DESCRIPTIONS"}),": During the model compilation process, the toolchain will perform a time consumption analysis internally. In the actual process, the time consumption will be increased when doing operations such as data alignment of operators. After setting this parameter, when the deviation between the actual computation time and the theoretical computation time of a certain OP is larger than the value you specify, the relevant log will be printed, including information about the change in time, the shape and padding ratio before and after data alignment, etc."]})}),(0,i.jsx)("td",{children:"optional"})]})]})]}),"\n","\n",(0,i.jsxs)(n.h2,{id:"param_value",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#param_value",children:"#"}),"param_value Configuration"]}),"\n",(0,i.jsxs)(n.p,{children:["You can specify the parameters like this: ",(0,i.jsx)(n.code,{children:"param_name:  'param_value'"}),", while multiple values can be separated by ",(0,i.jsx)(n.code,{children:"';'"}),": ",(0,i.jsx)(n.code,{children:"param_name:  'param_value1; param_value2; param_value3'"}),"."]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive tip",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Tip"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.p,{children:["To avoid parameter sequence problems, You are strongly suggested to specify the parameters(such as ",(0,i.jsx)(n.code,{children:"input_shape"})," etc.) explicitly when there are multi-input models."]})})]}),"\n",(0,i.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,i.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsx)(n.div,{className:"rspress-directive-content",children:(0,i.jsxs)(n.p,{children:["Please note that, if set ",(0,i.jsx)(n.code,{children:"input_type_rt"})," to ",(0,i.jsx)(n.code,{children:"nv12"})," , an odd number cannot appear in the input size of model."]})})]}),"\n",(0,i.jsxs)(n.h2,{id:"int16_config",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#int16_config",children:"#"}),"int16 Configuration"]}),"\n",(0,i.jsxs)(n.p,{children:["In the process of model conversion, most of the operators in the model are quantized to int8 for computation, and by configuring the ",(0,i.jsx)(n.code,{children:"node_info"})," or the ",(0,i.jsx)(n.code,{children:"quant_config"})," parameter.\nYou can specify in detail the input or the output of an op as int16 calculation (The range of operators supporting the configuration of int16 you can refer to ",(0,i.jsx)(n.a,{href:"/3.0.17/en/guide/appendix/supported_op_list/onnx_operator_support_list.html",children:"Toolchain Operator Support Constraint List-ONNX Operator Support List"}),") The basic principle is as follows:basically as follows."]}),"\n",(0,i.jsx)(n.p,{children:"After you configure an op input/output data type to int16, the model transformation automatically performs an update and check of the op input/output context int16 configuration internally.\nFor example, when configuring op_1 input/output data type as int16, it actually potentially specifies that the previous/next op of op_1 needs to support computation in int16 at the same time. For unsupported scenarios,\nthe model conversion tool will print a log indicating that the int16 configuration combination is temporarily unsupported and fall back to int8 computation."})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,r.ah)(),e.components);return n?(0,i.jsx)(n,Object.assign({},e,{children:(0,i.jsx)(t,e)})):t(e)}n.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fptq%2Fptq_tool%2Fhb_compile%2Fconvert.mdx"]={toc:[{id:"usage",text:"Usage",depth:2},{id:"parameters-introduction",text:"Parameters Introduction",depth:2},{id:"full_yaml",text:"Configuration File Template",depth:2},{id:"config_parameter",text:"Specific Parameter Information",depth:2},{id:"model_parameter_group",text:"Model Parameters",depth:3},{id:"input-information-parameters",text:"Input Information Parameters",depth:3},{id:"calibration-parameters",text:"Calibration Parameters",depth:3},{id:"compile_parameter_group",text:"Compilation Parameters",depth:3},{id:"param_value",text:"param_value Configuration",depth:2},{id:"int16_config",text:"int16 Configuration",depth:2}],title:"Model Quantized Compilation",frontmatter:{}}}}]);