"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["92025"],{37133:function(n,e,s){n.exports=s.p+"static/image/qat.dceb2d76.png"},40234:function(n,e,s){s.r(e);var i=s(85893),o=s(50065),l=s(37133);function r(n){let e=Object.assign({h1:"h1",a:"a",p:"p",code:"code",ul:"ul",li:"li",h2:"h2",h3:"h3",pre:"pre",span:"span",ol:"ol",strong:"strong",h4:"h4",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td",div:"div"},(0,o.ah)(),n.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(e.h1,{id:"quantized-training",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#quantized-training",children:"#"}),"Quantized Training"]}),"\n",(0,i.jsxs)(e.p,{children:["This document only describes the operations needed to perform quantization training in HAT. For the basic principles of quantization and its implementation in the training framework, refer to the documentation of ",(0,i.jsx)(e.code,{children:"horizon_plugin_pytorch"})," ."]}),"\n",(0,i.jsx)(e.p,{children:"In quantized training, the conversion process from a floating-point model to a fixed-point model is as follows:"}),"\n",(0,i.jsx)("img",{src:l,alt:"qat",height:"900",width:"900"}),"\n",(0,i.jsxs)(e.p,{children:["Most of these steps are already integrated in the HAT training pipeline, and the user only needs to pay attention to implementing the ",(0,i.jsx)(e.code,{children:"fuse_model"})," method to complete the model fusion when adding a custom model and the ",(0,i.jsx)(e.code,{children:"set_qconfig"})," method to configure the quantization method. The following points need to be noted when writing the models."]}),"\n",(0,i.jsxs)(e.ul,{children:["\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:["HAT will only call the ",(0,i.jsx)(e.code,{children:"fuse_model"})," method of the outermost module, so the implementation of ",(0,i.jsx)(e.code,{children:"fuse_model"})," is responsible for the fuse of all submodules."]}),"\n"]}),"\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:["Preference should be given to the base modules provided in ",(0,i.jsx)(e.code,{children:"hat.models.base_modules"}),", which has already implemented the ",(0,i.jsx)(e.code,{children:"fuse_model"})," method to reduce the effort and development difficulties."]}),"\n"]}),"\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:["Model registration, all the modules in HAT use the registration mechanism, only when the defined model is registered in the corresponding registration item, can the model be used in the config file as ",(0,i.jsx)(e.code,{children:"dict(type={$class_name}, ...) "}),"."]}),"\n"]}),"\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:["The ",(0,i.jsx)(e.code,{children:"set_qconfig"})," method needs to be implemented in the outermost module. If there is a special layer in a submodule that needs a separate QConfig setting, the ",(0,i.jsx)(e.code,{children:"set_qconfig"})," method needs to be implemented in that submodule as well, details of which can be found in the ",(0,i.jsx)(e.code,{children:"Writing Specifications of set_qconfig and Customization of qconfig"})," sections."]}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(e.p,{children:["In addition, to make the model transferable to a quantized model, some conditions need to be met, as described in the documentation for ",(0,i.jsx)(e.code,{children:"horizon_plugin_pytorch"}),"."]}),"\n",(0,i.jsxs)(e.h2,{id:"introduction-to-quantized-training-process",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#introduction-to-quantized-training-process",children:"#"}),"Introduction to Quantized Training Process"]}),"\n",(0,i.jsxs)(e.h3,{id:"adding-custom-models",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#adding-custom-models",children:"#"}),"Adding Custom Models"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hat"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"registry "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" OBJECT_REGISTRY"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Registering the model using decorators"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"@OBJECT_REGISTRY"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"register_module"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"ExampleNet"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"nn"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"Module"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        ..."})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"x"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        ..."})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fuse_model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# You need to call the fuse_model method of all the submodules"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hasattr"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(self.submodule, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_model"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"submodule"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fuse_model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Descriptions on the fuse interface can be found in the horizon_plugin_pytorch document"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        ..."})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"set_qconfig"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Descriptions on the interface of the specific model quantization configuration can be found in the horizon_plugin_pytorch document"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hat"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"utils "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" qconfig_manager"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# The default QConfig is obtained by using qconfig_manager.get_default_qat_qconfig()"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qconfig "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" qconfig_manager"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"get_default_qat_qconfig"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# For submodules requiring special handling, call the submodule's set_qconfig"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# For set_qconfig of the submodules, you only need to implement the QConfig settings for the special layer"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hasattr"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(self.submodule, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"set_qconfig"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"submodule"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"set_qconfig"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# If a special node does not require any QConfig setting, such as loss, you need to set its QConfig to None"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"loss "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"is"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Not "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"loss"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qconfig "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        ..."})}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"add-the-config-file",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#add-the-config-file",children:"#"}),"Add The Config File"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ckpt_dir "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ..."})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ExampleNet"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"float_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ...,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qat_mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    ckpt_dir, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float-checkpoint-best.pth.tar"'})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ...,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"val_callback "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Validation"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[val_metric_updater, ...],"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"trace_callback "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"SaveTraced"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    save_dir"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"ckpt_dir,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    trace_inputs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"deploy_inputs,"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"ckpt_callback "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Checkpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    save_dir"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"ckpt_dir,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    name_prefix"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"training_step "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"-"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    strict_match"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"max"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"int_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Trainer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"deploy_model,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qat_mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    ckpt_dir, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"qat-checkpoint-best.pth.tar"'})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"QAT2Quantize"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Int_trainer contains no training process"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"################################"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ckpt_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        trace_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(e.h2,{id:"training",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#training",children:"#"}),"Training"]}),"\n",(0,i.jsxs)(e.p,{children:["You only need to simply specify the training phases in order when using the ",(0,i.jsx)(e.code,{children:"tools/train.py"})," script, and the corresponding ",(0,i.jsx)(e.code,{children:"solver"})," will be called automatically according to the training phase to execute the training process."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"train"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"float"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ..."})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"train"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage qat ..."})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"train"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage int_infer ..."})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.ul,{children:["\n",(0,i.jsx)(e.li,{children:"float\uFF1Anormal floating-point training."}),"\n",(0,i.jsx)(e.li,{children:"qat\uFF1AQAT training (Quantized Awareness Training), this stage first initializes a floating-point model, loads the trained floating-point model weights, and then converts this floating-point model into a QAT model for training."}),"\n",(0,i.jsx)(e.li,{children:"int_infer\uFF1AFixed-point transformation prediction, this stage first initializes a floating-point model, converts the floating-point model into a QAT model and loads the trained QAT model weights, and then converts the QAT model into a fixed-point model. The converted fixed-point model cannot be trained and can only perform validation to obtain the final fixed-point model accuracy."}),"\n"]}),"\n",(0,i.jsxs)(e.h2,{id:"resume-training",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#resume-training",children:"#"}),"Resume Training"]}),"\n",(0,i.jsxs)(e.p,{children:["Unexpectedly interrupted training can be resumed by configuring the ",(0,i.jsx)(e.code,{children:"resume_optimizer"})," and ",(0,i.jsx)(e.code,{children:"resume_epoch_or_step"})," fields in ",(0,i.jsx)(e.code,{children:"{stage}_trainer"})," of ",(0,i.jsx)(e.code,{children:"config"}),", or by resuming only the optimizer for fine-tuning. For example:"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"float_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ..."})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ..."})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"your_checkpoint_path"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:",  "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# checkpoint path"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    resume_optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:",      "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# resume optimizer"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    resume_epoch_or_step"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:",  "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# resume epoch and step "})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ...,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Training recovery has three scenarios:"}),"\n",(0,i.jsxs)(e.ol,{children:["\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.strong,{children:"Full Recovery"}),": This scenario is to resume the training that was unexpectedly interrupted, and will restore all the states of the previous checkpoint, including optimizer, LR, epoch, step, and so on. In this scenario, you only need to configure the ",(0,i.jsx)(e.code,{children:"resume_optimizer"})," field."]}),"\n"]}),"\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.strong,{children:"Resume Optimizer for Fine-tuning"}),": This scenario will only restore the state of optimizer and LR, with epoch and step reset to 0 for the fine-tuning of certain tasks. In this scenario, you need to configure both ",(0,i.jsx)(e.code,{children:"resume_optimizer"})," and ",(0,i.jsx)(e.code,{children:"resume_epoch_or_step=False"}),"."]}),"\n"]}),"\n",(0,i.jsxs)(e.li,{children:["\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.strong,{children:"Load Model Parameters Only"}),": This scenario loads only model parameters and does not restore any other state (optimizeizer, epoch, step, or LR). In this scenario, you need to configure ",(0,i.jsx)(e.code,{children:"LoadCheckpoint"})," in ",(0,i.jsx)(e.code,{children:"model_convert_pipeline"}),", ",(0,i.jsx)(e.code,{children:"resume_optimizer=False"}),", and ",(0,i.jsx)(e.code,{children:"resume_epoch_or_step=False"}),"."]}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(e.h2,{id:"qat-mode",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#qat-mode",children:"#"}),"QAT Mode"]}),"\n",(0,i.jsxs)(e.h3,{id:"effects",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#effects",children:"#"}),"Effects"]}),"\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.code,{children:"Qat_mode"})," is used to set whether to perform the quantization training with BN in the QAT phase. With the help of the ",(0,i.jsx)(e.code,{children:"FuseBN"})," interface provided by HAT, it can also control whether to perform the training with BN throughout the whole process or with BN being gradually absorbed midway."]}),"\n",(0,i.jsxs)(e.h3,{id:"optional-definitions",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#optional-definitions",children:"#"}),"Optional Definitions"]}),"\n",(0,i.jsx)(e.p,{children:"The following three settings are available for qat_mode\uFF1A"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"QATMode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"object"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    FuseBN "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    WithBN "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"with_bn"'})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    WithBNReverseFold "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"with_bn_reverse_fold"'})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"principles",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#principles",children:"#"}),"Principles"]}),"\n",(0,i.jsxs)(e.h4,{id:"fuse-bn",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#fuse-bn",children:"#"}),"Fuse BN"]}),"\n",(0,i.jsx)(e.p,{children:(0,i.jsx)(e.strong,{children:"QAT Phase without BN (default quantization training method of HAT)"})}),"\n",(0,i.jsxs)(e.p,{children:["By setting qat_mode to ",(0,i.jsx)(e.code,{children:"fuse_bn"}),", in the op fusion process of the floating-point model, the weight and bias of BN are absorbed into that of Conv, and the original combination of Conv + BN will be left with only Conv, and this absorption process is theoretically error-free."]}),"\n",(0,i.jsxs)(e.h4,{id:"with-bn",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#with-bn",children:"#"}),"With BN"]}),"\n",(0,i.jsx)(e.p,{children:(0,i.jsx)(e.strong,{children:"QAT Phase with BN"})}),"\n",(0,i.jsxs)(e.p,{children:["By setting qat_mode to ",(0,i.jsx)(e.code,{children:"with_bn"}),", when the floating-point model is converted to QAT model, BN is not absorbed into Conv, but exists in the quantized model as a fused quantized op in the QAT phase in the form of ",(0,i.jsx)(e.code,{children:"Conv + BN + Output Quantized Node"}),". Finally, at the end of quantization training, in the step where the model is converted to quantized (also called int infer), the weight and bias of BN will be automatically absorbed into the quantization parameters of Conv, where the quantized op obtained after the absorption remains consistent with the original QAT op calculation result."]}),"\n",(0,i.jsx)(e.p,{children:"In this mode, the user can also choose to absorb the BN into Conv in the middle of QAT. The reason why the forward results of the QAT model before and after user manually absorbing the BN are inconsistent is that after the BN weight is absorbed into the Conv weight, the quantized parameter conv_weight_scale calculated in the previous quantization training is no longer applicable to the current conv_weight and will lead to large errors in the quantization of conv_weight, which requires more quantization training and more adjustments on quantization parameters."}),"\n",(0,i.jsxs)(e.h4,{id:"with-bn-reverse-fold",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#with-bn-reverse-fold",children:"#"}),"With BN Reverse Fold"]}),"\n",(0,i.jsx)(e.p,{children:(0,i.jsx)(e.strong,{children:"QAT Phase with BN"})}),"\n",(0,i.jsxs)(e.p,{children:["The difference between this mode and ",(0,i.jsx)(e.code,{children:"with_bn"})," is that, in this mode, the BN weight is considered when calculating conv_weight_scale in the quantization training phase before the BN is absorbed (calculations are not detailed here), so that after absorbing the BN weight, the conv_weight_scale is still applicable to the new conv_weight."]}),"\n",(0,i.jsx)(e.p,{children:"This mode is intended to provide a lossless way of absorbing BNs step by step: absorbing BNs in the middle of the quantization training, the forward result of the model is theoretically identical before and after the absorption, and the user can gradually absorb all the BNs in the model before the end of quantization training and ensure that the loss will not fluctuate too much after each absorption."}),"\n",(0,i.jsx)(e.p,{children:"In this mode, if there are BNs not absorbed at the end of the quantization training, they will be automatically absorbed when the model is converted from QAT to quantized. In theory, such absorption is lossless."}),"\n",(0,i.jsxs)(e.h3,{id:"usage",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#usage",children:"#"}),"Usage"]}),"\n",(0,i.jsxs)(e.h4,{id:"set-qat_mode",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#set-qat_mode",children:"#"}),"Set qat_mode"]}),"\n",(0,i.jsxs)(e.p,{children:["The user only needs to set ",(0,i.jsx)(e.code,{children:"qat_mode"})," in ",(0,i.jsx)(e.code,{children:"model_convert_pipeline"}),"."]}),"\n",(0,i.jsx)(e.p,{children:"For example:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model_convert_pipeline"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qat_mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"with_bn"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    converters"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            checkpoint_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ckpt_dir, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"qat-checkpoint-best.pth.tar"'})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(e.h4,{id:"view-current-qat_mode",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#view-current-qat_mode",children:"#"}),"View Current qat_mode"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat_mode "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" get_qat_mode"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat_mod "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"get_qat_mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h4,{id:"set-progressive-absorption-bn",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#set-progressive-absorption-bn",children:"#"}),"Set Progressive Absorption BN"]}),"\n",(0,i.jsxs)(e.p,{children:["In both ",(0,i.jsx)(e.code,{children:"with_bn"})," and ",(0,i.jsx)(e.code,{children:"with_bn_reverse_fold"})," modes, you can set ",(0,i.jsx)(e.code,{children:"FuseBN"})," as a callback function to absorb the BN in the specified module at the specified epoch or step."]}),"\n",(0,i.jsx)(e.p,{children:"FuseBN definition:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"FuseBN"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"OnlineModelTrick"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    Args"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        module"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" sub model names to fuse BN"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        step_or_epoch"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" when to fuseBN"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" same length "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" module"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        update_by"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" by step "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"or"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" by epoch"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        inplace"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" fuse BN inplace"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"modules"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" List"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"List"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"str"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]],"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"step_or_epoch"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" List"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"update_by"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"str"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"inplace"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"bool"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    )"})}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Use the FuseBN example in the config file:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hat"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"callbacks "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" FuseBN"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Define the callback function"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# BN in the backbone module is absorbed at the 1000th step"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# BN in the neck module is absorbed at the 1500th step"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"fuse_bn_callback "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"FuseBN"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"   modules"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'backbone'"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], ["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'neck'"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]],"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"   step_or_epoch"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1500"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"   update_by"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'step'"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# Add the callback function to the trainer"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qat_mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    ckpt_dir, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"qat-checkpoint-best.pth.tar"'})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"...,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        callbacks0,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ..., "})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        fuse_bn_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        callbacks99"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ...,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"qat_mode-summary",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#qat_mode-summary",children:"#"}),"Qat_mode Summary"]}),"\n",(0,i.jsxs)(e.table,{children:[(0,i.jsx)(e.thead,{children:(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.th,{children:"QAT Mode"}),(0,i.jsx)(e.th,{children:"BN Absorbed Time"}),(0,i.jsx)(e.th,{children:"BN Absorbing Method"}),(0,i.jsx)(e.th,{children:"Forward Result Changes After Absorption (Theoretically )?"})]})}),(0,i.jsxs)(e.tbody,{children:[(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.td,{children:"fuse_bn"}),(0,i.jsx)(e.td,{children:"Must be in the floating-point model op fusion process"}),(0,i.jsx)(e.td,{children:"Absorbed after executing fuse_module"}),(0,i.jsx)(e.td,{children:"No Changes"})]}),(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.td,{children:"with_bn"}),(0,i.jsx)(e.td,{children:"Can be in the middle of quantized training process"}),(0,i.jsx)(e.td,{children:"By setting a callback function to absorb in the specified epoch or batch"}),(0,i.jsx)(e.td,{children:"Yes"})]}),(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.td,{children:"with_bn"}),(0,i.jsx)(e.td,{children:"Can be in the conversion process of the model from QAT to quantized"}),(0,i.jsx)(e.td,{children:"Auto completes with the model conversion"}),(0,i.jsx)(e.td,{children:"Yes"})]}),(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.td,{children:"with_bn_reverse_fold"}),(0,i.jsx)(e.td,{children:"Can be in the middle of quantized training process"}),(0,i.jsx)(e.td,{children:"By setting a callback function to absorb in the specified epoch or batch"}),(0,i.jsx)(e.td,{children:"Yes"})]}),(0,i.jsxs)(e.tr,{children:[(0,i.jsx)(e.td,{children:"with_bn_reverse_fold"}),(0,i.jsx)(e.td,{children:"Can be in the conversion process of the model from QAT to quantized"}),(0,i.jsx)(e.td,{children:"Auto completes with the model conversion"}),(0,i.jsx)(e.td,{children:"Yes"})]})]})]}),"\n",(0,i.jsxs)(e.p,{children:["In general, a training process starts from the floating-point training, and when the desired accuracy is met, move on to the quantization training, where only ",(0,i.jsx)(e.code,{children:"fuse_bn"})," is used. Only when the floating-point training is skipped, i.e., it starts with the quantization training, the quantized training mode with BN is needed to ensure the model converges."]}),"\n",(0,i.jsxs)(e.div,{className:"rspress-directive info",children:[(0,i.jsx)(e.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(e.div,{className:"rspress-directive-content",children:(0,i.jsx)(e.p,{children:'The reason why we say "theoretically lossless before and after absorption" or "no change" in this document is that because there is a low probability that the results of the two floating-point calculations before and after the absorption will not match at the later decimal places in the actual calculation. The small variation combined with the quantization operation may result in an absolute error in the output scale of some values of Conv after absorbing BN compared to the output of Conv + BN before absorbing.'})})]})]})}function t(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,o.ah)(),n.components);return e?(0,i.jsx)(e,Object.assign({},n,{children:(0,i.jsx)(r,n)})):r(n)}e.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Ftutorials%2Fquantization.mdx"]={toc:[{id:"introduction-to-quantized-training-process",text:"Introduction to Quantized Training Process",depth:2},{id:"adding-custom-models",text:"Adding Custom Models",depth:3},{id:"add-the-config-file",text:"Add The Config File",depth:3},{id:"training",text:"Training",depth:2},{id:"resume-training",text:"Resume Training",depth:2},{id:"qat-mode",text:"QAT Mode",depth:2},{id:"effects",text:"Effects",depth:3},{id:"optional-definitions",text:"Optional Definitions",depth:3},{id:"principles",text:"Principles",depth:3},{id:"fuse-bn",text:"Fuse BN",depth:4},{id:"with-bn",text:"With BN",depth:4},{id:"with-bn-reverse-fold",text:"With BN Reverse Fold",depth:4},{id:"usage",text:"Usage",depth:3},{id:"set-qat_mode",text:"Set qat_mode",depth:4},{id:"view-current-qat_mode",text:"View Current qat_mode",depth:4},{id:"set-progressive-absorption-bn",text:"Set Progressive Absorption BN",depth:4},{id:"qat_mode-summary",text:"Qat_mode Summary",depth:3}],title:"Quantized Training",frontmatter:{}}}}]);