"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["88636"],{45700:function(n,s,e){e.r(s);var i=e(85893),l=e(50065);function r(n){let s=Object.assign({h1:"h1",a:"a",p:"p",code:"code",h2:"h2",pre:"pre",span:"span",h3:"h3",div:"div"},(0,l.ah)(),n.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.h1,{id:"lidarmultitask-model-training",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#lidarmultitask-model-training",children:"#"}),"lidarMultiTask Model Training"]}),"\n",(0,i.jsxs)(s.p,{children:["This tutorial focuses on how to use HAT to train a ",(0,i.jsx)(s.code,{children:"lidarMultiTask"})," model on the lidar point cloud dataset ",(0,i.jsx)(s.code,{children:"nuscenes"})," from scratch, including floating-point, QAT and quantized models."]}),"\n",(0,i.jsxs)(s.h2,{id:"dataset-preparation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#dataset-preparation",children:"#"}),"Dataset Preparation"]}),"\n",(0,i.jsxs)(s.p,{children:["Before starting to train the model, the first step is to prepare the dataset, download the full dataset (v1.0) and nuScenes-lidarseg from ",(0,i.jsx)(s.a,{href:"https://www.nuscenes.org/nuscenes",target:"_blank",rel:"noopener noreferrer",children:"nuscenes dataset"}),"."]}),"\n",(0,i.jsxs)(s.p,{children:["After downloading, unzip and organize the folder structure as follows which can refer to ",(0,i.jsx)(s.a,{href:"https://www.nuscenes.org/nuscenes?tutorial=lidarseg_panoptic",target:"_blank",rel:"noopener noreferrer",children:"nuscenes Tutorials"})]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 data"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u251C\u2500\u2500 nuscenes"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 lidarseg"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 maps"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 samples"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 sweeps"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 v1.0-mini"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 v1.0-trainval"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsx)(s.p,{children:"To improve the speed of training, we did a package of data information files to convert them into lmdb format datasets from nuscenes lidar files.\r\nThe conversion can be successfully achieved by simply running the following script:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/nuscenes_packer.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"data/nuscenes/"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tmp_data/nuscenes/lidar_seg/v1.0-trainval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--version"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"v1.0-trainval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"val"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--only-lidar"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/nuscenes_packer.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"data/nuscenes/"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tmp_data/nuscenes/lidar_seg/v1.0-trainval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--version"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"v1.0-trainval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"train"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--only-lidar"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The above two commands correspond to transforming the training dataset and the validation dataset, respectively.\r\nAfter the packing is completed, the file structure in the data directory should look as follows:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 tmp_data"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u251C\u2500\u2500 nuscenes"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 lidar_seg"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-trainval"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u2502   \u251C\u2500\u2500 train_lmdb       # Newly generated lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u2502   \u251C\u2500\u2500 val_lmdb         # Newly generated lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 meta"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 maps"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-mini"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-trainval"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"train_lmdb"})," and ",(0,i.jsx)(s.code,{children:"val_lmdb"})," are the packaged training and validation datasets, which are also the final datasets read by the network.\r\n",(0,i.jsx)(s.code,{children:"meta"})," contains information for metrics initialization, copying from nuscenes."]}),"\n",(0,i.jsxs)(s.p,{children:["Also, for nuscenes point cloud data training, it is necessary to generate database files for each individual training target in the dataset and store it using a ",(0,i.jsx)(s.code,{children:".bin"})," format file in ",(0,i.jsx)(s.code,{children:"tmp_nuscenes/lidar/nuscenes_gt_database"}),".\r\nThe path can be modified as needed.\r\nAt the same time, a file containing these database information in .pkl format needs to be generated. In addition, we need to collect category information of all samples in train dataset and resample the whole dataset, thus we can generate these information and save them in .pkl format to accelerate training.\r\nThen, create these files by running the following command:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/create_data.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"nuscenes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--root-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./tmp_data/nuscenes/lidar_seg/v1.0-trainval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--extra-tag"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"nuscenes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--out-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tmp_nuscenes/lidar"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"After executing the above command, the following file directory is generated:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 tmp_data"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u251C\u2500\u2500 nuscenes"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 lidar_seg"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-trainval"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u2502   \u251C\u2500\u2500 train_lmdb       # Newly generated lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u2502   \u251C\u2500\u2500 val_lmdb         # Newly generated lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 meta"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 maps"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-mini"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 v1.0-trainval"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u251C\u2500\u2500 tmp_nuscenes"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u251C\u2500\u2500 lidar"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 nuscenes_gt_database           # Newly generated nuscenes_gt_database"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u2502   \u251C\u2500\u2500 xxxxx.bin"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 nuscenes_dbinfos_train.pkl     # Newly generated nuscenes_dbinfos_train.pkl"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"\u2502   \u2502   \u251C\u2500\u2500 nuscenes_infos_train.pkl       # Newly generated nuscenes_infos_train.pkl"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"nuscenes_gt_database"})," and ",(0,i.jsx)(s.code,{children:"nuscenes_dbinfos_train.pkl"})," are the samples that are used for sampling during training, and ",(0,i.jsx)(s.code,{children:"nuscenes_infos_train.pkl"})," can be used to accelerate train dataset initialization."]}),"\n",(0,i.jsxs)(s.h2,{id:"floating-point-model-training",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#floating-point-model-training",children:"#"}),"Floating-point Model Training"]}),"\n",(0,i.jsx)(s.p,{children:"Once the dataset is ready, you can start training the floating-point lidarMultiTask network.\r\nBefore the network training starts, you can test the computation and the number of parameters of the network by using the following command."}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/calops.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"If you simply want to start such a training task, just run the following command:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"float"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Since the HAT algorithm package uses an ingenious registration mechanism, each training task can be started in the form of this train.py plus the config configuration file.\r\nThe train.py is the unified training script has nothing to do with the task.\r\nWhat kind of task we need to train, what kind of dataset to use, and training-related hyperparameter settings are all in the specified config configuration file.\r\nThe config file provides key dicts such as model building and data reading."}),"\n",(0,i.jsxs)(s.h3,{id:"model-building",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-building",children:"#"}),"Model Building"]}),"\n",(0,i.jsxs)(s.p,{children:["The network structure of lidarMultiTask can refer to ",(0,i.jsx)(s.code,{children:"CenterPoint"})," model with modified neck and additional segmentation head.\r\nYou can find details in the config file. We can easily define and modify the model by defining a dict-type variable such as ",(0,i.jsx)(s.code,{children:"model"})," in the config configuration file."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LidarMultiTask"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    feature_map_shape"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"get_feature_map_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(point_cloud_range, voxel_size),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    pre_process"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CenterPointPreProcess"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        pc_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        voxel_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"voxel_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        max_voxels_num"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"max_voxels,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        max_points_in_voxel"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"max_num_points,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        norm_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"51.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"51.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"5.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"51.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"51.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"255.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        norm_dims"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    reader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"PillarFeatureNet"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_input_features"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_filters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:",),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        with_distance"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        pool_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(max_num_points, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        voxel_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"voxel_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        pc_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"norm_cfg,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        quantize"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        use_4dim"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        use_conv"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        hw_reverse"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    scatter"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"PointPillarScatter"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_input_features"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        use_horizon_pillar_scatter"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        quantize"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    backbone"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MixVarGENet"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        net_config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"net_config,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        disable_quanti_input"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        input_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        input_sequence_length"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_classes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"bn_kwargs,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        include_top"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bias"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        output_list"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    neck"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Unet"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        in_strides"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        out_strides"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:",),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stride2channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            {"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"96"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"160"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        out_stride2channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            {"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"160"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            }"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        factor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        group_base"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"bn_kwargs,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    lidar_decoders"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LidarSegDecoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"seg"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            task_weight"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"80.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            task_feat_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            head"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"DepthwiseSeparableFCNHead"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                input_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                in_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                feat_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                num_classes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                dropout_ratio"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                num_convs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                bn_kwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"bn_kwargs,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                int8_output"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            target"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"FCNTarget"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            loss"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CrossEntropyLoss"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                loss_name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"seg"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                reduction"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mean"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ignore_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"=-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                use_sigmoid"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                class_weight"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            decoder"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"FCNDecoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                upsample_output_scale"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                use_bce"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                bg_cls"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"=-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LidarDetDecoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"det"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            task_weight"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            task_feat_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            head"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"DepthwiseSeparableCenterPointHead"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                in_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                tasks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"tasks,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                share_conv_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                share_conv_num"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                common_heads"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"common_heads,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                head_conv_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                init_bias"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"=-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2.19"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                final_kernel"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            target"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CenterPointLidarTarget"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                grid_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                voxel_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"voxel_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                point_cloud_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                tasks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"tasks,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                dense_reg"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                max_objs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"500"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                gaussian_overlap"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                min_radius"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                out_size_factor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                norm_bbox"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                with_velocity"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"with_velocity,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            loss"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CenterPointLoss"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                loss_cls"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"GaussianFocalLoss"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", loss_weight"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                loss_bbox"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"L1Loss"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    reduction"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mean"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    loss_weight"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.25"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                with_velocity"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"with_velocity,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                code_weights"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            decoder"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CenterPointPostProcess"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                tasks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"tasks,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                norm_bbox"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                bbox_coder"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CenterPointBBoxCoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    pc_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range[:"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    post_center_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    max_num"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    score_threshold"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    out_size_factor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    voxel_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"voxel_size[:"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# test_cfg"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                max_pool_nms"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                score_threshold"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                post_center_limit_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"61.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                min_radius"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"12"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.85"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.175"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                out_size_factor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                nms_type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"rotate"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                pre_max_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                post_max_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"83"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                nms_thr"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                box_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"9"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Among them, the ",(0,i.jsx)(s.code,{children:"type"})," under ",(0,i.jsx)(s.code,{children:"model"})," means the name of the defined model, and the remaining variables mean the other components of the model.\r\nThe advantage of defining the model this way is that we can easily replace the structure we want. After starting, the training script calls the ",(0,i.jsx)(s.code,{children:"build_model"})," interface to convert such a model of type dict into a model of type ",(0,i.jsx)(s.code,{children:"torch.nn.Module"}),"."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"build_model"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"cfg"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"default_args"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" cfg "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"is"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"assert"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"type"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" cfg"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"type is need in model"'})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"build_from_cfg"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(cfg, MODELS)"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"data-enhancement",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#data-enhancement",children:"#"}),"Data Enhancement"]}),"\n",(0,i.jsxs)(s.p,{children:["Like the definition of ",(0,i.jsx)(s.code,{children:"model"}),", the data enhancement process is implemented by defining two dicts ",(0,i.jsx)(s.code,{children:"data_loader"})," and ",(0,i.jsx)(s.code,{children:"val_data_loader"})," in the config file, which correspond to the processing of the training and validation sets, respectively.\r\nHere we take ",(0,i.jsx)(s.code,{children:"data_loader"})," as an example:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"train_dataset "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"NuscenesLidarWithSegDataset"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_sweeps"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"9"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data_rootdir, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"train_lmdb"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    info_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(gt_data_root, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"nuscenes_infos_train.pkl"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    load_dim"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    use_dim"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    pad_empty_sweeps"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    remove_close"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    use_valid_flag"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    classes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"det_class_names,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    transforms"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LidarMultiPreprocess"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            class_names"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"det_class_names,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            global_rot_noise"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.3925"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.3925"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            global_scale_noise"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.95"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.05"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            db_sampler"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"db_sampler,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ObjectRangeFilter"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            point_cloud_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"AssignSegLabel"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            bev_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            num_classes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            class_names"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            point_cloud_range"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"point_cloud_range,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            voxel_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"voxel_size[:"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LidarReformat"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", with_gt"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"data_loader "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DataLoader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CBGSDataset"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"train_dataset),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sampler"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DistributedSampler),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_size_per_gpu,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    shuffle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    pin_memory"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    collate_fn"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"hat.data.collates.collate_lidar3d,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Here, the type directly uses the interface torch.utils.data.DataLoader that comes with pytorch, which represents the combination of ",(0,i.jsx)(s.code,{children:"batch_size"})," size samples together.\r\nHere you may only need to pay attention the ",(0,i.jsx)(s.code,{children:"dataset"})," variable, and the ",(0,i.jsx)(s.code,{children:"data_path"})," path is the path we mentioned in the first part of the dataset preparation.\r\n",(0,i.jsx)(s.code,{children:"transforms"})," contains a series of data augmentations.\r\nIn ",(0,i.jsx)(s.code,{children:"val_data_loader"}),", only point cloud reading, segmentation labels generation and data reformat are available.\r\nYou can also implement your desired data augmentation operations by inserting a new dict in ",(0,i.jsx)(s.code,{children:"transforms"}),"."]}),"\n",(0,i.jsxs)(s.h3,{id:"training-strategy",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#training-strategy",children:"#"}),"Training Strategy"]}),"\n",(0,i.jsxs)(s.p,{children:["To train a model with high accuracy, a good training strategy is essential.\r\nFor each training task, the corresponding training strategy is also defined in the config file, which can be seen from the variable ",(0,i.jsx)(s.code,{children:"float_trainer"}),"."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"float_trainer "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_loader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.optim.AdamW,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        betas"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.95"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.99"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        lr"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2e-4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        weight_decay"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.01"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_processor,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"20"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stat_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        loss_show_update,"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CyclicLrUpdater"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            target_ratio"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1e-4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            cyclic_times"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            step_ratio_up"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            step_log_interval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"200"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        grad_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        val_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ckpt_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sync_bn"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    train_metrics"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LossShow"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"float_trainer"})," defines our training approach from the big picture, including the use of distributed_data_parallel_trainer, the number of epochs for model training, and the choice of optimizer.\r\nAt the same time, ",(0,i.jsx)(s.code,{children:"callbacks"})," reflects the small strategies used by the model in the training process and the operations that the user wants to implement,\r\nincluding the transformation method of the learning rate (CyclicLrUpdater), the indicator (Validation), and save (Checkpoint) the operation of the model.\r\nOf course, if you have operations that you want the model to implement during training, you can also add it in this dict way.\r\n",(0,i.jsx)(s.code,{children:"float_trainer"})," is responsible for concatenating the entire training logic, which is also responsible for model pretraining."]}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsx)(s.p,{children:"\nIf you need to reproduce the accuracy, it is best not to modify the training strategy in the config. Otherwise, unexpected training situations may arise."})})]}),"\n",(0,i.jsx)(s.p,{children:"Through the above introduction, you should have a clear understanding of the role of the config file.\r\nThen, through the training script mentioned above, a high-precision pure floating-point model can be trained.\r\nOf course, training a good model is not our ultimate goal, it is just a pre-training for our future training of quantitative models."}),"\n",(0,i.jsxs)(s.h2,{id:"quantitative-model-training",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#quantitative-model-training",children:"#"}),"Quantitative Model Training"]}),"\n",(0,i.jsx)(s.p,{children:"When we have a floating-point model, we can start training the corresponding QAT model.\r\nIn the same way as floating-point training, we can train a QAT model just by running the following script: BTW, it is recommended to add a calibration stage before quantization aware training.\r\nCalibration can provide better initialization parameters for QAT."}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"calibration"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"qat"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["As you can see, our configuration file has not changed, only the type of ",(0,i.jsx)(s.code,{children:"stage"})," has been changed. At this point, the training strategy we use comes from the qat_trainer in the config file."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"qat_trainer "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qat_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qconfig_params"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            activation_qat_qkwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                averaging_constant"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            weight_qat_qkwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                averaging_constant"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", convert_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"convert_mode),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    ckpt_dir, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration-checkpoint-last.pth.tar"'})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_loader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.optim.SGD,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        weight_decay"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        lr"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1e-4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        momentum"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.9"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_processor,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stat_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        loss_show_update,"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CyclicLrUpdater"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            target_ratio"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1e-4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            cyclic_times"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            step_ratio_up"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            step_log_interval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"200"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        grad_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        val_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ckpt_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    train_metrics"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LossShow"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"with-different-model_convert_pipeline-parameters",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#with-different-model_convert_pipeline-parameters",children:"#"}),"With Different model_convert_pipeline Parameters"]}),"\n",(0,i.jsx)(s.p,{children:"By setting model_convert_pipeline when training quantitative models, the corresponding floating-point model can be converted into a quantitative model, as below:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"model_convert_pipeline"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qat_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    converters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2QAT"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", convert_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"convert_mode),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            checkpoint_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ckpt_dir, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"qat-checkpoint-best.pth.tar"'})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"QAT2Quantize"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", convert_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"convert_mode),"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["For the key steps in quantitative training, such as preparing floating-point models, operator replacement, inserting quantization and dequantization nodes, setting quantization parameters, and operator fusion,\r\nplease read the ",(0,i.jsx)(s.a,{href:"/3.0.17/en/guide/plugin/introduce.html",children:"Quantized Awareness Training (QAT)"})," section."]}),"\n",(0,i.jsxs)(s.h3,{id:"with-different-training-strategies",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#with-different-training-strategies",children:"#"}),"With Different Training Strategies"]}),"\n",(0,i.jsxs)(s.p,{children:["As we said before, the quantitative training is actually finetue on the basis of pure floating-point training.\r\nTherefore, when quantized training, our initial learning rate is set to half of the floating-point training, the number of epochs for training is also reduced, and most importantly,\r\nwhen ",(0,i.jsx)(s.code,{children:"model"})," is defined, our ",(0,i.jsx)(s.code,{children:"pretrained"})," needs to be set to the address of the pure floating-point model that has been trained or the calibration model."]}),"\n",(0,i.jsx)(s.p,{children:"After making these simple adjustments, we can start training our quantitative model."}),"\n",(0,i.jsxs)(s.h3,{id:"export-fixedpoint-model",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#export-fixedpoint-model",children:"#"}),"Export FixedPoint Model"]}),"\n",(0,i.jsx)(s.p,{children:"Once you've completed your quantization training, you can start exporting your fixed-point model. You can export it with the following command:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/export_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"model-validation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-validation",children:"#"}),"Model Validation"]}),"\n",(0,i.jsx)(s.p,{children:"After the model is trained, we can also validate the performance of the trained model.\r\nSince we provide two stages of training process, float and qat, we can validate the performance of the model trained in these two stages.\r\nRun the following two commands:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"float"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"qat"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"At the same time, we also provide a performance test of the quantization model, just run the following command, but it should be noted that hbir must be exported first:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int_infer"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The displayed accuracy is the real accuracy of the final int8 model.\r\nOf course, this accuracy should be very close to the accuracy of the qat verification stage."}),"\n",(0,i.jsxs)(s.h3,{id:"simulation-of-on-board-accuracy-validation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#simulation-of-on-board-accuracy-validation",children:"#"}),"Simulation of On-board Accuracy Validation"]}),"\n",(0,i.jsx)(s.p,{children:"In addition to the model validation described above, we offer an accuracy validation method that is identical to the board side, you can refer to the following:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/validation_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"align_bpu"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"model-inference-and-results-visualization",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference-and-results-visualization",children:"#"}),"Model Inference and Results Visualization"]}),"\n",(0,i.jsx)(s.p,{children:"If you want to see the detection effect of the trained model for a lidar point cloud file, we also provide point cloud prediction and visualization scripts in our tools folder, you just need to run the following script."}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/infer_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--model-inputs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"input_points:"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${lidar-pointcloud-path} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--save-path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${save_path}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"model-checking-and-compilation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-checking-and-compilation",children:"#"}),"Model Checking and Compilation"]}),"\n",(0,i.jsxs)(s.p,{children:["After training, the quantized model can be compiled into an ",(0,i.jsx)(s.code,{children:"hbm"})," file that can be run on the board by using the ",(0,i.jsx)(s.code,{children:"compile_perf_hbir"})," tool.\r\nAt the same time, the tool can also estimate the running performance on the BPU.\r\nThe following scripts can be used:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/lidar_multi_task/centerpoint_mixvargnet_multitask_nuscenes.py"})]}),"\n"]})})})]})}function o(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,l.ah)(),n.components);return s?(0,i.jsx)(s,Object.assign({},n,{children:(0,i.jsx)(r,n)})):r(n)}s.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Fexamples%2Flidar_multitask.mdx"]={toc:[{id:"dataset-preparation",text:"Dataset Preparation",depth:2},{id:"floating-point-model-training",text:"Floating-point Model Training",depth:2},{id:"model-building",text:"Model Building",depth:3},{id:"data-enhancement",text:"Data Enhancement",depth:3},{id:"training-strategy",text:"Training Strategy",depth:3},{id:"quantitative-model-training",text:"Quantitative Model Training",depth:2},{id:"with-different-model_convert_pipeline-parameters",text:"With Different model_convert_pipeline Parameters",depth:3},{id:"with-different-training-strategies",text:"With Different Training Strategies",depth:3},{id:"export-fixedpoint-model",text:"Export FixedPoint Model",depth:3},{id:"model-validation",text:"Model Validation",depth:3},{id:"simulation-of-on-board-accuracy-validation",text:"Simulation of On-board Accuracy Validation",depth:3},{id:"model-inference-and-results-visualization",text:"Model Inference and Results Visualization",depth:3},{id:"model-checking-and-compilation",text:"Model Checking and Compilation",depth:3}],title:"lidarMultiTask Model Training",frontmatter:{}}}}]);