"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["86278"],{24159:function(e,n,s){s.r(n);var i=s(85893),r=s(50065);function o(e){let n=Object.assign({h1:"h1",a:"a",p:"p",code:"code",pre:"pre",span:"span",h2:"h2",h3:"h3"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(n.h1,{id:"mobilenetv1-classification-model-training",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#mobilenetv1-classification-model-training",children:"#"}),"MobileNetV1 Classification Model Training"]}),"\n",(0,i.jsxs)(n.p,{children:["This tutorial focuses on how to train a state-of-art floating-point and fixed-point model on ",(0,i.jsx)(n.code,{children:"ImageNet"})," using HAT."]}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.code,{children:"ImageNet"})," is the most often used dataset for image classification, and many state-of-the-art image classification studies are primarily based on this dataset for validation."]}),"\n",(0,i.jsx)(n.p,{children:"Although there are many ways to obtain a state-of-art classification model in the community or through other means, training a state-of-art classification model from scratch is still not a simple task."}),"\n",(0,i.jsxs)(n.p,{children:["Starting from dataset preparation, this tutorial will focus on how to train a state-of-art model on ",(0,i.jsx)(n.code,{children:"ImageNet"}),", including floating-point, quantitative, and fixed-point models."]}),"\n",(0,i.jsxs)(n.p,{children:["The ",(0,i.jsx)(n.code,{children:"ImageNet"})," dataset can be downloaded from ",(0,i.jsx)(n.a,{href:"http://image-net.org/",target:"_blank",rel:"noopener noreferrer",children:"ImageNet official website"}),".\r\nThe downloaded dataset will be in the following formats:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ILSVRC2012_img_train.tar"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ILSVRC2012_img_val.tar"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ILSVRC2012_devkit_t12.tar.gz"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["Here we use ",(0,i.jsx)(n.code,{children:"MobileNetV1"})," as an example to describe the whole classification process in detail."]}),"\n",(0,i.jsxs)(n.h2,{id:"training-process",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#training-process",children:"#"}),"Training Process"]}),"\n",(0,i.jsx)(n.p,{children:"If you just want to use the HAT interface for simple experiments, it is a good idea to read this section first."}),"\n",(0,i.jsxs)(n.p,{children:["HAT uses the ",(0,i.jsx)(n.code,{children:"tools + config"})," format for all the training and evaluation tasks.\r\nAfter preparing the raw dataset, we can easily complete the training process by taking the procedure below."]}),"\n",(0,i.jsxs)(n.h3,{id:"dataset-preparation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#dataset-preparation",children:"#"}),"Dataset Preparation"]}),"\n",(0,i.jsxs)(n.p,{children:["The first thing is dataset packaging. Comparing with raw datasets, packed datasets have obvious advantages in terms of processing speed.\r\nHere we choose the ",(0,i.jsx)(n.code,{children:"LMDB"})," packaging method, which has the same style as ",(0,i.jsx)(n.code,{children:"PyTorch"}),".\r\nThanks to the flexibility of HAT in handling ",(0,i.jsx)(n.code,{children:"datasets"}),", other forms of dataset packing and reading, such as ",(0,i.jsx)(n.code,{children:"MXRecord"}),", are also supported independently."]}),"\n",(0,i.jsxs)(n.p,{children:["Packaging scripts for common datasets such as ",(0,i.jsx)(n.code,{children:"cityscapes"}),", ",(0,i.jsx)(n.code,{children:"imagenet"}),", ",(0,i.jsx)(n.code,{children:"voc"}),", and ",(0,i.jsx)(n.code,{children:"mscoco"})," are provided in the ",(0,i.jsx)(n.code,{children:"tools/datasets"})," directory.\r\nFor example, the ",(0,i.jsx)(n.code,{children:"imagenet_packer"})," script can directly convert the original public ",(0,i.jsx)(n.code,{children:"ImageNet"})," dataset to ",(0,i.jsx)(n.code,{children:"Numpy"})," or ",(0,i.jsx)(n.code,{children:"Tensor"})," format by using the default public dataset processing method provided by ",(0,i.jsx)(n.code,{children:"torchvision"}),", and finally compress the result data into the ",(0,i.jsx)(n.code,{children:"LMDB"})," file using the ",(0,i.jsx)(n.code,{children:"msgpack"})," method."]}),"\n",(0,i.jsx)(n.p,{children:"The dataset packing process can be easily accomplished with the following script:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/imagenet_packer.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${src-data-dir} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${target-data-dir} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"train"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--num-workers"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/imagenet_packer.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${src-data-dir} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${target-data-dir} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"val"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--num-workers"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["After the dataset is packed, you can get the ",(0,i.jsx)(n.code,{children:"LMDB"})," dataset containing ",(0,i.jsx)(n.code,{children:"ImageNet"})," and move on to the next stage - training."]}),"\n",(0,i.jsxs)(n.h3,{id:"model-training",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-training",children:"#"}),"Model Training"]}),"\n",(0,i.jsx)(n.p,{children:"Once you have prepared the packed dataset, you can start training the model simply by running the following command:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["The HAT algorithm toolkit uses a registration mechanism that allows each training task to be started in the form of ",(0,i.jsx)(n.code,{children:"train.py"})," plus a ",(0,i.jsx)(n.code,{children:"config"})," file."]}),"\n",(0,i.jsxs)(n.p,{children:[(0,i.jsx)(n.code,{children:"train.py"})," is a uniform training script and independent of the task.\r\nThe task we need to train, the dataset we need to use, and the hyperparameters we need to set for the training are all in the specified ",(0,i.jsx)(n.code,{children:"config"})," file."]}),"\n",(0,i.jsxs)(n.p,{children:["The parameters after ",(0,i.jsx)(n.code,{children:"--stage"})," in the above command can be ",(0,i.jsx)(n.code,{children:'"float"'})," and ",(0,i.jsx)(n.code,{children:'"calibration"'}),", which, respectively, indicates the training of the\r\nfloating-point model and the quantitative model, where the training of the quantitative model depends on the floating-point model produced by the previous floating-point training.\r\nThe details are described in the preceding section about quantization."]}),"\n",(0,i.jsxs)(n.h3,{id:"exporting-fixed-point-model",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#exporting-fixed-point-model",children:"#"}),"Exporting Fixed-point Model"]}),"\n",(0,i.jsx)(n.p,{children:"After completing quantization training, you can proceed to export the fixed-point model.\r\nYou can use the following command to perform the export:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/export_hbir.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"model-validation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-validation",children:"#"}),"Model Validation"]}),"\n",(0,i.jsxs)(n.p,{children:["After completing the training, we get the trained floating-point, quantitative, or fixed-point model.\r\nSimilar to the training method, we can use the same method to complete metrics validation on the trained model and get the metrics of ",(0,i.jsx)(n.code,{children:"Float"}),", ",(0,i.jsx)(n.code,{children:"Calibration"}),", and ",(0,i.jsx)(n.code,{children:"Quantized"}),",\r\nwhich are floating-point, quantitative, and fully fixed-point metrics, respectively, as described in Quantization details."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--ckpt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${float-checkpoint-path} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--ckpt"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${calibration-checkpoint-path} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["Similar to the model training, we can use ",(0,i.jsx)(n.code,{children:"--stage"})," followed by ",(0,i.jsx)(n.code,{children:'"float"'}),", ",(0,i.jsx)(n.code,{children:'"calibration"'}),", to validate the trained floating-point model and quantitative model respectively."]}),"\n",(0,i.jsx)(n.p,{children:"The following command can be used to verify the accuracy of a fixed-point model, but it should be noted that hbir must be exported first:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int_infer"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"model-inference",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference",children:"#"}),"Model Inference"]}),"\n",(0,i.jsxs)(n.p,{children:["HAT provides the ",(0,i.jsx)(n.code,{children:"infer_hbir.py"})," script to visualize the inference results of the models trained at each phase:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/infer_hbir.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--model-inputs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"imgs:"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"${img-path} "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--save-path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" ${save_path}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"simulation-on-board-accuracy-validation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#simulation-on-board-accuracy-validation",children:"#"}),"Simulation On-board Accuracy Validation"]}),"\n",(0,i.jsx)(n.p,{children:"In addition to the above model validation, we provide an accuracy validation method identical to the on-board environment, which can be accomplished by:"}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/validation_hbir.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"align_bpu"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"fixed-point-model-compilation",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#fixed-point-model-compilation",children:"#"}),"Fixed-point Model Compilation"]}),"\n",(0,i.jsxs)(n.p,{children:["After the model is trained, you can use the ",(0,i.jsx)(n.code,{children:"compile_perf_hbir"})," script to compile the quantitative model into a ",(0,i.jsx)(n.code,{children:"hbm"})," file that supports on-board running.\r\nThis tool can also predict the model performance on the ",(0,i.jsx)(n.code,{children:"BPU"}),"."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf_hbir.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["For Horizon BPUs with different architectures, you can set ",(0,i.jsx)(n.code,{children:"march = March.NASH_E"})," or ",(0,i.jsx)(n.code,{children:"march = March.NASH_M"})," in ",(0,i.jsx)(n.code,{children:"configs/classification/mobilenetv1_imagenet.py"}),"."]}),"\n",(0,i.jsx)(n.p,{children:"The above is the whole process from data preparation to the generation of quantitative and deployable models."}),"\n",(0,i.jsxs)(n.h3,{id:"training-details",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#training-details",children:"#"}),"Training Details"]}),"\n",(0,i.jsxs)(n.p,{children:["We still use ",(0,i.jsx)(n.code,{children:"MobileNetV1"})," as an example to illustrate some things that need to be taken into account for model training, which mainly includes settings related to ",(0,i.jsx)(n.code,{children:"config"}),"."]}),"\n",(0,i.jsxs)(n.h3,{id:"training-conditions",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#training-conditions",children:"#"}),"Training Conditions"]}),"\n",(0,i.jsxs)(n.p,{children:["Training a deep learning model on ",(0,i.jsx)(n.code,{children:"ImageNet"})," with more than 1 million images is very resource intensive, and the main bottlenecks are matrix computation and data reading."]}),"\n",(0,i.jsx)(n.p,{children:"For matrix computation, it is highly recommended to use a high-performance GPU instead of CPU for the training, and using multiple GPUs at the same time can effectively reduce the training time."}),"\n",(0,i.jsxs)(n.p,{children:["For data reading, it is recommended to use a better CPU and SSD storage.\r\nMulti-threaded CPU acceleration and better SSD storage can help a lot in data reading.\r\nNote that the whole ",(0,i.jsx)(n.code,{children:"ImageNet"})," will roughly take up 300G of storage, so the SSD storage should have at least 300G of storage space."]}),"\n",(0,i.jsxs)(n.h3,{id:"network-structure",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#network-structure",children:"#"}),"Network Structure"]}),"\n",(0,i.jsxs)(n.p,{children:["As you can find many implementations of ",(0,i.jsx)(n.code,{children:"MobileNetV1"})," in both HAT and other communities, here we skip the specific implementation methods of ",(0,i.jsx)(n.code,{children:"MobileNetV1"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["In the ",(0,i.jsx)(n.code,{children:"config"})," of HAT, we can build a floating-point ",(0,i.jsx)(n.code,{children:"MobileNetV1"})," classification model directly with the dict below.\r\nUsers can modify the model by directly modifying the configuration parameters in ",(0,i.jsx)(n.code,{children:"backbone"}),"."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Classifier"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     backbone"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MobileNetV1"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         num_classes"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1000"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         bn_kwargs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{},"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     ),"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     losses"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CEWithLabelSmooth"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["In addition to ",(0,i.jsx)(n.code,{children:"backbone"}),", the model also has a ",(0,i.jsx)(n.code,{children:"losses"})," module."]}),"\n",(0,i.jsxs)(n.p,{children:["In common classification models, we often use ",(0,i.jsx)(n.code,{children:"Cross-Entropy"})," as the training loss,\r\nbut more and more experiments prove that adding ",(0,i.jsx)(n.code,{children:"Label-Smooth"})," to the classification loss can help to improve the training results,\r\nespecially when combined with ",(0,i.jsx)(n.code,{children:"Cosine"}),"'s lr update method."]}),"\n",(0,i.jsxs)(n.p,{children:["After defining a model, especially for some public models, we usually have the need to check the FLOPs. HAT calculates the operations of the model by using the ",(0,i.jsx)(n.code,{children:"calops"})," tool, which is implemented as below:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"tools/calops.py"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string)"},children:"configs/classification/mobilenetv1_imagenet.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(n.p,{children:"Such ops-counting tool can support both floating-point and fixed-point models."}),"\n",(0,i.jsxs)(n.h3,{id:"data-enhancement",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#data-enhancement",children:"#"}),"Data Enhancement"]}),"\n",(0,i.jsxs)(n.p,{children:["There is an emerging consensus on the data enhancement for ",(0,i.jsx)(n.code,{children:"ImageNet"})," training, and we use the data enhancement provided by ",(0,i.jsx)(n.code,{children:"torchvision"})," as the basis to build the data enhancement for classification training,\r\nincluding ",(0,i.jsx)(n.code,{children:"RandomResizedCrop"}),", ",(0,i.jsx)(n.code,{children:"RandomHorizontalFlip"}),", and ",(0,i.jsx)(n.code,{children:"ColorJitter"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["Since the final model running on the ",(0,i.jsx)(n.code,{children:"BPU"})," uses ",(0,i.jsx)(n.code,{children:"YUV444"})," as image input, while training image input is generally in the ",(0,i.jsx)(n.code,{children:"RGB"})," format, HAT provides ",(0,i.jsx)(n.code,{children:"BgrToYuv444"})," data enhancement to convert ",(0,i.jsx)(n.code,{children:"RGB"})," to ",(0,i.jsx)(n.code,{children:"YUV444"}),"."]}),"\n",(0,i.jsxs)(n.p,{children:["To optimize the training process, some enhancement can be processed in ",(0,i.jsx)(n.code,{children:"batch_processor"})," to optimize the training."]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"dataset"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ImageNetFromLMDB"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./tmp_data/imagenet/train_lmdb/"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    transforms"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.RandomResizedCrop,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            size"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            scale"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.08"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ratio"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:". "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"., "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:". "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:".),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_samples"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"1281167"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["The corresponding ",(0,i.jsx)(n.code,{children:"batch_processor"})," part:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"batch_processor "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'BasicBatchProcessor'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    need_grad_update"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_transforms"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.RandomHorizontalFlip),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.ColorJitter,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            brightness"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            contrast"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            saturation"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            hue"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"BgrToYuv444"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", rgb_input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.Normalize, mean"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", std"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.p,{children:["The data conversion of the validation set is relatively simpler, and the main difference is the short edge ",(0,i.jsx)(n.code,{children:"Resize"})," to 256 and ",(0,i.jsx)(n.code,{children:"CenterCrop"}),"."]}),"\n",(0,i.jsx)(n.p,{children:"The other color space transformations are the same as the training set."}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"dataset"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ImageNetFromLMDB"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_path"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"./tmp_data/imagenet/val_lmdb/"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    transforms"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.Resize, size"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.CenterCrop, size"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_samples"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"50000"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number"}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"val_batch_processor "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'BasicBatchProcessor'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    need_grad_update"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_transforms"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"BgrToYuv444"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", rgb_input"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torchvision.transforms.Normalize, mean"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", std"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"training-strategies",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#training-strategies",children:"#"}),"Training Strategies"]}),"\n",(0,i.jsxs)(n.p,{children:["The training strategies for training different classification models on ",(0,i.jsx)(n.code,{children:"ImageNet"})," are roughly the same with minor differences."]}),"\n",(0,i.jsx)(n.p,{children:"Here we focus on the details that have improved effects."}),"\n",(0,i.jsxs)(n.p,{children:["The learning strategy of ",(0,i.jsx)(n.code,{children:"Cosine"})," with ",(0,i.jsx)(n.code,{children:"Warmup"})," has some boosting effect compared with the regular ",(0,i.jsx)(n.code,{children:"StepLr"}),".\r\nAppropriately extending the epoch training length also has a boost for small models."]}),"\n",(0,i.jsxs)(n.p,{children:["In addition, applying L2 norm only to the parameters of ",(0,i.jsx)(n.code,{children:"weight"})," is also a recommended training strategy.\r\nThe ",(0,i.jsx)(n.code,{children:"float_trainer"}),", ",(0,i.jsx)(n.code,{children:"calibration_trainer"}),", and ",(0,i.jsx)(n.code,{children:"int_trainer"})," in the ",(0,i.jsx)(n.code,{children:"configs/classification/mobilenetv1_imagenet.py"})," file correspond to the training strategies for floating-point, quantitative, and fixed-point models, respectively."]}),"\n",(0,i.jsxs)(n.p,{children:["Next we use ",(0,i.jsx)(n.code,{children:"float_trainer"})," as an example of training strategy:"]}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"float_trainer "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'distributed_data_parallel_trainer'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     data_loader"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_loader,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     optimizer"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.optim.SGD,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         params"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"weight"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(weight_decay"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"4e-5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")},"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         lr"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.4"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         momentum"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.9"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     ),"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     batch_processor"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_processor,"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     num_epochs"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"240"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     device"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     callbacks"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         stat_callback,"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"             type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CosLrUpdater"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"             warmup_by"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'epoch'"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"             warmup_len"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         ),"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         metric_updater,"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         val_callback,"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"         ckpt_callback,"})}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     ],"})}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     train_metrics"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[ "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Accuracy"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"TopKAccuracy"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", top_k"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")],"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"     val_metrics"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"[ "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Accuracy"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"), "}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"TopKAccuracy"'}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:", top_k"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")],"})]}),"\n",(0,i.jsx)(n.span,{className:"line line-number",children:(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(n.h3,{id:"quantitative-training",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#quantitative-training",children:"#"}),"Quantitative Training"]}),"\n",(0,i.jsxs)(n.p,{children:["For key stages in quantitative training, e.g., preparing the floating-point model, operator substitution, inserting quantization and inverse quantitative nodes, setting quantitative parameters, and operator fusion, etc.,\r\nplease read the ",(0,i.jsx)(n.a,{href:"/3.0.17/en/guide/plugin/introduce.html",children:"Quantized Awareness Training (QAT)"})," section."]}),"\n",(0,i.jsx)(n.p,{children:"Here we focus on how to define and use quantitative models in the HAT classification."}),"\n",(0,i.jsx)(n.p,{children:"When the model is ready and some existing modules are quantized, HAT uses the following scripts in the training script to map the floating-point model to the fixed-point model."}),"\n",(0,i.jsx)(n.pre,{className:"code",children:(0,i.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"set_qconfig"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(n.span,{className:"line line-number",children:[(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"horizon"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quantization"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare_qat_fx"}),(0,i.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model)"})]}),"\n"]})})}),"\n",(0,i.jsx)(n.p,{children:"As the strategies for quantitative training are not necessarily the same, here we briefly introduce some common strategies used in training classification models."}),"\n",(0,i.jsx)(n.p,{children:"The overall strategy of quantitative training can directly follow the strategy of floating-point training, but the learning rate and training length need to be adjusted appropriately."}),"\n",(0,i.jsxs)(n.p,{children:["Because there is a floating-point pre-training model, the learning rate ",(0,i.jsx)(n.code,{children:"Lr"})," of quantitative training can be rather small, usually starting from 0.001 or 0.0001,\r\nand can perform ",(0,i.jsx)(n.code,{children:"Lr"})," adjustments of ",(0,i.jsx)(n.code,{children:"scale=0.1"})," for 1 or 2 times with ",(0,i.jsx)(n.code,{children:"StepLrUpdater"}),"; meanwhile, the training length does not need to be long."]}),"\n",(0,i.jsxs)(n.p,{children:["In addition, ",(0,i.jsx)(n.code,{children:"weight decay"})," will also have some influence on the training results."]}),"\n",(0,i.jsxs)(n.h2,{id:"pre-trained-models",children:[(0,i.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#pre-trained-models",children:"#"}),"Pre-trained Models"]}),"\n",(0,i.jsxs)(n.p,{children:["HAT already provides a rich set of pre-trained models on ",(0,i.jsx)(n.code,{children:"ImageNet"}),", you can refer to ",(0,i.jsx)(n.code,{children:"modelzoo"}),". All models are included in the release package."]})]})}function t(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,r.ah)(),e.components);return n?(0,i.jsx)(n,Object.assign({},e,{children:(0,i.jsx)(o,e)})):o(e)}n.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Fexamples%2Fclassification.mdx"]={toc:[{id:"training-process",text:"Training Process",depth:2},{id:"dataset-preparation",text:"Dataset Preparation",depth:3},{id:"model-training",text:"Model Training",depth:3},{id:"exporting-fixed-point-model",text:"Exporting Fixed-point Model",depth:3},{id:"model-validation",text:"Model Validation",depth:3},{id:"model-inference",text:"Model Inference",depth:3},{id:"simulation-on-board-accuracy-validation",text:"Simulation On-board Accuracy Validation",depth:3},{id:"fixed-point-model-compilation",text:"Fixed-point Model Compilation",depth:3},{id:"training-details",text:"Training Details",depth:3},{id:"training-conditions",text:"Training Conditions",depth:3},{id:"network-structure",text:"Network Structure",depth:3},{id:"data-enhancement",text:"Data Enhancement",depth:3},{id:"training-strategies",text:"Training Strategies",depth:3},{id:"quantitative-training",text:"Quantitative Training",depth:3},{id:"pre-trained-models",text:"Pre-trained Models",depth:2}],title:"MobileNetV1 Classification Model Training",frontmatter:{}}}}]);