"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["69091"],{22575:function(s,e,r){s.exports=r.p+"static/image/HPL5FFT2D_input.08ffeb80.png"},67640:function(s,e,r){s.exports=r.p+"static/image/HPL5FFT2D_output.aba6462e.png"},75088:function(s){s.exports="data:image/png;base64,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"},30502:function(s,e,r){s.exports=r.p+"static/image/HPL5IFFT2D_y.22a8ed56.png"},84230:function(s,e,r){r.r(e);var n=r(85893),l=r(50065),i=r(67640),o=r(22575),a=r(30502),t=r(75088);function c(s){let e=Object.assign({h1:"h1",a:"a",p:"p",h2:"h2",table:"table",thead:"thead",tr:"tr",th:"th",strong:"strong",tbody:"tbody",td:"td",img:"img",ol:"ol",li:"li",pre:"pre",code:"code",span:"span"},(0,l.ah)(),s.components);return(0,n.jsxs)(n.Fragment,{children:[(0,n.jsxs)(e.h1,{id:"inverse-fast-fourier-transform-2d",children:[(0,n.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#inverse-fast-fourier-transform-2d",children:"#"}),"Inverse Fast Fourier Transform 2D"]}),"\n",(0,n.jsx)(e.p,{children:"The Inverse Fast Fourier Transform 2D (hereinafter referred to as IFFT2D) is a fast algorithm derived from the Inverse Fast Fourier Transform (hereinafter referred to as IFFT).\nIt efficiently converts two-dimensional data from the frequency domain to the time domain,\ncommonly employed for the restoration of images and other two-dimensional frequency domain data to their original time domain representation."}),"\n",(0,n.jsxs)(e.h2,{id:"operator-effect",children:[(0,n.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#operator-effect",children:"#"}),"Operator Effect"]}),"\n",(0,n.jsxs)(e.table,{children:[(0,n.jsx)(e.thead,{children:(0,n.jsxs)(e.tr,{children:[(0,n.jsx)(e.th,{align:"center",children:(0,n.jsx)(e.strong,{children:"Time Domain Input Data"})}),(0,n.jsx)(e.th,{align:"center",children:(0,n.jsx)(e.strong,{children:"Parameter"})}),(0,n.jsx)(e.th,{align:"center",children:(0,n.jsx)(e.strong,{children:"Frequency Domain Output Data"})})]})}),(0,n.jsx)(e.tbody,{children:(0,n.jsxs)(e.tr,{children:[(0,n.jsx)(e.td,{align:"center",children:(0,n.jsx)(e.img,{alt:"image",src:i})}),(0,n.jsxs)(e.td,{align:"center",children:["p_size = HB_HPL_FFT16 ",(0,n.jsx)("br",{})," normalize = 0 ",(0,n.jsx)("br",{})," dataType = HB_HPL_DATA_TYPE_I16 ",(0,n.jsx)("br",{})," imFormat = HB_IM_FORMAT_SEPARATE ",(0,n.jsx)("br",{})," numDimensionSize = 2"]}),(0,n.jsx)(e.td,{align:"center",children:(0,n.jsx)(e.img,{alt:"image",src:o})})]})})]}),"\n",(0,n.jsxs)(e.h2,{id:"ifft_2d_principle",children:[(0,n.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#ifft_2d_principle",children:"#"}),"Principle"]}),"\n",(0,n.jsx)(e.p,{children:"IFFT2D is an extension of the IFFT algorithm, designed to map frequency domain data to time domain data.\nIt operates on two-dimensional data by performing IFFT operations separately along the y and x directions. The specific procedure is outlined as follows:"}),"\n",(0,n.jsxs)(e.ol,{children:["\n",(0,n.jsxs)(e.li,{children:["Perform IFFT calculation on each column of the two-dimensional data, where ",(0,n.jsx)(e.strong,{children:"ny"})," represents the number of FFT points set in the interface parameters for the y-axis."]}),"\n"]}),"\n",(0,n.jsx)("img",{src:a,alt:"HPL5IFFT2D_y",height:"500",width:"500"}),"\n",(0,n.jsxs)(e.ol,{start:"2",children:["\n",(0,n.jsxs)(e.li,{children:["Building upon the processing in step 1, perform IFFT calculation on each row of the two-dimensional data, where ",(0,n.jsx)(e.strong,{children:"nx"})," represents the number of FFT points set in the interface parameters for the x-axis."]}),"\n"]}),"\n",(0,n.jsx)("img",{src:t,alt:"HPL5IFFT2D_x",height:"500",width:"500"}),"\n",(0,n.jsxs)(e.ol,{start:"3",children:["\n",(0,n.jsx)(e.li,{children:"Return the calculation results from step 2."}),"\n"]}),"\n",(0,n.jsxs)(e.h2,{id:"api-interface",children:[(0,n.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#api-interface",children:"#"}),"API Interface"]}),"\n",(0,n.jsx)(e.pre,{className:"code",children:(0,n.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,n.jsxs)(e.code,{className:"language-c",meta:"",children:[(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"int32_t"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbIFFT2D"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"hbUCPTaskHandle_t"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"taskHandle"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hbHPLImaginaryData "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                 hbHPLImaginaryData "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" hbIFFT2DParam "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"const"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"param);"})]}),"\n"]})})}),"\n",(0,n.jsxs)(e.p,{children:["For detailed interface information, please refer to ",(0,n.jsx)(e.a,{href:"/3.0.17/en/guide/ucp/hpl/hpl7_api/hpl_api_function_interface/hbifft2d.html",children:"hbIFFT2D"}),"\u3002"]}),"\n",(0,n.jsxs)(e.h2,{id:"usage",children:[(0,n.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#usage",children:"#"}),"Usage"]}),"\n",(0,n.jsx)(e.pre,{className:"code",children:(0,n.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,n.jsxs)(e.code,{className:"language-c",meta:"",children:[(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// Include the header"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hb_ucp.h"'})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hpl/hb_hpl.h"'})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"#include"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"hobot/hpl/hb_ifft_2d.h"'})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// init, allocate memory for data"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src_length "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1024"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"5"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src_re_mem"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_length"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src_im_mem"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_length"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbHPLImaginaryData src;"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.realDataVirAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_re_mem.virAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.realDataPhyAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_re_mem.phyAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.imDataVirAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_im_mem.virAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.imDataPhyAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_im_mem.phyAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.numDimensionSize "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.dataType "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_HPL_DATA_TYPE_I16;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.imFormat "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_IM_FORMAT_SEPARATE;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.dimensionSize["}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"] "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"11"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src.dimensionSize["}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"] "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst_re_mem"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_length"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPMallocCached"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst_im_mem"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" src_length"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbHPLImaginaryData dst;"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.realDataVirAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dst_re_mem.virAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.realDataPhyAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dst_re_mem.phyAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.imDataVirAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dst_im_mem.virAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.imDataPhyAddr "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" dst_im_mem.phyAddr;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.numDimensionSize "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.dataType "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_HPL_DATA_TYPE_I16;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.imFormat "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_IM_FORMAT_SEPARATE;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.dimensionSize["}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"] "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"11"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst.dimensionSize["}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"] "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// init param"})}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbIFFT2DParam param;"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"param.nx "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_FFT_POINT_SIZE_16;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"param.ny "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" HB_FFT_POINT_SIZE_32;"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"param.normalize "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:";"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// init task handle and schedule param"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"hbUCPTaskHandle_t"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" task_handle{nullptr};"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"hbUCPSchedParam sched_param{...};"})}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// create task"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbIFFT2D"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"task_handle"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"param);"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// submit task"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPSubmitTask"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"sched_param);"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// wait for task done "})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPWaitTaskDone"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:");"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// release task handle"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPReleaseTask"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"(task_handle);"})]}),"\n",(0,n.jsx)(e.span,{className:"line line-number"}),"\n",(0,n.jsx)(e.span,{className:"line line-number",children:(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"// release memory"})}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src_re_mem);"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"src_im_mem);"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst_re_mem);"})]}),"\n",(0,n.jsxs)(e.span,{className:"line line-number",children:[(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"hbUCPFree"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"&"}),(0,n.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"dst_im_mem);"})]}),"\n"]})})})]})}function h(){let s=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,l.ah)(),s.components);return e?(0,n.jsx)(e,Object.assign({},s,{children:(0,n.jsx)(c,s)})):c(s)}e.default=h,h.__RSPRESS_PAGE_META={},h.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fucp%2Fhpl%2Fhpl5_op%2Fop_ifft_2d.mdx"]={toc:[{id:"operator-effect",text:"Operator Effect",depth:2},{id:"ifft_2d_principle",text:"Principle",depth:2},{id:"api-interface",text:"API Interface",depth:2},{id:"usage",text:"Usage",depth:2}],title:"Inverse Fast Fourier Transform 2D",frontmatter:{}}}}]);