"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["66246"],{7671:function(e,n,s){s.r(n);var t=s(85893),o=s(50065);function i(e){let n=Object.assign({h1:"h1",a:"a",h2:"h2",p:"p",code:"code",div:"div",pre:"pre",span:"span",table:"table",thead:"thead",tr:"tr",th:"th",tbody:"tbody",td:"td",ol:"ol",li:"li"},(0,o.ah)(),e.components);return(0,t.jsxs)(t.Fragment,{children:[(0,t.jsxs)(n.h1,{id:"flops-tool",children:[(0,t.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#flops-tool",children:"#"}),"FLOPs Tool"]}),"\n",(0,t.jsxs)(n.h2,{id:"definition-of-flops",children:[(0,t.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#definition-of-flops",children:"#"}),"Definition of FLOPs"]}),"\n",(0,t.jsx)(n.p,{children:"FLOPs is a common tool used to evaluate the size of neural networks. Common FLOPs tools generally calculate two types of operations, one is convolutional layer related operations, and the other is fully-connected layer related operations. Both are related to multiplication and addition."}),"\n",(0,t.jsxs)(n.p,{children:["Take the common ",(0,t.jsx)(n.code,{children:"torch.nn.Conv2d"})," as an example, the shape of the input data is ",(0,t.jsx)(n.code,{children:"bs * c_in * w_in * h_in"}),", the shape of the output data is ",(0,t.jsx)(n.code,{children:"bs * c_out * w_out * h_out"}),", and the size of the convolution kernel is ",(0,t.jsx)(n.code,{children:"f"}),". Then the FLOPs of this ",(0,t.jsx)(n.code,{children:"Conv2d"})," are ",(0,t.jsx)(n.code,{children:"2 * bs * f * f * c_in * c_out * w_out * h_out"}),". Here ",(0,t.jsx)(n.code,{children:"2"})," denotes half of the addition operations and half of the multiplication operations."]}),"\n",(0,t.jsxs)(n.p,{children:["In the case of ",(0,t.jsx)(n.code,{children:"torch.nn.Linear"}),", the number of neurons in the input data is ",(0,t.jsx)(n.code,{children:"c_in"}),", and the number of neurons in the output data is ",(0,t.jsx)(n.code,{children:"c_out"}),". In fact, this fully-connected layer can be used as a special convolutional layer, where the sizes of both input and output are ",(0,t.jsx)(n.code,{children:"1x1"})," and the size of the convolutional kernel is also ",(0,t.jsx)(n.code,{children:"1x1"}),". Then the FLOPs of the fully connected layer is ",(0,t.jsx)(n.code,{children:"bs * (c_in * c_out + c_out)"}),". Note that the ops of multiplication and addition are not exactly the same here."]}),"\n",(0,t.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,t.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,t.jsx)(n.div,{className:"rspress-directive-content",children:(0,t.jsx)(n.p,{children:"The quantitative and QAT models are identical to the corresponding floating-point models in terms of FLOPs."})})]}),"\n",(0,t.jsxs)(n.h2,{id:"the-use-of-flops-tool",children:[(0,t.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#the-use-of-flops-tool",children:"#"}),"The Use of FLOPs Tool"]}),"\n",(0,t.jsxs)(n.p,{children:["The current FLOPs tool supports the calculation of three types of operations, i.e., ",(0,t.jsx)(n.code,{children:"torch.nn.Conv2d"}),", ",(0,t.jsx)(n.code,{children:"torch.nn.Linear"})," and ",(0,t.jsx)(n.code,{children:"torch.nn.ConvTranspose2d"}),"."]}),"\n",(0,t.jsx)(n.pre,{className:"code",children:(0,t.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,t.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,t.jsxs)(n.span,{className:"line line-number",children:[(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"calops"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"py --config $"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"CONFIG_PATH"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" --method hook"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,t.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"fx"})]}),"\n"]})})}),"\n",(0,t.jsxs)(n.p,{children:["In ",(0,t.jsx)(n.code,{children:"config"})," , the main keys affecting the ",(0,t.jsx)(n.code,{children:"op"})," counting are ",(0,t.jsx)(n.code,{children:"test_model"})," (or ",(0,t.jsx)(n.code,{children:"model"}),") and ",(0,t.jsx)(n.code,{children:"test_inputs"}),". The ",(0,t.jsx)(n.code,{children:"model"})," determines the model to be checked by the tool, while ",(0,t.jsx)(n.code,{children:"test_inputs"})," determines the input size. The input shape can also be determined by the input parameters of ",(0,t.jsx)(n.code,{children:"-input-shape B,C,H,W"})," ."]}),"\n",(0,t.jsxs)(n.p,{children:["Note that the calops tool can also support ",(0,t.jsx)(n.code,{children:"matmul"})," by selecting ",(0,t.jsx)(n.code,{children:"fx"})," for ",(0,t.jsx)(n.code,{children:"method"}),". However, this method requires that the model itself can support ",(0,t.jsx)(n.code,{children:"fx"}),"."]}),"\n",(0,t.jsxs)(n.h2,{id:"flops-of-common-classification-models-input-size1x3x224x224",children:[(0,t.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#flops-of-common-classification-models-input-size1x3x224x224",children:"#"}),"FLOPs of Common Classification Models (Input Size:",(0,t.jsx)(n.code,{children:"1x3x224x224"}),")"]}),"\n",(0,t.jsxs)(n.table,{children:[(0,t.jsx)(n.thead,{children:(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.th,{align:"center",children:"Network"}),(0,t.jsx)(n.th,{align:"center",children:"OPS(G)"})]})}),(0,t.jsxs)(n.tbody,{children:[(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"mobilenetv1 (alpha=1.0)"}),(0,t.jsx)(n.td,{align:"center",children:"0.57"})]}),(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"mobilenetv2 (alpha=1.0)"}),(0,t.jsx)(n.td,{align:"center",children:"0.31"})]}),(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"resnet18"}),(0,t.jsx)(n.td,{align:"center",children:"1.81"})]}),(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"resnet50"}),(0,t.jsx)(n.td,{align:"center",children:"3.86"})]}),(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"vargnetv2"}),(0,t.jsx)(n.td,{align:"center",children:"0.36"})]}),(0,t.jsxs)(n.tr,{children:[(0,t.jsx)(n.td,{align:"center",children:"efficientnetb0"}),(0,t.jsx)(n.td,{align:"center",children:"0.39"})]})]})]}),"\n",(0,t.jsxs)(n.h2,{id:"descriptions",children:[(0,t.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#descriptions",children:"#"}),"Descriptions"]}),"\n",(0,t.jsxs)(n.p,{children:["In general, there are two cases when using ",(0,t.jsx)(n.code,{children:"calops"}),", which may cause incorrect results or calculation errors."]}),"\n",(0,t.jsxs)(n.ol,{children:["\n",(0,t.jsxs)(n.li,{children:["\n",(0,t.jsxs)(n.p,{children:["When ",(0,t.jsx)(n.code,{children:"hook"})," is selected for ",(0,t.jsx)(n.code,{children:"method"}),", but the model contains ",(0,t.jsx)(n.code,{children:"matmul"})," or other operators that are explicitly not covered."]}),"\n"]}),"\n",(0,t.jsxs)(n.li,{children:["\n",(0,t.jsxs)(n.p,{children:["When ",(0,t.jsx)(n.code,{children:"fx"})," is selected for ",(0,t.jsx)(n.code,{children:"method"}),", but the model itself does not support ",(0,t.jsx)(n.code,{children:"fx"}),", or contains other operators that are explicitly not covered."]}),"\n"]}),"\n"]})]})}function r(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,o.ah)(),e.components);return n?(0,t.jsx)(n,Object.assign({},e,{children:(0,t.jsx)(i,e)})):i(e)}n.default=r,r.__RSPRESS_PAGE_META={},r.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Ftutorials%2Fcalops.mdx"]={toc:[{id:"definition-of-flops",text:"Definition of FLOPs",depth:2},{id:"the-use-of-flops-tool",text:"The Use of FLOPs Tool",depth:2},{id:"flops-of-common-classification-models-input-size1x3x224x224",text:"FLOPs of Common Classification Models (Input Size:`1x3x224x224`)",depth:2},{id:"descriptions",text:"Descriptions",depth:2}],title:"FLOPs Tool",frontmatter:{}}}}]);