"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["62877"],{80484:function(e,n,i){e.exports=i.p+"static/image/fixed_scale.6716b571.jpg"},56762:function(e,n,i){e.exports=i.p+"static/image/mixed_precision_tuning_int8_int16.702a3806.jpg"},49841:function(e,n,i){e.exports=i.p+"static/image/mixed_precision_tuning_int8_int16_fp16.48e66c0d.jpg"},22757:function(e,n,i){e.exports=i.p+"static/image/shared_module.8a358b02.jpg"},83268:function(e,n,i){e.exports=i.p+"static/image/tuning_pipeline.bec981f8.jpg"},34845:function(e,n,i){i.r(n);var s=i(85893),a=i(50065),t=i(22757),r=i(83268),l=i(80484),o=i(56762),c=i(49841);function h(e){let n=Object.assign({h1:"h1",a:"a",p:"p",ol:"ol",li:"li",h2:"h2",div:"div",h3:"h3",pre:"pre",code:"code",span:"span",img:"img",h4:"h4"},(0,a.ah)(),e.components);return(0,s.jsxs)(s.Fragment,{children:[(0,s.jsxs)(n.h1,{id:"quantization-accuracy-tuning-guide",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#quantization-accuracy-tuning-guide",children:"#"}),"Quantization Accuracy Tuning Guide"]}),"\n",(0,s.jsx)(n.p,{children:"Quantization accuracy tuning involves two aspects:"}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Model structure and quantization configuration check. The main purpose is to avoid non-tuning issues affecting quantization accuracy, such as incorrect qconfig settings or using shared modules which are not quantization-friendly."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Mixed precision tuning. Start with a model using high precision operators to quickly achieve the desired accuracy, establishing the upper bound of accuracy and lower bound of performance. Then, use accuracy tuning tools to analyze and adjust quantization configurations to obtain a model that balances accuracy and performance."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h2,{id:"model-structure-and-quantization-configuration-check",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#model-structure-and-quantization-configuration-check",children:"#"}),"Model Structure and Quantization Configuration Check"]}),"\n",(0,s.jsxs)(n.p,{children:["After preparing the model, first check for quantization configuration errors and model structures which are not quantization-friendly. You can use the check_qat_model interface in the debug tools. Please refer to ",(0,s.jsx)(n.a,{href:"/3.0.17/en/guide/plugin/user_guide/quant_analysis.html",children:"Accuracy Tuning Tool Guide"})," for interface usage."]}),"\n",(0,s.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,s.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,s.jsx)(n.div,{className:"rspress-directive-content",children:(0,s.jsx)(n.p,{children:"check_qat_model is integrated into the prepare interface, and you can directly view the model_check_result.txt in the running directory."})})]}),"\n",(0,s.jsxs)(n.h3,{id:"operator-fusion",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#operator-fusion",children:"#"}),"Operator Fusion"]}),"\n",(0,s.jsx)(n.p,{children:"Check if there are modules in the model that can be fused but are not. When deploying the model on BPU, operators like conv, bn, add, and relu will be fused. In a QAT model, these operators will be replaced with a single module to avoid inserting fake quantization nodes. If these operators are not fused, additional quantization nodes will be inserted, potentially causing slight impacts on accuracy and performance. The following example shows that conv and relu are not fused."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Fusable modules are listed below:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"name    type"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"------  -----------------------------------------------------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"conv    <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'>"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"relu    <class 'horizon_plugin_pytorch.nn.qat.relu.ReLU'>"})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.p,{children:["Possible causes and solutions for operator fusion errors in different prepare ",(0,s.jsx)(n.a,{href:"/3.0.17/en/guide/plugin/user_guide/prepare.html#preparemethod",children:"methods"}),":"]}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"PrepareMethod.JIT and PrepareMethod.JIT_STRIP:"}),"\n",(0,s.jsx)(n.p,{children:"a. Operator fusion in dynamic code blocks requires marking with dynamic_block."}),"\n",(0,s.jsx)(n.p,{children:"b. Code with varying call counts were only executed once during tracing. Use inputs which make the code execute multiple times as example_inputs."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"PrepareMethod.EAGER: Missing or incorrect fuse operations. You need to check and fix the handwritten fuse logic."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"PrepareMethod.SYMBOLIC: Modules that can be fused are included in fx.wrap, which needs to be moved out to ensure these modules exist in the graph or use manual fusion like PrepareMethod.EAGER."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h3,{id:"shared-modules",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#shared-modules",children:"#"}),"Shared Modules"]}),"\n",(0,s.jsx)(n.p,{children:"Since the plugin inserts quantization nodes by module replacement, only one set of quantization information can be collected for each module. When a module is called multiple times with significantly different output data distributions, using the same set of quantization parameters will cause large errors, and the shared module needs to be copied. If the output data distribution of multiple calls is not significantly different, the shared module does not need to be copied. Here, we explain the concept of shared modules, which will help decide whether to copy shared modules during layer-by-layer comparison."}),"\n",(0,s.jsx)(n.p,{children:(0,s.jsx)(n.img,{src:t})}),"\n",(0,s.jsx)(n.p,{children:'The difference of three common-understanding "shared modules":'}),"\n",(0,s.jsx)(n.p,{children:"A. A module followed by multiple modules. Module A is considered shared, but here module A is only called once, and the output data distribution is not different, so it does not affect quantization accuracy and will not be reflected in the call count check."}),"\n",(0,s.jsx)(n.p,{children:"B. A module is called multiple times, but the output data distribution are similar. Although this can be seen in the call count check, it has little impact on quantization accuracy and does not need modification."}),"\n",(0,s.jsx)(n.p,{children:"C. A module is called multiple times, with significantly different output distributions each time. This will be reflected in the call count check and significantly impacts quantization accuracy, requiring manual splitting."}),"\n",(0,s.jsx)(n.p,{children:"In model_check_result.txt, you can see the call count of each module. Normally, each op is called only once. Zero means it is not called, and more than one indicates multiple calls. In the following example, conv is a shared module."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Each module called times:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"name       called times"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"-------  --------------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"conv                  2"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"quant                 1"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"dequant               1"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"# Corresponding code"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"# def forward(self, x):"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"#     x = self.quant(x)"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"#     x = self.conv(x)  "})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"#     x = self.conv(x)"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"#     x = self.dequant(x)"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"#     return x  "})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.h3,{id:"qconfig-configuration-errors",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#qconfig-configuration-errors",children:"#"}),"QConfig Configuration Errors"]}),"\n",(0,s.jsx)(n.p,{children:"Using qconfig incorrectly can cause the model to quantize in unexpected ways, resulting in low accuracy (e.g. mixing template and qconfig attribute settings). Here, we mainly check if the input and output of each operator meet expectations by looking at model_check_result.txt:"}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Whether the dtype matches the settings."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Whether high precision output is enabled."}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Each layer out qconfig:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+---------------+-----------------------------------------------------------+---------------+---------------+----------------+-----------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| Module Name   | Module Type                                               | Input dtype   | out dtype     | ch_axis        | observer                    |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|---------------+-----------------------------------------------------------+---------------+---------------+----------------+-----------------------------|"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| quant         | <class 'horizon_plugin_pytorch.nn.qat.stubs.QuantStub'>   | torch.float32 | qint8         | -1             | MovingAverageMinMaxObserver |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| conv          | <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'>     | qint8         | qint8         | -1             | MovingAverageMinMaxObserver |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| relu          | <class 'horizon_plugin_pytorch.nn.qat.relu.ReLU'>         | qint8         | qint8         | qconfig = None |                             |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| dequant       | <class 'horizon_plugin_pytorch.nn.qat.stubs.DeQuantStub'> | qint8         | torch.float32 | qconfig = None |                             |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+---------------+-----------------------------------------------------------+---------------+---------------+----------------+-----------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"# This check result shows that all modules are int8 quantized. If you configured int16, it means the configuration did not take effect, and you need to check the usage of qconfig."})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Weight qconfig:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+---------------+-------------------------------------------------------+----------------+-----------+---------------------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| Module Name   | Module Type                                           | weight dtype   |   ch_axis | observer                              |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|---------------+-------------------------------------------------------+----------------+-----------+---------------------------------------|"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| conv          | <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'> | qint8          |         0 | MovingAveragePerChannelMinMaxObserver |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+---------------+-------------------------------------------------------+----------------+-----------+---------------------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsx)(n.p,{children:"Additionally, model_check_result.txt will have prompts for abnormal qconfig. These are configurations that the tool identifies for you to double-check. They need verification to see if they meet expectations."}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Weight int16. J6M does not support both of input and weight being int16. If weight int16 is found, check whether the input is int16."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Fixed scale. Check if the fixed scale settings are as expected."}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Please check if these OPs qconfigs are expected.."})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+-----------------+----------------------------------------------------------------------------+------------------------------------------------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| Module Name     | Module Type                                                                | Msg                                                              |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|-----------------+----------------------------------------------------------------------------+------------------------------------------------------------------|"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| convmod1.add    | <class 'horizon_plugin_pytorch.nn.qat.conv2d.ConvAddReLU2d'>               | qint16 weight!!!                                                 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| convmod2.conv2d | <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'>                      | qint16 weight!!!                                                 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| convmod3.add    | <class 'horizon_plugin_pytorch.nn.qat.conv2d.ConvAddReLU2d'>               | qint16 weight!!!                                                 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| shared_conv     | <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'>                      | qint16 weight!!!                                                 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| shared_conv(1)  | <class 'horizon_plugin_pytorch.nn.qat.conv2d.Conv2d'>                      | qint16 weight!!!                                                 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"| sub[sub]        | <class 'horizon_plugin_pytorch.nn.qat.functional_modules.FloatFunctional'> | Fixed scale 3.0517578125e-05                                     |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+-----------------+----------------------------------------------------------------------------+------------------------------------------------------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.h2,{id:"mixed-precision-tuning",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#mixed-precision-tuning",children:"#"}),"Mixed Precision Tuning"]}),"\n",(0,s.jsxs)(n.h3,{id:"tuning-pipeline",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#tuning-pipeline",children:"#"}),"Tuning Pipeline"]}),"\n",(0,s.jsx)(n.p,{children:(0,s.jsx)(n.img,{src:r})}),"\n",(0,s.jsx)(n.p,{children:"The entire pipeline first involves all-int16 accuracy tuning to confirm the model's upper bound of accuracy and check for tool usage issues or quantization-unfriendly modules."}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"After confirming that all-int16 accuracy meets the requirements, perform all-int8 accuracy tuning. If the accuracy is not good enough, perform int8/int16 mixed precision tuning. Starting with an all-int8 model, gradually increase the proportion of int16 operators, balancing accuracy and performance."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"If all-int16 accuracy does not meet the requirements, perform int16/fp16 mixed precision tuning. Ideally, int16/fp16 mixed precision tuning can solve all accuracy problems. Based on this, perform int8/int16/fp16 mixed precision tuning, fixing all fp16 operator configurations, and adjust the proportion of int16 operators as described in step 1."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h3,{id:"basic-tuning-methods",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#basic-tuning-methods",children:"#"}),"Basic Tuning Methods"]}),"\n",(0,s.jsx)(n.p,{children:"The goal of basic tuning methods is to get a quantization model quickly."}),"\n",(0,s.jsxs)(n.h4,{id:"calibration",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#calibration",children:"#"}),"Calibration"]}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Adjust calibration steps. The more calibration data, the better. However, due to the marginal effect, when the data volume reaches a certain level, the improvement in accuracy will be very limited. If the training set is small, use it all for calibration. If the training set is large, select a subset for calibration to balance time and accuracy. It's recommended to perform at least 10 to 100 steps of calibration."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Adjust batch size. Generally, a larger batch size is preferable. However, if the data is noisy or the model has many outliers, it may be necessary to reduce the batch size."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Use inference stage preprocessing with training data for calibration. Calibration data should reflect the real distribution and can use data augmentation methods like flipping, but avoid using augmentation methods that destory the real distribution, such as rotation and mosaic."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h4,{id:"qat",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#qat",children:"#"}),"QAT"]}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Adjust learning rate."}),"\n",(0,s.jsx)(n.p,{children:"a. Initial Learning Rate\uFF1ADisable warmup and decay strategies. Use different fixed learning rates (e.g., 1e-3, 1e-4, etc.) to fine-tune for a few steps and select the learning rate with best accuracy. If the floating-point model uses different learning rates for different modules, replicate this in QAT."}),"\n",(0,s.jsx)(n.p,{children:"b. Scheduler\uFF1AAlign the learning rate decay strategy with the floating-point model's but ensure no warmup strategies are used."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Experiment with fixing or updating input/output scales. When the accuracy of calibration model is good, fixing the input/output scale for QAT training can achieve better results. Otherwise, do not fix the scales. Both of the two strategies need to be tested as there are no definitive metrics to guide it."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Training steps. Generally, QAT training steps should not exceed 20% of the floating-point training steps. Adjust training steps based on training loss and evaluation results."}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(n.p,{children:"Special considerations:"}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Apart from the specific adjustments mentioned above, ensure all other QAT training configurations align with the floating-point training."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"If the floating-point training uses freeze BN trick, set the QAT mode to WithBN."}),"\n"]}),"\n"]}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_mode "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" QATMode"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" set_qat_mode"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"set_qat_mode"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(QATMode.WithBN)"})]}),"\n"]})})}),"\n",(0,s.jsxs)(n.ol,{start:"3",children:["\n",(0,s.jsx)(n.li,{children:"If accuracy issues arise despite tuning, such as non-converging loss or NaNs, first fine-tune the floating-point model with the same configuration to rule out issues on misalignment or overfitting."}),"\n"]}),"\n",(0,s.jsxs)(n.h3,{id:"advanced-tuning-methods",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#advanced-tuning-methods",children:"#"}),"Advanced Tuning Methods"]}),"\n",(0,s.jsx)(n.p,{children:"Advanced tuning methods generally require more time and experiments. They are used when higher accuracy is required."}),"\n",(0,s.jsxs)(n.h4,{id:"setting-fixed-scale",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#setting-fixed-scale",children:"#"}),"Setting Fixed Scale"]}),"\n",(0,s.jsx)(n.p,{children:"Some parts of the model may require fixed scales due to difficulty in determining the optimal quantization scale through statistics. Common situations requiring fixed scales include operators with known output ranges."}),"\n",(0,s.jsx)(n.p,{children:"For example: If input data represents speed in km/h with a range of [0, 200], the quantstub output range is fixed, and the scale should be set to 200 divided by the quantization range. Statistical methods might underestimate this range due to outliers being averaged out, causing error for samples exceeding this range."}),"\n",(0,s.jsx)(n.p,{children:"In the case below, the value range of input a and b is determined, and the value range of input c is uncertain. Except for quantstub_c and the last add, all other operators need to set fixed scale."}),"\n",(0,s.jsx)(n.p,{children:(0,s.jsx)(n.img,{src:l})}),"\n",(0,s.jsxs)(n.h4,{id:"calibration-1",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#calibration-1",children:"#"}),"Calibration"]}),"\n",(0,s.jsxs)(n.p,{children:["Experiment with different calibration methods. The plugin supports various methods, including min max, percentile, kl, mse, and mix. For tuning experiences, refer to the ",(0,s.jsx)(n.a,{href:"/3.0.17/en/guide/plugin/user_guide/calibration.html",children:"calibration guide"}),"."]}),"\n",(0,s.jsxs)(n.h4,{id:"qat-1",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#qat-1",children:"#"}),"QAT"]}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Adjust weight decay. Weight decay impacts the range of weight values. Smaller range means more quantization-friendly. Adjust weight decay during both floating-point and QAT phases if necessary."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Adjust data augmentation. Quantized models have lower learning capabilities compared to floating-point models. Strong data augmentation may hinder QAT model convergence, so it's generally advisable to moderate the augmentation."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h3,{id:"int8int16--int16fp16-mixed-precision-tuning",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#int8int16--int16fp16-mixed-precision-tuning",children:"#"}),"INT8/INT16 & INT16/FP16 Mixed Precision Tuning"]}),"\n",(0,s.jsx)(n.p,{children:"The basic idea of mixed precision tuning is to incrementally introduce higher precision operators into a lower precision model until the desired accuracy is achieved. For int8/int16 tuning, start with an all-int8 model and incrementally increase the number of int16 operators. For int16/FP16 tuning, start with an all-int16 model and incrementally increase the number of FP16 operators."}),"\n",(0,s.jsx)(n.p,{children:(0,s.jsx)(n.img,{src:o})}),"\n",(0,s.jsx)(n.p,{children:"The calibration and QAT tuning in the figure above can reference both basic and advanced tuning methods chapters. Increasing the number of high-precision operators for int16/fp16 relies on a series of debug results produced by accuracy debugging tools."}),"\n",(0,s.jsxs)(n.p,{children:["QAT accuracy debugging is entirely based on the comparison between the floating-point model and the calibration model. Generally, it is not recommended to compare the floating-point model with the QAT model directly, as they become incomparable after QAT training. Please refer to ",(0,s.jsx)(n.a,{href:"/3.0.17/en/guide/plugin/user_guide/quant_analysis.html",children:"Accuracy Tuning Tool Guide"})," for background information. First, provide a dataset to find bad cases with significant calibration error, then compare layer-by-layer and calculate quantization sensitivity based on these bad cases."]}),"\n",(0,s.jsxs)(n.h4,{id:"find-badcase",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#find-badcase",children:"#"}),"Find Badcase"]}),"\n",(0,s.jsx)(n.p,{children:"All accuracy debugging operations are based on bad cases. You need to provide a sample set with low quantization accuracy. This process will traverse the sample set and compare the output error of each sample in the floating-point model and the calibration model. Generally, you do not need to provide an error measurement function."}),"\n",(0,s.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,s.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,s.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,s.jsx)(n.p,{children:"Start from finding bad cases, models need to include some post-processing logic (removing or replacing parts of the original post-processing logic that make the model outputs completely incomparable). For example:"}),(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Sigmoid should not be removed. Values in the sigmoid saturation domain are not sensitive to errors, but values near 0 are highly sensitive. Removing sigmoid will prevent accurate reflection of quantization errors within different domains."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"NMS should be removed. Small errors can lead to completely different NMS results, making the output incomparable."}),"\n"]}),"\n"]}),(0,s.jsx)(n.p,{children:"The debug tool supports automatic replacement of sort/topk/argmax. Besides these operators, you need to check if there are similar operators in the model and post-processing, and delete all parts after these operators."})]})]}),"\n",(0,s.jsx)(n.p,{children:"Use the auto_find_bad_case interface in the debugging tool to find bad cases."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_profiler"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model_profilerv2 "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" QuantAnalysis"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 1. Initialize the quantization analysis object"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"QuantAnalysis"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(float_net, calibration_model, "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fake_quant"'}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 2. Find bad cases. If there are too many data, you can specify num_steps to find bad cases in a subset of the data"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"auto_find_bad_case"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dataloader)"})]}),"\n"]})})}),"\n",(0,s.jsx)(n.p,{children:"After finding the bad cases, check the result file. For each output of the model, the debug tool will find the worst sample under each error metric. In the example below, the model has three outputs. The first table shows the worst sample index for each output under each metric, the second table shows the corresponding errors, and the third table shows the worst bad case index under the current metric for all outputs."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"The bad case input index of each output:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Name/Index    Cosine    MSE    L1    KL    SQNR"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"------------  --------  -----  ----  ----  ------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-0           4         4      1     4     1"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-1           14        1      1     1     1"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-2           12        11     9     12    9"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"The metric results of each badcase:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Name/Index    Cosine    MSE          L1         KL           SQNR"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"------------  --------  -----------  ---------  -----------  ---------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-0           0.969289  2.35591      0.996721   0.0828096    11.9335"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-1           0.974127  0.00964048   0.0404785  0.00104532   12.6742"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"0-2           0.450689  4.76039      1.08771    0.320661     -0.821809"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"The bad case input index of the worst output:"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"metric    dataloader index"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"--------  ------------------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"Cosine    11"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"MSE       17"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"L1        17"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"KL        12"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"SQNR      0 "})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,s.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,s.jsx)(n.div,{className:"rspress-directive-content",children:(0,s.jsx)(n.p,{children:"We can only debug the outputs related to accuracy drop. Different model outputs require different error metrics. Typically, L1 and Cosine are suitable for most issues. L1 is suitable for tasks requiring absolute error reflection, such as bbox regression, while Cosine is suitable for tasks requiring overall distribution error reflection, such as classification."})})]}),"\n",(0,s.jsxs)(n.h4,{id:"layer-by-layer-comparison",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#layer-by-layer-comparison",children:"#"}),"Layer-by-Layer Comparison"]}),"\n",(0,s.jsx)(n.p,{children:"Layer-by-layer comparison uses the bad cases to run the floating-point model and the calibration model separately, comparing the output of each layer. This can be done using the compare_per_layer interface in the debug tool. This method is suitable for detailed accuracy analysis. If the accuracy drop is not significant, you can skip this step and analyze it later with sensitivity results."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_profiler"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model_profilerv2 "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" QuantAnalysis"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 1. Initialize the quantization analysis object"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"QuantAnalysis"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(float_net, calibration_model, "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fake_quant"'}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 2. Find bad cases. If there are too many data, you can specify num_steps to find bad cases in a subset of the data"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"auto_find_bad_case"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dataloader)"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 3. Run the model with bad cases to get information on each layer"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"run"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 4. Compare the information of each layer"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"compare_per_layer"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,s.jsx)(n.p,{children:"The results of the layer-by-layer comparison can be viewed in generated text files. In the text file, you can see where the error starts to magnify from top to bottom."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"+------+----------------------------------------+-----------------------------------------------------------------------------+-----------------------------------------------------------+---------------------------------------+---------------+-----------+------------+-----------------+--------------+------------+--------------+---------------+-------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+-----------------+-------------------+"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|      | mod_name                               | base_op_type                                                                | analy_op_type                                             | shape                                 | quant_dtype   |    qscale |     Cosine |             MSE |           L1 |         KL |         SQNR |          Atol |              Rtol |     base_model_min |    analy_model_min |     base_model_max |    analy_model_max |    base_model_mean |   analy_model_mean |     base_model_var |    analy_model_var |   max_atol_diff |   max_qscale_diff |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|------+----------------------------------------+-----------------------------------------------------------------------------+-----------------------------------------------------------+---------------------------------------+---------------+-----------+------------+-----------------+--------------+------------+--------------+---------------+-------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+--------------------+-----------------+-------------------|"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    0 | backbone.quant                         | horizon_plugin_pytorch.quantization.stubs.QuantStub                         | horizon_plugin_pytorch.nn.qat.stubs.QuantStub             | torch.Size([4, 3, 512, 960])          | qint16        | 0.0078125 |  0.9999999 |       0.0000000 |    0.0000000 |  0.0000000 |  inf         |     0.0000000 |         0.0000000 |         -1.0000000 |         -1.0000000 |          0.9843750 |          0.9843750 |         -0.1114422 |         -0.1114422 |          0.1048462 |          0.1048462 |       0.0000000 |         0.0000000 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    1 | backbone.mod1.0                        | torch.nn.modules.conv.Conv2d                                                | horizon_plugin_pytorch.nn.qat.conv_bn2d.ConvBN2d          | torch.Size([4, 32, 256, 480])         | qint16        | 0.0003464 |  0.4019512 |       0.4977255 |    0.4296696 |  0.0115053 |   -0.3768753 |    14.2325277 |   5343133.5000000 |         -5.9793143 |        -15.0439596 |          8.7436047 |         17.3419971 |          0.1503869 |          0.0484397 |          0.4336909 |          0.3707855 |      14.2325277 |     41088.2696619 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    2 | backbone.mod1.1                        | torch.nn.modules.batchnorm.BatchNorm2d                                      | torch.nn.modules.linear.Identity                          | torch.Size([4, 32, 256, 480])         | qint16        | 0.0003464 |  0.9999998 |       0.0000000 |    0.0000000 |  0.0000000 |  inf         |     0.0000000 |         0.0000000 |        -15.0439596 |        -15.0439596 |         17.3419971 |         17.3419971 |          0.0484397 |          0.0484397 |          0.3707855 |          0.3707855 |       0.0000000 |         0.0000000 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    3 | backbone.mod2.0.head_layer.conv.0.0    | torch.nn.modules.conv.Conv2d                                                | horizon_plugin_pytorch.nn.qat.conv_bn2d.ConvBNReLU2d      | torch.Size([4, 64, 256, 480])         | qint16        | 0.0004594 |  0.5790146 |      49.3001938 |    4.0790396 |  0.0415040 |    0.3848250 |   164.3788757 |   4046676.7500000 |       -164.3788757 |          0.0000000 |        140.9307404 |         25.1951389 |         -0.5375993 |          0.2460073 |         53.5661125 |          0.2699530 |     164.3788757 |    357789.3997821 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    4 | backbone.mod2.0.head_layer.conv.0.1    | torch.nn.modules.batchnorm.BatchNorm2d                                      | torch.nn.modules.linear.Identity                          | torch.Size([4, 64, 256, 480])         | qint16        | 0.0004594 |  0.7092103 |       0.3265578 |    0.2332140 |  0.0003642 |    3.0239849 |    17.1071243 |         1.0000000 |        -17.1071243 |          0.0000000 |         25.1951389 |         25.1951389 |          0.0127933 |          0.2460073 |          0.6568668 |          0.2699530 |      17.1071243 |     37235.6102222 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    5 | backbone.mod2.0.head_layer.conv.0.2    | torch.nn.modules.activation.ReLU                                            | torch.nn.modules.linear.Identity                          | torch.Size([4, 64, 256, 480])         | qint16        | 0.0004594 |  1.0000001 |       0.0000000 |    0.0000000 |  0.0000000 |  inf         |     0.0000000 |         0.0000000 |          0.0000000 |          0.0000000 |         25.1951389 |         25.1951389 |          0.2460073 |          0.2460073 |          0.2699530 |          0.2699530 |       0.0000000 |         0.0000000 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    6 | backbone.mod2.0.head_layer.short_add   | horizon_plugin_pytorch.nn.quantized.functional_modules.FloatFunctional.add  | horizon_plugin_pytorch.nn.qat.conv_bn2d.ConvBNAddReLU2d   | torch.Size([4, 32, 256, 480])         | qint16        | 0.0004441 |  0.5653002 |       1.6375992 |    0.4214573 |  0.0008538 |    1.6659310 |    39.9804993 |         1.0000000 |        -39.9804993 |          0.0000000 |         19.6796150 |         19.6796150 |          0.0330326 |          0.4544899 |          2.4056008 |          0.5625318 |      39.9804993 |     90017.7454165 |"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"|    7 | backbone.mod2.0.head_layer.relu        | torch.nn.modules.activation.ReLU                                            | torch.nn.modules.linear.Identity                          | torch.Size([4, 32, 256, 480])         | qint16        | 0.0004441 |  1.0000000 |       0.0000000 |    0.0000000 |  0.0000000 |  inf         |     0.0000000 |         0.0000000 |          0.0000000 |          0.0000000 |         19.6796150 |         19.6796150 |          0.4544899 |          0.4544899 |          0.5625318 |          0.5625318 |       0.0000000 |         0.0000000 |"})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,s.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,s.jsxs)(n.div,{className:"rspress-directive-content",children:[(0,s.jsx)(n.p,{children:"After finding the operators with significant accuracy drop, first check base_model_min / base_model_max / analy_model_min / analy_model_max to confirm if there are substantial errors in the extreme values."}),(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Significant errors in min / max values: This indicates that the output range of the operator in the floating-point model significantly exceeds the range obtained from calibration. Check the scale of the operator and calculate the maximum value obtained from calibration using the dtype and scale. For instance, if the scale is 0.0078 and the dtype is int8, then the maximum value should be 0.0078 \xd7 128 = 0.9984. Compare this with base_model_max and analy_model_max. Reasons for a very small scale may include: unreasonable calibration data (too little calibration data or biased distribution resulting in an excessively small output range), shared module etc."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"No significant errors in min / max values\uFF1ASimilarly, calculate the calibration maximum value as described in point 1, compare it with base_model_max and analy_model_max to confirm that the output range of the operator in the floating-point model does not significantly exceed the range obtained from calibration. These issues may be caused by insufficient resolution of the quantization type or an excessively large numerical range."}),"\n",(0,s.jsx)(n.p,{children:"a. Check if the current quantization dtype matches the numerical range. Generally, if the maximum value exceeds 10, it is not recommended to use int8 quantization."}),"\n",(0,s.jsx)(n.p,{children:"b. Identify why the calibration get a large numerical range. The reason may be outliers or unreasonable settings."}),"\n"]}),"\n"]})]})]}),"\n",(0,s.jsxs)(n.h4,{id:"calculating-quantization-sensitivity",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#calculating-quantization-sensitivity",children:"#"}),"Calculating Quantization Sensitivity"]}),"\n",(0,s.jsx)(n.p,{children:"This step evaluates the impact of quantization nodes on model accuracy. The sensitivity interface in the debug tool can be used to get quantization sensitivity. The specific evaluation method is to use badcase as the model input, individually enabling each quantization node, and comparing the error between the calibration model and the floating-point model. The error measurement metric is the same as the one used when finding badcase."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_profiler"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"model_profilerv2 "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" QuantAnalysis"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 1. Initialize the quantization analysis object"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"QuantAnalysis"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(float_net, calibration_model, "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fake_quant"'}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 2. Find bad cases. If there are too many data, you can specify num_steps to find bad cases in a subset of the data"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"auto_find_bad_case"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dataloader)"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 3. Run the model with bad cases to get information on each layer"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"run"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 4. Compare the information of each layer"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"compare_per_layer"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-comment)"},children:"# 5. Calculate quantization sensitivity"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qa"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitivity"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n"]})})}),"\n",(0,s.jsx)(n.p,{children:"In the results of quantization sensitivity, operators ranked higher have a greater impact on model accuracy and need to be set to a higher precision data type."}),"\n",(0,s.jsx)(n.p,{children:"The sensitive_type column has two values: weight and activation, representing the cases of enabling only the weight quantization node or the output quantization node of the operator, respectively."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-text",meta:"",children:[(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"op_name                                                                                                          sensitive_type    op_type                                                                           L1  quant_dtype"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"---------------------------------------------------------------------------------------------------------------  ----------------  --------------------------------------------------------------------------  --------  ------------"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.transformer.decoder.layers.5.cross_attn.quant                                   activation        <class 'horizon_plugin_pytorch.nn.qat.stubs.QuantStub'>                     1.59863   qint8"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.transformer.decoder.layers.5.norm3.var_mean.pre_mean                            activation        <class 'horizon_plugin_pytorch.nn.qat.functional_modules.FloatFunctional'>  1.52816   qint16"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.ref_pts_quant                                                                   activation        <class 'horizon_plugin_pytorch.nn.qat.stubs.QuantStub'>                     1.16427   qint8"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.fps_quant                                                                       activation        <class 'horizon_plugin_pytorch.nn.qat.stubs.QuantStub'>                     1.13563   qint8"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.transformer.decoder.mem_bank_layer.emb_fps_queue_add                            activation        <class 'horizon_plugin_pytorch.nn.qat.functional_modules.FloatFunctional'>  1.11997   qint8"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"bev_stage2_e2e_dynamic_head.head.transformer.decoder.mem_bank_layer.temporal_norm2.weight_mul                    activation        <class 'horizon_plugin_pytorch.nn.qat.functional_modules.FloatFunctional'>  1.09876   qint8"})}),"\n",(0,s.jsx)(n.span,{className:"line",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,s.jsxs)(n.div,{className:"rspress-directive warning",children:[(0,s.jsx)(n.div,{className:"rspress-directive-title",children:"Attention"}),(0,s.jsx)(n.div,{className:"rspress-directive-content",children:(0,s.jsx)(n.p,{children:"Even for very quantization-unfriendly models, some operators should have relatively low quantization sensitivity. Therefore, in a normal sensitivity table, the sensitivity should vary, with the last few operators' sensitivities near to zero. If the errors for the last few operators are large, consider whether there are incorrect post-processing operations, such as NMS, that have not been thoroughly removed."})})]}),"\n",(0,s.jsx)(n.p,{children:"You need to use a sensitivity template to set the qconfig. See the qconfig section for detailed usage. Below is an example of setting the top 20% most sensitive operators to int16 in an int8/int16 mixed precision tuning. Adjust the int16 ratio continuously until you find the minimal int16 ratio that meets the accuracy requirements."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitive_op_calibration_8bit_weight_16bit_act_qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(table, ratio"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        default_calibration_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitive_op_qat_8bit_weight_16bit_act_qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(table, ratio"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        default_qat_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,s.jsx)(n.p,{children:"Currently, there is no interface to set fp16 based on sensitivity in bulk. You need to set a small number of fp16 based on the int16 sensitivity results using ModuleNameQconfigSetter. Below is an example of setting the top 1 most sensitive int16 operator to fp16 in int16/fp16 mixed precision optimization."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"module_name_to_qconfig "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"op_1"'}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"get_qconfig"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(in_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16, weight_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16, out_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ModuleNameQconfigSetter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(module_name_to_qconfig),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        calibration_8bit_weight_16bit_act_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ModuleNameQconfigSetter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(module_name_to_qconfig),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        qat_8bit_weight_16bit_act_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,s.jsx)(n.p,{children:"J6M has limited floating-point compute power. If fp16 is not absolutely necessary, try to use int8/int16 mixed precision tuning. When the all-int16 model cannot meet the accuracy requirements, introduce a small number of fp16 operators into the all-int16 model."}),"\n",(0,s.jsx)(n.p,{children:"Two scenarios in which the all-int16 model fail to meet accuracy standards:"}),"\n",(0,s.jsxs)(n.ol,{children:["\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Dual int16 needed: This manifests as certain operators having high sensitivity under both activation and weight sensitivity types. Setting weight and activation to int16 meets the accuracy requirements. Since J6M does not support using int16 for both activation and weight simultaneously, adjust the floating-point model to make one of them more quantization-friendly. Common methods include increasing weight decay and adding normalization operators."}),"\n"]}),"\n",(0,s.jsxs)(n.li,{children:["\n",(0,s.jsx)(n.p,{children:"Dual int16 not needed: This manifests as certain operators having high sensitivity under either activation or weight sensitivity type, generally due to plugin usage issues or certain operators requiring fixed scale settings. Accuracy debugging can find specific problems."}),"\n"]}),"\n"]}),"\n",(0,s.jsxs)(n.h3,{id:"int8--int16--fp16-mixed-precision-tuning",children:[(0,s.jsx)(n.a,{className:"header-anchor","aria-hidden":"true",href:"#int8--int16--fp16-mixed-precision-tuning",children:"#"}),"INT8 / INT16 / FP16 Mixed Precision Tuning"]}),"\n",(0,s.jsx)(n.p,{children:"Before performing int8/int16/fp16 mixed precision tuning, you should have completed int16/fp16 mixed precision tuning. Reuse the fp16 configuration from int16/fp16 mixed precision tuning and perform accuracy debugging based on the int8/fp16 mixed calibration model. Refer to the accuracy debugging methods in the previous section, continuously adjusting the int16 ratio until you find the minimal int16 ratio that meets the accuracy requirements."}),"\n",(0,s.jsx)(n.p,{children:(0,s.jsx)(n.img,{src:c})}),"\n",(0,s.jsx)(n.p,{children:"Below is an example of setting the top 1 most sensitive int16 operator to fp16 and the top 20% most sensitive int8 operators to int16 in int8/int16/fp16 mixed precision optimization."}),"\n",(0,s.jsx)(n.pre,{className:"code",children:(0,s.jsx)(n.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,s.jsxs)(n.code,{className:"language-python",meta:"",children:[(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"module_name_to_qconfig "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"op_1"'}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"get_qconfig"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(in_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16, weight_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16, out_dtype"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.float16),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number"}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ModuleNameQconfigSetter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(module_name_to_qconfig),"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitive_op_8bit_weight_16bit_act_calibration_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(table, ratio"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        default_calibration_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    example_inputs"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"example_input,"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"ModuleNameQconfigSetter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(module_name_to_qconfig),"})]}),"\n",(0,s.jsxs)(n.span,{className:"line line-number",children:[(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-function)"},children:"sensitive_op_8bit_weight_16bit_act_qat_setter"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(table, ratio"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        default_qat_qconfig_setter,"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    )"})}),"\n",(0,s.jsx)(n.span,{className:"line line-number",children:(0,s.jsx)(n.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})})]})}function d(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:n}=Object.assign({},(0,a.ah)(),e.components);return n?(0,s.jsx)(n,Object.assign({},e,{children:(0,s.jsx)(h,e)})):h(e)}n.default=d,d.__RSPRESS_PAGE_META={},d.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fplugin%2Fuser_guide%2Fprecision_tuning.mdx"]={toc:[{id:"model-structure-and-quantization-configuration-check",text:"Model Structure and Quantization Configuration Check",depth:2},{id:"operator-fusion",text:"Operator Fusion",depth:3},{id:"shared-modules",text:"Shared Modules",depth:3},{id:"qconfig-configuration-errors",text:"QConfig Configuration Errors",depth:3},{id:"mixed-precision-tuning",text:"Mixed Precision Tuning",depth:2},{id:"tuning-pipeline",text:"Tuning Pipeline",depth:3},{id:"basic-tuning-methods",text:"Basic Tuning Methods",depth:3},{id:"calibration",text:"Calibration",depth:4},{id:"qat",text:"QAT",depth:4},{id:"advanced-tuning-methods",text:"Advanced Tuning Methods",depth:3},{id:"setting-fixed-scale",text:"Setting Fixed Scale",depth:4},{id:"calibration-1",text:"Calibration",depth:4},{id:"qat-1",text:"QAT",depth:4},{id:"int8int16--int16fp16-mixed-precision-tuning",text:"INT8/INT16 & INT16/FP16 Mixed Precision Tuning",depth:3},{id:"find-badcase",text:"Find Badcase",depth:4},{id:"layer-by-layer-comparison",text:"Layer-by-Layer Comparison",depth:4},{id:"calculating-quantization-sensitivity",text:"Calculating Quantization Sensitivity",depth:4},{id:"int8--int16--fp16-mixed-precision-tuning",text:"INT8 / INT16 / FP16 Mixed Precision Tuning",depth:3}],title:"Quantization Accuracy Tuning Guide",frontmatter:{}}}}]);