"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["33178"],{40050:function(n,e,s){s.r(e);var i=s(85893),o=s(50065);function r(n){let e=Object.assign({h1:"h1",a:"a",p:"p",code:"code",h2:"h2",h3:"h3",pre:"pre",span:"span"},(0,o.ah)(),n.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(e.h1,{id:"unet-segmentation-model-training",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#unet-segmentation-model-training",children:"#"}),"UNet Segmentation Model Training"]}),"\n",(0,i.jsxs)(e.p,{children:["As a sample of the HAT segmentation task, this tutorial demonstrates how to train a state-of-the-art floating-point and fixed-point model on the ",(0,i.jsx)(e.code,{children:"Cityscapes"})," dataset using HAT."]}),"\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.code,{children:"Cityscapes"})," is an image dataset of urban driving scenes, containing 5000 images with pixel-level annotations, and the objects in the images are divided into 19 categories.\r\nThe segmentation task is relatively complex and requires a high level of model capability, and it is not easy to achieve good metrics on the segmentation task using small models."]}),"\n",(0,i.jsxs)(e.p,{children:["This tutorial will elaborate on how to train a state-of-the-art segmentation model on the ",(0,i.jsx)(e.code,{children:"Cityscapes"})," dataset using HAT and conduct quantitative training on top of the floating-point model to finally get a fixed-point model from scratch."]}),"\n",(0,i.jsxs)(e.h2,{id:"training-process",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#training-process",children:"#"}),"Training Process"]}),"\n",(0,i.jsxs)(e.h3,{id:"downloading-dataset",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#downloading-dataset",children:"#"}),"Downloading Dataset"]}),"\n",(0,i.jsxs)(e.p,{children:["To download the ",(0,i.jsx)(e.code,{children:"Cityscapes"})," dataset, you first need to register an account on the ",(0,i.jsx)(e.a,{href:"https://www.cityscapes-dataset.com/register/",target:"_blank",rel:"noopener noreferrer",children:"official website"}),"."]}),"\n",(0,i.jsxs)(e.p,{children:["After that, you can download the dataset files from the ",(0,i.jsx)(e.a,{href:"https://www.cityscapes-dataset.com/downloads/",target:"_blank",rel:"noopener noreferrer",children:"Download"})," page.\r\nHere we only need two files: ",(0,i.jsx)(e.code,{children:"gtFine_trainvaltest.zip"})," and ",(0,i.jsx)(e.code,{children:"leftImg8bit_trainvaltest.zip"}),"."]}),"\n",(0,i.jsxs)(e.p,{children:["Additionally, the official ",(0,i.jsx)(e.code,{children:"Cityscapes"})," dataset provides a script for downloading and processing the data, see ",(0,i.jsx)(e.a,{href:"https://github.com/mcordts/cityscapesScripts",target:"_blank",rel:"noopener noreferrer",children:"Github"}),"."]}),"\n",(0,i.jsx)(e.p,{children:"First install the official tools using the following command:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-m"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"pip"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"install"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"cityscapesscripts"})]}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Then use the official tool to log into the account registered above and download the required dataset files."}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"csDownload"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-d"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"gtFine_trainvaltest.zip"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"csDownload"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-d"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"leftImg8bit_trainvaltest.zip"})]}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Finally, unpack the downloaded files (optional):"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir}"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"unzip"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"gtFine_trainvaltest.zip"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"unzip"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"leftImg8bit_trainvaltest.zip"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"packing-dataset",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#packing-dataset",children:"#"}),"Packing Dataset"]}),"\n",(0,i.jsxs)(e.p,{children:["To improve data reading efficiency, we recommend pre-packing the dataset into the ",(0,i.jsx)(e.code,{children:"LMDB"})," format.\r\nHAT provides the ",(0,i.jsx)(e.code,{children:"cityscapes_packer.py"})," script for you to easily convert the dataset from the original public format to ",(0,i.jsx)(e.code,{children:"numpy.ndarray"})," or ",(0,i.jsx)(e.code,{children:"torch.Tensor"}),".\r\nUse ",(0,i.jsx)(e.code,{children:"msgpack"})," to wrap the data and eventually pack it into ",(0,i.jsx)(e.code,{children:"LMDB"})," files."]}),"\n",(0,i.jsx)(e.p,{children:"The command to pack the dataset is as follows:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/cityscapes_packer.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"train"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/cityscapes_packer.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"val"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.p,{children:["The generated LMDB files are saved under ",(0,i.jsx)(e.code,{children:"${data-dir}/train_lmdb"})," and ",(0,i.jsx)(e.code,{children:"${data-dir}/val_lmdb"}),"."]}),"\n",(0,i.jsxs)(e.h3,{id:"model-training",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-training",children:"#"}),"Model Training"]}),"\n",(0,i.jsxs)(e.p,{children:["After packing the dataset into ",(0,i.jsx)(e.code,{children:"LMDB"})," files, you can start training the model.\r\nHAT provides the training script ",(0,i.jsx)(e.code,{children:"train.py"})," to facilitate model training together with ",(0,i.jsx)(e.code,{children:"config"})," files."]}),"\n",(0,i.jsxs)(e.p,{children:["Before starting the training, please make sure that the dataset path (",(0,i.jsx)(e.code,{children:"data_rootdir"}),") in the configuration file ",(0,i.jsx)(e.code,{children:"unet_mobilenetv1_cityscapes.py"})," is set to the ",(0,i.jsx)(e.code,{children:"LMDB"})," file path."]}),"\n",(0,i.jsx)(e.p,{children:"The commands for model training are as follows:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"float"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"calibration"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"qat"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.p,{children:["The above two commands are respectively for the training of the floating-point model and the fixed-point model.\r\nThe fixed-point model training needs to be based on the trained fixed-point model.\r\nFor details on this, please read the ",(0,i.jsx)(e.a,{href:"/3.0.17/en/guide/plugin/introduce.html",children:"Quantized Awareness Training (QAT)"})," section."]}),"\n",(0,i.jsxs)(e.h3,{id:"metrics-validation",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#metrics-validation",children:"#"}),"Metrics Validation"]}),"\n",(0,i.jsx)(e.p,{children:"After training, the script will automatically validate the metrics of the trained model."}),"\n",(0,i.jsxs)(e.p,{children:["In addition, HAT provides a script to validate the metrics of the trained floating-point and fixed-point models, which is also configured by using the ",(0,i.jsx)(e.code,{children:"config"})," file."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"predict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"float"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" --config configs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"segmentation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"unet_mobilenetv1_cityscapes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --ckpt $"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"float"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"checkpoint"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"predict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage calibration --config configs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"segmentation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"unet_mobilenetv1_cityscapes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --ckpt $"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"calibration"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"checkpoint"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"predict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage qat --config configs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"segmentation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"unet_mobilenetv1_cityscapes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --ckpt $"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"checkpoint"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"predict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --stage int_infer --config configs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"segmentation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"unet_mobilenetv1_cityscapes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --ckpt $"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"infer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"checkpoint"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"simulation-of-on-board-accuracy-validation",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#simulation-of-on-board-accuracy-validation",children:"#"}),"Simulation of On-board Accuracy Validation"]}),"\n",(0,i.jsx)(e.p,{children:"In addition to the above model validation, we also provide the exact same accuracy validation method simulating the on-board conditions, as below:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"python3 tools"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"align_bpu_validation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py --config configs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"segmentation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"unet_mobilenetv1_cityscapes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"model-inference",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference",children:"#"}),"Model Inference"]}),"\n",(0,i.jsxs)(e.p,{children:["HAT provides the ",(0,i.jsx)(e.code,{children:"infer.py"})," script to visualize the inference results of the trained models at each phase:"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/infer.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-c"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--model-inputs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"img:"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"${img-path} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--save-path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${save_path}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"model-compilation",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-compilation",children:"#"}),"Model Compilation"]}),"\n",(0,i.jsxs)(e.p,{children:["The quantization algorithms used in the HAT integrated quantitative training framework are specifically designed for Horizon processors, so fixed-point models trained with HAT can be compiled using the tools provided by ",(0,i.jsx)(e.code,{children:"HBDK"})," to generate fixed-point models that can run on the computing platform.\r\nWe provided the script ",(0,i.jsx)(e.code,{children:"compile_perf.py"})," to facilitate the compilation process."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-c"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--opt"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"})]}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Thus, we have got a segmentation task fixed-point model that can run on the Horizon processors from scratch."}),"\n",(0,i.jsxs)(e.h3,{id:"export-fixedpoint-model",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#export-fixedpoint-model",children:"#"}),"Export FixedPoint Model"]}),"\n",(0,i.jsx)(e.p,{children:"Once you've completed your quantization training, you can start exporting your fixed-point model. You can export it with the following command:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/export_hbir.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"model-verification",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-verification",children:"#"}),"Model Verification"]}),"\n",(0,i.jsxs)(e.p,{children:["After completing the training, we get the trained floating-point, quantitative, or fixed-point model. Similar to the training method, we can use the same method to complete metrics validation on the trained model and get the metrics of ",(0,i.jsx)(e.code,{children:"Float"}),", ",(0,i.jsx)(e.code,{children:"Calibration"}),", and ",(0,i.jsx)(e.code,{children:"Quantized"}),",\r\nwhich are floating-point, quantitative, and fully fixed-point metrics, respectively."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number"}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.p,{children:["Similar to the model training, we can use ",(0,i.jsx)(e.code,{children:"--stage"})," followed by ",(0,i.jsx)(e.code,{children:'"float"'}),", ",(0,i.jsx)(e.code,{children:'"calibration"'}),", to validate the trained floating-point model, and quantitative model, respectively."]}),"\n",(0,i.jsx)(e.p,{children:"The following command can be used to verify the accuracy of a fixed-point model, but it should be noted that hbir must be exported first:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int_infer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"model-inference-1",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference-1",children:"#"}),"Model Inference"]}),"\n",(0,i.jsxs)(e.p,{children:[(0,i.jsx)(e.code,{children:"HAT"})," provides the ",(0,i.jsx)(e.code,{children:"infer_hbir.py"})," script to visualize the inference results for the fixed-point model:"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/infer_hbir.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--model-inputs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"img:"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"${img-path} "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--save-path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ${save_path}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"simulation-board-accuracy-verification",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#simulation-board-accuracy-verification",children:"#"}),"Simulation Board Accuracy Verification"]}),"\n",(0,i.jsx)(e.p,{children:"In addition to the above model validation, we provide an accuracy validation method identical to the on-board environment, which can be accomplished by:"}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/validation_hbir.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"align_bpu"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"fixed-point-model-checking-and-compilation",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#fixed-point-model-checking-and-compilation",children:"#"}),"Fixed-point Model Checking and Compilation"]}),"\n",(0,i.jsx)(e.p,{children:"As the quantitative training toolchain integrated in HAT is mainly prepared for Horizon's processors, it is a must to check and compile the quantitative models."}),"\n",(0,i.jsxs)(e.p,{children:["We provide an interface for model checking in HAT, which allows the user to define a quantitative model and then check whether it can work properly on the ",(0,i.jsx)(e.code,{children:"BPU"})," first."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/model_checker.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.p,{children:["After the model is trained, you can use the ",(0,i.jsx)(e.code,{children:"compile_perf_hbir"})," script to compile the quantitative model into an ",(0,i.jsx)(e.code,{children:"HBM"})," file that supports on-board running.\r\nThe tool can also predict the performance on the ",(0,i.jsx)(e.code,{children:"BPU"}),"."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf_hbir.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"The above is the whole process from data preparation to the generation of quantitative and deployable models."}),"\n",(0,i.jsxs)(e.h2,{id:"training-details",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#training-details",children:"#"}),"Training Details"]}),"\n",(0,i.jsxs)(e.h3,{id:"model-structure",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-structure",children:"#"}),"Model Structure"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"model "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Segmentor"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    backbone"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MobileNetV1"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_classes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=-"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(eps"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2e-5"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", momentum"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        alpha"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.25"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        dw_with_relu"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        include_top"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        flat_output"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    neck"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"DwUnet"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        base_channels"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(eps"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2e-5"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", momentum"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        act_type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"nn.ReLU,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        use_deconv"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        dw_with_relu"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        output_scales"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    head"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"SegHead"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_classes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"19"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        in_strides"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        out_strides"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stride2channels"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"512"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        },"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        feat_channels"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"512"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stacked_convs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        argmax_output"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        dequant_output"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        int8_output"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        upscale"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        output_with_bn"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        bn_kwargs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(eps"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2e-5"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", momentum"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    losses"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ClassificationFocalLoss"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        loss_name"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Focal"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_classes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"19"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        weight"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"tuple"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"64"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"16"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")) "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"19"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        reduction"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mean"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(e.p,{children:["The segmentation model mainly consists of ",(0,i.jsx)(e.code,{children:"backbone"}),", ",(0,i.jsx)(e.code,{children:"neck"}),", and ",(0,i.jsx)(e.code,{children:"head"}),".\r\nHere we use ",(0,i.jsx)(e.code,{children:"MobileNetV1_0.25"})," as the ",(0,i.jsx)(e.code,{children:"backbone"}),", which is a lightweight and efficient network structure.\r\nThe ",(0,i.jsx)(e.code,{children:"neck"})," uses the ",(0,i.jsx)(e.code,{children:"Unet"})," structure, which can combine the ",(0,i.jsx)(e.code,{children:"featuremap"})," at each scale and preserve the fine spatial information.\r\nThe ",(0,i.jsx)(e.code,{children:"head"})," is a convolutional layer responsible for the output of the final segmentation results."]}),"\n",(0,i.jsxs)(e.p,{children:["We use ",(0,i.jsx)(e.code,{children:"FocalLoss"})," as the loss function. ",(0,i.jsx)(e.code,{children:"FocalLoss"})," can be regarded as a cross-entropy loss function with dynamic weights, which can better solve the problem of training difficulties caused by category imbalance."]}),"\n",(0,i.jsxs)(e.p,{children:["The hierarchical structure of ",(0,i.jsx)(e.code,{children:"Unet"})," is consistent with the idea of ",(0,i.jsx)(e.code,{children:"FPN"})," and can be treated with the same training method, that is, constructing an output on each ",(0,i.jsx)(e.code,{children:"scale"})," of ",(0,i.jsx)(e.code,{children:"Unet"}),",  and construct a loss function with this output and the ",(0,i.jsx)(e.code,{children:"ground truth"})," with corresponding size for training,\r\nwhich supervises each network scale, provides richer reference information for network training, reduces the training difficulty, and improves the training speed and the final accuracy."]}),"\n",(0,i.jsxs)(e.p,{children:["Meanwhile, considering that the final result we need is the max-sized network output (scale=4), to avoid the over large gradient of other sizes affecting the accuracy of the max-sized output, we add weights to the loss function according to ",(0,i.jsx)(e.code,{children:"scale"}),".\r\nA layer with larger ",(0,i.jsx)(e.code,{children:"scale"})," has smaller weight."]}),"\n",(0,i.jsxs)(e.p,{children:["Usually, after defining a model, especially for some public models, we would have the need to check the FLOPs.\r\nHAT provides ",(0,i.jsx)(e.code,{children:"calops.py"})," to calculate the operations of the model, which is implemented as below:"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/calops.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Such ops-counting tool can support both floating-point and fixed-point models at the same time."}),"\n",(0,i.jsxs)(e.h3,{id:"data-pre-processing",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#data-pre-processing",children:"#"}),"Data Pre-processing"]}),"\n",(0,i.jsxs)(e.p,{children:["First, we use ",(0,i.jsx)(e.code,{children:"LabelRemap"})," to re-map the data labels to the interval [0, 18]."]}),"\n",(0,i.jsxs)(e.p,{children:["For the training set, ",(0,i.jsx)(e.code,{children:"SegRandomAffine"})," can perform a random affine transformation on the image for data enhancement, and we only configure a random scaling without any rotation operation."]}),"\n",(0,i.jsxs)(e.p,{children:["Since the training uses an ",(0,i.jsx)(e.code,{children:"FPN"}),"-like approach, we need to scale the labels to different sizes to train the models with different ",(0,i.jsx)(e.code,{children:"scales"}),"."]}),"\n",(0,i.jsxs)(e.p,{children:["The final model running on the ",(0,i.jsx)(e.code,{children:"BPU"})," uses the ",(0,i.jsx)(e.code,{children:"YUV444"})," format as the image input, while regular trainings use the ",(0,i.jsx)(e.code,{children:"RGB"})," format.\r\nTherefore, HAT provides ",(0,i.jsx)(e.code,{children:"ImageBgrToYuv444"})," data enhancement to convert ",(0,i.jsx)(e.code,{children:"RGB"})," data to the ",(0,i.jsx)(e.code,{children:"YUV444"})," format."]}),"\n",(0,i.jsx)(e.p,{children:"Finally, normalization is necessary for deep learning model training."}),"\n",(0,i.jsxs)(e.p,{children:["Note that here we use ",(0,i.jsx)(e.code,{children:"MultiBatchProcessor"})," for the task training. This ",(0,i.jsx)(e.code,{children:"Processor"})," supports data pre-processing on the ",(0,i.jsx)(e.code,{children:"GPU"})," in batches.\r\nSince the data preprocessing of the segmentation task is relatively complex, bottlenecks will occur if we use ",(0,i.jsx)(e.code,{children:"CPU"})," for the processing.\r\nHowever, using ",(0,i.jsx)(e.code,{children:"GPU"})," will increase the video memory usage, resulting in a lower maximum ",(0,i.jsx)(e.code,{children:"batch size"}),". That said, the final training speed is considerably improved."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"data_loader "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DataLoader,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    dataset"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CityscapesFromLMDB"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        data_path"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"os.path."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data_rootdir, "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"train_lmdb"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        transforms"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"PILToTensor"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        num_samples"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2975"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sampler"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DistributedSampler),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_size"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_size_per_gpu,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    shuffle"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_workers"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"dataloader_workers,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    pin_memory"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"batch_processor "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MultiBatchProcessor"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    need_grad_update"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_transforms"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LabelRemap"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", mapping"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"CITYSCAPES_LABLE_MAPPINGS),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"SegOneHot"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", num_classes"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"num_classes),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"SegResize"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", size"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_shape["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":]),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"SegRandomAffine"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            degrees"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            scale"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2.0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            interpolation"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"InterpolationMode.BILINEAR,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            label_fill_value"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ImageBgrToYuv444"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", rgb_input"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ImageNormalize"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", mean"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", std"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Scale"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            scales"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"tuple"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" np."}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(train_scales)),"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            mode"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"bilinear"'})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    loss_collector"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"loss_collector,"})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsx)(e.p,{children:"Compared with the training set, the data preprocessing of the validation set does not require random affine transformation and multi-scale scaling. The other stages are the same and will not be repeated."}),"\n",(0,i.jsxs)(e.h3,{id:"training-strategies",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#training-strategies",children:"#"}),"Training Strategies"]}),"\n",(0,i.jsx)(e.p,{children:"The segmentation task can be regarded as a pixel-level classification task, so the training strategy is highly similar to that of the classification task."}),"\n",(0,i.jsx)(e.p,{children:"First, the training speed can be increased by increasing the learning rate as much as possible while ensuring convergence."}),"\n",(0,i.jsx)(e.p,{children:"When training with a certain learning rate until the accuracy no longer grows, you can reduce the learning rate appropriately, the model will continue to converge, and the accuracy can be further improved."}),"\n",(0,i.jsxs)(e.p,{children:["After the final training, compare the accuracy of the test set with the training set, and if the accuracy of the training set is too much higher than the test set, the model is considered to be overfitted.\r\nIn this case, increasing the ",(0,i.jsx)(e.code,{children:"weight decay"})," can enhance the generalization ability of the model, reduce the overfitting, and obtain a higher accuracy of the test set."]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"float_trainer "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_loader,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.optim.SGD,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        params"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"weight"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:": "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(weight_decay"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"5e-3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")},"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        lr"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.01"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        momentum"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.9"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_processor,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"train_epochs,"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stat_callback,"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"StepDecayLrUpdater"'}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            lr_decay_id"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"200"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"240"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"280"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            lr_decay_factor"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        metric_updater,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        tb_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        aidi_tb_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        tb_loss_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        aidi_tb_loss_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        val_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ckpt_callback,"})}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sync_bn"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(e.span,{className:"line line-number",children:(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,i.jsxs)(e.h3,{id:"quantitative-training-strategies",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#quantitative-training-strategies",children:"#"}),"Quantitative Training Strategies"]}),"\n",(0,i.jsx)(e.p,{children:"The purpose of quantitative training is to simulate the process of fix-point computation by performing simulated data quantization based on the trained floating-point model to minimize the accuracy loss during the quantitative to fixed-point model conversion."}),"\n",(0,i.jsxs)(e.p,{children:["Since the floating-point model has converged to a good state after sufficient training, the model usually needs only a little fine-tuning in the quantitative training.\r\nThe learning rate should not be set too large. You can start trying from ",(0,i.jsx)(e.code,{children:"1e-4"})," order of magnitude, leaving other parameters the same as the floating-point training.\r\nSimilarly, as the model fine-tuning requires less amount of training, usually a few dozen training ",(0,i.jsx)(e.code,{children:"epochs"})," is enough."]}),"\n",(0,i.jsx)(e.p,{children:"Since the model already has a good accuracy before quantitative training, room for the accuracy improvement is small.\r\nThe simulated quantization of the data will also lead to large fluctuations in the training process.\r\nAt this point, we need to patiently and carefully observe the trend from the fluctuations and adjust the parameters appropriately to get the best results."}),"\n",(0,i.jsxs)(e.h3,{id:"model-checking--compilation",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#model-checking--compilation",children:"#"}),"Model Checking & Compilation"]}),"\n",(0,i.jsx)(e.p,{children:"For HAT, the significance of the quantitative model is that it can be run directly on the BPU.\r\nTherefore, it is necessary to check and compile the quantitative model."}),"\n",(0,i.jsxs)(e.p,{children:["The ",(0,i.jsx)(e.code,{children:"compile_perf.py"})," script provided by HAT first checks the model to ensure that it can run properly on the BPU.\r\nThen it compiles the model to make it runnable on the BPU. After that, the script will also test the compiled fixed-point model to predict its performance on the BPU.\r\nRun the command as below:"]}),"\n",(0,i.jsx)(e.pre,{className:"code",children:(0,i.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(e.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(e.span,{className:"line line-number",children:[(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"-c"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"configs/segmentation/unet_mobilenetv1_cityscapes.py"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-string)"},children:"--opt"}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"})]}),"\n"]})})}),"\n",(0,i.jsxs)(e.h2,{id:"pre-trained-model",children:[(0,i.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#pre-trained-model",children:"#"}),"Pre-trained Model"]}),"\n",(0,i.jsx)(e.p,{children:"HAT has provided pre-trained models for this example, which are all included in the release package."})]})}function t(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,o.ah)(),n.components);return e?(0,i.jsx)(e,Object.assign({},n,{children:(0,i.jsx)(r,n)})):r(n)}e.default=t,t.__RSPRESS_PAGE_META={},t.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Fexamples%2Fsegmentation.mdx"]={toc:[{id:"training-process",text:"Training Process",depth:2},{id:"downloading-dataset",text:"Downloading Dataset",depth:3},{id:"packing-dataset",text:"Packing Dataset",depth:3},{id:"model-training",text:"Model Training",depth:3},{id:"metrics-validation",text:"Metrics Validation",depth:3},{id:"simulation-of-on-board-accuracy-validation",text:"Simulation of On-board Accuracy Validation",depth:3},{id:"model-inference",text:"Model Inference",depth:3},{id:"model-compilation",text:"Model Compilation",depth:3},{id:"export-fixedpoint-model",text:"Export FixedPoint Model",depth:3},{id:"model-verification",text:"Model Verification",depth:3},{id:"model-inference-1",text:"Model Inference",depth:3},{id:"simulation-board-accuracy-verification",text:"Simulation Board Accuracy Verification",depth:3},{id:"fixed-point-model-checking-and-compilation",text:"Fixed-point Model Checking and Compilation",depth:3},{id:"training-details",text:"Training Details",depth:2},{id:"model-structure",text:"Model Structure",depth:3},{id:"data-pre-processing",text:"Data Pre-processing",depth:3},{id:"training-strategies",text:"Training Strategies",depth:3},{id:"quantitative-training-strategies",text:"Quantitative Training Strategies",depth:3},{id:"model-checking--compilation",text:"Model Checking & Compilation",depth:3},{id:"pre-trained-model",text:"Pre-trained Model",depth:2}],title:"UNet Segmentation Model Training",frontmatter:{}}}}]);