"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["1600"],{8491:function(n,s,e){e.r(s);var i=e(85893),r=e(50065);function o(n){let s=Object.assign({h1:"h1",a:"a",p:"p",code:"code",pre:"pre",span:"span",h2:"h2",h3:"h3"},(0,r.ah)(),n.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.h1,{id:"car-keypoint-detection-model-training",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#car-keypoint-detection-model-training",children:"#"}),"Car Keypoint Detection Model Training"]}),"\n",(0,i.jsxs)(s.p,{children:["This tutorial primarily focuses on how to train a key point detection model from scratch using HAT on the ",(0,i.jsx)(s.code,{children:"CarFusion"})," car key point dataset.\r\nThe tutorial covers floating-point, quantization, and fixed-point models."]}),"\n",(0,i.jsxs)(s.p,{children:["CarFusion is a car keypoint dataset that includes annotations for 12 keypoints on cars: the centers of the front, rear, left, and right wheels, as well as the positions of the car lights and the corners of the car roof.\r\nBefore starting the model training, the first step is to prepare the dataset. To do this, we need to apply for the dataset on the official website.\r\nThe official website link for CarFusion is: ",(0,i.jsx)(s.a,{href:"http://www.cs.cmu.edu/~ILIM/projects/IM/CarFusion/cvpr2018/index.html",target:"_blank",rel:"noopener noreferrer",children:"CarFusion"}),".\r\nAfter scrolling down, you will find the dataset application form. Once you submit the form, you will receive an email with the dataset download link.\r\nAfter downloading and extracting the dataset, the directory structure will be as follows:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"CarFusion"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- train"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_butler1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_butler2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_craig1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_craig2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_fifth1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_fifth2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_morewood1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_morewood2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- test"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_penn1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_penn2"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsx)(s.p,{children:"Here, we only consider a simpler scenario, which is to detect keypoints from pre-detected car images.\r\nTherefore, we need to first crop the cars from the images based on the annotated bounding boxes."}),"\n",(0,i.jsx)(s.p,{children:"To convert the data into the cropped format, you can simply run the following command:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/dataset_converters/gen_carfusion_data.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--out-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${cropped-data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--num-workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The directory structure of the processed cropped data will be as follows:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"cropped-data-dir"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- train"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_butler1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_butler2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_craig1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_craig2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_fifth1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_fifth2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_morewood1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_morewood2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- test"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_penn1"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- car_penn2"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- simple_anno"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- keypoints_train.json"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    |-- keypoints_test.json"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsx)(s.p,{children:'The file "keypoints_test.json" contains annotations for the test dataset, while "keypoints_train.json" contains annotations for the training dataset.\r\nEach sample is stored in JSON format as a dictionary with the following structure: "img_path": keypoints_list.\r\nThe "keypoints_list" has a shape of (12, 3), where each row represents a keypoint.\r\nThe first two elements of each row are the x and y coordinates of the keypoint, and the third element indicates the validity of the keypoint.\r\nIf the keypoint is outside the image or is invalid, the third element is set to 0.'}),"\n",(0,i.jsxs)(s.p,{children:["Next, you can package the data into a ",(0,i.jsx)(s.code,{children:"LMDB"})," format dataset. You can successfully accomplish this conversion by running the following script:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/carfusion_packer.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${cropped-data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${pack-data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"train"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--num-workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/datasets/carfusion_packer.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--src-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${cropped-data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--target-data-dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${pack-data-dir} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--split-name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"test"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--pack-type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"lmdb"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--num-workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"After the packaging is completed, the file structure in the directory should look as follows:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"tmp_data"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- CarFusion"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- test_lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  |-- train_lmdb"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"train_lmdb"})," and ",(0,i.jsx)(s.code,{children:"val_lmdb"})," are the training and validation datasets, respectively, after packaging. Now you can proceed to train the model using these datasets."]}),"\n",(0,i.jsxs)(s.h2,{id:"model-training",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-training",children:"#"}),"Model Training"]}),"\n",(0,i.jsxs)(s.p,{children:[(0,i.jsx)(s.code,{children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})," includes all the settings related to model training in this tutorial."]}),"\n",(0,i.jsx)(s.p,{children:"Before starting the network training, you can use the following command to calculate the computational complexity and the number of parameters in the network:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/calops.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The next step is to start the training. Training can also be accomplished using the following script.\r\nBefore training, make sure to confirm that the dataset paths in the configuration have been switched to the packaged dataset path."}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/train.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Since the HAT algorithm package utilizes a registration mechanism, it allows each training task to follow this pattern, it allows each training task to follow this pattern, using ",(0,i.jsx)(s.code,{children:"train.py"})," and ",(0,i.jsx)(s.code,{children:"config"})," file to launch.\r\nHere ",(0,i.jsx)(s.code,{children:"train.py"})," is a unified training script, that is irrelevant to the task. The type of task we need to train, the dataset to be used, and the hyperparameter settings for training are all specified in the designated config configuration file.\r\nIn the command above, the parameter following ",(0,i.jsx)(s.code,{children:"--stage"})," can be set to ",(0,i.jsx)(s.code,{children:"float"})," or ",(0,i.jsx)(s.code,{children:"calibration"})," .\r\nThese options correspond to training a floating-point model and training a quantized model, respectively.\r\nTraining a quantized model relies on the floating-point model generated from the previous floating-point training step."]}),"\n",(0,i.jsxs)(s.h2,{id:"exporting-fixed-point-model",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#exporting-fixed-point-model",children:"#"}),"Exporting Fixed-point Model"]}),"\n",(0,i.jsx)(s.p,{children:"After completing quantization training, you can proceed to export the fixed-point model. You can use the following command to perform the export:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/export_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"model-validation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-validation",children:"#"}),"Model Validation"]}),"\n",(0,i.jsxs)(s.p,{children:["After completing the training, you will obtain the trained floating-point and quantized models.\r\nSimilar to the training process, you can use the same method to perform metric evaluation on the trained models.\r\nThis evaluation will provide metrics labeled as ",(0,i.jsx)(s.code,{children:"Float"})," and ",(0,i.jsx)(s.code,{children:"QAT"})," corresponding to the floating-point and quantized models, respectively."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"calibration"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Similar to the training process, when the parameter following ",(0,i.jsx)(s.code,{children:"--stage"})," is set to ",(0,i.jsx)(s.code,{children:"float"})," or ",(0,i.jsx)(s.code,{children:"calibration"})," , ",(0,i.jsx)(s.code,{children:"tools/predict.py"})," can be used to perform validation on the trained floating-point model or quantized model respectively."]}),"\n",(0,i.jsx)(s.p,{children:"For the fix-point model validation, we could use following command, but it should be noted that hbir must be exported first:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/predict.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"int_infer"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"model-inference",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-inference",children:"#"}),"Model Inference"]}),"\n",(0,i.jsxs)(s.p,{children:["HAT provides the ",(0,i.jsx)(s.code,{children:"infer_hbir.py"})," script, which allows visualization of the inference results of the integer model."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/infer_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--model-inputs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"img:"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${img1-path} "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--save-path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ${save_path}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"simulation-on-board-accuracy-validation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#simulation-on-board-accuracy-validation",children:"#"}),"Simulation On-board Accuracy Validation"]}),"\n",(0,i.jsx)(s.p,{children:"In addition to the above model validation, we provide an accuracy validation method identical to the on-board environment, which can be accomplished by:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/validation_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--stage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"align_bpu"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"fixed-point-model-check-and-compilation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#fixed-point-model-check-and-compilation",children:"#"}),"Fixed-point Model Check and Compilation"]}),"\n",(0,i.jsx)(s.p,{children:"As the quantitative training toolchain integrated in HAT is mainly prepared for Horizon's processors, it is a must to check and compile the quantitative models."}),"\n",(0,i.jsxs)(s.p,{children:["We provide a script for model checking in HAT, allowing you to define the quantitative model and then check whether it can work properly on the ",(0,i.jsx)(s.code,{children:"BPU"})," ."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/model_checker.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["After the model is trained, you can use the ",(0,i.jsx)(s.code,{children:"compile_perf_hbir"})," script to compile the quantitative model into a ",(0,i.jsx)(s.code,{children:"hbm"})," file that supports on-board running.\r\nThis tool can also predict the model performance on the ",(0,i.jsx)(s.code,{children:"BPU"})," ."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"python3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"tools/compile_perf_hbir.py"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--config"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The above is the whole process from data preparation to the generation of quantitative and deployable models."}),"\n",(0,i.jsxs)(s.h2,{id:"training-details",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#training-details",children:"#"}),"Training Details"]}),"\n",(0,i.jsx)(s.p,{children:"In this explanation, we will outline some considerations to be aware of during model training, primarily focusing on relevant settings in the config file."}),"\n",(0,i.jsxs)(s.h3,{id:"network-structure",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#network-structure",children:"#"}),"Network Structure"]}),"\n",(0,i.jsxs)(s.p,{children:["For the lightweight car keypoint detection task, the network model ",(0,i.jsx)(s.code,{children:"HeatmapKeypointModel"})," utilizes ",(0,i.jsx)(s.code,{children:"efficientnet-b0"})," as the ",(0,i.jsx)(s.code,{children:"backbone"}),".\r\nIt adds three transpose convolutional layers to generate heatmaps, from which the keypoint coordinates are decoded. By defining a dictionary variable, such as",(0,i.jsx)(s.code,{children:"model"}),"in the",(0,i.jsx)(s.code,{children:"config"}),"configuration file, we can easily define and modify the model."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  model "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HeatmapKeypointModel"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      backbone"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"efficientnet"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          model_type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"b0"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          num_classes"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          bn_kwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{},"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          activation"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"relu"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          use_se_block"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          include_top"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      decode_head"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"DeconvDecoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          in_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"320"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          out_channels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"NUM_LDMK,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          input_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          num_conv_layers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          num_deconv_filters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          num_deconv_kernels"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          final_conv_kernel"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      loss"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MSELoss"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", reduction"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"mean"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      post_process"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"HeatmapDecoder"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          scale"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"averaged"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["The model consists of the ",(0,i.jsx)(s.code,{children:"backbone"})," , ",(0,i.jsx)(s.code,{children:"decode_head"})," composed of transpose convolutions, ",(0,i.jsx)(s.code,{children:"losses"})," , and ",(0,i.jsx)(s.code,{children:"post_process"})," modules. In the ",(0,i.jsx)(s.code,{children:"HeatmapKeypointModel"})," , the input is cropped car images. The ",(0,i.jsx)(s.code,{children:"backbone"})," is responsible for extracting image features, while the ",(0,i.jsx)(s.code,{children:"decoder"})," upsamples and generates heatmaps. The ",(0,i.jsx)(s.code,{children:"losses"})," module utilizes the weighted ",(0,i.jsx)(s.code,{children:"MSELoss"})," based on the heatmap positions as the training loss. The ",(0,i.jsx)(s.code,{children:"post_process"})," module uses the ",(0,i.jsx)(s.code,{children:"HeatmapDecoder"})," to convert the heatmap output into predicted keypoint locations."]}),"\n",(0,i.jsxs)(s.h3,{id:"data-augmentation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#data-augmentation",children:"#"}),"Data Augmentation"]}),"\n",(0,i.jsxs)(s.p,{children:["Same as the definition of ",(0,i.jsx)(s.code,{children:"model"})," , the data augmentation pipeline is achieved by defining ",(0,i.jsx)(s.code,{children:"data_loader"})," and ",(0,i.jsx)(s.code,{children:"val_data_loader"})," two dicts in the ",(0,i.jsx)(s.code,{children:"config"})," file, which corresponds to the process pipelines in train and test set."]}),"\n",(0,i.jsxs)(s.p,{children:["Taking the example of the data_loader, data augmentation techniques used include ",(0,i.jsx)(s.code,{children:"RandomFlip"})," , ",(0,i.jsx)(s.code,{children:"Resize"})," , ",(0,i.jsx)(s.code,{children:"RandomPadLdmkData"})," , and ",(0,i.jsx)(s.code,{children:"GaussianNoise"})," . For the keypoint detection task, it is also necessary to use ",(0,i.jsx)(s.code,{children:"GenerateHeatmapTarget"})," to generate heatmap targets from the keypoint annotations."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  data_loader "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DataLoader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CarfusionPackData"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          data_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_root"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'/train_lmdb"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          transforms"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"RandomFlip"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", px"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.5"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Resize"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  img_scale"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  keep_ratio"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"RandomPadLdmkData"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"AddGaussianNoise"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  prob"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  mean"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  sigma"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"GenerateHeatmapTarget"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  num_ldmk"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"NUM_LDMK,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  feat_stride"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  heatmap_shape"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"32"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  sigma"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ToTensor"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  to_yuv"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  use_yuv_v2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Normalize"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  mean"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  std"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      sampler"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DistributedSampler),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      batch_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_size_per_gpu,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      shuffle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      num_workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      pin_memory"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      collate_fn"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"hat.data.collates.collate_2d,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Because the model that runs on the ",(0,i.jsx)(s.code,{children:"BPU"})," eventually uses ",(0,i.jsx)(s.code,{children:"YUV444"})," images as input, while regular training images are typically in RGB format, HAT provides the ",(0,i.jsx)(s.code,{children:"to_yuv=True"})," option in the ",(0,i.jsx)(s.code,{children:"ToTensor"})," data transform to convert ",(0,i.jsx)(s.code,{children:"RGB"})," format images to ",(0,i.jsx)(s.code,{children:"YUV444"})," format."]}),"\n",(0,i.jsxs)(s.p,{children:["HAT also offers the ",(0,i.jsx)(s.code,{children:"batch_processor"})," interface for batch processing the data, but no additional augmentation is added in this case. The ",(0,i.jsx)(s.code,{children:"loss_collector"})," is a function that retrieves the loss for the current batch data. As the model returns a tuple ",(0,i.jsx)(s.code,{children:"(pred, loss)"})," , the loss value is obtained by indexing the tuple's element at index 1."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  batch_processor "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MultiBatchProcessor"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      need_grad_update"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      loss_collector"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"collect_loss_by_index"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The data transformation for the validation set is relatively simpler, as shown below:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  val_data_loader "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DataLoader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CarfusionPackData"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        data_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"f"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"{"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_root"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'/test_lmdb"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        transforms"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Resize"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                img_scale"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                keep_ratio"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"RandomPadLdmkData"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                random"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ToTensor"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                to_yuv"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                use_yuv_v2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Normalize"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                mean"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                std"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"128.0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_size_per_gpu,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sampler"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.utils.data.DistributedSampler),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    shuffle"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_workers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"8"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    pin_memory"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    collate_fn"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"hat.data.collates.collate_2d,"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  val_batch_processor "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MultiBatchProcessor"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    need_grad_update"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"False"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.h3,{id:"training-strategy",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#training-strategy",children:"#"}),"Training Strategy"]}),"\n",(0,i.jsxs)(s.p,{children:["In the ",(0,i.jsx)(s.code,{children:"configs/keypoint/keypoint_efficientnetb0_carfusion.py"})," file, the ",(0,i.jsx)(s.code,{children:"float_trainer"})," and ",(0,i.jsx)(s.code,{children:"calibration_trainer"})," correspond to the training strategies for floating-point, and quantized models, respectively.\r\nBelow is an example of the ",(0,i.jsx)(s.code,{children:"float_trainer"})," training strategy:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  float_trainer "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"distributed_data_parallel_trainer"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model_convert_pipeline"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        converters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                checkpoint_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"pretrain_model_path,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                allow_miss"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                ignore_extra"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"data_loader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    optimizer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"torch.optim.AdamW, lr"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.001"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", weight_decay"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"5e-2"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    batch_processor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"batch_processor,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    num_epochs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"30"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    device"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    callbacks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        stat_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        loss_show_update,"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"CosLrUpdater"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            warmup_len"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            warmup_by"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"epoch"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            step_log_interval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        val_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ckpt_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    train_metrics"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LossShow"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    sync_bn"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"True"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    val_metrics"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"PCKMetric"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", alpha"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", feat_stride"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", img_shape"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MeanKeypointDist"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            feat_stride"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"float_trainer"})," defines our overall training approach, including the use of multi-GPU distributed training (distributed_data_parallel_trainer), the number of epochs for model training, and the choice of optimizer."]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"model_convert_pipeline"})," defines the transformation operations before the model starts training. In this case, the model first loads the pre-trained model of ",(0,i.jsx)(s.code,{children:"Efficientnet-b0"})," on ",(0,i.jsx)(s.code,{children:"ImageNet"})," ."]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"callbacks"})," define the strategies and operations used during the training process, including the learning rate variation ",(0,i.jsx)(s.code,{children:"CosLrUpdater"})," , validation of model metrics (Validation), and saving the model (Checkpoint). If you have any specific operations you want the model to perform during training, you can add them in this dictionary format."]}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"train_metrics"})," and ",(0,i.jsx)(s.code,{children:"val_metrics"})," define the metrics to be monitored during model training and validation, respectively."]}),"\n",(0,i.jsxs)(s.p,{children:["In summary, the ",(0,i.jsx)(s.code,{children:"float_trainer"})," is responsible for connecting the entire logic of floating-point model training."]}),"\n",(0,i.jsxs)(s.h3,{id:"quantization-model-calibration",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#quantization-model-calibration",children:"#"}),"Quantization Model Calibration"]}),"\n",(0,i.jsxs)(s.p,{children:["Once we have the pure floating-point model, we can proceed to the quantization process.\r\nWe first use some data samples to calculate the scale parameters of each layer of the model quantization through the ",(0,i.jsx)(s.code,{children:"Calibration"})," operation, so as to perform int8 quantization on the model. The relevant config is:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_data_loader "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" copy"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"deepcopy"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data_loader)"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"pop"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"sampler"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Calibration do not support DDP or DP"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"batch_size"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" batch_size_per_gpu "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"*"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"dataset"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"transforms"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"] "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" val_data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"dataset"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"      "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"transforms"'})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  ]"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_batch_processor "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" copy"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"deepcopy"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(val_batch_processor)"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_step "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  calibration_trainer "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Calibrator"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      model"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"model,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      model_convert_pipeline"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"ModelConvertPipeline"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          qat_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"fuse_bn"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          qconfig_params"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              activation_calibration_observer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"percentile"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              activation_calibration_qkwargs"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  percentile"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"99.975"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          converters"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"LoadCheckpoint"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  checkpoint_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                      os.path."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(ckpt_dir, "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"float-checkpoint-best.pth.tar"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                  ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"Float2Calibration"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", convert_mode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"convert_mode),"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          ],"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ),"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      data_loader"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"calibration_data_loader,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      batch_processor"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"calibration_batch_processor,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      num_steps"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"calibration_step,"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      device"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      callbacks"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          stat_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          val_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          ckpt_callback,"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      val_metrics"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"PCKMetric"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", alpha"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", feat_stride"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", img_shape"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"image_size),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"dict"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"MeanKeypointDist"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"              feat_stride"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"          ),"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      ],"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"      log_interval"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"calibration_step "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"/"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"10"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"  )"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"converter"})," defines the conversion steps before model calibration. The model is first loaded as a floating-point model and then, through the ",(0,i.jsx)(s.code,{children:"Float2Calibration"})," operation, pseudo-quantization nodes are inserted into each layer of the model, transforming it into a ",(0,i.jsx)(s.code,{children:"calibration"})," model."]}),"\n",(0,i.jsx)(s.p,{children:'After the calibration process, the "calibration" model achieves performance of over 99% compared to the floating-point model. Therefore, there is no need for quantization training, and we can proceed with inference using the model converted to a fixed-point model.'}),"\n",(0,i.jsxs)(s.h3,{id:"model-checking--compilation--simulation-of-on-board-accuracy-validation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-checking--compilation--simulation-of-on-board-accuracy-validation",children:"#"}),"Model Checking & Compilation & Simulation of On-board Accuracy Validation"]}),"\n",(0,i.jsx)(s.p,{children:"For HAT, the significance of quantized models lies in their ability to run directly on the BPU (Binary Processing Unit). Therefore, model checking and compilation for quantized models are essential steps."}),"\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"compile_perf_hbir"})," script mentioned above also allows the user to define the quantitative model and then check if it runs properly on the BPU."]}),"\n",(0,i.jsxs)(s.p,{children:["Users can obtain the on-board accuracy of the model by using the ",(0,i.jsx)(s.code,{children:"validation_hbir"})," script. The usage is the same as described in the previous section."]})]})}function l(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,r.ah)(),n.components);return s?(0,i.jsx)(s,Object.assign({},n,{children:(0,i.jsx)(o,n)})):o(n)}s.default=l,l.__RSPRESS_PAGE_META={},l.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fadvanced_content%2Fhat%2Fexamples%2Fcar_keypoint.mdx"]={toc:[{id:"model-training",text:"Model Training",depth:2},{id:"exporting-fixed-point-model",text:"Exporting Fixed-point Model",depth:2},{id:"model-validation",text:"Model Validation",depth:2},{id:"model-inference",text:"Model Inference",depth:2},{id:"simulation-on-board-accuracy-validation",text:"Simulation On-board Accuracy Validation",depth:2},{id:"fixed-point-model-check-and-compilation",text:"Fixed-point Model Check and Compilation",depth:2},{id:"training-details",text:"Training Details",depth:2},{id:"network-structure",text:"Network Structure",depth:3},{id:"data-augmentation",text:"Data Augmentation",depth:3},{id:"training-strategy",text:"Training Strategy",depth:3},{id:"quantization-model-calibration",text:"Quantization Model Calibration",depth:3},{id:"model-checking--compilation--simulation-of-on-board-accuracy-validation",text:"Model Checking & Compilation & Simulation of On-board Accuracy Validation",depth:3}],title:"Car Keypoint Detection Model Training",frontmatter:{}}}}]);