"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["15512"],{14047:function(s,e,n){n.r(e);var o=n(85893),r=n(50065);function l(s){let e=Object.assign({h1:"h1",a:"a",p:"p",code:"code",h2:"h2",h3:"h3",pre:"pre",span:"span",ul:"ul",li:"li"},(0,r.ah)(),s.components);return(0,o.jsxs)(o.Fragment,{children:[(0,o.jsxs)(e.h1,{id:"fx-quantization-principle",children:[(0,o.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#fx-quantization-principle",children:"#"}),"FX Quantization Principle"]}),"\n",(0,o.jsxs)(e.p,{children:["Before reading this section, it is recommended to read the ",(0,o.jsx)(e.a,{href:"https://pytorch.org/docs/stable/fx.html",target:"_blank",rel:"noopener noreferrer",children:"torch.fx \u2014 PyTorch documentation"})," to get an initial understanding of torch's FX mechanism."]}),"\n",(0,o.jsxs)(e.p,{children:["FX uses the symbolic execution approach, which allows models to be graphically constructed at the ",(0,o.jsx)(e.code,{children:"nn.Module"})," or function level, allowing for automated fuse and other graph-based optimizations."]}),"\n",(0,o.jsxs)(e.h2,{id:"quantized-process",children:[(0,o.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#quantized-process",children:"#"}),"Quantized Process"]}),"\n",(0,o.jsxs)(e.h3,{id:"fuse-optional",children:[(0,o.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#fuse-optional",children:"#"}),"Fuse (Optional)"]}),"\n",(0,o.jsx)(e.p,{children:"FX can sense the computational graph, so you can automate the fusion of operators. You no longer need to manually specify the operators to be fused, just call the interface directly."}),"\n",(0,o.jsx)(e.pre,{className:"code",children:(0,o.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,o.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"fused_model "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantization"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"fuse_fx"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(model)"})]}),"\n"]})})}),"\n",(0,o.jsxs)(e.ul,{children:["\n",(0,o.jsxs)(e.li,{children:["Note that there is no ",(0,o.jsx)(e.code,{children:"inplace"})," parameter for ",(0,o.jsx)(e.code,{children:"fuse_fx"}),", because internally you need to do symbolic trace on the model to generate a ",(0,o.jsx)(e.code,{children:"GraphModule"}),", so you can't do inplace modification."]}),"\n",(0,o.jsxs)(e.li,{children:["The ",(0,o.jsx)(e.code,{children:"fused_model"})," and ",(0,o.jsx)(e.code,{children:"model"})," will share almost all attributes (including submodules, operators, etc.), so do not make any changes to the ",(0,o.jsx)(e.code,{children:"model"})," after fuse, as this may affect the ",(0,o.jsx)(e.code,{children:"fused_model"}),"."]}),"\n",(0,o.jsxs)(e.li,{children:["It is not necessary to explicitly call the ",(0,o.jsx)(e.code,{children:"fuse_fx"})," interface, as the subsequent ",(0,o.jsx)(e.code,{children:"prepare"})," interface integrates the fuse procedure internally."]}),"\n"]}),"\n",(0,o.jsxs)(e.h3,{id:"prepare",children:[(0,o.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#prepare",children:"#"}),"Prepare"]}),"\n",(0,o.jsxs)(e.p,{children:["The global march must be set according to the target hardware platform before calling the ",(0,o.jsx)(e.code,{children:"prepare"})," interface, which internally performs a fuse procedure (even if the model has already been fused) and then replaces the eligible operators in the model with implementations from ",(0,o.jsx)(e.code,{children:"horizon.nn.qat"}),"."]}),"\n",(0,o.jsxs)(e.ul,{children:["\n",(0,o.jsx)(e.li,{children:"You can choose the appropriate qconfig (Calibtaion or QAT, note that you can't mix the two qconfigs) if you want."}),"\n",(0,o.jsxs)(e.li,{children:["Similar to ",(0,o.jsx)(e.code,{children:"fuse_fx"}),", this interface does not support the ",(0,o.jsx)(e.code,{children:"inplace"})," parameter, and please do not make any changes to the input model after ",(0,o.jsx)(e.code,{children:"prepare"}),"."]}),"\n"]}),"\n",(0,o.jsx)(e.pre,{className:"code",children:(0,o.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,o.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"horizon"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"march"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"set_march"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(horizon.march.March.NASH)"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"qat_model "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"quantization"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"prepare"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    model,"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    qconfig_setter "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" horizon.quantization.qconfig_template.default_qat_qconfig_setter,"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"    method "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" horizon.quantization.PrepareMethod.SYMBOLIC,"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})}),"\n"]})})}),"\n",(0,o.jsxs)(e.h3,{id:"eager-mode-compatibility",children:[(0,o.jsx)(e.a,{className:"header-anchor","aria-hidden":"true",href:"#eager-mode-compatibility",children:"#"}),"Eager Mode Compatibility"]}),"\n",(0,o.jsxs)(e.p,{children:["In most cases, FX quantized interfaces can directly replace eager mode quantized interfaces (",(0,o.jsx)(e.code,{children:"prepare_qat"})," -> ",(0,o.jsx)(e.code,{children:"prepare"}),"), but they cannot be mixed with eager mode interfaces.\nSome models require some modifications to the code structure in the following cases."]}),"\n",(0,o.jsxs)(e.ul,{children:["\n",(0,o.jsx)(e.li,{children:"Operations not supported by FX: the symbolic trace of torch supports limited operations, e.g., it does not support non-static variables as judgment conditions, it does not support pkgs (e.g., numpy) other than torch by default, etc., and unexecuted conditional branches will be discarded."}),"\n",(0,o.jsx)(e.li,{children:"Operations that don't want to be processed by FX: If torch's ops are used in the model's pre- and post-processing, FX will treat them as part of the model when tracing, producing undesired behavior (e.g., replacing some of torch's function calls with FloatFunctional)."}),"\n"]}),"\n",(0,o.jsx)(e.p,{children:"Both of these cases can be avoided by using wrap, as illustrated by RetinaNet."}),"\n",(0,o.jsx)(e.pre,{className:"code",children:(0,o.jsx)(e.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,o.jsxs)(e.code,{className:"language-python",meta:"",children:[(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_plugin_pytorch"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"fx"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"fx_helper "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" wrap "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" fx_wrap"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"class"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"RetinaNet"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"backbone"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"neck"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"head"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"anchors"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"targets"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"post_process"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"loss_cls"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"loss_reg"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Optional"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"nn"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Module"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    ):"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"super"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(RetinaNet, self)."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"__init__"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"backbone "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" backbone"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"neck "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" neck"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"head "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" head"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"anchors "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" anchors"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"targets "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" targets"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"post_process "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" post_process"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"loss_cls "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" loss_cls"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"loss_reg "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" loss_reg"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rearrange_head_out"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"inputs"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" List"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"torch"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"Tensor"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"num"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"int"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        outputs "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" []"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" t "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" inputs"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            outputs"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"append"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(t."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"permute"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"2"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"3"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"reshape"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(t.shape["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"], "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"-"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:", num))"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" torch"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cat"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(outputs, dim"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"forward"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"data"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" Dict):"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        feat "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"backbone"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"img"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"])"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        feat "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"neck"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(feat)"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"neck "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" feat"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        cls_scores"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" bbox_preds "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"head"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(feat)"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"post_process "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"is"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cls_scores"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" bbox_preds"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# by encapsulating operations that don't need to build a graph into a method, "})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# FX will no longer care about the logic inside the method, it will just leave it as is "})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# (the module called in the method can still be set to qconfig and replaced by prepare_qat_fx and convert_fx)"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"_post_process"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"( data, feat, cls_scores, bbox_preds)"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"@fx_wrap"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"  "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# fx_wrap supports direct decoration of class method"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"_post_process"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"data"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"feat"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"cls_scores"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-parameter)"},children:"bbox_preds"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:")"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        anchors "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"anchors"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(feat)"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number"}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-comment)"},children:"# the judgment of self.training must be encapsulated, otherwise it will be thrown away after the symbolic trace."})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"training"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            cls_scores "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rearrange_head_out"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                cls_scores, self.head.num_classes"})}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            )"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            bbox_preds "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"rearrange_head_out"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(bbox_preds, "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"4"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            gt_labels "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ["})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                torch"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"cat"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    [data["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"gt_bboxes"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"][i], data["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"gt_classes"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"][i][:, "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"None"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"] "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                    dim"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=-"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                )"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" i "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"range"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"len"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(data["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"gt_classes"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]))"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            ]"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            gt_labels "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" [gt_label"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"float"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" gt_label "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" gt_labels]"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            _"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" labels "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"targets"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(anchors, gt_labels)"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            avg_factor "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" labels"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"reg_label_mask"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"sum"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" avg_factor "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                avg_factor "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"+="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            cls_loss "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"loss_cls"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                pred"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"cls_scores."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"sigmoid"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(),"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                target"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"labels["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cls_label"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                weight"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"labels["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cls_label_mask"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                avg_factor"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"avg_factor,"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            )"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            reg_loss "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"loss_reg"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                pred"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"bbox_preds,"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                target"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"labels["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"reg_label"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                weight"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"labels["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"reg_label_mask"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"],"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                avg_factor"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"avg_factor,"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            )"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"{"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"cls_loss"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" cls_loss"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"reg_loss"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" reg_loss"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"}"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"else"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            preds "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" self"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"post_process"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                anchors,"})}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                cls_scores,"})}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                bbox_preds,"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"                [torch."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"tensor"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(shape) "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" shape "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:" data["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"resized_shape"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]],"})]}),"\n",(0,o.jsx)(e.span,{className:"line line-number",children:(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"            )"})}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"assert"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" ("})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"                "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"pred_bboxes"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"not"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" data"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-function)"},children:"keys"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            )"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"pred_bboxes has been in data.keys()"'})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            data"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"pred_bboxes"'}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" preds"})]}),"\n",(0,o.jsxs)(e.span,{className:"line line-number",children:[(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,o.jsx)(e.span,{style:{color:"var(--shiki-color-text)"},children:" data"})]}),"\n"]})})})]})}function i(){let s=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:e}=Object.assign({},(0,r.ah)(),s.components);return e?(0,o.jsx)(e,Object.assign({},s,{children:(0,o.jsx)(l,s)})):l(s)}e.default=i,i.__RSPRESS_PAGE_META={},i.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fplugin%2Fadvanced_tutorial%2Ffx_quantization_explain.mdx"]={toc:[{id:"quantized-process",text:"Quantized Process",depth:2},{id:"fuse-optional",text:"Fuse (Optional)",depth:3},{id:"prepare",text:"Prepare",depth:3},{id:"eager-mode-compatibility",text:"Eager Mode Compatibility",depth:3}],title:"FX Quantization Principle",frontmatter:{}}}}]);