"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["10164"],{4542:function(e,s,n){n.r(s);var i=n(85893),r=n(50065);function l(e){let s=Object.assign({h1:"h1",a:"a",div:"div",p:"p",code:"code",ul:"ul",li:"li",ol:"ol",pre:"pre",span:"span"},(0,r.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.h1,{id:"prepare-calibration-data",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#prepare-calibration-data",children:"#"}),"Prepare Calibration Data"]}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["If you need to do this process in the sample folder, you need to execute the ",(0,i.jsx)(s.code,{children:"00_init.sh"})," script in the folder first to get the corresponding original model and dataset."]})})]}),"\n",(0,i.jsx)(s.p,{children:"When performing model calibration, 20~100 samples are required at the calibration stage, each is an independent data file.\nTo ensure the accuracy of the calibrated models, these calibration samples better come from the training or validation dataset when training the models.\nIn addition, please try NOT to use rare samples, e.g. single colored images or those images who don't contain any detection or classification targets in them."}),"\n",(0,i.jsxs)(s.p,{children:["You need to preprocess the samples from the training/verification sets (the preprocessing process is the same as the original floating-point model data preprocessing process),\nand the calibrated samples after processing will have the same data type (",(0,i.jsx)(s.code,{children:"input_type_train"}),"), size (",(0,i.jsx)(s.code,{children:"input_shape"}),") and layout (",(0,i.jsx)(s.code,{children:"input_layout _train"}),") with the original floating-point model.\nYou can save the data as an npy file with the ",(0,i.jsx)(s.code,{children:"numpy.save"})," command, and the toolchain will read it based on the ",(0,i.jsx)(s.code,{children:"numpy.load"})," command when it is calibrated.\nFor example, there is an ImageNet trained original classification floating-point model with only one input node, it should be described as below:"]}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsxs)(s.li,{children:["Input type: ",(0,i.jsx)(s.code,{children:"BGR"}),"."]}),"\n",(0,i.jsxs)(s.li,{children:["Input layout: ",(0,i.jsx)(s.code,{children:"NCHW"}),"."]}),"\n",(0,i.jsxs)(s.li,{children:["Input size: ",(0,i.jsx)(s.code,{children:"1x3x224x224"}),"."]}),"\n"]}),"\n",(0,i.jsx)(s.p,{children:"The steps for data preprocessing of the original floating point model are as follows:"}),"\n",(0,i.jsxs)(s.ol,{children:["\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Uniformly scale the image and resize the shorter side to 256."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["Get 224x224 image using the ",(0,i.jsx)(s.code,{children:"center_crop"})," method."]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["Align the input layout to the ",(0,i.jsx)(s.code,{children:"NCHW"})," required by the model."]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["Convert the color space to the ",(0,i.jsx)(s.code,{children:"BGR"})," required by the model."]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Adjust the range of image values to [0, 255] as required by the model."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Subtract mean value by the channel."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Data multiple by the scale factor."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.p,{children:["The sample processing code for the above example model is as follows (to avoid excessive code length, some simple transformer implementation codes are ignored, the usage of transformer can be found in ",(0,i.jsx)(s.a,{href:"/3.0.17/en/guide/ptq/ptq_appendix/transformer.html",children:"Image Processing"}),")."]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# this sample uses skimage, mind the differences when using opencv/PIL"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" skimage"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" skimage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"io"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" numpy "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" np"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" horizon_tc_ui"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"data"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"transformer "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" (CenterCropTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            HWC2CHWTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            MeanTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            RGB2BGRTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            ScaleTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"                                            ShortSideResizeTransformer)"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data_transformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"():"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    transformers "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# uniformly scale the image and resize the shorter side to 256"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ShortSideResizeTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(short_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# get 224x224 image using the CenterCrop"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"CenterCropTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(crop_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"224"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the NHWC layout results using the skimage and convert into the model required NCHW layout"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"HWC2CHWTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the RGB channel sequence results using the skimage and convert into the model required BGR"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"RGB2BGRTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# read the value range between [0.0,1.0] using the skimage and adjust into the model required value range"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(scale_value"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"255"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# for all pixels in the input image, subtract mean_value"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"MeanTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(means"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"np."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"array"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"103.94"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"116.78"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"123.68"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"])),"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# for all pixels in the input image, multiple by the data_scale factor"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"ScaleTransformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(scale_value"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0.017"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    ]"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"return"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" transformers"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# the src_image refers to the source images in sample dataset"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# the dst_file refers to the filename to save the final sample datasets"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"def"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"convert_image"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"src_image"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"dst_file"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-parameter)"},children:"transformers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"):"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" [skimage"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"img_as_float"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"        skimage.io."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"imread"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_image))."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.float32)"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"]"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" trans "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" transformers"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        image "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"trans"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(image)"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"#  type of input_type_train BGR value specified by the model is UINT8"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    image "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" image"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"]."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"astype"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(np.uint8)"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Save calibration samples into a data file in binary format"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    np"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"save"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dst_file, image)"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"if"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"__name__"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"=="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'__main__'"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# refer to the original sample images, fake-code"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    src_images "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'ILSVRC2012_val_00000001.JPEG'"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ...]"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# denote the filename (no restrictions on suffix) of the final samples, fake-code"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# calibration_data_bgr refers to your specified cal_data_dir in the configuration file"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    dst_files "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'./calibration_data_bgr/ILSVRC2012_val_00000001.npy'"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" ...]"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    transformers "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"data_transformer"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"()"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"for"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" src_image"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" dst_file "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"in"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"zip"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_images, dst_files):"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"convert_image"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(src_image, dst_file, transformers)"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Attention"}),(0,i.jsxs)(s.div,{className:"rspress-directive-content",children:[(0,i.jsx)(s.p,{children:"Note that the input_shape parameter in the yaml file serves to specify the input data size of the original floating-point model.\nIf it is a dynamic input model, you can use this parameter to set the converted input size, and the shape size of the calibration data should be consistent with input_shape."}),(0,i.jsx)(s.p,{children:'For example, if the original floating-point model input node shape is ?x3x224x224 ("?" sign represents the placeholder, i.e., the first dimension of the model is dynamic input), and the input_shape: 8x3x224x224 is set in the conversion profile,\nthen the size of each calibration data that you need to prepare is 8x3x224x224 (Please be aware that the input_batch parameter does not support modifying the model batch information for models with the first dimension of the input shape not equal to 1).'})]})]})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,r.ah)(),e.components);return s?(0,i.jsx)(s,Object.assign({},e,{children:(0,i.jsx)(l,e)})):l(e)}s.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["3.0.17%2Fen%2Fguide%2Fptq%2Fptq_usage%2Fprepare_calibration_data.mdx"]={toc:[],title:"Prepare Calibration Data",frontmatter:{}}}}]);