## Single-image inference using modified_model_output/yolov8s_640x640_nv12_quantized_model.onnx
import sys
sys.path.append("./python/data/")
from transformer import *
from dataloader import *
from horizon_tc_ui import HB_ONNXRuntime
import numpy as np
import cv2

from getoutput_process import postprocess


# Create preprocess transformer
def infer_transformers(input_shape, input_layout):
    transformers = [
        # Resize
        ResizeTransformer(target_size=input_shape, mode="opencv"),
        # BGR->RGB
        BGR2RGBTransformer(data_format=input_layout[1:]),
        # RGB->NV12
        RGB2NV12Transformer(data_format=input_layout[1:]),
        # NV12->YUV444
        NV12ToYUV444Transformer(target_size=input_shape, yuv444_output_layout=input_layout[1:]),
    ]
    return transformers


def preprocess(image_name, is_processed):
    input_shape = (640, 640)
    input_layout = "NHWC"
    
    transformers = infer_transformers(input_shape, input_layout)
    origin_image, processed_image = SingleImageDataLoaderWithOrigin(transformers, image_name, imread_mode="opencv")
    return processed_image if is_processed else origin_image


def main():
    image_name = "./det_bev_yolov8_mini/000347.jpg"
    # Load model for inference
    sess = HB_ONNXRuntime(model_file="./model_output/yolov8_bevdet_640x640_nv12_quantized_model.onnx")
    # (Optional) GPU acceleration
    sess.set_providers(["CPUExecutionProvider"])
    # Get input and output names
    input_names = [input.name for input in sess.get_inputs()]
    output_names = [output.name for output in sess.get_outputs()]
    # Data preprocess before inference
    feed_dict = dict()
    for input_name in input_names:
        feed_dict[input_name] = preprocess(image_name, is_processed=True)
    # Inference for model with input in (RGB/BGR/NV12/YUV444/GRAY, dtype=uint8)
    outputs = sess.run(output_names, feed_dict, input_offset=128)
    
    #print("len(outputs) is ", len(outputs)) # len(outputs) is  6
    #print("outputs[0].shape is ", outputs[0].shape) # outputs[0].shape is  (1, 80, 80, 4)
    #print("outputs[1].shape is ", outputs[1].shape) # outputs[1].shape is  (1, 80, 80, 64)
    #print("outputs[2].shape is ", outputs[2].shape) # outputs[2].shape is  (1, 40, 40, 4)
    #print("outputs[3].shape is ", outputs[3].shape) # outputs[3].shape is  (1, 40, 40, 64)
    #print("outputs[4].shape is ", outputs[4].shape) # outputs[4].shape is  (1, 20, 20, 4)
    #print("outputs[5].shape is ", outputs[5].shape) # outputs[5].shape is  (1, 20, 20, 64)
    # Postprocess and visualize results
    origin_image = np.squeeze(preprocess(image_name, is_processed=False))
    postprocess(outputs, origin_image, confidence=0.4, iou=0.4, save_path="./quantized_model.jpg")


if __name__ == '__main__':
    main()
