

import cv2
import numpy as np
import argparse
 
def mergeUV(u, v):
    if u.shape == v.shape:
        uv = np.zeros(shape=(u.shape[0], u.shape[1] * 2))
        print(uv.shape)
        for i in range(0, u.shape[0]):
            for j in range(0, u.shape[1]):
                uv[i, 2 * j] = u[i, j]
                uv[i, 2 * j + 1] = v[i, j]
        return uv
    else:
        raise ValueError("size of Channel U is different with Channel V")

def rgb2nv12_calc(image):
    b = image[:, :, 0]
    g = image[:, :, 1]
    r = image[:, :, 2]
    y = (0.299 * r + 0.587 * g + 0.114 * b)
    u = (-0.169 * r - 0.331 * g + 0.5 * b + 128)[::2, ::2]
    v = (0.5 * r - 0.419 * g - 0.081 * b + 128)[::2, ::2]
    print(y.shape, u.shape, v.shape)
    uv = mergeUV(u, v)
    yuv = np.vstack((y, uv))
    return yuv.astype(np.uint8)

 
if __name__ == "__main__":    
    bgr = cv2.imread("car_1080p.png")
    yuv420sp = rgb2nv12_calc(bgr)
    print("yuv420sp: ", yuv420sp.shape)
    yuv420sp.tofile("car.yuv")
