from hobot_dnn import pyeasy_dnn
import numpy as np
import cv2
import json
import matplotlib.pyplot as plt


def softmax_2D(X):
    """
    针对二维numpy矩阵每一行进行softmax操作
    X: np.array. Probably should be floats.
    return: 二维矩阵
    """
    # looping through rows of X
    #   循环遍历X的行
    ps = np.empty(X.shape)
    for i in range(X.shape[0]):
        ps[i,:]  = np.exp(X[i,:])
        ps[i,:] /= np.sum(ps[i,:])
    return ps


def print_properties(pro):
    print("tensor type:", pro.tensor_type)
    print("data type:", pro.dtype)
    print("layout:", pro.layout)
    print("shape:", pro.shape)


def get_hw(pro):
    if pro.layout == "NCHW":
        return pro.shape[2], pro.shape[3]
    else:
        return pro.shape[1], pro.shape[2]


if __name__ == '__main__':
    # test classification result
    models = pyeasy_dnn.load('resnet34_224x224_rgb.bin')
    h, w = get_hw(models[0].inputs[0].properties)
    img_file = cv2.imread('./data/rose111.jpg')
    des_dim = (w, h)

    resized_data = cv2.resize(np.array(img_file), des_dim)
    img = cv2.cvtColor(resized_data, cv2.COLOR_BGR2RGB)
    #img -= [124.16, 116.28, 103.53]
    #img *= [0.0171248, 0.0175070, 0.0174292]
    img = img.transpose(2, 0, 1)
    ## -------------------------------#
    ##  添加batch维度
    ## -------------------------------#
    img = np.expand_dims(img, 0)
    # --------------------------------#
    #   class_indict用于可视化类别
    # --------------------------------#
    json_path = './class_indices.json'
    with open(json_path, "r") as f:
        class_indict = json.load(f)

    outputs = models[0].forward(img)
    print('outputs[0].buffer:', outputs[0].buffer)
    print('outputs[0].buffer type:', type(outputs[0].buffer))
    print('outputs[0].buffer squeeze:', outputs[0].buffer.squeeze())
    if outputs[0].buffer.squeeze().shape == (5,):
        outputs = outputs[0].buffer.squeeze()[np.newaxis, :]
        print('outputs:', outputs)
    
    print("=" * 10, "Classification result", "=" * 10)
    print("cls id:", np.argmax(outputs[0]))

    # -----------------------------------#
    #   经过softmax转化为概率
    #   softmax_2D按行转化，一行一个样本
    #   测试时，softmax可不要！
    # -----------------------------------#
    predict_probability = softmax_2D(outputs)        
    print('predict_probability:', predict_probability)  # array([[0.1],[0.2],[0.3],[0.3],[0.1]])           
    
    # ----------------------------------------#
    #   argmax得到最大概率索引，也就是类别对应索引
    # ----------------------------------------#
    predict_cla = np.argmax(predict_probability, axis=-1)
    # print('predict_cla:',predict_cla)        # array([2])

    print_res = "class: {}   prob: {:.3}".format(class_indict[str(predict_cla[0])],
                                                 predict_probability[0][predict_cla[0]])
    print(print_res)
    plt.title(print_res)
    for i in range(len(predict_probability[0])):
        print("class: {:10}   prob: {:.3}".format(class_indict[str(i)],
                                                  predict_probability[0][i]))
    plt.savefig("./result.jpg")
    plt.show()


